/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialPurchasingControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialSrvUtils;
import com.kingdee.eas.basedata.master.material.util.MaterialUtils;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MaterialPurchasingControllerBean
extends AbstractMaterialPurchasingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialPurchasingControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkOrgDup(ctx, model);
        MaterialPurchasingInfo info = (MaterialPurchasingInfo)model;
        if (info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        info.verify(ctx);
        info.put("MaterialNumber", MaterialSrvUtils.getMaterialLogInfo((Context)ctx, (String)info.getMaterial().getId().toString()));
        return super._addnew(ctx, model);
    }

    private void _checkOrgDup(Context ctx, IObjectValue model) throws MaterialBaseException, EASBizException, BOSException {
        MaterialPropertyBaseInfo info = (MaterialPropertyBaseInfo)model;
        String orgID = info.getOrgUnit().getId().toString();
        String materialID = info.getMaterial().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new MaterialBaseException(MaterialBaseException.EXIST_PURCHASEINFO);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialPurchasingInfo Info = this.getMaterialPurchasingInfo(ctx, pk);
        if (Info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (Info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        this.checkHasReference(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected MaterialPurchasingInfo _first(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.getMaterialPurchasingInfo(ctx, pk);
    }

    @Override
    protected MaterialPurchasingInfo _previous(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.getMaterialPurchasingInfo(ctx, pk);
    }

    @Override
    protected MaterialPurchasingInfo _next(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.getMaterialPurchasingInfo(ctx, pk);
    }

    @Override
    protected MaterialPurchasingInfo _last(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.getMaterialPurchasingInfo(ctx, pk);
    }

    private void checkHasReference(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETE_PUR);
            }
        }
    }

    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialPurchasing iproperty = MaterialPurchasingFactory.getLocalInstance(ctx);
        MaterialPurchasingInfo info = iproperty.getMaterialPurchasingInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.FREEZED);
        info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialPurchasing iproperty = MaterialPurchasingFactory.getLocalInstance(ctx);
        MaterialPurchasingInfo info = iproperty.getMaterialPurchasingInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTFREEZED);
        }
        info.setStatus(UsedStatusEnum.APPROVED);
        info.setFreezeOrgUnit(null);
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialPurchasingInfo info = this.getMaterialPurchasingInfo(ctx, pk);
        this._approve(ctx, info);
    }

    protected void _approve(Context ctx, MaterialPropertyBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
        if (mainfo.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
        }
        if (mainfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        MaterialUtil.checkMeasureUnit((MaterialInfo)mainfo, (MeasureUnitInfo)((MaterialPurchasingInfo)info).getUnit(), MaterialBaseException.class, (NumericExceptionSubItem)MaterialBaseException.UNIT_PRECISION_ERROR2, (Context)ctx);
        StringBuffer updatesql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            updatesql.append(" update T_BD_MaterialPurchasing set FStatus = ").append(String.valueOf(1)).append("  where fid = '").append(info.getId().toString()).append("'");
            statement.execute(updatesql.toString());
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
    }

    protected void _unApprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialPurchasing iproperty = MaterialPurchasingFactory.getLocalInstance(ctx);
        MaterialPurchasingInfo info = iproperty.getMaterialPurchasingInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MaterialPurchasingInfo info = (MaterialPurchasingInfo)model;
        if (info.getOrgUnit() != null && info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        info.verify(ctx);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, MaterialPurchasingInfo info) throws BOSException, EASBizException {
        String name = "";
        name = info.getMaterial().getName(ctx.getLocale());
        if (info.getOrgUnit() != null && info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        info.verify(ctx);
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{name});
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{name});
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialPurchasingInfo info = this.getMaterialPurchasingInfo(ctx, pk, this.getSelectors());
        MaterialInfo matInfo = (MaterialInfo)info.get("material");
        if (matInfo != null) {
            return matInfo.getNumber() + "  " + matInfo.getName(ctx.getLocale());
        }
        return pk.toString();
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        return sic;
    }

    @Override
    protected MaterialPurchasingInfo _getPurchasingInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = MaterialControllerBean.getFilterOUMaterial((Context)ctx, (String)"orgUnit.id", (String)ouid, (String)"material.id", (String)matid);
        viewInfo.setFilter(filterinfo);
        this.getPurchasingSelectors(viewInfo.getSelector());
        MaterialPurchasingCollection con = MaterialPurchasingFactory.getLocalInstance(ctx).getMaterialPurchasingCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            int i = 0;
            if (i < con.size()) {
                MaterialPurchasingInfo info = con.get(i);
                if (info.getOrgUnit().getId().toString().equals(ouid)) {
                    // empty if block
                }
                return info;
            }
            return con.get(0);
        }
        MaterialPurchasingInfo info = null;
        return info;
    }

    private SelectorItemCollection getPurchasingSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("purPerson.id"));
        sic.add(new SelectorItemInfo("purPerson.number"));
        sic.add(new SelectorItemInfo("purPerson.name"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("appointPurOrgUnit.id"));
        sic.add(new SelectorItemInfo("appointPurOrgUnit.name"));
        sic.add(new SelectorItemInfo("appointPurOrgUnit.number"));
        sic.add(new SelectorItemInfo("producingArea"));
        sic.add(new SelectorItemInfo("produceFactory"));
        sic.add(new SelectorItemInfo("purchaseStrategy"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("priceTop"));
        sic.add(new SelectorItemInfo("receiveTopRatio"));
        sic.add(new SelectorItemInfo("receiveBottomRatio"));
        sic.add(new SelectorItemInfo("daydAhead"));
        sic.add(new SelectorItemInfo("daysDelay"));
        sic.add(new SelectorItemInfo("isReturn"));
        sic.add(new SelectorItemInfo("fineQualityFairPrice"));
        sic.add(new SelectorItemInfo("isNotControlQty"));
        sic.add(new SelectorItemInfo("isNotControlTime"));
        sic.add(new SelectorItemInfo("qualityOrg.id"));
        sic.add(new SelectorItemInfo("qualityOrg.number"));
        sic.add(new SelectorItemInfo("qualityOrg.name"));
        sic.add(new SelectorItemInfo("useSupplyList"));
        return sic;
    }
}

