/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.QuotaPolicyFactory;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.HashMap;

public class MaterialPurAutoCreateProcessor
extends AbstractBusinessProcessor {
    public MaterialPurAutoCreateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo matInfo = (MaterialInfo)ac.getData("matInfo");
        HashMap errors = (HashMap)ac.getData("errors");
        CtrlUnitInfo cuInfo = (CtrlUnitInfo)ac.getData("cuInfo");
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)ac.getData("ouInfo");
        IMaterialPurchasing imatPur = MaterialPurchasingFactory.getLocalInstance(this.ctx);
        MaterialPurchasingInfo purInfo = new MaterialPurchasingInfo();
        purInfo.setMaterial(matInfo);
        purInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        purInfo.setEffectedStatus(2);
        purInfo.setOrgUnit(ouInfo);
        purInfo.setUnit(matInfo.getBaseUnit());
        PurchaseOrgUnitInfo purOU = PurchaseOrgUnitFactory.getLocalInstance((Context)this.ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuInfo.getId()));
        purInfo.setAppointPurOrgUnit(purOU);
        purInfo.setIsReturn(true);
        purInfo.setReceiveTopRatio(0);
        purInfo.setReceiveBottomRatio(0);
        purInfo.setDaydAhead(0);
        purInfo.setDaysDelay(0);
        try {
            purInfo.setQuotaPolicy(QuotaPolicyFactory.getLocalInstance(this.ctx).getQuotaPolicyInfo("where number='005'"));
        }
        catch (Exception e) {
            errors.put("QuotaPolicy", e);
        }
        try {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            imatPur.addnew((CoreBaseInfo)purInfo);
        }
        catch (PermissionException e3) {
            errors.put("pur", e3);
        }
    }
}

