/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CopyDataStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UserParamInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class MaterialPurCopyProcessor
extends AbstractBusinessProcessor {
    public MaterialPurCopyProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo newMaterial = (MaterialInfo)ac.getData("newMaterial");
        EntityViewInfo viewInfo = (EntityViewInfo)ac.getData("viewInfo");
        MeasureUnitInfo newBaseUnit = (MeasureUnitInfo)ac.getData("newBaseUnit");
        boolean isModify = (Boolean)ac.getData("isModify");
        UserParamInfo userParam = (UserParamInfo)ac.getData("userParam");
        IMaterialPurchasing iMaterialPurchasing = MaterialPurchasingFactory.getLocalInstance(this.ctx);
        MaterialPurchasingCollection materialPurchasingColl = iMaterialPurchasing.getMaterialPurchasingCollection(viewInfo);
        int size = materialPurchasingColl.size();
        MaterialPurchasingInfo materialPurchasingInfo = null;
        for (int index = 0; index < size; ++index) {
            CopyDataStatusEnum copyBaseDataStaus;
            UsedStatusEnum destStatus;
            materialPurchasingInfo = materialPurchasingColl.get(index);
            materialPurchasingInfo.setId(null);
            materialPurchasingInfo.setMaterial(newMaterial);
            materialPurchasingInfo.setCreator(newMaterial.getCreator());
            materialPurchasingInfo.setCreateTime(newMaterial.getCreateTime());
            materialPurchasingInfo.setLastUpdateUser(newMaterial.getLastUpdateUser());
            materialPurchasingInfo.setLastUpdateTime(newMaterial.getLastUpdateTime());
            if (isModify) {
                materialPurchasingInfo.setUnit(newBaseUnit);
            }
            if ((destStatus = MaterialUtil.getMaterialCopyStatus((CopyDataStatusEnum)(copyBaseDataStaus = userParam.getCopyPurDataStaus()), (UsedStatusEnum)materialPurchasingInfo.getStatus())) == UsedStatusEnum.APPROVED) {
                try {
                    MaterialUtil.checkFunctionPermission((Context)this.ctx, (String)newMaterial.getCU().getId().toString(), (String)"bd_materialPur_approve");
                }
                catch (PermissionException e) {
                    destStatus = UsedStatusEnum.UNAPPROVE;
                }
            }
            materialPurchasingInfo.setStatus(destStatus);
            iMaterialPurchasing.addnew((CoreBaseInfo)materialPurchasingInfo);
        }
    }
}

