/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.material.AbstractMaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.common.EASBizException;
import java.io.Serializable;
import java.math.BigDecimal;

public class MaterialSalesInfo
extends AbstractMaterialSalesInfo
implements Serializable {
    public MaterialSalesInfo() {
    }

    protected MaterialSalesInfo(String pkField) {
        super(pkField);
    }

    public String getLogInfo() {
        return this.getMaterial().getNumber() + "  " + this.getMaterial().getName();
    }

    public void verify() throws EASBizException, BOSException {
        this.verify(null);
    }

    public void verify(Context ctx) throws EASBizException, BOSException {
        if (this.getPrice() != null && this.getPrice().doubleValue() < 0.0 || this.getIssueTopRatio() < 0 || this.getIssueBottomRatio() < 0 || this.getDaydAhead() < 0 || this.getDaysDelay() < 0 || this.getTaxRate() != null && this.getTaxRate().doubleValue() < 0.0) {
            throw new MaterialBaseException(MaterialBaseException.MATSALERANGEINVALID);
        }
        if (this.isIsConsignCheck() && this.getQualityOrg() == null) {
            String propName = CSSPUtils.getPropertyAlias((Context)ctx, (AbstractObjectValue)this, (String)"qualityOrg");
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{propName});
        }
        if (this.getInnerPriceRate() < -100 || this.getInnerPriceRate() > 100) {
            throw new MaterialBaseException(MaterialBaseException.INNERPRICERATE);
        }
        BigDecimal value = this.getCheapRate();
        if (value == null) {
            this.setCheapRate(new BigDecimal("0"));
        } else {
            if ((value = value.setScale(4, 4)).compareTo(new BigDecimal("0")) < 0 || value.compareTo(new BigDecimal("100")) >= 0) {
                throw new MaterialBaseException(MaterialBaseException.CHEAPRATE);
            }
            this.setCheapRate(value);
        }
    }
}

