/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ITaxData;
import com.kingdee.eas.basedata.assistant.TaxDataCollection;
import com.kingdee.eas.basedata.assistant.TaxDataFactory;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataImportMaterialSales
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(DataImportMaterialSales.class);
    private Set PerminsionCheckedCuIds = new HashSet();
    private Map<String, Boolean> userBizOrgRangeMap = new HashMap<String, Boolean>();
    Map cacheSaleOrgUnit = new HashMap();
    Map cacheOrg = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialSalesFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            logger.info((Object)e);
            throw e;
        }
        catch (Exception ex) {
            logger.info((Object)("DataImportMaterialSales Exception" + ex.getClass().getName() + "\n" + ex));
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, Exception {
        String creatorNumber;
        SaleOrgUnitInfo saleOrgUnit = null;
        Object data = ((DataToken)hsData.get((Object)"FOrgUnit")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetBizOrgUnitFailed", (Context)ctx));
        }
        saleOrgUnit = this.getSaleOrgByNumber(ctx, data.toString());
        if (saleOrgUnit == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetBizOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        boolean isUserBizOrgRange = false;
        if (this.userBizOrgRangeMap.containsKey(userId + saleOrgUnit.getId().toString())) {
            isUserBizOrgRange = this.userBizOrgRangeMap.get(userId + saleOrgUnit.getId().toString());
        } else {
            isUserBizOrgRange = PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)saleOrgUnit.getId().toString());
            this.userBizOrgRangeMap.put(userId + saleOrgUnit.getId().toString(), isUserBizOrgRange);
        }
        if (!isUserBizOrgRange) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{saleOrgUnit.getName()}).getMessage());
        }
        String CuId = saleOrgUnit.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"bd_materialSale_import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        MaterialInfo materialInfo = DataImportTools.getMaterialInfo((Context)ctx, (CtrlUnitInfo)saleOrgUnit.getCU(), (String)this.getDataString(hsData, "FNumber"));
        MaterialSalesInfo info = new MaterialSalesInfo();
        if (this.isSltImportUpdate()) {
            FilterInfo filter = new FilterInfo();
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"orgUnit.id", (Object)saleOrgUnit.getId().toString());
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.number", (Object)this.getDataString(hsData, "FNumber"));
            filter.setMaskString("#0 and #1");
            IMaterialSales iProperty = MaterialSalesFactory.getLocalInstance(ctx);
            MaterialSalesCollection proCollection = iProperty.getMaterialSalesCollection(DataImportTools.getViewInfo((FilterInfo)filter));
            if (proCollection != null && proCollection.size() > 0) {
                info.setId(proCollection.get(0).getId());
                info.setCU(proCollection.get(0).getCU());
            }
        }
        info.setMaterial(materialInfo);
        info.setOrgUnit(saleOrgUnit.castToFullOrgUnitInfo());
        info.setCU(saleOrgUnit.getCU());
        String createdate = hsData.get("FCreateTime").toString();
        if (createdate != null && createdate.length() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Object createTime = df.parseObject(createdate);
                info.setCreateTime(new Timestamp(((Date)createTime).getTime()));
            }
            catch (ParseException df) {
                // empty catch block
            }
        }
        if (info.getCreateTime() == null) {
            Date date = new Date();
            info.setCreateTime(new Timestamp(date.getTime()));
        }
        if ((creatorNumber = hsData.get("FCreatorNumber").toString()) != null && creatorNumber.trim().length() > 0) {
            UserInfo userInfo;
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)creatorNumber, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            UserCollection collection = iUser.getUserCollection(viewInfo);
            if (collection != null && collection.size() > 0 && (userInfo = collection.get(0)) != null) {
                info.setCreator(userInfo);
            }
        }
        if (info.getCreator() == null) {
            UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            info.setCreator(userinfo);
        }
        return this.handleInfo(ctx, hsData, info, materialInfo.getId().toString());
    }

    private SaleOrgUnitInfo getSaleOrgByNumber(Context ctx, String number) throws BOSException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheSaleOrgUnit.get(number);
        if (result == null) {
            result = DataImportTools.getSaleOrgUnitInfoFromNumber((Context)ctx, (String)number);
            this.cacheSaleOrgUnit.put(number, result);
        }
        return (SaleOrgUnitInfo)result;
    }

    private OrgUnitInfo getOrgByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheOrg.get(number);
        if (result == null) {
            result = DataImportTools.getOrgUnitInfo((Context)ctx, (String)number);
            this.cacheOrg.put(number, result);
        }
        return (OrgUnitInfo)result;
    }

    private CoreBaseInfo handleInfo(Context ctx, Hashtable hsData, MaterialSalesInfo info, String materialID) throws TaskExternalException {
        info.setPrice(this.getDataBigDecimal(hsData, "FPrice"));
        info.setIsReturn(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsReturn"));
        info.setIsnotCheckOnReturn(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsnotCheckOnReturn"));
        info.setIsReceivByCheck(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsReceivByCheck"));
        info.setIsConsignCheck(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsConsignCheck"));
        info.setIsPurBySale(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsPurBySale"));
        info.setUnit(DataImportTools.getMeasureUnitInfo((Context)ctx, (String)this.getDataString(hsData, "FUnitID")));
        info.setUnit(DataImportTools.getMultiMeasureUnitInfo((Context)ctx, (String)this.getDataString(hsData, "FUnitID"), (String)materialID));
        if (info.getUnit() == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_MeasureUnit_Error", (Locale)ctx.getLocale()));
        }
        info.setIssueTopRatio(DataImportTools.getDataint((Hashtable)hsData, (String)"FIssueTopRatio"));
        info.setIssueBottomRatio(DataImportTools.getDataint((Hashtable)hsData, (String)"FIssueBottomRatio"));
        info.setDaydAhead(DataImportTools.getDataint((Hashtable)hsData, (String)"FDaydAhead"));
        info.setDaysDelay(DataImportTools.getDataint((Hashtable)hsData, (String)"FDaysDelay"));
        info.setLowerQuantity(this.getDataBigDecimal(hsData, "FLowerQuantity"));
        info.setTaxData(this.getTaxDataInfo(ctx, this.getDataString(hsData, "FTaxData")));
        info.setInnerPriceRate(DataImportTools.getDataint((Hashtable)hsData, (String)"FInnerPriceRate"));
        info.setCheapRate(DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FCheapRate"));
        info.setTaxRate(this.getDataBigDecimal(hsData, "FTaxRate"));
        info.setAbcType(DataImportTools.getABCEnum((String)this.getDataString(hsData, "FABCType"), (Context)ctx));
        QualityOrgUnitInfo qualityOrg = null;
        OrgUnitInfo ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FQualityOrg"));
        if (ou != null) {
            if (!ou.isIsQualityOrgUnit()) {
                throw new TaskExternalException(this.getDataString(hsData, "FQualityOrg") + "," + ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"4_DataImportMaterialInventory", (Locale)ctx.getLocale()));
            }
            qualityOrg = new QualityOrgUnitInfo();
            qualityOrg.setId(ou.getId());
        }
        info.setQualityOrg(qualityOrg);
        ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        info.setStatus(DataImportTools.getStatusEnum((String)this.getDataString(hsData, "FStatus"), (Context)ctx));
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else if (info.getStatus() == UsedStatusEnum.FREEZED) {
            info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
        info.setEffectedStatus(2);
        return info;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
    }

    private TaxDataInfo getTaxDataInfo(Context ctx, String number) throws TaskExternalException {
        TaxDataCollection taxDataCollection;
        if (number == null || number.equals("")) {
            return null;
        }
        String curId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        FilterInfo filter = new FilterInfo();
        String ineerSql = "select FDATABASEDID from t_bd_databasedassign WHERE FBOSOBJECTTYPE = '91E210CA' and FASSIGNCUID = '" + curId + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ineerSql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)curId));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.setMaskString("(#0 OR #1) AND #2");
        try {
            ITaxData iTaxData = TaxDataFactory.getLocalInstance((Context)ctx);
            taxDataCollection = iTaxData.getTaxDataCollection(DataImportTools.getViewInfo((FilterInfo)filter));
            if (taxDataCollection == null || taxDataCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_TaxNumber_Error", (Locale)ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return taxDataCollection.get(0);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FOrgUnit", rs.getString("orgUnit.number"));
            this.putTable(result, "FPrice", rs.getBigDecimal("Sales.price"));
            this.putTable(result, "FIsReturn", DataImportTools.boolToString((boolean)rs.getBoolean("Sales.isReturn")));
            this.putTable(result, "FIsnotCheckOnReturn", DataImportTools.boolToString((boolean)rs.getBoolean("Sales.isnotCheckOnReturn")));
            this.putTable(result, "FIsReceivByCheck", DataImportTools.boolToString((boolean)rs.getBoolean("Sales.isReceivByCheck")));
            this.putTable(result, "FIsPurBySale", DataImportTools.boolToString((boolean)rs.getBoolean("Sales.isPurBySale")));
            this.putTable(result, "FUnitID", rs.getString("salesUnit.number"));
            this.putTable(result, "FIssueTopRatio", rs.getString("Sales.issueTopRatio"));
            this.putTable(result, "FIssueBottomRatio", rs.getString("Sales.issueBottomRatio"));
            this.putTable(result, "FDaydAhead", rs.getString("Sales.daydAhead"));
            this.putTable(result, "FDaysDelay", rs.getString("Sales.daysDelay"));
            this.putTable(result, "FLowerQuantity", rs.getBigDecimal("Sales.lowerQuantity"));
            this.putTable(result, "FTaxData", rs.getString("taxData.number"));
            this.putTable(result, "FTaxRate", rs.getString("Sales.taxRate"));
            ABCEnum abcEnum = ABCEnum.getEnum((int)rs.getInt("Sales.abcType"));
            this.putTable(result, "FABCType", abcEnum == null ? "" : abcEnum.getAlias(ctx.getLocale()));
            this.putTable(result, "FIsConsignCheck", rs.getString("Sales.isConsignCheck"));
            this.putTable(result, "FQualityOrg", rs.getString("qualityOrg.number"));
            this.putTable(result, "FInnerPriceRate", rs.getString("Sales.innerPriceRate"));
            this.putTable(result, "FCheapRate", rs.getString("Sales.cheapRate"));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            this.putTable(result, "FStatus", UsedStatusEnum.getEnum((int)rs.getInt("Sales.status")).getAlias(locale));
            this.putTable(result, "FCreateTime", rs.getString("Sales.createTime"));
            this.putTable(result, "FCreatorNumber", rs.getString("creator.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iMaterial.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpSalesQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }
}

