/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialSalesControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialSrvUtils;
import com.kingdee.eas.basedata.master.material.util.MaterialUtils;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MaterialSalesControllerBean
extends AbstractMaterialSalesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialSalesControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkOrgDup(ctx, model);
        MaterialSalesInfo info = (MaterialSalesInfo)model;
        if (info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        info.verify(ctx);
        info.put("MaterialNumber", MaterialSrvUtils.getMaterialLogInfo((Context)ctx, (String)info.getMaterial().getId().toString()));
        return super._addnew(ctx, model);
    }

    private void _checkOrgDup(Context ctx, IObjectValue model) throws MaterialBaseException, EASBizException, BOSException {
        MaterialPropertyBaseInfo info = (MaterialPropertyBaseInfo)model;
        String orgID = info.getOrgUnit().getId().toString();
        String materialID = info.getMaterial().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new MaterialBaseException(MaterialBaseException.EXIST_SALEINFO);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialSalesInfo info = this.getMaterialSalesInfo(ctx, pk);
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        this.checkHasReference(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected MaterialSalesInfo _first(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialSalesInfo _previous(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialSalesInfo _next(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialSalesInfo _last(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    private void checkHasReference(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETE_SALES);
            }
        }
    }

    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialSales iproperty = MaterialSalesFactory.getLocalInstance(ctx);
        MaterialSalesInfo info = iproperty.getMaterialSalesInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.FREEZED);
        info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialSales iproperty = MaterialSalesFactory.getLocalInstance(ctx);
        MaterialSalesInfo info = iproperty.getMaterialSalesInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTFREEZED);
        }
        info.setStatus(UsedStatusEnum.APPROVED);
        info.setFreezeOrgUnit(null);
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialSalesInfo info = this.getMaterialSalesInfo(ctx, pk);
        this._approve(ctx, info);
    }

    protected void _approve(Context ctx, MaterialPropertyBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        IMaterial ima = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
        if (mainfo.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
        }
        if (mainfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        MaterialUtil.checkMeasureUnit((MaterialInfo)mainfo, (MeasureUnitInfo)((MaterialSalesInfo)info).getUnit(), MaterialBaseException.class, (NumericExceptionSubItem)MaterialBaseException.UNIT_PRECISION_ERROR3, (Context)ctx);
        StringBuffer updatesql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            updatesql.append(" update T_BD_MaterialSales set FStatus = ").append(String.valueOf(1)).append("  where fid = '").append(info.getId().toString()).append("'");
            statement.execute(updatesql.toString());
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
    }

    protected void _unApprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialSales iproperty = MaterialSalesFactory.getLocalInstance(ctx);
        MaterialSalesInfo info = iproperty.getMaterialSalesInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU((Context)ctx, (String)info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        iproperty.update(pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, MaterialSalesInfo newInfo) throws BOSException, EASBizException {
        String name = "";
        name = newInfo.getMaterial().getName(ctx.getLocale());
        if (newInfo.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{name});
        }
        if (newInfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{name});
        }
        newInfo.verify(ctx);
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MaterialSalesInfo info = (MaterialSalesInfo)model;
        if (info.getOrgUnit() != null && info.getOrgUnit().getCU() != null) {
            info.setCU(info.getOrgUnit().getCU());
        }
        info.verify(ctx);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialSalesInfo info = this.getMaterialSalesInfo(ctx, pk, this.getSelectors());
        MaterialInfo matInfo = (MaterialInfo)info.get("material");
        if (matInfo != null) {
            return matInfo.getNumber() + "  " + matInfo.getName(ctx.getLocale());
        }
        return pk.toString();
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        return sic;
    }

    @Override
    protected MaterialSalesInfo _getSalesInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = MaterialControllerBean.getFilterOUMaterial((Context)ctx, (String)"orgUnit.id", (String)ouid, (String)"material.id", (String)matid);
        viewInfo.setFilter(filterinfo);
        this.getSalesSelectors(viewInfo.getSelector());
        MaterialSalesCollection con = MaterialSalesFactory.getLocalInstance(ctx).getMaterialSalesCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            int i = 0;
            if (i < con.size()) {
                MaterialSalesInfo info = con.get(i);
                if (info.getOrgUnit().getId().toString().equals(ouid)) {
                    // empty if block
                }
                return info;
            }
            return con.get(0);
        }
        MaterialSalesInfo info = null;
        return info;
    }

    private SelectorItemCollection getSalesSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("taxData.id"));
        sic.add(new SelectorItemInfo("taxData.number"));
        sic.add(new SelectorItemInfo("taxData.name"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("isReturn"));
        sic.add(new SelectorItemInfo("isnotCheckOnReturn"));
        sic.add(new SelectorItemInfo("isReceivByCheck"));
        sic.add(new SelectorItemInfo("issueTopRatio"));
        sic.add(new SelectorItemInfo("issueBottomRatio"));
        sic.add(new SelectorItemInfo("daydAhead"));
        sic.add(new SelectorItemInfo("daysDelay"));
        sic.add(new SelectorItemInfo("lowerQuantity"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("abcType"));
        sic.add(new SelectorItemInfo("isPurBySale"));
        sic.add(new SelectorItemInfo("innerPriceRate"));
        return sic;
    }
}

