/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CopyDataStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UserParamInfo;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class MaterialSaleCopyProcessor
extends AbstractBusinessProcessor {
    public MaterialSaleCopyProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo newMaterial = (MaterialInfo)ac.getData("newMaterial");
        EntityViewInfo viewInfo = (EntityViewInfo)ac.getData("viewInfo");
        MeasureUnitInfo newBaseUnit = (MeasureUnitInfo)ac.getData("newBaseUnit");
        boolean isModify = (Boolean)ac.getData("isModify");
        UserParamInfo userParam = (UserParamInfo)ac.getData("userParam");
        IMaterialSales iMaterialSales = MaterialSalesFactory.getLocalInstance(this.ctx);
        MaterialSalesCollection materialSalesColl = iMaterialSales.getMaterialSalesCollection(viewInfo);
        int size = materialSalesColl.size();
        MaterialSalesInfo materialSales = null;
        for (int index = 0; index < size; ++index) {
            CopyDataStatusEnum copyBaseDataStaus;
            UsedStatusEnum destStatus;
            materialSales = materialSalesColl.get(index);
            materialSales.setId(null);
            materialSales.setMaterial(newMaterial);
            materialSales.setCreator(newMaterial.getCreator());
            materialSales.setCreateTime(newMaterial.getCreateTime());
            materialSales.setLastUpdateUser(newMaterial.getLastUpdateUser());
            materialSales.setLastUpdateTime(newMaterial.getLastUpdateTime());
            if (isModify) {
                materialSales.setUnit(newBaseUnit);
            }
            if ((destStatus = MaterialUtil.getMaterialCopyStatus((CopyDataStatusEnum)(copyBaseDataStaus = userParam.getCopySaleDataStaus()), (UsedStatusEnum)materialSales.getStatus())) == UsedStatusEnum.APPROVED) {
                try {
                    MaterialUtil.checkFunctionPermission((Context)this.ctx, (String)newMaterial.getCU().getId().toString(), (String)"bd_materialSale_approve");
                }
                catch (PermissionException e) {
                    destStatus = UsedStatusEnum.UNAPPROVE;
                }
            }
            materialSales.setStatus(destStatus);
            iMaterialSales.addnew((CoreBaseInfo)materialSales);
        }
    }
}

