/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.AreaCollection;
import com.kingdee.eas.basedata.assistant.AreaFactory;
import com.kingdee.eas.basedata.assistant.AreaInfo;
import com.kingdee.eas.basedata.assistant.IndustryFactory;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitLayer;
import com.kingdee.eas.basedata.org.IOtherDealUpdateSortCode;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.app.di.BizOrgDIBase;
import com.kingdee.eas.basedata.org.app.di.IAdminOrgImportCheck;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Hashtable;
import java.util.Locale;

public class AdminDI
extends BizOrgDIBase {
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        StringBuffer message;
        AdminOrgUnitCollection adminOrgUnitCollection;
        AdminOrgUnitInfo adminOrgUnitInfo;
        String number = this.getFieldValue(hsData, "FNumber");
        String parent = this.getFieldValue(hsData, "FParentID");
        String layerType = this.getFieldValue(hsData, "FLayerTypeID");
        String address = this.getFieldValue(hsData, "FAddressID");
        String telephone = this.getFieldValue(hsData, "FPhoneNumber");
        String zipCode = this.getFieldValue(hsData, "FZipCode");
        String fax = this.getFieldValue(hsData, "FFax");
        String isVirtual = this.getFieldValue(hsData, "FIsVirtual");
        String baseDuty_l1 = this.getFieldValue(hsData, "FBaseDuty_L1");
        String baseDuty_l2 = this.getFieldValue(hsData, "FBaseDuty_L2");
        String baseDuty_l3 = this.getFieldValue(hsData, "FBaseDuty_L3");
        String industry = this.getFieldValue(hsData, "FIndustry");
        String territory = this.getFieldValue(hsData, "FTerritory");
        String juridicalPerson = this.getFieldValue(hsData, "FJuridicalPersonID");
        String taxNum = this.getFieldValue(hsData, "FTaxNumber");
        String capital = this.getFieldValue(hsData, "FRegisteredCapital");
        String orgCode = this.getFieldValue(hsData, "FOrgCode");
        String isJuridicalCompany = this.getFieldValue(hsData, "FIsJuridicalCompany");
        String isIndependence = this.getFieldValue(hsData, "FIsIndependence");
        String isChurchyard = this.getFieldValue(hsData, "FIsChurchyard");
        String setDate = this.getFieldValue(hsData, "FSetupDate");
        String endDate = this.getFieldValue(hsData, "FEndupDate");
        String areaNumber = this.getFieldValue(hsData, "FArea_number");
        AreaInfo areaInfo = null;
        if (!StringUtils.isEmpty((String)areaNumber)) {
            AreaCollection areaCollection = AreaFactory.getLocalInstance((Context)ctx).getAreaCollection("select id where deletedStatus = 1 and number = '" + areaNumber + "'");
            if (areaCollection.size() > 0) {
                areaInfo = areaCollection.get(0);
            } else {
                throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"AREANUMBER_NOT_VALID", (Locale)ctx.getLocale()));
            }
        }
        boolean isSltImportUpdate = this.isSltImportUpdate();
        if (orgCode != null && orgCode.length() > 80) {
            orgCode = orgCode.substring(0, 80);
        }
        String unitLayer = this.getFieldValue(hsData, "FLayer");
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkRequeiredField(ctx, "FParentID", parent);
        this.checkRequeiredField(ctx, "FLayerTypeID", layerType);
        if (isSltImportUpdate && (adminOrgUnitInfo = (adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance(ctx).getAdminOrgUnitCollection("select isstartshr,longnumber where number = '" + number + "'")).get(0)) != null && adminOrgUnitInfo.isIsStartSHR()) {
            String longnumber = adminOrgUnitInfo.getLongNumber();
            String[] numbers = longnumber.split("!");
            if (numbers.length >= 2) {
                String parentNumber = numbers[numbers.length - 2];
                if (!parent.equalsIgnoreCase(parentNumber)) {
                    Locale currentLocale = ctx.getLocale();
                    throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"IS_NOT_MODIFY_PARENT", (Locale)currentLocale));
                }
            } else if (!"".equals(parent)) {
                Locale currentLocale = ctx.getLocale();
                throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"IS_NOT_MODIFY_PARENT", (Locale)currentLocale));
            }
        }
        if (number.equals(parent)) {
            Locale currentLocale = ctx.getLocale();
            throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADD_BIZ_NUMBER_NOTEQ_PARENT", (Locale)currentLocale));
        }
        FullOrgUnitInfo unitInfo = this.getFullOrgUnitInfo4BizOrg(ctx, number);
        unitInfo.setIsAdminOrgUnit(true);
        AdminOrgUnitInfo parentInfo = (AdminOrgUnitInfo)this.getBizOrgUnitInfo(ctx, OrgType.Admin, parent);
        this.getBizParentAndDelegationInfo(unitInfo).setParentOrg(OrgType.Admin, (OrgUnitInfo)parentInfo);
        OUPartAdminInfo partAdminInfo = unitInfo.getPartAdmin();
        if (partAdminInfo == null) {
            partAdminInfo = new OUPartAdminInfo();
            partAdminInfo.setUnit(unitInfo);
            unitInfo.setPartAdmin(partAdminInfo);
        }
        if (unitInfo.isIsCU()) {
            partAdminInfo.setControlUnit(unitInfo.getCU());
        } else {
            partAdminInfo.setControlUnit(parentInfo.getCU());
        }
        partAdminInfo.setUnitLayerType(this.getLayerTypeInfo(ctx, layerType));
        if (!StringUtils.isEmpty((String)unitLayer)) {
            partAdminInfo.setUnitLayer(this.getUnitLayerInfo(ctx, unitLayer, partAdminInfo.getUnitLayerType().getId().toString()));
        } else {
            IOrgUnitLayer iLayer = OrgUnitLayerFactory.getLocalInstance(ctx);
            String layerTypeID = partAdminInfo.getUnitLayerType().getId().toString();
            OrgUnitLayerCollection layerCollection = iLayer.getOrgUnitLayerCollection("Select id,name Where layerType.id = '" + layerTypeID + "'");
            if (layerCollection != null && layerCollection.size() > 0) {
                partAdminInfo.setUnitLayer(layerCollection.get(0));
            }
        }
        if (StringUtils.isEmpty((String)address) && isSltImportUpdate) {
            partAdminInfo.setAddress(null);
        }
        if (!StringUtils.isEmpty((String)address)) {
            AddressInfo addressInfo = (AddressInfo)this.getCoreBaseInfo((ICoreBase)AddressFactory.getLocalInstance((Context)ctx), address);
            if (addressInfo == null) {
                message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(address);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADDRESS_NOT_EXISTED", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partAdminInfo.setAddress(addressInfo);
        }
        partAdminInfo.setArea(areaInfo);
        if (StringUtils.isEmpty((String)telephone) && isSltImportUpdate) {
            partAdminInfo.setPhoneNumber(null);
        }
        if (!StringUtils.isEmpty((String)telephone)) {
            partAdminInfo.setPhoneNumber(telephone);
        }
        if (StringUtils.isEmpty((String)fax) && isSltImportUpdate) {
            partAdminInfo.setFax(null);
        }
        if (!StringUtils.isEmpty((String)fax)) {
            partAdminInfo.setFax(fax);
        }
        if (StringUtils.isEmpty((String)zipCode) && isSltImportUpdate) {
            partAdminInfo.setZipCode(null);
        }
        if (!StringUtils.isEmpty((String)zipCode)) {
            partAdminInfo.setZipCode(zipCode);
        }
        if ("1".equalsIgnoreCase(isVirtual) || "Y".equalsIgnoreCase(isVirtual)) {
            partAdminInfo.setIsVirtual(true);
        } else {
            partAdminInfo.setIsVirtual(false);
        }
        if (StringUtils.isEmpty((String)baseDuty_l1) && isSltImportUpdate) {
            partAdminInfo.setBaseDuty(null, new Locale("L1"));
        }
        if (!StringUtils.isEmpty((String)baseDuty_l1)) {
            partAdminInfo.setBaseDuty(baseDuty_l1, new Locale("L1"));
        }
        if (StringUtils.isEmpty((String)baseDuty_l2) && isSltImportUpdate) {
            partAdminInfo.setBaseDuty(null, new Locale("L2"));
        }
        if (!StringUtils.isEmpty((String)baseDuty_l2)) {
            partAdminInfo.setBaseDuty(baseDuty_l2, new Locale("L2"));
        }
        if (StringUtils.isEmpty((String)baseDuty_l3) || isSltImportUpdate) {
            partAdminInfo.setBaseDuty(null, new Locale("L3"));
        }
        if (!StringUtils.isEmpty((String)baseDuty_l3)) {
            partAdminInfo.setBaseDuty(baseDuty_l3, new Locale("L3"));
        }
        if (StringUtils.isEmpty((String)industry) && isSltImportUpdate) {
            partAdminInfo.setIndustry(null);
        }
        if (!StringUtils.isEmpty((String)industry)) {
            IndustryInfo industryInfo = (IndustryInfo)this.getCoreBaseInfo((ICoreBase)IndustryFactory.getLocalInstance((Context)ctx), industry);
            if (industryInfo == null) {
                message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(industry);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"INDUSTRY", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partAdminInfo.setIndustry(industryInfo);
        }
        if (territory != null && territory.length() != 0) {
            partAdminInfo.setTerritory(territory);
        }
        if (StringUtils.isEmpty((String)juridicalPerson) && isSltImportUpdate) {
            partAdminInfo.setJuridicalPerson(null);
        }
        if (!StringUtils.isEmpty((String)juridicalPerson)) {
            PersonInfo juridicalPersonInfo = (PersonInfo)this.getCoreBaseInfo((ICoreBase)PersonFactory.getLocalInstance((Context)ctx), juridicalPerson);
            if (juridicalPersonInfo == null) {
                message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(juridicalPerson);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"JURIDICAL_PERSON", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partAdminInfo.setJuridicalPerson(juridicalPersonInfo);
        }
        if (StringUtils.isEmpty((String)taxNum) && isSltImportUpdate) {
            partAdminInfo.setTaxNumber(null);
        }
        if (!StringUtils.isEmpty((String)taxNum)) {
            partAdminInfo.setTaxNumber(taxNum);
        }
        if (StringUtils.isEmpty((String)orgCode) && isSltImportUpdate) {
            partAdminInfo.setOrgCode(null);
        }
        if (!StringUtils.isEmpty((String)orgCode)) {
            partAdminInfo.setOrgCode(orgCode);
        }
        if (StringUtils.isEmpty((String)setDate) && isSltImportUpdate) {
            partAdminInfo.setSetupDate(null);
        }
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        if (!StringUtils.isEmpty((String)setDate)) {
            partAdminInfo.setSetupDate(new Timestamp(dtformat.parse(setDate).getTime()));
        }
        if (StringUtils.isEmpty((String)endDate) && isSltImportUpdate) {
            partAdminInfo.setEndupDate(null);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            partAdminInfo.setEndupDate(new Timestamp(dtformat.parse(endDate).getTime()));
        }
        if ("1".equalsIgnoreCase(isJuridicalCompany) || "Y".equalsIgnoreCase(isJuridicalCompany)) {
            partAdminInfo.setIsJuridicalCompany(true);
        } else {
            partAdminInfo.setIsJuridicalCompany(false);
        }
        if ("1".equalsIgnoreCase(isIndependence) || "Y".equalsIgnoreCase(isIndependence)) {
            partAdminInfo.setIsIndependence(true);
        } else {
            partAdminInfo.setIsIndependence(false);
        }
        if ("1".equalsIgnoreCase(isChurchyard) || "Y".equalsIgnoreCase(isChurchyard)) {
            partAdminInfo.setIsChurchyard(true);
        } else {
            partAdminInfo.setIsChurchyard(false);
        }
        if (StringUtils.isEmpty((String)capital) && isSltImportUpdate) {
            partAdminInfo.setRegisteredCapital(null);
        }
        if (!StringUtils.isEmpty((String)capital)) {
            partAdminInfo.setRegisteredCapital(new BigDecimal(capital));
        }
        if (partAdminInfo.isIsJuridicalCompany() && !partAdminInfo.isIsIndependence()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.basedata.orgext.ORGEXTAutoGenerateResource", (String)"0_AdminDI", (Locale)ctx.getLocale()));
        }
        if (unitInfo.isIsCompanyOrgUnit()) {
            partAdminInfo.setIsIndependence(true);
        }
        if (unitInfo.isIsCompanyOrgUnit()) {
            partAdminInfo.setIsIndependence(true);
        }
        this.otherDealAdminOrgImportChecker(ctx, partAdminInfo, isSltImportUpdate);
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        orgTypeHelper.addOrgType(OrgType.Admin);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        return unitInfo;
    }

    private void otherDealAdminOrgImportChecker(Context ctx, OUPartAdminInfo ouPartAdminInfo, boolean importModel) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"BCA8D47D", IOtherDealUpdateSortCode.class);
            if (checks != null && checks.length > 0) {
                IAdminOrgImportCheck otherDealCheckers = null;
                for (int i = 0; i < checks.length; ++i) {
                    otherDealCheckers = (IAdminOrgImportCheck)Class.forName(checks[i]).newInstance();
                    otherDealCheckers.check(ctx, ouPartAdminInfo, importModel);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private OrgUnitLayerTypeInfo getLayerTypeInfo(Context ctx, String layerType) throws Exception {
        boolean isBOSUuid = true;
        try {
            BOSUuid.read((String)layerType);
        }
        catch (Exception e) {
            isBOSUuid = false;
        }
        if (isBOSUuid) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)layerType));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            if (OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).exists(filterInfo)) {
                BOSUuid uuid = BOSUuid.read((String)layerType);
                OrgUnitLayerTypeInfo layerTypeInfo = new OrgUnitLayerTypeInfo();
                layerTypeInfo.setId(uuid);
                return layerTypeInfo;
            }
        }
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("name", (Object)layerType));
        filterInfo2.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        if (OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).exists(filterInfo2)) {
            OrgUnitLayerTypeInfo layerTypeInfo = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).getOrgUnitLayerTypeInfo("select id where name = '" + layerType + "' and state = 1");
            return layerTypeInfo;
        }
        throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ORG_LAYER_TYPE_NOT_CORRECT", (Locale)ctx.getLocale()));
    }

    private OrgUnitLayerInfo getUnitLayerInfo(Context ctx, String unitLayer, String layerTypeID) throws Exception {
        boolean isBOSUuid = true;
        try {
            BOSUuid.read((String)unitLayer);
        }
        catch (Exception e) {
            isBOSUuid = false;
        }
        if (isBOSUuid) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)unitLayer));
            filterInfo.getFilterItems().add(new FilterItemInfo("layerType.id", (Object)layerTypeID));
            if (OrgUnitLayerFactory.getLocalInstance(ctx).exists(filterInfo)) {
                BOSUuid uuid = BOSUuid.read((String)unitLayer);
                OrgUnitLayerInfo layerInfo = new OrgUnitLayerInfo();
                layerInfo.setId(uuid);
                return layerInfo;
            }
        }
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("name", (Object)unitLayer));
        filterInfo2.getFilterItems().add(new FilterItemInfo("layerType.id", (Object)layerTypeID));
        if (OrgUnitLayerFactory.getLocalInstance(ctx).exists(filterInfo2)) {
            OrgUnitLayerInfo layerInfo = OrgUnitLayerFactory.getLocalInstance(ctx).getOrgUnitLayerInfo("select id where name = '" + unitLayer + "'");
            return layerInfo;
        }
        throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.basedata.orgext.ORGEXTAutoGenerateResource", (String)"1_AdminDI", (Locale)ctx.getLocale()));
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            boolean isIndependence;
            boolean isJuridicalCompany;
            String orgCode;
            Timestamp endupDate;
            Timestamp setupDate;
            Timestamp createTime;
            String creatorNumber;
            BigDecimal registeredCapital;
            String taxNumber;
            String juridicalPersonNumber;
            String territory;
            String industryNumber;
            boolean isVirtual;
            String fax;
            String zipCode;
            String phoneNumber;
            String addressNumber;
            String layerId;
            String layerTypeId;
            result.put("FNumber", rs.getString("number"));
            String parentNumber = rs.getString("parent.number");
            if (parentNumber != null) {
                result.put("FParentID", parentNumber);
            }
            if ((layerTypeId = rs.getString("unitLayerType.name")) != null) {
                result.put("FLayerTypeID", layerTypeId);
            }
            if ((layerId = rs.getString("unitLayer.name")) != null) {
                result.put("FLayer", layerId);
            }
            if ((addressNumber = rs.getString("address.number")) != null) {
                result.put("FAddressID", addressNumber);
            }
            if ((phoneNumber = rs.getString("phoneNumber")) != null) {
                result.put("FPhoneNumber", phoneNumber);
            }
            if ((zipCode = rs.getString("zipCode")) != null) {
                result.put("FZipCode", zipCode);
            }
            if ((fax = rs.getString("fax")) != null) {
                result.put("FFax", fax);
            }
            if (isVirtual = rs.getBoolean("isVirtual")) {
                result.put("FIsVirtual", new String("Y"));
            }
            if ((industryNumber = rs.getString("industry.number")) != null) {
                result.put("FIndustry", industryNumber);
            }
            if ((territory = rs.getString("territory")) != null) {
                result.put("FTerritory", territory);
            }
            if ((juridicalPersonNumber = rs.getString("juridicalPerson.number")) != null) {
                result.put("FJuridicalPersonID", juridicalPersonNumber);
            }
            if ((taxNumber = rs.getString("taxNumber")) != null) {
                result.put("FTaxNumber", taxNumber);
            }
            if ((registeredCapital = rs.getBigDecimal("registeredCapital")) != null) {
                result.put("FRegisteredCapital", registeredCapital.toString());
            }
            Locale currentLocale = ctx.getLocale();
            String baseDuty = rs.getString("baseDuty");
            if (baseDuty != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FBaseDuty_L1", baseDuty);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FBaseDuty_L2", baseDuty);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FBaseDuty_L3", baseDuty);
                }
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
            if ((setupDate = rs.getTimestamp("setupDate")) != null) {
                result.put("FSetupDate", ExcelUtil.formatNationalTime((Context)ctx, (Object)setupDate));
            }
            if ((endupDate = rs.getTimestamp("endupDate")) != null) {
                result.put("FEndupDate", ExcelUtil.formatNationalTime((Context)ctx, (Object)endupDate));
            }
            if ((orgCode = rs.getString("orgCode")) != null) {
                result.put("FOrgCode", orgCode);
            }
            if (isJuridicalCompany = rs.getBoolean("isJuridicalCompany")) {
                result.put("FIsJuridicalCompany", new String("Y"));
            }
            if (isIndependence = rs.getBoolean("isIndependence")) {
                result.put("FIsIndependence", new String("Y"));
            }
            boolean isChurchyard = rs.getBoolean("isChurchyard");
            if (isIndependence) {
                result.put("FIsChurchyard", new String("Y"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.AdminExportQuery";
    }
}

