/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartStorageInfo;
import com.kingdee.eas.basedata.org.OrgStorageStatus;
import com.kingdee.eas.basedata.org.OrgStorageType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.app.di.BizOrgDIBase;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Locale;

public class StorageDI
extends BizOrgDIBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String number = this.getFieldValue(hsData, "FNumber");
        String parent = this.getFieldValue(hsData, "FParentID");
        String isBizUnit = this.getFieldValue(hsData, "FIsBizUnit");
        String address = this.getFieldValue(hsData, "FAddressID");
        String leader = this.getFieldValue(hsData, "FLeader");
        String type = this.getFieldValue(hsData, "FType");
        String status = this.getFieldValue(hsData, "FStatus");
        String location = this.getFieldValue(hsData, "FLocation");
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkRequeiredField(ctx, "FParentID", parent);
        if (number.equals(parent)) {
            Locale currentLocale = ctx.getLocale();
            throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADD_BIZ_NUMBER_NOTEQ_PARENT", (Locale)currentLocale));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)parent));
        filterInfo.getFilterItems().add(new FilterItemInfo("partStorage.isBizUnit", (Object)Boolean.TRUE));
        if (this.getBizInterface(ctx).exists(filterInfo)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.basedata.orgext.ORGEXTAutoGenerateResource", (String)"2_CompanyDI", (Locale)ctx.getLocale()));
        }
        FullOrgUnitInfo unitInfo = this.getFullOrgUnitInfo4BizOrg(ctx, number);
        unitInfo.setIsStorageOrgUnit(true);
        this.getBizParentAndDelegationInfo(unitInfo).setParentOrg(OrgType.Storage, (OrgUnitInfo)((StorageOrgUnitInfo)this.getBizOrgUnitInfo(ctx, OrgType.Storage, parent)));
        OUPartStorageInfo partStorageInfo = unitInfo.getPartStorage();
        if (partStorageInfo == null) {
            partStorageInfo = new OUPartStorageInfo();
            partStorageInfo.setUnit(unitInfo);
            unitInfo.setPartStorage(partStorageInfo);
        }
        if ("1".equalsIgnoreCase(isBizUnit) || "Y".equalsIgnoreCase(isBizUnit)) {
            partStorageInfo.setIsBizUnit(true);
        } else {
            partStorageInfo.setIsBizUnit(false);
        }
        if (address != null && address.length() != 0) {
            AddressInfo addressInfo = (AddressInfo)this.getCoreBaseInfo((ICoreBase)AddressFactory.getLocalInstance((Context)ctx), address);
            if (addressInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(address);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADDRESS_NOT_EXISTED", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partStorageInfo.setAddress(addressInfo);
        }
        if (leader != null && leader.length() != 0) {
            PersonInfo leadInfo = (PersonInfo)this.getCoreBaseInfo((ICoreBase)PersonFactory.getLocalInstance((Context)ctx), leader);
            if (leadInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(leader);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"LEADER_NOT_EXISTED", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partStorageInfo.setLeader(leadInfo);
        }
        if (type != null && type.length() != 0) {
            if ("-1".equals(type)) {
                partStorageInfo.setType(OrgStorageType.None);
            } else if ("0".equals(type)) {
                partStorageInfo.setType(OrgStorageType.Factory);
            } else {
                if (!"1".equals(type)) throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"STORAGE_TYPE_NOT_CORRECT", (Locale)ctx.getLocale()));
                partStorageInfo.setType(OrgStorageType.DispatchCenter);
            }
        } else {
            partStorageInfo.setType(OrgStorageType.None);
        }
        if (status != null && status.length() != 0) {
            if ("-1".equals(status)) {
                partStorageInfo.setStatus(OrgStorageStatus.None);
            } else if ("0".equals(status)) {
                partStorageInfo.setStatus(OrgStorageStatus.Normal);
            } else if ("1".equals(status)) {
                partStorageInfo.setStatus(OrgStorageStatus.StorageInFreeze);
            } else if ("2".equals(status)) {
                partStorageInfo.setStatus(OrgStorageStatus.StorageOutFreeze);
            } else if ("3".equals(status)) {
                partStorageInfo.setStatus(OrgStorageStatus.StorageInOutFreeze);
            } else {
                if (!"4".equals(status)) throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"STORAGE_STATUS_NOT_CORRECT", (Locale)ctx.getLocale()));
                partStorageInfo.setStatus(OrgStorageStatus.SealUp);
            }
        } else {
            partStorageInfo.setStatus(OrgStorageStatus.None);
        }
        if (location != null && location.length() != 0) {
            partStorageInfo.setLocation(location);
        }
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        orgTypeHelper.addOrgType(OrgType.Storage);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        return unitInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            String leaderNumber;
            String addressNumber;
            boolean isBizUnit;
            result.put("FNumber", rs.getString("number"));
            String parentNumber = rs.getString("parent.number");
            if (parentNumber != null) {
                result.put("FParentID", parentNumber);
            }
            if (isBizUnit = rs.getBoolean("isBizUnit")) {
                result.put("FIsBizUnit", "Y");
            }
            if ((addressNumber = rs.getString("address.number")) != null) {
                result.put("FAddressID", addressNumber);
            }
            if ((leaderNumber = rs.getString("leader.number")) != null) {
                result.put("FLeader", leaderNumber);
            }
            int type = rs.getInt("type");
            result.put("FType", new Integer(type).toString());
            int status = rs.getInt("status");
            result.put("FStatus", new Integer(status).toString());
            String location = rs.getString("location");
            if (location != null) {
                result.put("FLocation", location);
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.StorageExportQuery";
    }
}

