/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartTransportInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.org.app.di.BizOrgDIBase;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Locale;

public class TransportDI
extends BizOrgDIBase {
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String number = this.getFieldValue(hsData, "FNumber");
        String parent = this.getFieldValue(hsData, "FParentID");
        String isBizUnit = this.getFieldValue(hsData, "FIsBizUnit");
        this.checkRequeiredField(ctx, "FNumber", number);
        if (number.equals(parent)) {
            Locale currentLocale = ctx.getLocale();
            throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADD_BIZ_NUMBER_NOTEQ_PARENT", (Locale)currentLocale));
        }
        FullOrgUnitInfo unitInfo = this.getFullOrgUnitInfo4BizOrg(ctx, number);
        if (parent != null && parent.trim().length() != 0) {
            this.getBizParentAndDelegationInfo(unitInfo).setParentOrg(OrgType.Transport, (OrgUnitInfo)((TransportOrgUnitInfo)this.getBizOrgUnitInfo(ctx, OrgType.Transport, parent)));
        } else if (unitInfo.getParent() != null) {
            this.checkRequeiredField(ctx, "FParentID", parent);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)parent));
        filterInfo.getFilterItems().add(new FilterItemInfo("partTransport.isBizUnit", (Object)Boolean.TRUE));
        if (this.getBizInterface(ctx).exists(filterInfo)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.basedata.orgext.ORGEXTAutoGenerateResource", (String)"2_CompanyDI", (Locale)ctx.getLocale()));
        }
        unitInfo.setIsTransportOrgUnit(true);
        OUPartTransportInfo partTransportInfo = unitInfo.getPartTransport();
        if (partTransportInfo == null) {
            partTransportInfo = new OUPartTransportInfo();
            partTransportInfo.setUnit(unitInfo);
            unitInfo.setPartTransport(partTransportInfo);
        }
        if ("1".equalsIgnoreCase(isBizUnit) || "Y".equalsIgnoreCase(isBizUnit)) {
            partTransportInfo.setIsBizUnit(true);
        } else {
            partTransportInfo.setIsBizUnit(false);
        }
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        orgTypeHelper.addOrgType(OrgType.Transport);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        return unitInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            boolean isBizUnit;
            result.put("FNumber", rs.getString("number"));
            String parentNumber = rs.getString("parent.number");
            if (parentNumber != null) {
                result.put("FParentID", parentNumber);
            }
            if (isBizUnit = rs.getBoolean("isBizUnit")) {
                result.put("FIsBizUnit", "Y");
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.TransportExportQuery";
    }
}

