/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.app.di.OrgDIBase;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Locale;

public class UnionCompanyDI
extends OrgDIBase {
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String treeNumber = this.getFieldValue(hsData, "TreeNumber");
        String unionGroupNumber = this.getFieldValue(hsData, "UnionGroupNumber");
        String companyNumber = this.getFieldValue(hsData, "FNumber");
        this.checkRequeiredField(ctx, "TreeNumber", treeNumber);
        this.checkRequeiredField(ctx, "UnionGroupNumber", unionGroupNumber);
        this.checkRequeiredField(ctx, "FNumber", companyNumber);
        OrgTreeCollection treeCol = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection("select id, layerType where number = '" + treeNumber + "'");
        if (treeCol.size() == 0) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(treeNumber);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"UNION_RANGE_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        if (treeCol.size() > 1) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(treeNumber);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"UNION_RANGE_HAS_VERSION1", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        OrgTreeInfo tree = treeCol.get(0);
        OrgStructureCollection parentCol = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select id,longNumber,level,displayName,sortCode where tree.number = '" + treeNumber + "' and unit.number = '" + unionGroupNumber + "'");
        if (parentCol.size() == 0) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(unionGroupNumber);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"UNION_GROUP_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        OrgStructureInfo parent = parentCol.get(0);
        FullOrgUnitInfo unit = (FullOrgUnitInfo)this.getCoreBaseInfo((ICoreBase)FullOrgUnitFactory.getLocalInstance((Context)ctx), companyNumber);
        if (unit == null) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(companyNumber);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"COMPANY_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        OrgViewType layerType = tree.getLayerType();
        if (OrgViewType.COMPANY.equals((Object)layerType) && !unit.isIsCompanyOrgUnit()) {
            throw new OrgException(OrgException.IMPORT_ORG_IS_NOT_COMPANY, new Object[]{unit.getNumber()});
        }
        if (OrgViewType.PROFITCENTER.equals((Object)layerType) && !unit.isIsProfitOrgUnit()) {
            throw new OrgException(OrgException.IMPORT_ORG_IS_NOT_PROFITCENTER, new Object[]{unit.getNumber()});
        }
        OrgStructureInfo structInfo = new OrgStructureInfo();
        structInfo.setParent(parent);
        structInfo.setTree(tree);
        structInfo.setUnit(unit);
        return structInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            OrgStructureCollection orgStructureCol = new OrgStructureCollection();
            orgStructureCol.add((OrgStructureInfo)coreBaseInfo);
            NewOUInnerFacadeFactory.getLocalInstance((Context)ctx).addNewUnionInput(orgStructureCol);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected void injectIDWhenUpdate(CoreBaseInfo newData, Context ctx) throws Exception {
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            String unitNumber;
            String unionGroupNumber;
            String treeNumber = rs.getString("tree.number");
            if (treeNumber != null) {
                result.put("TreeNumber", treeNumber);
            }
            if ((unionGroupNumber = rs.getString("unit2.number")) != null) {
                result.put("UnionGroupNumber", unionGroupNumber);
            }
            if ((unitNumber = rs.getString("unit.number")) != null) {
                result.put("FNumber", unitNumber);
            }
            Locale currentLocale = ctx.getLocale();
            String unitName = rs.getString("unit.name");
            if (unitName != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FName_L1", unitName);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FName_L2", unitName);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FName_L3", unitName);
                }
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("unit.createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.UnionCompanyExportQuery";
    }
}

