/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.extimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOUPartFI;
import com.kingdee.eas.basedata.org.OUPartFIFactory;
import com.kingdee.eas.basedata.org.OUPartFIInfo;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUtils;
import com.kingdee.eas.basedata.org.app.ext.IOrgExt;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.IAcountScheme;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;

public class OrgExtImpl
implements IOrgExt {
    public boolean hasAssistBizRefrenceForAdmin(Context ctx, String id) throws BOSException, EASBizException {
        return AssistUtil.hasBizRefrence((Context)ctx, (String)id, (BOSObjectType)BOSObjectType.create((String)"6A6435BE"));
    }

    public void updateAssistDataForAdmin(Context ctx, String id, String parentId) throws BOSException, EASBizException {
        AssistUtil.updateBizDate((Context)ctx, (String)id, (String)parentId, (BOSObjectType)BOSObjectType.create((String)"6A6435BE"));
    }

    public void updateCom(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IOUPartFI iCom = OUPartFIFactory.getLocalInstance(ctx);
        OUPartFIInfo info = (OUPartFIInfo)model;
        OUPartFIInfo comInfo = iCom.getOUPartFIInfo(pk);
        this._checkCompanyRef(ctx, comInfo, info);
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (info.getAccountTable() != null && comInfo.getAccountTable() != null) {
            if (!comInfo.getAccountTable().getId().equals((Object)info.getAccountTable().getId())) {
                iAccountView.deleteByCompany(pk);
                iAccountView.addAccountByCompany(pk);
            }
        } else if (comInfo.getAccountTable() == null) {
            iAccountView.addAccountByCompany(pk);
        } else {
            iAccountView.deleteByCompany(pk);
        }
        if (!(!info.isIsGroup() || OrgUtils.objectEquals((Object)((Object)info.getReportConvertMode()), (Object)((Object)comInfo.getReportConvertMode())) && OrgUtils.objectEquals((Object)info.getReportCurrency(), (Object)comInfo.getReportCurrency()) && OrgUtils.objectEquals((Object)info.getReportExchangeTable(), (Object)comInfo.getReportExchangeTable()))) {
            this.updateChildren(ctx, info);
        }
        iCom.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    private void updateChildren(Context ctx, OUPartFIInfo info) throws EASBizException, BOSException {
        OrgStructureCollection structInfos = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("Select id,longNumber Where tree.id='00000000-0000-0000-0000-0000000000024F2827FD' and unit.id='" + info.getUnit().getId().toString() + "'");
        OrgStructureInfo structInfo = null;
        if (structInfos.size() <= 0) {
            return;
        }
        structInfo = structInfos.get(0);
        Connection con = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DBUtils.getConnection((Context)ctx);
            String sql = "SELECT FUnitID from T_ORG_Structure WHERE FTreeID='00000000-0000-0000-0000-0000000000024F2827FD' and FLongNumber like '" + structInfo.getLongNumber() + "!" + "%'";
            String psql = "UPDATE T_ORG_OUPartFI SET FReportCurrencyID=?,FReportExgTableID=?,FReportConvertMode=? WHERE FUnitId=?";
            stmt = con.createStatement();
            pstmt = con.prepareStatement(psql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String unitID = rs.getString("FUnitID");
                this.fillBlank(pstmt, 1, (CoreBaseInfo)info.getReportCurrency());
                this.fillBlank(pstmt, 2, (CoreBaseInfo)info.getReportExchangeTable());
                pstmt.setInt(3, info.getReportConvertMode().getValue());
                pstmt.setString(4, unitID);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    private void _checkCompanyRef(Context ctx, OUPartFIInfo oldValue, OUPartFIInfo newValue) throws BOSException, EASBizException {
        boolean isRef = false;
        try {
            IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            fullOrgUnit.isReferenced((IObjectPK)new ObjectUuidPK(oldValue.getId()));
        }
        catch (ObjectReferedException e) {
            isRef = true;
        }
        if (isRef) {
            if (oldValue.getBaseCurrency() == null && newValue.getBaseCurrency() != null || oldValue.getBaseCurrency() != null && newValue.getBaseCurrency() == null || oldValue.getBaseCurrency().getId() != null && newValue.getBaseCurrency().getId() != null && !oldValue.getBaseCurrency().getId().toString().equals(newValue.getBaseCurrency().getId().toString())) {
                throw new OrgException(OrgException.COMPANY_BASE_CURRENCY_ISREFERENCE);
            }
            if (oldValue.getAccountPeriodType() == null && newValue.getAccountPeriodType() != null || oldValue.getAccountPeriodType() != null && newValue.getAccountPeriodType() == null || oldValue.getAccountPeriodType().getId() != null && newValue.getAccountPeriodType().getId() != null && !oldValue.getAccountPeriodType().getId().toString().equals(newValue.getAccountPeriodType().getId().toString())) {
                throw new OrgException(OrgException.COMPANY_PERIODTYPE_ISREFFERENCE);
            }
        }
    }

    private void fillBlank(PreparedStatement pstmt, int index, CoreBaseInfo info) throws SQLException {
        if (info == null) {
            pstmt.setString(index, null);
        } else {
            pstmt.setString(index, info.getId().toString());
        }
    }

    public void generateAssistantOrg(Context ctx, IObjectPK unitPK, IObjectPK accountSchemePK) throws BOSException, EASBizException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo mainFullInfo = (FullOrgUnitInfo)iFull.getValue(unitPK);
        if (!mainFullInfo.isIsCompanyOrgUnit()) {
            throw new OrgException(OrgException.NOT_COMPANY_TO_GENERATE_ASSISTANT);
        }
        IAcountScheme iScheme = AcountSchemeFactory.getLocalInstance((Context)ctx);
        AcountSchemeInfo schemeInfo = (AcountSchemeInfo)iScheme.getValue(accountSchemePK);
        if (schemeInfo.isIsMaster()) {
            throw new OrgException(OrgException.NOT_ALLOW_GENERATE_ASSISTANT_IN_MASTER);
        }
        FullOrgUnitInfo assistantFullInfo = this.createAssistantFullOrgUnitInfo(ctx, mainFullInfo, schemeInfo);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance(ctx);
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)iCompany.getValue(unitPK);
        BizParentAndDelegateInfo pdInfo = new BizParentAndDelegateInfo();
        pdInfo.setParentOrg(OrgType.Company, (OrgUnitInfo)companyInfo.getParent());
        assistantFullInfo.put("PDValueInfo", (Object)pdInfo);
        iFull.addnew((CoreBaseInfo)assistantFullInfo);
    }

    private FullOrgUnitInfo createAssistantFullOrgUnitInfo(Context ctx, FullOrgUnitInfo mainFullInfo, AcountSchemeInfo schemeInfo) throws BOSException, EASBizException {
        FullOrgUnitInfo assistantFullInfo = new FullOrgUnitInfo();
        String number = this.generateAssistantOrgNumber(ctx, mainFullInfo.getNumber(), schemeInfo.getNumber());
        assistantFullInfo.setNumber(number);
        String mainLongNumber = mainFullInfo.getLongNumber();
        int index = mainLongNumber.lastIndexOf("!");
        if (index != -1) {
            assistantFullInfo.setLongNumber(mainLongNumber.substring(0, index) + "!" + number);
        } else {
            assistantFullInfo.setLongNumber(number);
        }
        assistantFullInfo.setDescription(mainFullInfo.getDescription(new Locale("L1")), new Locale("L1"));
        assistantFullInfo.setDescription(mainFullInfo.getDescription(new Locale("L2")), new Locale("L2"));
        assistantFullInfo.setDescription(mainFullInfo.getDescription(new Locale("L3")), new Locale("L3"));
        assistantFullInfo.setSimpleName(mainFullInfo.getSimpleName());
        String name_l1 = null;
        if (!StringUtils.isEmpty((String)mainFullInfo.getName(new Locale("L1"))) && !StringUtils.isEmpty((String)schemeInfo.getName(new Locale("L1")))) {
            name_l1 = mainFullInfo.getName(new Locale("L1")) + "-" + schemeInfo.getName(new Locale("L1"));
        }
        String name_l2 = null;
        if (!StringUtils.isEmpty((String)mainFullInfo.getName(new Locale("L2"))) && !StringUtils.isEmpty((String)schemeInfo.getName(new Locale("L2")))) {
            name_l2 = mainFullInfo.getName(new Locale("L2")) + "-" + schemeInfo.getName(new Locale("L2"));
        }
        String name_l3 = null;
        if (!StringUtils.isEmpty((String)mainFullInfo.getName(new Locale("L3"))) && !StringUtils.isEmpty((String)schemeInfo.getName(new Locale("L3")))) {
            name_l3 = mainFullInfo.getName(new Locale("L3")) + "-" + schemeInfo.getName(new Locale("L3"));
        }
        assistantFullInfo.setName(name_l1, new Locale("L1"));
        assistantFullInfo.setName(name_l2, new Locale("L2"));
        assistantFullInfo.setName(name_l3, new Locale("L3"));
        String displayName_l1 = mainFullInfo.getDisplayName(new Locale("L1"));
        if (!StringUtils.isEmpty((String)displayName_l1) && !StringUtils.isEmpty((String)name_l1)) {
            int i = displayName_l1.lastIndexOf("_");
            if (i != -1) {
                assistantFullInfo.setDisplayName(displayName_l1.substring(0, i) + "_" + name_l1, new Locale("L1"));
            } else {
                assistantFullInfo.setDisplayName(name_l1, new Locale("L1"));
            }
        } else {
            assistantFullInfo.setDisplayName(null, new Locale("L1"));
        }
        String displayName_l2 = mainFullInfo.getDisplayName(new Locale("L2"));
        if (!StringUtils.isEmpty((String)displayName_l2) && !StringUtils.isEmpty((String)name_l2)) {
            int i = displayName_l2.lastIndexOf("_");
            if (i != -1) {
                assistantFullInfo.setDisplayName(displayName_l2.substring(0, i) + "_" + name_l2, new Locale("L2"));
            } else {
                assistantFullInfo.setDisplayName(name_l2, new Locale("L2"));
            }
        } else {
            assistantFullInfo.setDisplayName(null, new Locale("L2"));
        }
        String displayName_l3 = mainFullInfo.getDisplayName(new Locale("L3"));
        if (!StringUtils.isEmpty((String)displayName_l3) && !StringUtils.isEmpty((String)name_l3)) {
            int i = displayName_l3.lastIndexOf("_");
            if (i != -1) {
                assistantFullInfo.setDisplayName(displayName_l3.substring(0, i) + "_" + name_l3, new Locale("L3"));
            } else {
                assistantFullInfo.setDisplayName(name_l3, new Locale("L3"));
            }
        } else {
            assistantFullInfo.setDisplayName(null, new Locale("L3"));
        }
        assistantFullInfo.setIsLeaf(true);
        assistantFullInfo.setLevel(mainFullInfo.getLevel());
        assistantFullInfo.setIsFreeze(mainFullInfo.isIsFreeze());
        assistantFullInfo.setIsGrouping(mainFullInfo.isIsGrouping());
        assistantFullInfo.setIsStart(mainFullInfo.isIsStart());
        assistantFullInfo.setIsOUSealUp(mainFullInfo.isIsOUSealUp());
        assistantFullInfo.setIsCompanyOrgUnit(true);
        this.setAssistantOUPartFIInfo(ctx, mainFullInfo, assistantFullInfo, schemeInfo);
        assistantFullInfo.setIsAdminOrgUnit(false);
        assistantFullInfo.setPartAdmin(null);
        assistantFullInfo.setIsSaleOrgUnit(false);
        assistantFullInfo.setPartSale(null);
        assistantFullInfo.setIsPurchaseOrgUnit(false);
        assistantFullInfo.setPartPurchase(null);
        assistantFullInfo.setIsStorageOrgUnit(false);
        assistantFullInfo.setPartStorage(null);
        assistantFullInfo.setIsCostOrgUnit(false);
        assistantFullInfo.setPartCostCenter(null);
        assistantFullInfo.setIsProfitOrgUnit(false);
        assistantFullInfo.setPartProfitCenter(null);
        assistantFullInfo.setIsCU(false);
        assistantFullInfo.setPartCtrl(null);
        assistantFullInfo.setIsUnion(false);
        assistantFullInfo.setPartUnionGroup(null);
        assistantFullInfo.setIsHROrgUnit(false);
        assistantFullInfo.setPartHR(null);
        assistantFullInfo.setEffectDate(mainFullInfo.getEffectDate());
        assistantFullInfo.setInvalidDate(mainFullInfo.getInvalidDate());
        assistantFullInfo.setCreator(mainFullInfo.getCreator());
        assistantFullInfo.setCreateTime(mainFullInfo.getCreateTime());
        assistantFullInfo.setLastUpdateUser(mainFullInfo.getLastUpdateUser());
        assistantFullInfo.setLastUpdateTime(mainFullInfo.getLastUpdateTime());
        assistantFullInfo.setCU(mainFullInfo.getCU());
        assistantFullInfo.setParent(mainFullInfo.getParent());
        assistantFullInfo.setCode(null);
        assistantFullInfo.setEnglishName(mainFullInfo.getEnglishName());
        assistantFullInfo.setVersionNumber(mainFullInfo.getVersionNumber());
        assistantFullInfo.setMaintainCU(mainFullInfo.getMaintainCU());
        assistantFullInfo.setIsAssistantOrg(true);
        assistantFullInfo.setMainOrg(mainFullInfo);
        assistantFullInfo.getPartFI().setAccountScheme(schemeInfo);
        assistantFullInfo.setOrgTypeStr(";Company;");
        return assistantFullInfo;
    }

    private String generateAssistantOrgNumber(Context ctx, String mainOrgNumber, String schemeNumber) throws BOSException, EASBizException {
        StringBuffer symbol = new StringBuffer("@");
        StringBuffer numberBuf = new StringBuffer(mainOrgNumber).append(symbol).append(schemeNumber);
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        while (iFull.exists("where number = '" + numberBuf.toString() + "'")) {
            symbol.append("@");
            numberBuf = new StringBuffer(mainOrgNumber).append(symbol).append(schemeNumber);
        }
        return numberBuf.toString();
    }

    private void setAssistantOUPartFIInfo(Context ctx, FullOrgUnitInfo mainFullInfo, FullOrgUnitInfo assistantFullInfo, AcountSchemeInfo schemeInfo) throws BOSException, EASBizException {
        IOUPartFI iFI = OUPartFIFactory.getLocalInstance(ctx);
        OUPartFIInfo fiInfo = (OUPartFIInfo)iFI.getValue((IObjectPK)new ObjectUuidPK(mainFullInfo.getPartFI().getId()));
        fiInfo.setId(null);
        if (schemeInfo.getRateTable() != null) {
            fiInfo.setBaseExchangeTable(schemeInfo.getRateTable());
        }
        if (schemeInfo.getAdjRateTable() != null) {
            fiInfo.setAdjustExchangeTable(schemeInfo.getAdjRateTable());
        }
        if (schemeInfo.getPeriodType() != null) {
            fiInfo.setAccountPeriodType(schemeInfo.getPeriodType());
        }
        fiInfo.setAccountTable(null);
        if (schemeInfo.getCurrency() != null) {
            fiInfo.setBaseCurrency(schemeInfo.getCurrency());
        }
        assistantFullInfo.setPartFI(fiInfo);
    }

    public boolean existAccountTable(Context ctx, String accountTableId) throws BOSException, EASBizException {
        return AccountTableFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectStringPK(accountTableId));
    }

    public HashMap getFIPropertiesOfCU(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        OUPartFIInfo fiInfo;
        String oql;
        HashMap<String, Object> fiProperties = new HashMap<String, Object>();
        IOUPartFI iOUPartFI = OUPartFIFactory.getLocalInstance(ctx);
        if (iOUPartFI.exists(oql = "select accountTable.id, accountTable.name, accountPeriodType.id, accountPeriodType.name, reportCurrency.id, reportCurrency.name where unit.id = '" + cuPK.toString() + "'")) {
            fiInfo = iOUPartFI.getOUPartFIInfo(oql);
            fiProperties.put("accountTable", fiInfo.getAccountTable());
            fiProperties.put("periodType", fiInfo.getAccountPeriodType());
        }
        if (iOUPartFI.exists(oql = "select reportCurrency.id, reportCurrency.name where unit.id = '00000000-0000-0000-0000-000000000000CCE7AED4'")) {
            fiInfo = iOUPartFI.getOUPartFIInfo(oql);
            fiProperties.put("reportCurrency", fiInfo.getReportCurrency());
        }
        return fiProperties;
    }
}

