/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartPurchase;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartPurchaseCollection;
import com.kingdee.eas.basedata.org.OUPartPurchaseFactory;
import com.kingdee.eas.basedata.org.OUPartPurchaseInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppPurchaseImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppPurchaseImpl.class.getName());

    private boolean isPurchaseBizUnitChanged(Context ctx, OUPartPurchaseInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartPurchase iPartPurchase = OUPartPurchaseFactory.getLocalInstance(ctx);
        OUPartPurchaseInfo oldInfo = iPartPurchase.getOUPartPurchaseInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.isIsPurchaseOrgUnit()) {
            OUPartPurchaseInfo partPurchaseInfo = unitInfo.getPartPurchase();
            if (this.isPurchaseBizUnitChanged(ctx, partPurchaseInfo)) {
                if (partPurchaseInfo.isIsBizUnit()) {
                    INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                    if (iNOV.isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000084F2827FD")) {
                        throw new OUException(OUException.PURCHASE_BIZUNIT_CHILDREN);
                    }
                } else {
                    boolean isDelegatedByOthers = OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)3);
                    if (isDelegatedByOthers) {
                        throw new OUException(OUException.PURCHASE_BIZUNIT_DELEGATED);
                    }
                }
            }
            partPurchaseInfo.setUnit(unitInfo);
            IOUPartPurchase iPartPurchase = OUPartPurchaseFactory.getLocalInstance(ctx);
            if (iPartPurchase.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (partPurchaseInfo.getId() == null) {
                    BOSUuid partID = iPartPurchase.getOUPartPurchaseInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    partPurchaseInfo.setId(partID);
                }
                iPartPurchase.update((IObjectPK)new ObjectUuidPK(partPurchaseInfo.getId()), partPurchaseInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsPurchaseOrgUnit()) {
                    Object[] param = new Object[]{OrgType.Purchase.getAlias(), OrgType.Purchase.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                partPurchaseInfo.setVersionNumber(versionNumber);
                iPartPurchase.addnew(partPurchaseInfo);
                unitInfo.setPartPurchase(partPurchaseInfo);
            }
        } else {
            IOUPartPurchase iPartPurchase = OUPartPurchaseFactory.getLocalInstance(ctx);
            if (iPartPurchase.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartPurchaseInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartPurchase.delete(filter);
            }
            unitInfo.setPartPurchase(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsPurchaseOrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsPurchaseOrgUnit()) {
                Object[] param = new Object[]{OrgType.Purchase.getAlias(), OrgType.Purchase.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartPurchaseInfo ouPurchaseInfo = unitInfo.getPartPurchase();
            ouPurchaseInfo.setUnit(unitInfo);
            ouPurchaseInfo.setVersionNumber(unitInfo.getVersionNumber());
            IOUPartPurchase iPurchase = OUPartPurchaseFactory.getLocalInstance(ctx);
            IObjectPK newPK = iPurchase.addnew(ouPurchaseInfo);
            unitInfo.setPartPurchase(ouPurchaseInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsPurchaseOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
            Object[] params = new String[]{OrgType.Purchase.getAlias()};
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000084F2827FD")) {
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (iDelegate.isDelegatedByOthers(deleteInfo.getId().toString(), 3)) {
                throw new OUException(OUException.DELEGATEDBYOTHERS_NOTDELETE, params);
            }
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"5750B219", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"DF1A22A2", (String)pk.toString());
            IOUPartPurchase iPurchase = OUPartPurchaseFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iPurchase.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_Purchase (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FLeader,\n").append("FAddressID,\n").append("FIsSealUp,\n").append("FIsBizUnit ,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("pur.FLeader,\n").append("pur.FAddressID,\n").append("pur.FIsSealUp,\n").append("pur.FIsBizUnit ,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("pur.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartPurchase pur ON ou.FID = pur.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000084F2827FD')\n");
        return new String[]{"delete from T_ORG_Purchase", sb.toString()};
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartPurchase");
        orgInfo.setTableNameHis("T_ORG_OUPartPurchase_his");
        orgInfo.setTableNameAlias("PtPur");
        orgInfo.setViewTableName("T_ORG_Purchase");
        orgInfo.setViewTableNameHis("T_ORG_Purchase_his");
        orgInfo.setViewTableAlias("Pur");
        orgInfo.setOrgViewBosType(new PurchaseOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartPurchaseInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartPurchaseInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new PurchaseOrgUnitInfo());
        orgInfo.setOrgType(OrgType.Purchase);
        return orgInfo;
    }

    protected OrgUnitCollection _getPurchaseOrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Purchase_His WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartPurchaseCollection _getOUPartPurchaseVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartPurchase_His").toString();
        try {
            OUPartPurchaseCollection partPurchaseVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartPurchaseCollection oUPartPurchaseCollection = partPurchaseVersionCol = OrgAppPurchaseImpl.createOUPartPurchaseVersionCollection(ctx, (ResultSet)rs);
            return oUPartPurchaseCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static PurchaseOrgUnitInfo createPurchaseOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String parentId;
        String addressId;
        PurchaseOrgUnitInfo purchaseVersionInfo = (PurchaseOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new PurchaseOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = purchaseVersionInfo.getVersionNumber();
        String leaderId = rs.getString("FLeader");
        if (leaderId != null && leaderId.trim().length() != 0) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)leaderId));
            purchaseVersionInfo.setLeader(personInfo);
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setId(BOSUuid.read((String)addressId));
            purchaseVersionInfo.setAddress(addressInfo);
        }
        if ((parentId = rs.getString("FParentID")) != null && parentId.trim().length() != 0) {
            PurchaseOrgUnitInfo parentVersionInfo = new PurchaseOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            purchaseVersionInfo.setParent(parentVersionInfo);
        }
        purchaseVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        purchaseVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        purchaseVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return purchaseVersionInfo;
    }

    public static OrgUnitCollection createPurchaseOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection purchaseVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            PurchaseOrgUnitInfo purchaseVersionInfo = OrgAppPurchaseImpl.createPurchaseOrgUnitVersionInfo(ctx, rs);
            purchaseVersionCol.add((OrgUnitInfo)purchaseVersionInfo);
        }
        return purchaseVersionCol;
    }

    public static OUPartPurchaseInfo createOUPartPurchaseVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String addressId;
        String leaderId;
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartPurchaseInfo partPurchaseVersionInfo = new OUPartPurchaseInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partPurchaseVersionInfo.setUnit(fullVersionInfo);
        }
        if ((leaderId = rs.getString("FLeader")) != null && leaderId.trim().length() != 0) {
            partPurchaseVersionInfo.setLeader((PersonInfo)OrgHelper.getVO((Context)ctx, (String)leaderId));
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            partPurchaseVersionInfo.setAddress((AddressInfo)OrgHelper.getVO((Context)ctx, (String)addressId));
        }
        partPurchaseVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        partPurchaseVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        partPurchaseVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return partPurchaseVersionInfo;
    }

    public static OUPartPurchaseCollection createOUPartPurchaseVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartPurchaseCollection partPurchaseVersionCol = new OUPartPurchaseCollection();
        while (rs.next()) {
            OUPartPurchaseInfo partPurchaseVersionInfo = OrgAppPurchaseImpl.createOUPartPurchaseVersionInfo(ctx, rs);
            partPurchaseVersionCol.add(partPurchaseVersionInfo);
        }
        return partPurchaseVersionCol;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartPurchase_His(FID,FUnitID,FAddressID,FLeader,FIsBizUnit,FIsSealUp,FPropertySealUpDate,FVersionNumber) SELECT FID,FUnitID,FAddressID,FLeader,FIsBizUnit,FIsSealUp,FPropertySealUpDate,FVersionNumber FROM T_ORG_OUPartPurchase");
        retList.add("INSERT INTO T_ORG_Purchase_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsSealUp, FIsBizUnit, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsSealUp, FIsBizUnit, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_Purchase");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_Purchase_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new PurchaseOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsPurchaseOrgUnit()) {
            PurchaseOrgUnitInfo purchaseVersionInfo = (PurchaseOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (purchaseVersionInfo == null) {
                throw new OUException(OUException.NONE_PURCHASE_SUPERIOR);
            }
            PurchaseOrgUnitInfo info = purchaseVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.Purchase, (OrgUnitInfo)((PurchaseOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartPurchaseInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partPurchaseId = rs.getString("FPartPurchaseID");
        if (partPurchaseId != null && partPurchaseId.trim().length() != 0) {
            OUPartPurchaseInfo partPurchaseVersionInfo = new OUPartPurchaseInfo(versionNumber, BOSUuid.read((String)partPurchaseId));
            fullVersionInfo.setPartPurchase(partPurchaseVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Purchase_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            PurchaseOrgUnitInfo purchaseVersionInfo = OrgAppPurchaseImpl.createPurchaseOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = purchaseVersionInfo;
            return purchaseOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Purchase_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = OrgAppPurchaseImpl.createPurchaseOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartPurchaseInfo partPurchaseVersionInfo = OrgAppPurchaseImpl.createOUPartPurchaseVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartPurchaseInfo oUPartPurchaseInfo = partPurchaseVersionInfo;
            return oUPartPurchaseInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartPurchase_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartPurchase_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsPurchaseOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.Purchase.getAlias(), OrgType.Purchase.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)3)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsPurchaseOrgUnit(false);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"5750B219", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"DF1A22A2", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartPurchase iPurchase = OUPartPurchaseFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iPurchase.delete(filter);
            unitInfo.setPartPurchase(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.Purchase);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

