/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.orgext.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.orgext.app.AbstractEASOrgFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EASOrgFacadeControllerBean
extends AbstractEASOrgFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.EASOrgFacadeControllerBean");
    private final String ROOTID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private static final String BASEUNITQUERY = "com.kingdee.eas.basedata.orgext.app.BaseUnitQuery";
    private static final String ORGSTRUCTUREQUERY = "com.kingdee.eas.basedata.orgext.app.OrgStructureQuery";

    @Override
    protected String _getFullOrgUnitByParent(Context ctx, String parentId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)parentId)) {
            FullOrgUnitInfo rootInfo = this.getRootFullOrgUnit(ctx);
            result.put("root", this.fullOrgUnit2Map(rootInfo));
            parentId = rootInfo.getId().toString();
        }
        FullOrgUnitCollection fullOrgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(this.buildViewInfo(parentId));
        ArrayList<Map> orgList = new ArrayList<Map>();
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            orgList.add(this.fullOrgUnit2Map(fullOrgColl.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getAdminOrgUnitByParent(Context ctx, String parentId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)parentId)) {
            AdminOrgUnitInfo rootInfo = this.getRootAdminOrgUnit(ctx);
            result.put("root", this.adminOrgUnit2Map(rootInfo));
            parentId = rootInfo.getId().toString();
        }
        AdminOrgUnitCollection adminOrgUnitColl = AdminOrgUnitFactory.getLocalInstance(ctx).getAdminOrgUnitCollection(this.buildViewInfo(parentId));
        ArrayList<Map> orgList = new ArrayList<Map>();
        for (int i = 0; i < adminOrgUnitColl.size(); ++i) {
            orgList.add(this.adminOrgUnit2Map(adminOrgUnitColl.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private FullOrgUnitInfo getRootFullOrgUnit(Context ctx) throws BOSException, EASBizException {
        return FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"), this.getSimpleSic());
    }

    private AdminOrgUnitInfo getRootAdminOrgUnit(Context ctx) throws BOSException, EASBizException {
        return AdminOrgUnitFactory.getLocalInstance(ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"), this.getSimpleSic());
    }

    private SelectorItemCollection getSimpleSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("longNumber");
        sic.add("name");
        sic.add("isLeaf");
        sic.add("level");
        sic.add("displayName");
        sic.add("isCU");
        sic.add("parent.id");
        sic.add("isCU");
        return sic;
    }

    private Map fullOrgUnit2Map(FullOrgUnitInfo orgInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", orgInfo.getId().toString());
        map.put("number", orgInfo.getNumber().toString());
        map.put("name", orgInfo.getName());
        map.put("name_l1", orgInfo.getName(LocaleUtils.locale_L1));
        map.put("name_l2", orgInfo.getName(LocaleUtils.locale_L2));
        map.put("name_l3", orgInfo.getName(LocaleUtils.locale_L3));
        map.put("isLeaf", orgInfo.isIsLeaf());
        map.put("isCU", orgInfo.isIsCU());
        map.put("longNumber", orgInfo.getLongNumber().toString());
        if (orgInfo.getParent() == null || orgInfo.getParent().getId() == null) {
            map.put("parent", null);
        } else {
            map.put("parent", orgInfo.getParent().getId().toString());
        }
        map.put("level", orgInfo.getLevel());
        map.put("displayName", orgInfo.getDisplayName());
        return map;
    }

    private Map adminOrgUnit2Map(AdminOrgUnitInfo orgInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", orgInfo.getId().toString());
        map.put("number", orgInfo.getNumber().toString());
        map.put("name", orgInfo.getName());
        map.put("name_l1", orgInfo.getName(LocaleUtils.locale_L1));
        map.put("name_l2", orgInfo.getName(LocaleUtils.locale_L2));
        map.put("name_l3", orgInfo.getName(LocaleUtils.locale_L3));
        map.put("isLeaf", orgInfo.isIsLeaf());
        if (orgInfo.getParent() == null || orgInfo.getParent().getId() == null) {
            map.put("parent", null);
        } else {
            map.put("parent", orgInfo.getParent().getId().toString());
        }
        map.put("level", orgInfo.getLevel());
        map.put("displayName", orgInfo.getDisplayName());
        map.put("longNumber", orgInfo.getLongNumber().toString());
        map.put("isCU", orgInfo.isIsCU());
        return map;
    }

    private EntityViewInfo buildViewInfo(String parentId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parentId));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
        viewInfo.setSelector(this.getSimpleSic());
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longNumber"));
        viewInfo.setSorter(sorterColl);
        return viewInfo;
    }

    private EntityViewInfo buildViewInfo(OrgUnitInfo parentInfo, int level) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
        if (level != 0) {
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)parentInfo.getLevel(), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)(parentInfo.getLevel() + level), CompareType.LESS_EQUALS));
        }
        viewInfo.setSelector(this.getSimpleSic());
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longNumber"));
        viewInfo.setSorter(sorterColl);
        return viewInfo;
    }

    @Override
    protected String _getAllFullOrgUnitByParent(Context ctx, String parentId) throws BOSException, EASBizException {
        return this._getFullOrgUnitByParent(ctx, parentId, 0);
    }

    @Override
    protected String _getFullOrgUnitByParent(Context ctx, String parentId, int level) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FullOrgUnitInfo parentInfo = null;
        parentInfo = StringUtils.isEmpty((String)parentId) ? this.getRootFullOrgUnit(ctx) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentId), this.getSimpleSic());
        result.put("root", this.fullOrgUnit2Map(parentInfo));
        FullOrgUnitCollection fullOrgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(this.buildViewInfo((OrgUnitInfo)parentInfo, level));
        ArrayList<Map> orgList = new ArrayList<Map>();
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            orgList.add(this.fullOrgUnit2Map(fullOrgColl.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getOrgUnitByNumber(Context ctx, String number) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = this.getSimpleSic();
        sic.add("parent.number");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        FullOrgUnitCollection coll = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        if (coll.size() == 0) {
            return null;
        }
        FullOrgUnitInfo orgInfo = coll.get(0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", orgInfo.getId().toString());
        map.put("number", orgInfo.getNumber().toString());
        map.put("name", orgInfo.getName());
        map.put("name_l1", orgInfo.getName(LocaleUtils.locale_L1));
        map.put("name_l2", orgInfo.getName(LocaleUtils.locale_L2));
        map.put("name_l3", orgInfo.getName(LocaleUtils.locale_L3));
        map.put("isLeaf", orgInfo.isIsLeaf());
        if (orgInfo.getParent() == null || orgInfo.getParent().getId() == null) {
            map.put("parentId", null);
        } else {
            map.put("parentId", orgInfo.getParent().getId().toString());
        }
        if (orgInfo.getParent() == null || orgInfo.getParent().getNumber() == null) {
            map.put("parentNumber", null);
        } else {
            map.put("parentNumber", orgInfo.getParent().getNumber().toString());
        }
        map.put("level", orgInfo.getLevel());
        map.put("displayName", orgInfo.getDisplayName());
        map.put("longNumber", orgInfo.getLongNumber());
        return JSONUtils.convertObjectToJson((Context)ctx, map);
    }

    @Override
    protected String _getOrgUnitByCondition(Context ctx, String queryCondition) throws BOSException, EASBizException {
        logger.error((Object)("******queryCondition*****: " + queryCondition));
        HashMap queryConditionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)queryCondition);
        if (queryConditionMap == null || queryConditionMap.size() == 0) {
            return null;
        }
        String parentId = (String)queryConditionMap.get("parentId");
        String orgTypeId = (String)queryConditionMap.get("orgTypeId");
        String org = (String)queryConditionMap.get("org");
        String startIndex = null;
        String rowCount = null;
        String sorter = (String)queryConditionMap.get("sorter");
        String sorterType = (String)queryConditionMap.get("sorterType");
        if (queryConditionMap.get("startIndex") != null && !queryConditionMap.get("startIndex").equals("")) {
            startIndex = (String)queryConditionMap.get("startIndex");
        }
        if (queryConditionMap.get("rowCount") != null && !queryConditionMap.get("rowCount").equals("")) {
            rowCount = (String)queryConditionMap.get("rowCount");
        }
        Map result = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        OrgStructureInfo orgStructureInfo = null;
        if (orgTypeId != null && !"".equals(orgTypeId)) {
            orgStructureInfo = StringUtils.isEmpty((String)parentId) ? OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("where level = '1' and tree.id = '" + orgTypeId + "'") : OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo((IObjectPK)new ObjectUuidPK(parentId), this.getOrgStructureSic());
            result = this.getOrgStructureList(ctx, orgStructureInfo, orgTypeId, org, startIndex, rowCount, sorter, sorterType, false);
        } else {
            fullOrgUnitInfo = StringUtils.isEmpty((String)parentId) ? this.getRootFullOrgUnit(ctx) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentId), this.getSimpleSic());
            result = this.getFullOrgUnitList(ctx, fullOrgUnitInfo, org, startIndex, rowCount, sorter, sorterType, false);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)result);
    }

    private Map getOrgStructureList(Context ctx, OrgStructureInfo orgStructureInfo, String orgTypeId, String org, String startIndex, String rowCount, String sorter, String sorterType, boolean isGetAmount) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MetaDataPK queryPK = new MetaDataPK(ORGSTRUCTUREQUERY);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getOrgStructureSic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)orgStructureInfo.getLongNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgStructureInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTypeId));
        filter.getFilterItems().add(new FilterItemInfo("unit.isOUSealUp", (Object)false));
        if (org != null && org.length() > 0) {
            try {
                String filterStr = "lower(unit.name) like '%" + org.toLowerCase() + "%' or lower(unit.number) like '%" + org.toLowerCase() + "%'";
                filter.mergeFilter(new FilterInfo(filterStr), "AND");
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            filter.setMaskString("(#0 or #1) and #2 and #3 and (#4 or #5)");
        } else {
            filter.setMaskString("(#0 or #1) and #2 and #3");
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo(sorter);
        sorterItemInfo.setSortType("desc".equalsIgnoreCase(sorterType) ? SortType.DESCEND : SortType.ASCEND);
        sorterColl.getSorter().add(sorterItemInfo);
        viewInfo.setSorter(sorterColl);
        queryExcu.setObjectView(viewInfo);
        int totalCount = queryExcu.getRowCount();
        if (isGetAmount) {
            result.put("records", totalCount + "");
            return result;
        }
        IRowSet rowSet = null;
        rowSet = startIndex != null && rowCount != null ? queryExcu.executeQuery(Integer.parseInt(startIndex), Integer.parseInt(rowCount)) : queryExcu.executeQuery();
        ArrayList list = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rowSet.getString("id"));
                map.put("name", rowSet.getString("unit.name"));
                map.put("number", rowSet.getString("unit.number"));
                map.put("longNumber", rowSet.getString("longNumber"));
                map.put("level", rowSet.getString("level"));
                map.put("isLeaf", rowSet.getString("isLeaf"));
                map.put("displayName", rowSet.getString("displayName"));
                map.put("parent.id", rowSet.getString("parent.id"));
                list.add(map);
            }
            logger.error((Object)("******getOrgStructureList******list.size=" + list.size()));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        result.put("records", totalCount + "");
        result.put("rows", list);
        return result;
    }

    private Map getFullOrgUnitList(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, String org, String startIndex, String rowCount, String sorter, String sorterType, boolean isGetAmount) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MetaDataPK queryPK = new MetaDataPK(BASEUNITQUERY);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSimpleSic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)fullOrgUnitInfo.getLongNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(fullOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
        if (org != null && org.length() > 0) {
            try {
                String filterStr = "lower(name) like '%" + org.toLowerCase() + "%' or lower(number) like '%" + org.toLowerCase() + "%'";
                filter.mergeFilter(new FilterInfo(filterStr), "AND");
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            filter.setMaskString("(#0 or #1) and #2 and (#3 or #4)");
        } else {
            filter.setMaskString("(#0 or #1) and #2");
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo(sorter);
        sorterItemInfo.setSortType("desc".equalsIgnoreCase(sorterType) ? SortType.DESCEND : SortType.ASCEND);
        sorterColl.getSorter().add(sorterItemInfo);
        viewInfo.setSorter(sorterColl);
        queryExcu.setObjectView(viewInfo);
        int totalCount = queryExcu.getRowCount();
        if (isGetAmount) {
            result.put("records", totalCount + "");
            return result;
        }
        IRowSet rowSet = null;
        rowSet = startIndex != null && rowCount != null ? queryExcu.executeQuery(Integer.parseInt(startIndex), Integer.parseInt(rowCount)) : queryExcu.executeQuery();
        ArrayList list = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rowSet.getString("id"));
                map.put("name", rowSet.getString("name"));
                map.put("number", rowSet.getString("number"));
                map.put("longNumber", rowSet.getString("longNumber"));
                map.put("level", rowSet.getString("level"));
                map.put("isLeaf", rowSet.getString("isLeaf"));
                map.put("displayName", rowSet.getString("displayName"));
                map.put("isCU", rowSet.getString("isCU"));
                map.put("parent.id", rowSet.getString("parent.id"));
                list.add(map);
            }
            logger.error((Object)("******getFullOrgUnitList******list.size=" + list.size()));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        result.put("records", totalCount + "");
        result.put("rows", list);
        return result;
    }

    private SelectorItemCollection getOrgStructureSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("unit.name");
        sic.add("unit.number");
        sic.add("longNumber");
        sic.add("isLeaf");
        sic.add("level");
        sic.add("displayName");
        sic.add("parent.id");
        return sic;
    }

    @Override
    protected String _getOrgUnitAmountByCondition(Context ctx, String queryCondition) throws BOSException, EASBizException {
        logger.error((Object)("******queryCondition*****: " + queryCondition));
        HashMap queryConditionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)queryCondition);
        if (queryConditionMap == null || queryConditionMap.size() == 0) {
            return null;
        }
        String parentId = (String)queryConditionMap.get("parentId");
        String orgTypeId = (String)queryConditionMap.get("orgTypeId");
        String org = (String)queryConditionMap.get("org");
        String startIndex = null;
        String rowCount = null;
        String sorter = (String)queryConditionMap.get("sorter");
        String sorterType = (String)queryConditionMap.get("sorterType");
        if (queryConditionMap.get("startIndex") != null && !queryConditionMap.get("startIndex").equals("")) {
            startIndex = (String)queryConditionMap.get("startIndex");
        }
        if (queryConditionMap.get("rowCount") != null && !queryConditionMap.get("rowCount").equals("")) {
            rowCount = (String)queryConditionMap.get("rowCount");
        }
        Map result = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        OrgStructureInfo orgStructureInfo = null;
        if (orgTypeId != null && !"".equals(orgTypeId)) {
            orgStructureInfo = StringUtils.isEmpty((String)parentId) ? OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("where level = '1' and tree.id = '" + orgTypeId + "'") : OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo((IObjectPK)new ObjectUuidPK(parentId), this.getOrgStructureSic());
            result = this.getOrgStructureList(ctx, orgStructureInfo, orgTypeId, org, startIndex, rowCount, sorter, sorterType, true);
        } else {
            fullOrgUnitInfo = StringUtils.isEmpty((String)parentId) ? this.getRootFullOrgUnit(ctx) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentId), this.getSimpleSic());
            result = this.getFullOrgUnitList(ctx, fullOrgUnitInfo, org, startIndex, rowCount, sorter, sorterType, true);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)result);
    }
}

