/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.orgext.app.di;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IndustryFactory;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.RegistrationTypeFactory;
import com.kingdee.eas.basedata.assistant.RegistrationTypeInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.di.BizOrgDIBase;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.orgext.ITaxSubjectOrgUnit;
import com.kingdee.eas.basedata.orgext.OUPartTaxSubjectInfo;
import com.kingdee.eas.basedata.orgext.TaxSubjectOrgTypeAddNewInfo;
import com.kingdee.eas.basedata.orgext.TaxSubjectOrgUnitFactory;
import com.kingdee.eas.basedata.orgext.TaxSubjectOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Hashtable;
import java.util.Locale;

public class TaxSubjectDataDI
extends BizOrgDIBase {
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String cancellationDate;
        String establelisingData;
        String bussinessEndDate;
        TaxSubjectOrgUnitInfo parentInfo;
        String number = this.getFieldValue(hsData, "FNumber");
        String parent = this.getFieldValue(hsData, "FParentID");
        String isBizUnit = this.getFieldValue(hsData, "FIsBizUnit");
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkRequeiredField(ctx, "FParentID", parent);
        if (number.equals(parent)) {
            Locale currentLocale = ctx.getLocale();
            throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADD_BIZ_NUMBER_NOTEQ_PARENT", (Locale)currentLocale));
        }
        FullOrgUnitInfo unitInfo = this.getFullOrgUnitInfo4BizOrg(ctx, number);
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        orgTypeHelper.addOrgType(TaxSubjectOrgTypeAddNewInfo.newOrgType);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        String oql = new StringBuffer().append("select id, isBizUnit where number = '").append(parent).append("'").toString();
        ITaxSubjectOrgUnit iTaxSubject = TaxSubjectOrgUnitFactory.getLocalInstance(ctx);
        if (iTaxSubject.exists(oql)) {
            parentInfo = iTaxSubject.getTaxSubjectOrgUnitInfo(oql);
            if (parentInfo.isIsBizUnit()) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.basedata.orgext.ORGEXTAutoGenerateResource", (String)"2_CompanyDI", (Locale)ctx.getLocale()));
            }
        } else {
            StringBuffer message = new StringBuffer();
            Locale currentLocale = ctx.getLocale();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"THECODE", (Locale)currentLocale));
            message.append(parent);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"NOT_IN_BIZ_TABLE", (Locale)currentLocale));
            throw new Exception(message.toString());
        }
        this.getBizParentAndDelegationInfo(unitInfo).setParentOrg(TaxSubjectOrgTypeAddNewInfo.newOrgType, (OrgUnitInfo)parentInfo);
        OUPartTaxSubjectInfo testOrgInfo = (OUPartTaxSubjectInfo)unitInfo.getOUPart(TaxSubjectOrgTypeAddNewInfo.newOrgType);
        if (testOrgInfo == null) {
            testOrgInfo = new OUPartTaxSubjectInfo();
            testOrgInfo.setUnit(unitInfo);
            unitInfo.setOUPart(TaxSubjectOrgTypeAddNewInfo.newOrgType, (OUPartCoreBaseInfo)testOrgInfo);
        }
        if ("1".equalsIgnoreCase(isBizUnit) || "Y".equalsIgnoreCase(isBizUnit)) {
            testOrgInfo.setIsBizUnit(true);
        } else {
            testOrgInfo.setIsBizUnit(false);
        }
        String taxSubjectName = this.getFieldValue(hsData, "FTaxSubjectName");
        testOrgInfo.setTaxSubjectName(taxSubjectName);
        if (!testOrgInfo.isIsBizUnit()) {
            return unitInfo;
        }
        String creditCode = this.getFieldValue(hsData, "FCreditCode");
        testOrgInfo.setCreditCode(creditCode);
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        String bussinessStartDate = this.getFieldValue(hsData, "FBussinessStartDate");
        if (!StringUtils.isEmpty((String)bussinessStartDate)) {
            testOrgInfo.setBussinessStartDate(new Timestamp(dtformat.parse(bussinessStartDate).getTime()));
        }
        if (!StringUtils.isEmpty((String)(bussinessEndDate = this.getFieldValue(hsData, "FBussinessEndDate")))) {
            testOrgInfo.setBussinessEndDate(new Timestamp(dtformat.parse(bussinessEndDate).getTime()));
        }
        String indAndCommRegAuthority = this.getFieldValue(hsData, "FIndAndCommRegAuthority");
        testOrgInfo.setIndAndCommRegAuthority(indAndCommRegAuthority);
        String representative = this.getFieldValue(hsData, "FRepresentative");
        testOrgInfo.setRepresentative(representative);
        String competentTaxAuthority = this.getFieldValue(hsData, "FCompetentTaxAuthority");
        testOrgInfo.setCompetentTaxAuthority(competentTaxAuthority);
        String competentTaxAuthorityContact = this.getFieldValue(hsData, "FCompetentTaxAuthorityContact");
        testOrgInfo.setCompetentTaxAuthorityContact(competentTaxAuthorityContact);
        String registrationTypeID = this.getFieldValue(hsData, "FRegistrationTypeID");
        RegistrationTypeInfo registrationTypeInfo = (RegistrationTypeInfo)this.getCoreBaseInfo((ICoreBase)RegistrationTypeFactory.getLocalInstance((Context)ctx), registrationTypeID);
        if (registrationTypeInfo == null) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(registrationTypeID);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"REGISTRATION_TYPE_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        testOrgInfo.setRegistrationType(registrationTypeInfo);
        String businessScope = this.getFieldValue(hsData, "FBusinessScope");
        testOrgInfo.setBusinessScope(businessScope);
        String regCapitalCurrencyID = this.getFieldValue(hsData, "FRegCapitalCurrencyID");
        CurrencyInfo regCapitalCurrencyInfo = (CurrencyInfo)this.getCoreBaseInfo((ICoreBase)CurrencyFactory.getLocalInstance((Context)ctx), regCapitalCurrencyID);
        if (regCapitalCurrencyInfo == null) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(regCapitalCurrencyID);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"REG_CAPITAL_CURRENCY_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        testOrgInfo.setRegCapitalCurrency(regCapitalCurrencyInfo);
        String regCapital = this.getFieldValue(hsData, "FRegCapital");
        if (!StringUtils.isEmpty((String)regCapital)) {
            testOrgInfo.setRegCapital(new BigDecimal(regCapital));
        }
        String investmentCurrencyID = this.getFieldValue(hsData, "FInvestmentCurrencyID");
        CurrencyInfo currencyInfo = (CurrencyInfo)this.getCoreBaseInfo((ICoreBase)CurrencyFactory.getLocalInstance((Context)ctx), investmentCurrencyID);
        if (currencyInfo == null) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(investmentCurrencyID);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"INVESTMENT_CURRENCY_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        testOrgInfo.setInvestmentCurrency(currencyInfo);
        String investmentAmount = this.getFieldValue(hsData, "FInvestmentAmount");
        if (!StringUtils.isEmpty((String)investmentAmount)) {
            testOrgInfo.setInvestmentAmount(new BigDecimal(investmentAmount));
        }
        if (!StringUtils.isEmpty((String)(establelisingData = this.getFieldValue(hsData, "FEstablelisingData")))) {
            testOrgInfo.setEstablelisingData(new Timestamp(dtformat.parse(establelisingData).getTime()));
        }
        if (!StringUtils.isEmpty((String)(cancellationDate = this.getFieldValue(hsData, "FCancellationDate")))) {
            testOrgInfo.setCancellationDate(new Timestamp(dtformat.parse(cancellationDate).getTime()));
        }
        String regAddressID = this.getFieldValue(hsData, "FRegAddressID");
        AddressInfo addressInfo = (AddressInfo)this.getCoreBaseInfo((ICoreBase)AddressFactory.getLocalInstance((Context)ctx), regAddressID);
        if (addressInfo == null) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(regAddressID);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"REG_ADDRESS_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        testOrgInfo.setRegAddress(addressInfo);
        String businessAddressID = this.getFieldValue(hsData, "FBusinessAddressID");
        AddressInfo busAddressInfo = (AddressInfo)this.getCoreBaseInfo((ICoreBase)AddressFactory.getLocalInstance((Context)ctx), businessAddressID);
        if (busAddressInfo == null) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(businessAddressID);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"BUSINESS_ADDRESS_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        testOrgInfo.setBusinessAddress(busAddressInfo);
        String industryID = this.getFieldValue(hsData, "FIndustryID");
        IndustryInfo industryInfo = (IndustryInfo)this.getCoreBaseInfo((ICoreBase)IndustryFactory.getLocalInstance((Context)ctx), industryID);
        if (industryInfo == null) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(industryID);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"INVESTMENT_CURRENCY_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        testOrgInfo.setIndustry(industryInfo);
        return unitInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            String industryNumber;
            String businessAddressNumber;
            String regAddressNumber;
            Timestamp cancellationDate;
            Timestamp establelisingData;
            BigDecimal investmentAmount;
            String investmentCurrencyNumber;
            BigDecimal regCapital;
            String regCapitalCurrencyNumber;
            String businessScope;
            String registrationTypeNumber;
            String competentTaxAuthorityContact;
            String competentTaxAuthority;
            String indAndCommRegAuthority;
            Timestamp bussinessStartDate;
            String creditCode;
            String taxSubjectName;
            boolean isBizUnit;
            result.put("FNumber", rs.getString("number"));
            String parentNumber = rs.getString("parent.number");
            if (parentNumber != null) {
                result.put("FParentID", parentNumber);
            }
            if (isBizUnit = rs.getBoolean("isBizUnit")) {
                result.put("FIsBizUnit", "Y");
            }
            if ((taxSubjectName = rs.getString("taxSubjectName")) != null) {
                result.put("FTaxSubjectName", taxSubjectName);
            }
            if ((creditCode = rs.getString("creditCode")) != null) {
                result.put("FCreditCode", rs.getString("creditCode"));
            }
            if ((bussinessStartDate = rs.getTimestamp("bussinessStartDate")) != null) {
                result.put("FBussinessStartDate", ExcelUtil.formatNationalTime((Context)ctx, (Object)bussinessStartDate));
            }
            Timestamp bussinessEndDate = rs.getTimestamp("bussinessEndDate");
            if (bussinessStartDate != null) {
                result.put("FBussinessEndDate", ExcelUtil.formatNationalTime((Context)ctx, (Object)bussinessEndDate));
            }
            if ((indAndCommRegAuthority = rs.getString("indAndCommRegAuthority")) != null) {
                result.put("FIndAndCommRegAuthority", indAndCommRegAuthority);
            }
            String representative = rs.getString("representative");
            if (indAndCommRegAuthority != null) {
                result.put("FRepresentative", representative);
            }
            if ((competentTaxAuthority = rs.getString("competentTaxAuthority")) != null) {
                result.put("FCompetentTaxAuthority", competentTaxAuthority);
            }
            if ((competentTaxAuthorityContact = rs.getString("competentTaxAuthorityContact")) != null) {
                result.put("FCompetentTaxAuthorityContact", competentTaxAuthorityContact);
            }
            if ((registrationTypeNumber = rs.getString("registrationType.number")) != null) {
                result.put("FRegistrationTypeID", registrationTypeNumber);
            }
            if ((businessScope = rs.getString("businessScope")) != null) {
                result.put("FBusinessScope", businessScope);
            }
            if ((regCapitalCurrencyNumber = rs.getString("regCapitalCurrency.number")) != null) {
                result.put("FRegCapitalCurrencyID", regCapitalCurrencyNumber);
            }
            if ((regCapital = rs.getBigDecimal("regCapital")) != null) {
                result.put("FRegCapital", regCapital.toString());
            }
            if ((investmentCurrencyNumber = rs.getString("investmentCurrency.number")) != null) {
                result.put("FInvestmentCurrencyID", investmentCurrencyNumber);
            }
            if ((investmentAmount = rs.getBigDecimal("investmentAmount")) != null) {
                result.put("FInvestmentAmount", investmentAmount.toString());
            }
            if ((establelisingData = rs.getTimestamp("establelisingData")) != null) {
                result.put("FEstablelisingData", ExcelUtil.formatNationalTime((Context)ctx, (Object)establelisingData));
            }
            if ((cancellationDate = rs.getTimestamp("cancellationDate")) != null) {
                result.put("FCancellationDate", ExcelUtil.formatNationalTime((Context)ctx, (Object)cancellationDate));
            }
            if ((regAddressNumber = rs.getString("regAddress.number")) != null) {
                result.put("FRegAddressID", regAddressNumber);
            }
            if ((businessAddressNumber = rs.getString("businessAddress.number")) != null) {
                result.put("FBusinessAddressID", businessAddressNumber);
            }
            if ((industryNumber = rs.getString("industry.number")) != null) {
                result.put("FIndustryID", industryNumber);
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.orgext.app.TaxSubjectOrgUnitQuery";
    }
}

