/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.AbstractPositionInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DefaultPositionRoleCollection;
import com.kingdee.eas.basedata.org.DefaultPositionRoleFactory;
import com.kingdee.eas.basedata.org.DefaultPositionRoleInfo;
import com.kingdee.eas.basedata.org.DeletedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IDefaultPositionRole;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IOUPartAdmin;
import com.kingdee.eas.basedata.org.IPositionAdmin;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.IPositionRole;
import com.kingdee.eas.basedata.org.OUPartAdminFactory;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionAdminFactory;
import com.kingdee.eas.basedata.org.PositionAdminInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionRoleFactory;
import com.kingdee.eas.basedata.org.PositionRoleInfo;
import com.kingdee.eas.basedata.org.app.AbstractPositionControllerBean;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.basedata.org.app.processor.PositionBusinessProcessorBuilder;
import com.kingdee.eas.basedata.org.helper.HRBaseCommonUtil;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.log4j.Logger;

public class PositionControllerBean
extends AbstractPositionControllerBean {
    private static Logger logger = Logger.getLogger(PositionControllerBean.class);
    String resClass = "com.kingdee.eas.basedata.org.PositionResource";

    @Override
    protected IObjectCollection _getAllPersons(Context ctx, BOSUuid positionId) throws BOSException, EASBizException {
        PersonCollection personColl = new PersonCollection();
        if (positionId == null) {
            return personColl;
        }
        IPositionMember iPosiMem = PositionMemberFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)positionId.toString());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        PositionMemberCollection posiMemColl = iPosiMem.getPositionMemberCollection(viewInfo);
        int n = posiMemColl.size();
        for (int i = 0; i < n; ++i) {
            personColl.add(posiMemColl.get(i).getPerson());
        }
        return personColl;
    }

    @Override
    protected IObjectCollection _getPrimaryPersons(Context ctx, BOSUuid positionId) throws BOSException, EASBizException {
        PositionInfo model = (PositionInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(positionId));
        PersonCollection personColl = new PersonCollection();
        IPositionMember iPosiMem = PositionMemberFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = this.getPersonsViewInfo(model, true);
        PositionMemberCollection posiMemColl = iPosiMem.getPositionMemberCollection(viewInfo);
        for (int i = 0; i < posiMemColl.size(); ++i) {
            personColl.add(posiMemColl.get(i).getPerson());
        }
        return personColl;
    }

    @Override
    protected IObjectCollection _getAllParent(Context ctx, BOSUuid positionId) throws BOSException, EASBizException {
        PositionHierarchyCollection posiHierColl = this.getPHByPosition(ctx, null, positionId, false);
        PositionCollection posiColl = new PositionCollection();
        for (int i = 0; i < posiHierColl.size(); ++i) {
            posiColl.add(posiHierColl.get(i).getParent());
        }
        return posiColl;
    }

    @Override
    protected IObjectValue _getParent(Context ctx, BOSUuid hierarchyId, BOSUuid positionId) throws BOSException, EASBizException {
        PositionHierarchyCollection posiHierColl = this.getPHByPosition(ctx, hierarchyId, positionId, false);
        PositionInfo posiInfo = new PositionInfo();
        if (posiHierColl.size() > 0) {
            posiInfo = posiHierColl.get(0).getParent();
        }
        return posiInfo;
    }

    @Override
    protected IObjectValue _getParent(Context ctx, BOSUuid positionId) throws BOSException, EASBizException {
        PositionHierarchyCollection posiHierColl = this.getPHByPosition(ctx, null, positionId, false);
        PositionInfo posiInfo = new PositionInfo();
        if (posiHierColl.size() > 0) {
            posiInfo = posiHierColl.get(0).getParent();
        }
        return posiInfo;
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, BOSUuid positionId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("parent.id", (Object)positionId.toString());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        PositionHierarchyCollection posiHierColl = null;
        IPositionHierarchy iPosiHier = PositionHierarchyFactory.getLocalInstance(ctx);
        posiHierColl = iPosiHier.getPositionHierarchyCollection(viewInfo);
        PositionCollection posiColl = new PositionCollection();
        for (int i = 0; i < posiHierColl.size(); ++i) {
            posiColl.add(posiHierColl.get(i).getChild());
        }
        return posiColl;
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, BOSUuid hierarchyId, BOSUuid positionId) throws BOSException, EASBizException {
        PositionHierarchyCollection posiHierColl = this.getPHByPosition(ctx, hierarchyId, positionId, true);
        PositionCollection posiColl = new PositionCollection();
        for (int i = 0; i < posiHierColl.size(); ++i) {
            posiColl.add(posiHierColl.get(i).getChild());
        }
        return posiColl;
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, BOSUuid positionId) throws BOSException, EASBizException {
        PositionHierarchyCollection posiHierColl = this.getPHByPosition(ctx, null, positionId, true);
        PositionCollection posiColl = new PositionCollection();
        for (int i = 0; i < posiHierColl.size(); ++i) {
            posiColl.add(posiHierColl.get(i).getChild());
        }
        return posiColl;
    }

    private EntityViewInfo getPersonsViewInfo(PositionInfo positionInfo, boolean isPrimary) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("position.id", (Object)positionInfo.getId().toString());
        filter.getFilterItems().add(filterItem);
        if (isPrimary) {
            filterItem = new FilterItemInfo("isPrimary", (Object)"1");
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        return viewInfo;
    }

    private PositionHierarchyCollection getPHByPosition(Context ctx, BOSUuid hierarchyId, BOSUuid positionId, boolean isFindParent) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = !isFindParent ? new FilterItemInfo("child.id", (Object)positionId.toString()) : new FilterItemInfo("parent.id", (Object)positionId.toString());
        filter.getFilterItems().add(filterItem);
        if (hierarchyId == null) {
            IHierarchy iHierar = HierarchyFactory.getLocalInstance(ctx);
            HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
            filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarInfo.getId().toString());
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.toString());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        if (!isFindParent) {
            viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        }
        PositionHierarchyCollection posiHierColl = null;
        IPositionHierarchy iPosiHier = PositionHierarchyFactory.getLocalInstance(ctx);
        posiHierColl = iPosiHier.getPositionHierarchyCollection(viewInfo);
        return posiHierColl;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PositionInfo info = (PositionInfo)model;
        this._checkNameBlank(ctx, (IObjectValue)info);
        HRBaseCommonUtil.trimNameAndNumberSpaceOfObjectInfo(info);
        String rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"PositionNumberUniquenessRange");
        if ("true".equalsIgnoreCase(rangeValue)) {
            if (super._exists(ctx, "where number='" + info.getNumber().trim() + "' and id<>'" + info.getId().toString() + "'")) {
                String number = this._getPropertyAlias(ctx, info, "number") + info.getNumber();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
            }
        } else {
            this._checkNumberDup(ctx, (IObjectValue)info);
        }
        if (info.get("SuperPosition") instanceof PositionInfo) {
            PositionInfo parentInfo = (PositionInfo)info.get("SuperPosition");
            info.setParent(parentInfo);
        }
        boolean primaryPosition = false;
        String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"isAllowNoPositionInDepartment");
        if (info.get("PrimaryPosition") != null) {
            primaryPosition = (Boolean)info.get("PrimaryPosition");
            if ("true".equalsIgnoreCase(paramValue)) {
                info.setIsRespPosition((Boolean)info.get("PrimaryPosition"));
            }
        }
        if (primaryPosition) {
            info.setIndex(-1);
            PositionInfo oldInfo = this.getPositionInfo(ctx, pk);
            if (!oldInfo.isIsRespPosition()) {
                this.addDefaultPositionRole(ctx, info);
            }
        }
        this._checkNameBlank(ctx, (IObjectValue)info);
        IPositionHierarchy iPH = PositionHierarchyFactory.getLocalInstance(ctx);
        String ql = "where child='" + info.getId() + "' and hierarchy='" + "00000000-0000-0000-0000-000000000001396FCAD0" + "'";
        PositionHierarchyCollection coll = iPH.getPositionHierarchyCollection(ql);
        PositionHierarchyInfo oldPHInfo = null;
        if (coll != null && coll.size() > 0) {
            oldPHInfo = coll.get(0);
        }
        PositionInfo oldInfo = this.getPositionInfo(ctx, pk);
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        AdminOrgUnitInfo posAdminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getAdminOrgUnit().getId()));
        info.setAdminOrgUnit(posAdminInfo);
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx)) {
            this.checkPosAdminOrgIsStartSHR(ctx, info, posAdminInfo);
            if (info.getEFFDT() == null) {
                info.setEFFDT(oldInfo.getEFFDT());
            }
        }
        if (posAdminInfo.isIsSealUp() && info.getDeletedStatus().getValue() == 1) {
            throw new PositionException(PositionException.POSITION_NO_ENABLE);
        }
        super._update(ctx, pk, (IObjectValue)info);
        if (!info.getAdminOrgUnit().getId().toString().equals(oldInfo.getAdminOrgUnit().getId().toString())) {
            StringBuffer sql = new StringBuffer("UPDATE T_HR_PersonPosition SET FPersonDep='");
            sql.append(info.getAdminOrgUnit().getId().toString());
            sql.append("' WHERE FPrimaryPositionID='");
            sql.append(info.getId().toString());
            sql.append("' AND FPersonDep='");
            sql.append(oldInfo.getAdminOrgUnit().getId().toString());
            sql.append("' ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (!info.getNumber().equals(oldInfo.getNumber())) {
            PositionHierarchyCollection phColl = null;
            StringBuffer oql = new StringBuffer("select * where child='");
            oql.append(pk.toString()).append("'");
            phColl = iPH.getPositionHierarchyCollection(oql.toString());
            int size = phColl.size();
            for (int i = 0; i < size; ++i) {
                oql = new StringBuffer("UPDATE T_ORG_PositionHierarchy SET FLongNumber=REPLACE(FLongNumber,'");
                oql.append(phColl.get(i).getLongNumber());
                oql.append("!' , '");
                oql.append(this.createPrefix(phColl.get(i).getLongNumber(), info.getNumber()));
                oql.append("!') WHERE FLongNumber LIKE '");
                oql.append(phColl.get(i).getLongNumber());
                oql.append("!%'");
                DbUtil.execute((Context)ctx, (String)oql.toString());
                oql = new StringBuffer("UPDATE T_ORG_PositionHierarchy SET FLongNumber='");
                oql.append(this.createPrefix(phColl.get(i).getLongNumber(), info.getNumber()));
                oql.append("' WHERE FID='");
                oql.append(phColl.get(i).getId().toString());
                oql.append("' ");
                DbUtil.execute((Context)ctx, (String)oql.toString());
            }
        }
        OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
        ObjectUuidPK pk2 = new ObjectUuidPK(info.getAdminOrgUnit().getId());
        IFullOrgUnit iFullUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo fullUnitInfo = iFullUnit.getFullOrgUnitInfo((IObjectPK)pk2);
        IOUPartAdmin iOUPartAdmin = OUPartAdminFactory.getLocalInstance((Context)ctx);
        pk2 = new ObjectUuidPK(fullUnitInfo.getPartAdmin().getId());
        OUPartAdminInfo ouPartAdminInfo = iOUPartAdmin.getOUPartAdminInfo((IObjectPK)pk2);
        if ("false".equalsIgnoreCase(paramValue)) {
            if (ouPartAdminInfo.getResponPosition() == null || primaryPosition && !ouPartAdminInfo.getResponPosition().getId().toString().equals(info.getId().toString())) {
                this.doWithPrimaryPositionCase(ctx, oldInfo, ouPartAdminInfo);
            }
        } else {
            this.doWithPrimaryPositionCase2(ctx, info, ouPartAdminInfo);
        }
        if (oldPHInfo != null && !oldPHInfo.getParent().getId().toString().equals(info.getParent().getId().toString())) {
            oldPHInfo.setParent(info.getParent());
            iPH.update((IObjectPK)new ObjectUuidPK(oldPHInfo.getId()), (CoreBaseInfo)oldPHInfo);
        }
    }

    private void doWithPrimaryPositionCase2(Context ctx, PositionInfo info, OUPartAdminInfo ouPartAdminInfo) throws BOSException, EASBizException {
        String oldResPosId2;
        String oldResPosId;
        StringBuffer sql = null;
        if (ouPartAdminInfo.getResponPosition() != null && info.isIsRespPosition() && !(oldResPosId = ouPartAdminInfo.getResponPosition().getId().toString()).equalsIgnoreCase(info.getId().toString())) {
            sql = new StringBuffer("UPDATE T_ORG_Position SET FIsRespPosition=0,FIndex=0 WHERE FID='");
            sql.append(oldResPosId);
            sql.append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (info.isIsRespPosition()) {
            ouPartAdminInfo.setResponPosition(info);
            OUPartAdminFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ouPartAdminInfo.getId()), (OUPartCoreBaseInfo)ouPartAdminInfo);
            sql = new StringBuffer("UPDATE T_ORG_Admin SET FResponPositionID = '");
            sql.append(info.getId().toString());
            sql.append("' WHERE FID ='");
            sql.append(info.getAdminOrgUnit().getId().toString());
            sql.append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer("UPDATE T_ORG_Position SET FIsRespPosition=1,FIndex=-1 WHERE FID='");
            sql.append(info.getId().toString());
            sql.append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else if (ouPartAdminInfo.getResponPosition() != null && (oldResPosId2 = ouPartAdminInfo.getResponPosition().getId().toString()).equals(info.getId().toString())) {
            ouPartAdminInfo.setResponPosition(null);
            OUPartAdminFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ouPartAdminInfo.getId()), (OUPartCoreBaseInfo)ouPartAdminInfo);
            String sqlString = "UPDATE T_ORG_Admin SET FResponPositionID = null where fid = '" + info.getAdminOrgUnit().getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sqlString);
            logger.error((Object)("UPDATE T_ORG_Admin SET FResponPositionID = null where fid = '" + info.getAdminOrgUnit().getId().toString() + "'"));
        }
        OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx)) {
            this._reviseHistoryOnly(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    private String createPrefix(String longNumber, String number) {
        int index = longNumber.lastIndexOf("!");
        if (index < 0) {
            return number;
        }
        longNumber = longNumber.substring(0, index) + "!" + number;
        return longNumber;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PositionInfo info = this.getPositionInfo(ctx, pk);
        IPositionHierarchy iPH = PositionHierarchyFactory.getLocalInstance(ctx);
        PositionHierarchyCollection phColl = this.getPHListByChild(ctx, iPH, pk.toString());
        if (phColl != null) {
            for (int i = 0; i < phColl.size(); ++i) {
                iPH.deleteNew((IObjectPK)new ObjectUuidPK(phColl.get(i).getId()), false);
            }
        }
        ObjectUuidPK pk2 = new ObjectUuidPK(info.getAdminOrgUnit().getId());
        AdminOrgUnitInfo ouPartAdminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)pk2);
        if (ouPartAdminInfo.getResponPosition() != null && ouPartAdminInfo.getResponPosition().getId().toString().equals(pk.toString())) {
            String sql = "UPDATE T_ORG_OUPartAdmin SET FResponPositionID=null WHERE FUnitID=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk2.toString()});
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("EFFDT"));
            sic.add(new SelectorItemInfo("responPosition"));
            ouPartAdminInfo.setEFFDT(new Date());
            ouPartAdminInfo.setResponPosition(null);
            AdminOrgUnitFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)ouPartAdminInfo, sic);
            OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
        }
        DbUtil.execute((Context)ctx, (String)("update T_ORG_AdminHIS set FResponPositionID=null  where FResponPositionID = '" + pk + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_ORG_PositionHIS  where FHistoryRelateID = '" + pk + "'"));
        super._delete(ctx, pk);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = info.getCU().getId().toString();
        if (iCodingRuleManager.isExist((IObjectValue)info, orgId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, orgId)) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, orgId, info.getNumber());
        }
    }

    private PositionHierarchyCollection getPHListByChild(Context ctx, IPositionHierarchy iPH, String childId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("child.id", (Object)childId.trim());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return iPH.getPositionHierarchyCollection(view);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String rangeValue;
        String strCom;
        PositionInfo info = (PositionInfo)model;
        this._checkNameBlank(ctx, (IObjectValue)info);
        HRBaseCommonUtil.trimNameAndNumberSpaceOfObjectInfo(info);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (info.getCU() == null) {
            ObjectUuidPK pk2 = new ObjectUuidPK(info.getAdminOrgUnit().getId());
            IFullOrgUnit iFullUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            FullOrgUnitInfo fullUnitInfo = iFullUnit.getFullOrgUnitInfo((IObjectPK)pk2);
            CtrlUnitInfo cu = fullUnitInfo.getCU();
            info.setCU(cu);
        }
        if (info.getCU() != null && info.get("notNeedGenerateObjectNumber") == null && codingRuleManager.isExist((IObjectValue)info, info.getCU().getId().toString()) && (strCom = this.getIntermitNumber(ctx, model, info)) != null) {
            info.setNumber(strCom);
        }
        if ("true".equalsIgnoreCase(rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"PositionNumberUniquenessRange"))) {
            if (super._exists(ctx, "where number='" + info.getNumber().trim() + "'")) {
                String number = this._getPropertyAlias(ctx, info, "number") + info.getNumber();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
            }
        } else {
            this._checkNumberDup(ctx, (IObjectValue)info);
        }
        boolean primaryPosition = false;
        if (info.get("PrimaryPosition") != null) {
            info.setIsRespPosition((Boolean)info.get("PrimaryPosition"));
        }
        primaryPosition = info.isIsRespPosition();
        if (info.getAdminOrgUnit() == null) {
            info.setAdminOrgUnit((AdminOrgUnitInfo)info.get("adminiOrgUnit_importData"));
        }
        info.setIndex(this.getMaxIndex(ctx, info.getAdminOrgUnit().getId().toString()) + 1);
        if (primaryPosition) {
            info.setIndex(-1);
        }
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        if (info.get("SuperPosition") instanceof PositionInfo) {
            PositionInfo superPosInfo = (PositionInfo)info.get("SuperPosition");
            if (superPosInfo.getId() != null) {
                String parentPosId = superPosInfo.getId().toString();
                String orgId = info.getAdminOrgUnit().getId().toString();
                if (HRBaseCommonUtil.isBeginToUseSHR(ctx)) {
                    Date orgEffdt = HRBaseCommonUtil.getEarliestAdminOrgEFFDT(ctx, orgId);
                    Date parentPosEffdt = HRBaseCommonUtil.getEarliestPositionEFFDT(ctx, parentPosId);
                    if (parentPosEffdt != null && orgEffdt != null) {
                        if (DateTimeUtils.dayAfter((Date)parentPosEffdt, (Date)orgEffdt)) {
                            info.setEFFDT(parentPosEffdt);
                        } else {
                            info.setEFFDT(orgEffdt);
                        }
                    }
                }
                info.setParent(superPosInfo);
            }
        } else if (info.get("SuperPosition") instanceof String && "Me".equals((String)info.get("SuperPosition"))) {
            this.checkParentPosition(ctx);
            info.setParent(info);
            if (HRBaseCommonUtil.isBeginToUseSHR(ctx)) {
                info.setEFFDT(HRBaseCommonUtil.getMinEffdtDate());
            }
        }
        AdminOrgUnitInfo posAdminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getAdminOrgUnit().getId()));
        info.setAdminOrgUnit(posAdminInfo);
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx)) {
            this.checkPosAdminOrgIsStartSHR(ctx, info, posAdminInfo);
            this.setPosEFFDT(ctx, info, posAdminInfo);
            if (info.getLEFFDT() == null) {
                info.setLEFFDT(HistoryUtil.getMaxDate());
            }
        }
        if (info.getCU() == null) {
            info.setCU(posAdminInfo.getCU());
        }
        if (info.getEFFDT() == null) {
            info.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
        }
        if (info.getLEFFDT() == null) {
            info.setLEFFDT(HRBaseCommonUtil.getMaxEndDate());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
        ObjectUuidPK pk2 = new ObjectUuidPK(info.getAdminOrgUnit().getId());
        IFullOrgUnit iFullUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo fullUnitInfo = iFullUnit.getFullOrgUnitInfo((IObjectPK)pk2);
        IOUPartAdmin iOUPartAdmin = OUPartAdminFactory.getLocalInstance((Context)ctx);
        pk2 = new ObjectUuidPK(fullUnitInfo.getPartAdmin().getId());
        OUPartAdminInfo ouPartAdminInfo = iOUPartAdmin.getOUPartAdminInfo((IObjectPK)pk2);
        if (ouPartAdminInfo.getResponPosition() == null || info.isIsRespPosition()) {
            this.doWithPrimaryPositionCase(ctx, info, ouPartAdminInfo);
        }
        IHierarchy iHierarchy = HierarchyFactory.getLocalInstance(ctx);
        HierarchyInfo hInfo = iHierarchy.getDefaultHierarchy();
        IPositionHierarchy iPH = PositionHierarchyFactory.getLocalInstance(ctx);
        PositionHierarchyInfo pHInfo = new PositionHierarchyInfo();
        pHInfo.setId(BOSUuid.create((BOSObjectType)pHInfo.getBOSType()));
        pHInfo.setHierarchy(hInfo);
        pHInfo.setChild(info);
        pHInfo.setParent(info.getParent());
        iPH.addnew((CoreBaseInfo)pHInfo);
        if (primaryPosition) {
            this.addDefaultPositionRole(ctx, info);
        }
        return pk;
    }

    private void addDefaultPositionRole(Context ctx, PositionInfo info) throws BOSException, EASBizException {
        String existOql;
        IPositionAdmin iPositionAdmin;
        IDefaultPositionRole iDPR = DefaultPositionRoleFactory.getLocalInstance(ctx);
        DefaultPositionRoleCollection dPRC = iDPR.getDefaultPositionRoleCollection();
        if (dPRC != null && dPRC.size() > 0) {
            ObjectUuidPK adminPk = new ObjectUuidPK(info.getAdminOrgUnit().getId());
            OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)adminPk);
            if (orgUnitInfo != null) {
                IPositionRole iPositionRole = PositionRoleFactory.getLocalInstance(ctx);
                CtrlUnitInfo cu = orgUnitInfo.getCU();
                for (int i = 0; i < dPRC.size(); ++i) {
                    DefaultPositionRoleInfo dPInfo = dPRC.get(i);
                    String oql = " where position.id = '" + info.getId().toString() + "' and role.id = '" + dPInfo.getRole().getId().toString() + "' and orgUnit.id = '" + cu.getId().toString() + "'";
                    if (iPositionRole.exists(oql)) continue;
                    PositionRoleInfo pInfo = new PositionRoleInfo();
                    pInfo.setPosition(info);
                    pInfo.setRole(dPInfo.getRole());
                    FullOrgUnitInfo ouInfo = new FullOrgUnitInfo();
                    ouInfo.setId(cu.getId());
                    pInfo.setOrgUnit(ouInfo);
                    iPositionRole.addnew(pInfo);
                }
            }
        }
        if (!(iPositionAdmin = PositionAdminFactory.getLocalInstance(ctx)).exists(existOql = " where position.id = '" + info.getId().toString() + "' and adminOrgUnit.id = '" + info.getAdminOrgUnit().getId().toString() + "'")) {
            PositionAdminInfo pAdminInfo = new PositionAdminInfo();
            pAdminInfo.setPosition(info);
            pAdminInfo.setAdminOrgUnit(info.getAdminOrgUnit());
            pAdminInfo.setIsIncludeSub(true);
            iPositionAdmin.addnew(pAdminInfo);
        }
    }

    private void checkParentPosition(Context ctx) throws BOSException, PositionException {
        EntityViewInfo evInfo = new EntityViewInfo();
        evInfo.getSelector().add("name");
        evInfo.getSelector().add("adminOrgUnit.name");
        evInfo.setTopCount(1);
        CoreBaseCollection positionCollection = this.getCollection(ctx, evInfo);
        if (positionCollection.size() > 0) {
            PositionInfo positionInfo = (PositionInfo)positionCollection.get(0);
            Object[] params = new String[]{positionInfo.getAdminOrgUnit().getName(), positionInfo.getName()};
            throw new PositionException(PositionException.EXIST_ROOT_POSITION, params);
        }
    }

    private void doWithPrimaryPositionCase(Context ctx, PositionInfo info, OUPartAdminInfo ouPartAdminInfo) throws BOSException, EASBizException {
        String rangeValue;
        StringBuffer sql = null;
        if (ouPartAdminInfo.getResponPosition() != null) {
            String oldResPosId = ouPartAdminInfo.getResponPosition().getId().toString();
            sql = new StringBuffer("UPDATE T_ORG_Position SET FIsRespPosition=0,FIndex=0 WHERE FID='");
            sql.append(oldResPosId);
            sql.append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if ("false".equalsIgnoreCase(rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"isAllowNoPositionInDepartment")) || info.isIsRespPosition()) {
            ouPartAdminInfo.setResponPosition(info);
            OUPartAdminFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ouPartAdminInfo.getId()), (OUPartCoreBaseInfo)ouPartAdminInfo);
            sql = new StringBuffer("UPDATE T_ORG_Admin SET FResponPositionID = '");
            sql.append(info.getId().toString());
            sql.append("' WHERE FID ='");
            sql.append(info.getAdminOrgUnit().getId().toString());
            sql.append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer("UPDATE T_ORG_Position SET FIsRespPosition=1,FIndex=-1 WHERE FID='");
            sql.append(info.getId().toString());
            sql.append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx)) {
            this._reviseHistoryOnly(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    protected FilterInfo getFilterForCheckNumber(IObjectValue model) {
        return null;
    }

    @Override
    protected void _sort(Context ctx, String[] ids, int[] orders) throws BOSException, EASBizException {
        String sql = "UPDATE T_ORG_Position SET FIndex=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PositionInfo info = (PositionInfo)model;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_cancel", (BOSObjectType)info.getBOSType(), null, (String)(info.getNumber() + "  " + info.getName()), (String)"Position_Disable");
        super._cancel(ctx, pk, model);
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx) && info.getEFFDT() == null) {
            PositionInfo oldInfo = this.getPositionInfo(ctx, pk);
            info.setEFFDT(oldInfo.getEFFDT());
            info.setLEFFDT(oldInfo.getLEFFDT());
        }
        info.setValiDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.existPerson(ctx, pk.toString())) {
            Object[] params = new String[]{info.getName() + "(" + info.getNumber() + ")"};
            throw new PositionException(PositionException.NO_INVAID_POSITION, params);
        }
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        if (info.get("IS_FROM_SHR_OPTAction") == null) {
            this._reviseHistoryOnly(ctx, pk);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private boolean existPerson(Context ctx, String pId) throws BOSException, EASBizException {
        String sql = "SELECT DISTINCT \"PERSON\".FID AS \"ID\", \"PERSON\".FNumber AS \"NUMBER\", \"PERSON\".FName_l2 AS \"NAME\", \"POSITION\".FID AS \"POSITION.ID\", \"PERSON\".FDeletedStatus AS \"DELETEDSTATUS\", \"POSITION\".FName_l2 AS \"POSITION.NAME\"  FROM T_BD_Person AS \"PERSON\"  INNER JOIN T_ORG_PositionMember AS \"POSITIONMEMBER\" ON \"PERSON\".FID = \"POSITIONMEMBER\".FPersonID INNER JOIN T_ORG_Position AS \"POSITION\" ON \"POSITIONMEMBER\".FPositionID = \"POSITION\".FID WHERE \"POSITION\".FID ='" + pId + "' AND \"PERSON\".FDeletedStatus !='2'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            return rows.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PositionInfo info = (PositionInfo)model;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_cancelCancel", (BOSObjectType)info.getBOSType(), null, (String)(info.getNumber() + "  " + info.getName()), (String)"Position_Enable");
        super._cancelCancel(ctx, pk, model);
        if (info.getEFFDT() == null) {
            PositionInfo oldInfo = this.getPositionInfo(ctx, pk);
            info.setEFFDT(oldInfo.getEFFDT());
            info.setLEFFDT(oldInfo.getLEFFDT());
        }
        info.setValiDate(null);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        if (info.get("IS_FROM_SHR_OPTAction") == null) {
            this._reviseHistoryOnly(ctx, pk);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    String getIntermitNumber(Context ctx, IObjectValue _pInfo, PositionInfo bInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyId = bInfo.getCU().getId().toString();
        if (companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(_pInfo, companyId)) {
            String posNumber = iCodingRuleManager.getNumber(_pInfo, companyId);
            if (!StringUtils.isEmpty((String)posNumber)) {
                while (this.isPositionNumberDuplicate(ctx, posNumber)) {
                    posNumber = iCodingRuleManager.getNumber(_pInfo, companyId);
                }
            }
            return posNumber;
        }
        return null;
    }

    private boolean isPositionNumberDuplicate(Context ctx, String posNumber) throws BOSException, EASBizException {
        return PositionFactory.getLocalInstance(ctx).exists(" select id where number='" + posNumber + "'");
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        PositionInfo position = (PositionInfo)super._getValue(ctx, pk, selector);
        this.getHroPositionRelaInfo(ctx, position);
        return position;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PositionInfo position = (PositionInfo)super._getValue(ctx, pk);
        this.getHroPositionRelaInfo(ctx, position);
        return position;
    }

    private void getHroPositionRelaInfo(Context ctx, PositionInfo position) throws BOSException, EASBizException {
        String ql;
        IPositionHierarchy iPH;
        if (position.getParent() == null && (iPH = PositionHierarchyFactory.getLocalInstance(ctx)).exists(ql = "select parent.id,parent.name where child='" + position.getId() + "' and hierarchy='" + "00000000-0000-0000-0000-000000000001396FCAD0" + "'")) {
            PositionHierarchyInfo oldPHInfo = iPH.getPositionHierarchyInfo(ql);
            position.setParent(oldPHInfo.getParent());
        }
        if (!"true".equals(ctx.get((Object)"needPositionRelaInfo"))) {
            return;
        }
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PositionBusinessProcessorBuilder.ACT_GETHROPOSITIONRELAINFO, null, new Object[]{position});
        PositionBusinessProcessorBuilder builder = new PositionBusinessProcessorBuilder((ExecuteContext)executeContext);
        BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
        batchResults.throwExceptions();
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNumberDup(ctx, model);
    }

    private int getMaxIndex(Context ctx, String adminId) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FIndex) FROM T_ORG_Position WHERE FAdminOrgUnitID=?", (Object[])new Object[]{adminId});
        try {
            if (rows != null && rows.size() != 0) {
                rows.next();
                return rows.getInt(1);
            }
            return 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkPosAdminOrgIsStartSHR(Context ctx, PositionInfo info, AdminOrgUnitInfo posAdminInfo) throws PositionException, BOSException {
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx) && info.get("IS_FROM_SHR_OPT_CURD") == null && posAdminInfo != null && this.CheckisSHR(ctx, posAdminInfo)) {
            throw new PositionException(PositionException.ORG_STARTSHR, new Object[]{posAdminInfo.getName()});
        }
    }

    private void setPosEFFDT(Context ctx, PositionInfo info, AdminOrgUnitInfo posAdminInfo) throws EASBizException, BOSException {
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx) && info.get("IS_FROM_SHR_OPT_CURD") == null) {
            AbstractPositionInfo posParentInfo = null;
            if (info.getParent() != null) {
                posParentInfo = this.getPositionInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()));
            }
            if (posParentInfo != null) {
                info.setEFFDT(posParentInfo.getEFFDT());
            } else {
                info.setEFFDT(posAdminInfo.getEFFDT());
            }
        }
    }

    private boolean CheckisSHR(Context ctx, AdminOrgUnitInfo info) throws BOSException {
        boolean flag = false;
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"select FISSTARTSHR  from t_org_admin where fid =?", (Object[])new Object[]{info.getId().toString()});
        try {
            String isSHR;
            if (rows.next() && "1".equals(isSHR = String.valueOf(rows.getInt("FISSTARTSHR")))) {
                flag = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    protected void _initAllDefaultPositionRole(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("isRespPosition", (Object)1));
        evi.setFilter(filterInfo);
        PositionCollection pc = this.getPositionCollection(ctx, evi);
        for (int i = 0; i < pc.size(); ++i) {
            this.addDefaultPositionRole(ctx, pc.get(i));
        }
    }
}

