/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.JobCategoryCollection;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobException;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobSystemFactory;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.app.AbstractJobCategoryControllerBean;
import com.kingdee.eas.basedata.org.helper.HRBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

public class JobCategoryControllerBean
extends AbstractJobCategoryControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        JobCategoryInfo info = (JobCategoryInfo)model;
        this._checkNumberDup(ctx, (IObjectValue)info);
        JobCategoryInfo parentInfo = null;
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        if (info.getParent() != null && info.getParent().getId() != null) {
            parentInfo = super.getJobCategoryInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        }
        this.setLevelAndLongNumber(parentInfo, info);
        IJob iJob = JobFactory.getLocalInstance(ctx);
        if (parentInfo != null && iJob.exists("where jobCategory.id='" + parentInfo.getId() + "'")) {
            throw new JobException(JobException.PAREBT_JOBCAT_INCLUDE_JOB);
        }
        info.setIsLeaf(true);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (info.getState() == null) {
            info.setState(DeletedStatusEnum.NORMAL);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        if (parentInfo != null && parentInfo.isIsLeaf()) {
            parentInfo.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (IObjectValue)parentInfo);
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        JobCategoryInfo oldParentInfo;
        boolean flag;
        JobCategoryInfo info = (JobCategoryInfo)model;
        JobCategoryInfo oldInfo = this.getJobCategoryInfo(ctx, pk);
        this._checkNumberDup(ctx, (IObjectValue)info);
        JobCategoryInfo parentInfo = null;
        if (info.getParent() != null && info.getParent().getId() != null) {
            parentInfo = super.getJobCategoryInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()));
            this.checkUpdate(ctx, info, oldInfo);
        }
        this.setLevelAndLongNumber(parentInfo, info);
        IJob iJob = JobFactory.getLocalInstance(ctx);
        if (info.getParent() != null && info.getParent().getId() != null && iJob.exists("where jobCategory.id='" + info.getParent().getId() + "'")) {
            throw new JobException(JobException.PAREBT_JOBCAT_INCLUDE_JOB);
        }
        super._update(ctx, pk, (IObjectValue)info);
        if (info.getParent() != null && info.getParent().getId() != null && parentInfo.isIsLeaf()) {
            parentInfo.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (IObjectValue)parentInfo);
        }
        JobCategoryCollection JobCategoryColl = null;
        JobCategoryInfo jobCategoryInfo = null;
        String jobSystemId = null;
        if (oldInfo.getJobSystem() != null) {
            jobSystemId = oldInfo.getJobSystem().getId().toString();
        }
        JobCategoryColl = this.getListByParent(ctx, jobSystemId, oldInfo.getLongNumber());
        String temp = "";
        for (int i = 0; i < JobCategoryColl.size(); ++i) {
            jobCategoryInfo = JobCategoryColl.get(i);
            temp = jobCategoryInfo.getLongNumber().trim();
            temp = info.getLongNumber().trim() + temp.substring(oldInfo.getLongNumber().trim().length(), temp.length());
            jobCategoryInfo.setLongNumber(temp);
            jobCategoryInfo.setLevel(jobCategoryInfo.getLevel() + (info.getLevel() - oldInfo.getLevel()));
            super._update(ctx, (IObjectPK)new ObjectUuidPK(jobCategoryInfo.getId()), (IObjectValue)jobCategoryInfo);
        }
        if (oldInfo.getParent() != null && oldInfo.getParent().getId() != null && !(flag = this.hasChild(ctx, (oldParentInfo = this.getJobCategoryInfo(ctx, (IObjectPK)new ObjectUuidPK(oldInfo.getParent().getId()))).getLongNumber()))) {
            oldParentInfo.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(oldParentInfo.getId()), (IObjectValue)oldParentInfo);
        }
    }

    private void checkUpdate(Context ctx, JobCategoryInfo info, JobCategoryInfo oldInfo) throws BOSException, EASBizException {
        if (info.getParent().getId().toString().equalsIgnoreCase(info.getId().toString()) && oldInfo.getLevel() != 0) {
            throw new PositionException(PositionException.ERROR_PARENT_1);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(oldInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)info.getParent().getId());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem3 = null;
        int groupModel = JobSystemFactory.getLocalInstance(ctx).getJobSystemScheme();
        filterItem3 = groupModel == 0 ? new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4") : new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        filter.getFilterItems().add(filterItem3);
        if (this._exists(ctx, filter)) {
            throw new PositionException(PositionException.ERROR_PARENT_2);
        }
    }

    private JobCategoryCollection getListByParent(Context ctx, String jobSystemId, String fullNumber) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(fullNumber.trim() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem3 = null;
        int groupModel = JobSystemFactory.getLocalInstance(ctx).getJobSystemScheme();
        filterItem3 = groupModel == 0 ? new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4") : new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        filter.getFilterItems().add(filterItem3);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return this.getJobCategoryCollection(ctx, view);
    }

    private boolean hasChild(Context ctx, String fullNumber) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(fullNumber.trim() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem3 = null;
        int groupModel = JobSystemFactory.getLocalInstance(ctx).getJobSystemScheme();
        filterItem3 = groupModel == 0 ? new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4") : new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        filter.getFilterItems().add(filterItem3);
        return this._exists(ctx, filter);
    }

    private void setLevelAndLongNumber(JobCategoryInfo parentInfo, JobCategoryInfo model) throws BOSException {
        if (parentInfo == null || parentInfo == model) {
            model.setLevel(0);
            model.setLongNumber(model.getNumber());
        } else {
            model.setLevel(parentInfo.getLevel() + 1);
            model.setLongNumber(parentInfo.getLongNumber() + "!" + model.getNumber());
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        JobCategoryInfo parentInfo;
        JobCategoryInfo info = this.getJobCategoryInfo(ctx, pk);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem2 = new FilterItemInfo("parent", (Object)info.getId().toString());
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem3 = new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterItem3);
        boolean flag = JobCategoryFactory.getLocalInstance(ctx).exists(filter);
        if (flag) {
            throw new JobException(JobException.NO_DEL_PARENT);
        }
        flag = JobFactory.getLocalInstance(ctx).exists("where jobCategory='" + pk.toString() + "'");
        if (flag) {
            throw new JobException(JobException.JOB_IN_JOBCAT);
        }
        super._delete(ctx, pk);
        if (info.getParent() != null && !(flag = this.hasChild(ctx, (parentInfo = this.getJobCategoryInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()))).getLongNumber()))) {
            parentInfo.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (IObjectValue)parentInfo);
        }
    }

    @Override
    protected void _disable(Context ctx, JobCategoryInfo jobCategory) throws BOSException, EASBizException {
        this.checkExistEnableJob(ctx, jobCategory);
        this.checkExistChildJobCategory(ctx, jobCategory);
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp disableTime = new Timestamp(d.getTime().getTime());
        jobCategory.setDisableTime(disableTime);
        jobCategory.setState(DeletedStatusEnum.DELETED);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("disableTime"));
        selector.add(new SelectorItemInfo("state"));
        this._updatePartial(ctx, (IObjectValue)jobCategory, selector);
    }

    private void checkExistEnableJob(Context ctx, JobCategoryInfo jobCategory) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("jobCategory", (Object)jobCategory.getId().toString()));
        filter.setMaskString("#0 and #1");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        view.setSelector(selector);
        CoreBaseCollection col = JobFactory.getLocalInstance(ctx).getCollection(view);
        if (col.size() > 0) {
            throw new JobException(JobException.EXISTENABLEJOBORJOBCATEGORY, new String[]{jobCategory.getName()});
        }
    }

    private void checkExistChildJobCategory(Context ctx, JobCategoryInfo jobCategory) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(jobCategory.getLongNumber() + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 and #1");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        view.setSelector(selector);
        CoreBaseCollection col = this.getCollection(ctx, view);
        if (col.size() > 0) {
            throw new JobException(JobException.EXISTENABLEJOBORJOBCATEGORY, new String[]{jobCategory.getName()});
        }
    }

    @Override
    protected void _enable(Context ctx, JobCategoryInfo jobCategory) throws BOSException, EASBizException {
        JobCategoryInfo parent;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)jobCategory.getId()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("parent.state"));
        view.setFilter(filter);
        view.setSelector(selector);
        CoreBaseCollection col = this.getCollection(ctx, view);
        if (col.size() > 0 && (parent = ((JobCategoryInfo)col.get(0)).getParent()) != null && parent.getState() == DeletedStatusEnum.DELETED) {
            throw new JobException(JobException.EXISTDISABLEPARENTJOBCATEGORY);
        }
        selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("disableTime"));
        selector.add(new SelectorItemInfo("state"));
        jobCategory.setState(DeletedStatusEnum.NORMAL);
        jobCategory.setDisableTime(null);
        this._updatePartial(ctx, (IObjectValue)jobCategory, selector);
    }

    @Override
    protected void _batchDisable(Context ctx, Set set) throws BOSException, EASBizException {
        for (JobCategoryInfo jobCategory : set) {
            this._disable(ctx, jobCategory);
        }
    }

    @Override
    protected void _batchEnable(Context ctx, Set set) throws BOSException, EASBizException {
        for (JobCategoryInfo jobCategory : set) {
            this._enable(ctx, jobCategory);
        }
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException {
        HRBaseCommonUtil.updateInfoState(ctx, id, "FState", 1);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException {
        HRBaseCommonUtil.updateInfoState(ctx, id, "FState", 2);
    }
}

