/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.DeletedStatusEnum;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.app.AbstractPositionHierarchyControllerBean;
import com.kingdee.eas.basedata.org.helper.HRBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class PositionHierarchyControllerBean
extends AbstractPositionHierarchyControllerBean {
    private static final String RESOURCE = "com.kingdee.eas.basedata.org.PositionResource";

    private void checkParentPosition(Context ctx, PositionHierarchyInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)info.getHierarchy().getId().toString());
        filter.getFilterItems().add(filterItem);
        if (this._exists(ctx, filter)) {
            throw new PositionException(PositionException.NO_PARENT_POSITION);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PositionHierarchyInfo info = (PositionHierarchyInfo)model;
        IObjectPK logPk = null;
        try {
            HierarchyInfo hierarchy = info.getHierarchy();
            PositionInfo child = info.getChild();
            PositionInfo parent = info.getParent();
            Object[] params = new Object[]{hierarchy.getName(), hierarchy.getNumber(), child.getName(), child.getNumber(), parent.getName(), parent.getNumber()};
            String logMsg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"Hierarchy_AddNewPosition", (Locale)ctx.getLocale()), params);
            logPk = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)info.getBOSType(), null, (String)logMsg, (String)"Hierarchy_AddNew");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkParent(ctx, info);
        if (info.getParent() == info.getChild()) {
            this.checkParentPosition(ctx, info);
        }
        this.setLevelAndLongNumber(ctx, info.getParent(), info.getChild(), info);
        info.setIsLeaf(true);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        if (info.getParent() == null) {
            info.setParent(info.getChild());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        if (info.getParent() != info.getChild()) {
            PositionHierarchyInfo pModel = this.getParentPH(ctx, info, info.getParent());
            pModel.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(pModel.getId()), (IObjectValue)pModel);
        }
        LogUtil.afterLog((Context)ctx, logPk);
        return pk;
    }

    private void checkUpdate(Context ctx, PositionHierarchyInfo info, PositionHierarchyInfo oldInfo) throws BOSException, EASBizException {
        if (info.getParent().getId().toString().equals(info.getChild().getId().toString())) {
            throw new PositionException(PositionException.ERROR_PARENT_1);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(oldInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem = new FilterItemInfo("child", (Object)info.getParent().getId().toString());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem3 = new FilterItemInfo("hierarchy.id", (Object)oldInfo.getHierarchy().getId().toString());
        filter.getFilterItems().add(filterItem3);
        if (this._exists(ctx, filter)) {
            throw new PositionException(PositionException.ERROR_PARENT_2);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PositionHierarchyInfo info = (PositionHierarchyInfo)model;
        PositionHierarchyInfo oldInfo = this.getPositionHierarchyInfo(ctx, pk);
        if (oldInfo.getParent().getId().toString().equalsIgnoreCase(info.getParent().getId().toString())) {
            throw new PositionException(PositionException.ERROR_PARENT_4);
        }
        if (!info.getHierarchy().getId().equals((Object)oldInfo.getHierarchy().getId())) {
            this.checkParent(ctx, info);
        }
        this.checkUpdate(ctx, info, oldInfo);
        this.setLevelAndLongNumber(ctx, info.getParent(), info.getChild(), info);
        super._update(ctx, pk, (IObjectValue)info);
        PositionHierarchyInfo pModel = this.getParentPH(ctx, info, info.getParent());
        if (pModel.isIsLeaf()) {
            pModel.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(pModel.getId()), (IObjectValue)pModel);
        }
        PositionHierarchyCollection posiHierColl = null;
        PositionHierarchyInfo phInfo = null;
        posiHierColl = this.getPHListByParent(ctx, oldInfo.getHierarchy().getId().toString(), oldInfo.getLongNumber());
        String temp = "";
        for (int i = 0; i < posiHierColl.size(); ++i) {
            phInfo = posiHierColl.get(i);
            temp = phInfo.getLongNumber().trim();
            temp = info.getLongNumber().trim() + temp.substring(oldInfo.getLongNumber().trim().length(), temp.length());
            phInfo.setLongNumber(temp);
            phInfo.setLevel(phInfo.getLevel() + (info.getLevel() - oldInfo.getLevel()));
            super._update(ctx, (IObjectPK)new ObjectUuidPK(phInfo.getId()), (IObjectValue)phInfo);
        }
        PositionHierarchyInfo oldPModel = this.getParentPH(ctx, info, oldInfo.getParent());
        boolean flag = this.hasChild(ctx, oldPModel.getHierarchy().getId().toString(), oldPModel.getLongNumber());
        if (!flag) {
            oldPModel.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(oldPModel.getId()), (IObjectValue)oldPModel);
        }
        if (HRBaseCommonUtil.isBeginToUseSHR(ctx) && "00000000-0000-0000-0000-000000000001396FCAD0".equals(info.getHierarchy().getId().toString())) {
            this.updateParentOfPositionInfo(ctx, info);
        }
    }

    private void updateParentOfPositionInfo(Context ctx, PositionHierarchyInfo info) throws BOSException {
        String childId = info.getChild().getId().toString();
        String parentId = info.getParent().getId().toString();
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_ORG_Position set FParentID='").append(parentId).append("'").append(" where fid='").append(childId).append("'");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append("update T_ORG_PositionHis set FParentID='").append(parentId).append("'").append(" where FHistoryRelateID='").append(childId).append("'").append(" and FLEFFDT={ts'2199-12-31'}");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void checkParent(Context ctx, PositionHierarchyInfo info) throws BOSException, EASBizException {
        boolean flag = this.hasChild2(ctx, info.getHierarchy().getId().toString(), info.getChild().getId().toString());
        if (flag) {
            throw new PositionException(PositionException.EXIST_HIERARCHY);
        }
    }

    private void setLevelAndLongNumber(Context ctx, PositionInfo parentInfo, PositionInfo info, PositionHierarchyInfo model) throws EASBizException, BOSException {
        if (parentInfo == info) {
            model.setLevel(0);
            model.setLongNumber(info.getNumber());
        } else if (parentInfo == null) {
            model.setLevel(0);
            info = PositionFactory.getLocalInstance(ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            model.setLongNumber(info.getNumber());
        } else {
            PositionHierarchyInfo pModel = this.getParentPH(ctx, model, parentInfo);
            info = PositionFactory.getLocalInstance(ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            if (pModel == null) {
                Object[] params = new String[]{info.getName(), parentInfo.getName(), parentInfo.getName()};
                throw new PositionException(PositionException.ERROR_PARENT_6, params);
            }
            model.setLevel(pModel.getLevel() + 1);
            model.setLongNumber(pModel.getLongNumber() + "!" + info.getNumber());
        }
    }

    private PositionHierarchyInfo getParentPH(Context ctx, PositionHierarchyInfo model, PositionInfo parentInfo) throws BOSException {
        PositionHierarchyCollection posiHierColl = null;
        posiHierColl = this.getPHListByChild(ctx, model.getHierarchy().getId().toString(), parentInfo.getId().toString());
        if (posiHierColl != null && posiHierColl.size() > 0) {
            return posiHierColl.get(0);
        }
        return null;
    }

    private PositionHierarchyCollection getPHListByChild(Context ctx, String hierarchyId, String childId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("child.id", (Object)childId.trim());
        filter.getFilterItems().add(filterItem2);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return this.getPositionHierarchyCollection(ctx, view);
    }

    private boolean hasChild2(Context ctx, String hierarchyId, String childId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("child.id", (Object)childId.trim());
        filter.getFilterItems().add(filterItem2);
        return this._exists(ctx, filter);
    }

    private PositionHierarchyCollection getTop2PHListByParent(Context ctx, String hierarchyId, String fullNumber) throws BOSException {
        PositionHierarchyCollection col = new PositionHierarchyCollection();
        StringBuffer sql = new StringBuffer("SELECT TOP 2 FID FROM T_ORG_PositionHierarchy WHERE FLONGNUMBER LIKE '");
        sql.append(fullNumber.trim()).append("!").append("%' AND FHierarchyID='").append(hierarchyId.trim()).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs != null && rs.next()) {
                PositionHierarchyInfo info = new PositionHierarchyInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                col.add(info);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return col;
    }

    private PositionHierarchyCollection getPHListByParent(Context ctx, String hierarchyId, String fullNumber) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(fullNumber.trim() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return this.getPositionHierarchyCollection(ctx, view);
    }

    private boolean hasChild(Context ctx, String hierarchyId, String fullNumber) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(fullNumber.trim() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        return this._exists(ctx, filter);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._deleteNew(ctx, pk, true);
    }

    @Override
    protected void _deleteNew(Context ctx, IObjectPK pk, boolean flag) throws BOSException, EASBizException {
        PositionHierarchyInfo info = this.getPositionHierarchyInfo(ctx, pk);
        if (flag) {
            IHierarchy iHy = HierarchyFactory.getLocalInstance(ctx);
            if (info.getHierarchy().getId().toString().equals(iHy.getDefaultHierarchy().getId().toString())) {
                throw new PositionException(PositionException.FORBID_DELETE_ADMIN_HIERARCHY);
            }
        }
        PositionHierarchyCollection posiHierColl = null;
        posiHierColl = this.getTop2PHListByParent(ctx, info.getHierarchy().getId().toString(), info.getLongNumber());
        if (posiHierColl != null) {
            if (posiHierColl.size() > 1) {
                throw new PositionException(PositionException.EXIST_CHILDREN);
            }
            if (posiHierColl.size() == 1 && !posiHierColl.get(0).getId().toString().equals(pk.toString())) {
                throw new PositionException(PositionException.EXIST_CHILDREN);
            }
        }
        PositionHierarchyInfo oldPModel = this.getParentPH(ctx, info, info.getParent());
        PositionHierarchyCollection oldPosiHierColl = null;
        oldPosiHierColl = this.getTop2PHListByParent(ctx, oldPModel.getHierarchy().getId().toString(), oldPModel.getLongNumber());
        super._delete(ctx, pk);
        if (oldPModel.getId().toString().equals(pk.toString())) {
            return;
        }
        if (oldPosiHierColl != null && oldPosiHierColl.size() == 1 && oldPosiHierColl.get(0).getId().toString().equals(pk.toString())) {
            oldPModel.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(oldPModel.getId()), (IObjectValue)oldPModel);
        }
    }

    @Override
    protected void _deletePosition(Context ctx, String hierarchyId, String positionId) throws BOSException, EASBizException {
        IObjectPK logPk = null;
        try {
            HierarchyInfo hierarchyInfo = HierarchyFactory.getLocalInstance(ctx).getHierarchyInfo((IObjectPK)new ObjectUuidPK(hierarchyId));
            PositionInfo positionInfo = PositionFactory.getLocalInstance(ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionId));
            Object[] params = new Object[]{hierarchyInfo.getName(), hierarchyInfo.getNumber(), positionInfo.getName(), positionInfo.getNumber()};
            String logMsg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"Hierarchy_DeletePosition", (Locale)ctx.getLocale()), params);
            logPk = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)hierarchyInfo.getBOSType(), null, (String)logMsg, (String)"Hierarchy_Delete");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PositionHierarchyCollection phColl = this.getPHListByChild(ctx, hierarchyId, positionId);
        if (phColl.size() > 0) {
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(phColl.get(0).getId()));
        }
        LogUtil.afterLog((Context)ctx, logPk);
    }

    @Override
    protected Set _convert(Context ctx, Set phSet) throws BOSException, EASBizException {
        if (phSet == null || phSet.size() == 0) {
            return phSet;
        }
        HashSet<String> newSet = new HashSet<String>();
        StringBuffer oql = new StringBuffer("select id, longNumber, isLeaf, child.id, child.deletedStatus where id in ('");
        Iterator iterator = phSet.iterator();
        oql.append(iterator);
        while (iterator.hasNext()) {
            oql.append("', '").append(iterator.next());
        }
        oql.append("')");
        PositionHierarchyCollection phColl = this.getPositionHierarchyCollection(ctx, oql.toString());
        FilterItemInfo itemInfo = new FilterItemInfo("child.deletedStatus", (Object)2, CompareType.NOTEQUALS);
        for (int i = phColl.size() - 1; i >= 0; --i) {
            PositionHierarchyInfo phInfo = phColl.get(i);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(phInfo.getLongNumber() + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(itemInfo);
            if (!phInfo.isIsLeaf() && phInfo.getChild().getDeletedStatus() == DeletedStatusEnum.DELETED && !this._exists(ctx, filterInfo)) {
                phColl.removeObject(i);
                continue;
            }
            newSet.add(phInfo.getId().toString());
        }
        return newSet;
    }

    @Override
    protected IObjectPK _updateRoot(Context ctx, PositionHierarchyInfo model) throws BOSException, EASBizException {
        HierarchyInfo hierarchy = model.getHierarchy();
        PositionInfo posInfo = model.getChild();
        if (posInfo.getNumber() == null) {
            posInfo = PositionFactory.getLocalInstance(ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(posInfo.getId()));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchy.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("child.id", (Object)posInfo.getId().toString()));
        if (this._exists(ctx, filterInfo)) {
            throw new PositionException(PositionException.EXIST_HIERARCHY);
        }
        model.setParent(posInfo);
        model.setLevel(0);
        model.setIsLeaf(false);
        model.setLongNumber(posInfo.getNumber());
        if (model.getId() == null) {
            return super._addnew(ctx, (IObjectValue)model);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        PositionHierarchyInfo oldInfo = this.getPositionHierarchyInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getId()), sic);
        DbUtil.execute((Context)ctx, (String)"delete from t_org_PositionHierarchy where fid =?", (Object[])new Object[]{model.getId().toString()});
        IObjectPK pk = super._addnew(ctx, (IObjectValue)model);
        DbUtil.execute((Context)ctx, (String)"update t_org_PositionHierarchy set fparentid = ? where fparentid =? and fHierarchyid=? ", (Object[])new Object[]{posInfo.getId().toString(), oldInfo.getParent().getId().toString(), hierarchy.getId().toString()});
        PositionHierarchyCollection posiHierColl = null;
        PositionHierarchyInfo phInfo = null;
        posiHierColl = this.getPHListByParent(ctx, oldInfo.getHierarchy().getId().toString(), oldInfo.getLongNumber());
        String temp = null;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < posiHierColl.size(); ++i) {
            phInfo = posiHierColl.get(i);
            temp = phInfo.getLongNumber().trim();
            temp = posInfo.getNumber().trim() + temp.substring(oldInfo.getLongNumber().trim().length(), temp.length());
            paramsList.add(new Object[]{temp, phInfo.getId().toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)"update t_org_PositionHierarchy set flongnumber =? where fid =?", paramsList);
        return pk;
    }

    @Override
    protected IObjectPK _updateNode(Context ctx, PositionHierarchyInfo model, PositionInfo curInfo, PositionInfo parentInfo) throws BOSException, EASBizException {
        PositionHierarchyInfo phInfo = this.getPositionHierarchyInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getId()));
        phInfo.setParent(parentInfo);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(phInfo.getId()), (CoreBaseInfo)phInfo);
        if ("00000000-0000-0000-0000-000000000001396FCAD0".equals(phInfo.getHierarchy().getId().toString())) {
            curInfo.put("SuperPosition", parentInfo);
            curInfo.put("IS_FROM_SHR_OPT_CURD", "IS_FROM_SHR_OPT_CURD");
            PositionFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(curInfo.getId().toString()), (CoreBaseInfo)curInfo);
        }
        return null;
    }
}

