/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.person.PersonAccountFactory;
import com.kingdee.eas.basedata.person.PersonAccountInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class PersonAccountDataImport
extends AbstractDataTransmission {
    private String res = "com.kingdee.eas.basedata.person.PersonAccountInputResource.";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PersonAccountFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PersonAccountInfo info = new PersonAccountInfo();
        if (!this.checkPermission("PersonAccount_AddNew", info, ctx)) {
            throw new TaskExternalException(ResourceBase.getString((String)(this.res + "HAVE_NOT_PERMISSION"), (Locale)ctx.getLocale()));
        }
        String str = null;
        Locale locale = ctx.getLocale();
        try {
            str = (String)((DataToken)hsData.get((Object)"FPerson_number")).data;
            PersonCollection personCollection = PersonFactory.getLocalInstance(ctx).getPersonCollection("where number = '" + str.trim() + "'");
            if (personCollection.size() == 0) {
                throw new TaskExternalException(ResourceBase.getString((String)(this.res + "PERSON_NUMBER_NOT_FOUND"), (Locale)locale));
            }
            PersonInfo personInfo = personCollection.get(0);
            info.setPerson(personInfo);
            str = (String)((DataToken)hsData.get((Object)"FBank_l1")).data;
            info.setBank(str, new Locale("L1"));
            str = (String)((DataToken)hsData.get((Object)"FBank_l2")).data;
            info.setBank(str, new Locale("L2"));
            str = (String)((DataToken)hsData.get((Object)"FBank_l3")).data;
            info.setBank(str, new Locale("L3"));
            String rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"IsAllowedEnterPersonBank");
            if ("false".equalsIgnoreCase(rangeValue)) {
                String bank = info.getBank(locale);
                BEBankCollection bEBankCollection = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection("where name = '" + bank.trim() + "'");
                if (bEBankCollection.size() == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)(this.res + "BEBANK_NOT_FOUND"), (Locale)locale));
                }
                BEBankInfo beBankInfo = bEBankCollection.get(0);
                info.setBankId(beBankInfo);
            }
            if (StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FBankAccount")).data))) {
                throw new TaskExternalException(ResourceBase.getString((String)(this.res + "BANKACCOUNT_NOT_NULL"), (Locale)locale));
            }
            info.setBankAccount(str);
            str = (String)((DataToken)hsData.get((Object)"FCurrency_number")).data;
            if (!StringUtils.isEmpty((String)str)) {
                CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("where number = '" + str.trim() + "'");
                if (currencyCollection.size() == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)(this.res + "CURRENCY_NOT_FOUND"), (Locale)locale));
                }
                info.setCurrency(currencyCollection.get(0));
            }
            str = (String)((DataToken)hsData.get((Object)"FIsDefault")).data;
            boolean isDefault = this.getBooleanFromAlias(str);
            info.setIsDefault(isDefault);
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private Boolean getBooleanFromAlias(String isPrimary) {
        if ("Y".equalsIgnoreCase(isPrimary) || "1".equals(isPrimary)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean checkPermission(String permissionItem, PersonAccountInfo paInfo, Context ctx) {
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            ObjectUuidPK orgPk = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            boolean haspermission = permission.hasDataPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem, (IObjectValue)paInfo);
            if (!haspermission) {
                return false;
            }
        }
        catch (EASBizException e) {
            return false;
        }
        catch (BOSException e) {
            return false;
        }
        return true;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"person.number", "person.name", "bankName", "bankAccount", "Currency.number", "isDefault"});
        exportMap.put("excelFiled", new String[]{"FPerson_number", "FPerson_name_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toLowerCase(), "FBank_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toLowerCase(), "FBankAccount", "FCurrency_number", "FIsDefault"});
        exportMap.put("FiledType", new String[0]);
        return this.transeExport(rs, exportMap);
    }

    private Hashtable<String, String> transeExport(IRowSet rs, Map map) throws TaskExternalException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] queryFiled = (String[])map.get("queryFiled");
        String[] excelFiled = (String[])map.get("excelFiled");
        try {
            int size = queryFiled.length;
            for (int i = 0; i < size; ++i) {
                if (rs.getString(queryFiled[i]) == null) continue;
                if ("false".equals(rs.getString(queryFiled[i])) || "true".equals(rs.getString(queryFiled[i]))) {
                    if ("false".equals(rs.getString(queryFiled[i]))) {
                        hashtable.put(excelFiled[i], "N");
                        continue;
                    }
                    hashtable.put(excelFiled[i], "Y");
                    continue;
                }
                hashtable.put(excelFiled[i], rs.getString(queryFiled[i]));
            }
        }
        catch (SQLException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return hashtable;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.person.app.PersonAccountQuery";
    }
}

