/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.CnToSpell;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AgentUserManagerFacadeFactory;
import com.kingdee.eas.base.permission.IAgentUserManagerFacade;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.service.comstrategy.CommunicationInfo;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.BasePersonConstraints;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCheckException;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonDeleteFactory;
import com.kingdee.eas.basedata.person.PersonDeleteInfo;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.PersonUpdateConstraint;
import com.kingdee.eas.basedata.person.app.AbstractPersonControllerBean;
import com.kingdee.eas.basedata.person.app.IDisableBizCheck;
import com.kingdee.eas.basedata.person.app.PersonHistoryRelateCheckUtil;
import com.kingdee.eas.basedata.person.app.PersonInfoCheck;
import com.kingdee.eas.basedata.person.app.processor.PersonAfterBusinessProcessorBuilder;
import com.kingdee.eas.basedata.person.app.processor.PersonBeforeBusinessProcessorBuilder;
import com.kingdee.eas.basedata.person.util.CommonTool;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.AbstractBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PersonControllerBean
extends AbstractPersonControllerBean {
    private static final String NUMBER = "number";
    private static final String IDCARDNUMBER = "idCardNumber";
    private static final String PASSPORTNUMBER = "passportNumber";
    private static final String NPPERSONSTATUS = "00000000-0000-0000-0000-000000000009A29E85B3";
    private static final String paramNum = "IS_IDCARD_VERIFY";
    private boolean isIDCardVerify = true;
    private static Logger logger = Logger.getLogger(PersonControllerBean.class);

    @Override
    protected void _antiAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        this._batchAudit(ctx, ids, false);
    }

    @Override
    protected void _audit(Context ctx, String[] ids) throws BOSException, EASBizException {
        this._batchAudit(ctx, ids, true);
    }

    @Override
    protected IObjectValue _getPrimaryPosition(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("isPrimary", (Object)"1");
        FilterItemInfo filterItemPerson = new FilterItemInfo("person.id", (Object)personId.toString());
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItemPerson);
        filter.setMaskString("#0 and #1");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.job.*"));
        PositionInfo positionInfo = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection posiMemberColl = iPosiMember.getCollection(viewInfo);
        PositionMemberInfo posiMemberInfo = null;
        if (posiMemberColl.size() >= 1) {
            posiMemberInfo = (PositionMemberInfo)posiMemberColl.get(0);
            positionInfo = posiMemberInfo.getPosition();
        }
        return positionInfo;
    }

    protected PositionMemberCollection getPrimaryPositions(Context ctx, String personIds) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("isPrimary", (Object)"1");
        FilterItemInfo filterItemPerson = new FilterItemInfo("person.id", (Object)personIds, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItemPerson);
        filter.setMaskString("#0 and #1");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection posiMemberColl = iPosiMember.getPositionMemberCollection(viewInfo);
        return posiMemberColl;
    }

    @Override
    protected IObjectCollection _getPositions(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItemPerson = new FilterItemInfo("person.id", (Object)personId.toString().trim());
        filter.getFilterItems().add(filterItemPerson);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        PositionInfo positionInfo = null;
        PositionCollection positionColl = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection posiMemberColl = iPosiMember.getCollection(viewInfo);
        PositionMemberInfo posiMemberInfo = null;
        ObjectUuidPK pk = null;
        positionColl = new PositionCollection();
        int size = posiMemberColl.size();
        for (int i = 0; i < size; ++i) {
            posiMemberInfo = (PositionMemberInfo)posiMemberColl.get(i);
            pk = new ObjectUuidPK(posiMemberInfo.getPosition().getId());
            positionInfo = (PositionInfo)iPosition.getValue((IObjectPK)pk);
            positionColl.add(positionInfo);
        }
        return positionColl;
    }

    @Override
    protected IObjectCollection _getAllAdminOrgUnit(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        CoreBaseCollection posiMemberColl = this.getPosiMemberByPerson(ctx, personId, false);
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        PositionMemberInfo posiMemberInfo = null;
        AdminOrgUnitInfo adminOrgInfo = null;
        AdminOrgUnitCollection adminOrgColl = new AdminOrgUnitCollection();
        ObjectUuidPK pk = null;
        int size = posiMemberColl.size();
        for (int i = 0; i < size; ++i) {
            posiMemberInfo = (PositionMemberInfo)posiMemberColl.get(i);
            pk = new ObjectUuidPK(posiMemberInfo.getPosition().getAdminOrgUnit().getId());
            adminOrgInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)pk);
            adminOrgColl.add(adminOrgInfo);
        }
        return adminOrgColl;
    }

    @Override
    protected IObjectValue _getPrimaryAdminOrgUnit(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgInfo = null;
        CoreBaseCollection posiMemberColl = this.getPosiMemberByPerson(ctx, personId, true);
        PositionMemberInfo posiMemberInfo = null;
        if (posiMemberColl.size() >= 1) {
            posiMemberInfo = (PositionMemberInfo)posiMemberColl.get(0);
            adminOrgInfo = posiMemberInfo.getPosition().getAdminOrgUnit();
        }
        return adminOrgInfo;
    }

    private CoreBaseCollection getPosiMemberByPerson(Context ctx, BOSUuid personId, boolean isPrimary) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (isPrimary) {
            FilterItemInfo filterItem = new FilterItemInfo("isPrimary", (Object)"1");
            filter.getFilterItems().add(filterItem);
        }
        FilterItemInfo filterItemPerson = new FilterItemInfo("person.id", (Object)personId.toString());
        filter.getFilterItems().add(filterItemPerson);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.*"));
        CoreBaseCollection posiMemberColl = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        posiMemberColl = iPosiMember.getCollection(viewInfo);
        return posiMemberColl;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitInfo admin;
        PersonInfo info = (PersonInfo)model;
        this.sysnPersonCell(info);
        String methodName = "_addnew";
        BOSObjectType bizObjType = info.getBOSType();
        String instanceDetail = info.getNumber() + "  " + info.getName();
        String logItemName = "Person_AddNew";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, null, (String)instanceDetail, (String)logItemName);
        this._checkNameBlank(ctx, (IObjectValue)info);
        this.checkCellorMailDup(ctx, info.getCell(), info.getEmail(), null);
        this.parseNameAndIdCard(info);
        this.doWithPersonNumber(ctx, info);
        this._checkNumberBlank(ctx, (IObjectValue)info);
        this._checkNumberDup(ctx, (IObjectValue)info);
        CommonTool.trimNameAndNumberSpaceOfObjectInfo(info);
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PersonBeforeBusinessProcessorBuilder.ACT_ADDNEW, null, new Object[]{info});
        AbstractBusinessProcessorBuilder builder = new PersonBeforeBusinessProcessorBuilder((ExecuteContext)executeContext);
        BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
        batchResults.throwExceptions();
        this.doWithPersonOtherField(ctx, info);
        if (info.getIndexOf() == 0) {
            info.setIndexOf(9999999);
        }
        if (info.getLEFFDT() == null) {
            info.setLEFFDT(HistoryUtil.getMaxDate());
        }
        if ((admin = (AdminOrgUnitInfo)info.get("GKADMIN")) != null) {
            info.setGkAdmin(admin);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        if (info.get("IS_FROM_SHR_OPTAction") == null) {
            info.put(BasePersonConstraints.BASEPERSONFLAG, true);
            executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PersonAfterBusinessProcessorBuilder.ACT_ADDNEW, null, new Object[]{info});
            builder = new PersonAfterBusinessProcessorBuilder((ExecuteContext)executeContext);
            batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
            batchResults.throwExceptions();
            this.dealWithPotionMenmber(ctx, info);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    private void dealWithPotionMenmber(Context ctx, PersonInfo info) throws BOSException, EASBizException {
        IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
        if (info.get("PositionList") != null) {
            PositionMemberCollection pmColl = null;
            PositionMemberInfo pmInfo = null;
            pmColl = (PositionMemberCollection)info.get("PositionList");
            IPersonPlan iPPlan = PersonPlanFactory.getLocalInstance((Context)ctx);
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                pmInfo = pmColl.get(i);
                if (pmInfo.getId() != null && pmInfo.getId().toString().length() != 0) {
                    pmInfo.setPerson(info);
                    iPM.update((IObjectPK)new ObjectUuidPK(pmInfo.getId()), (CoreBaseInfo)pmInfo);
                    continue;
                }
                iPPlan.canAddPerson(pmInfo.getPosition().getId().toString());
                pmInfo.setId(BOSUuid.create((BOSObjectType)pmInfo.getBOSType()));
                pmInfo.setPerson(info);
                iPM.addnew((CoreBaseInfo)pmInfo);
            }
        }
        if (info.get("deleteList") != null) {
            ArrayList deleteList = (ArrayList)info.get("deleteList");
            for (ObjectUuidPK objPK : deleteList) {
                iPM.delete((IObjectPK)objPK);
            }
        }
    }

    private void sysnPersonCell(PersonInfo info) {
        String global = info.getGlobalRoaming();
        String ncell = info.getNCell();
        String cell = info.getCell();
        if (!StringUtils.isEmpty((String)ncell)) {
            if (StringUtils.isEmpty((String)global)) {
                info.setGlobalRoaming("+86");
                global = "+86";
            }
            if ("+86".equals(global)) {
                info.setCell(ncell);
            } else {
                info.setCell(global + "-" + ncell);
            }
        } else if (!StringUtils.isEmpty((String)cell)) {
            String[] globalMap = this.getGLObalMapCell(cell);
            info.setGlobalRoaming(globalMap[0]);
            info.setNCell(globalMap[1]);
        }
    }

    private String[] getGLObalMapCell(String cell) {
        String[] gm = new String[2];
        if (StringUtils.isEmpty((String)cell)) {
            return gm;
        }
        int index = cell.indexOf("-");
        if (index < 0) {
            gm[0] = "+86";
            gm[1] = cell;
            return gm;
        }
        String global = cell.substring(0, index);
        gm[0] = StringUtils.isEmpty((String)global) ? "+86" : (global.startsWith("+") ? global : "+" + global);
        gm[1] = cell.substring(index + 1);
        return gm;
    }

    @Override
    protected void _addUserInfo(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        this.personWithoutUser(ctx, personInfo);
    }

    private void personWithoutUser(Context ctx, PersonInfo info) throws PersonException {
        try {
            String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"IS_Auto_User");
            if ("false".equals(paramValue)) {
                return;
            }
            if (StringUtils.isEmpty((String)info.getCell())) {
                throw new UserException(UserException.CELL_NULL);
            }
            INewOrgUnitFacade orgFacade = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
            IPerson iPerson = PersonFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
            filterInfo.getFilterItems().add(new FilterItemInfo(NUMBER, (Object)info.getNumber()));
            view.setFilter(filterInfo);
            view.getSelector().add(new SelectorItemInfo("id"));
            PersonCollection personCollection = iPerson.getPersonCollection(view);
            PersonInfo pInfo = personCollection.get(0);
            AdminOrgUnitInfo adminOrgUnit = iPerson.getPrimaryAdminOrgUnit(pInfo.getId());
            boolean adminOrgIsStartSHR = orgFacade.getAdminOrgIsStartSHR(adminOrgUnit.getId().toString());
            if ("true".equals(paramValue) && !adminOrgIsStartSHR) {
                IUser user = UserFactory.getLocalInstance((Context)ctx);
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(pInfo.getId().toString());
                user.batchCreateUserByPerson(ids);
            }
        }
        catch (BOSException e) {
            throw new PersonException(PersonException.USER_CREATE_FAIL, e, new String[]{e.getMessage()});
        }
        catch (EASBizException e) {
            throw new PersonException(PersonException.USER_CREATE_FAIL, e, new String[]{e.getMessage()});
        }
    }

    private void doWithPersonOtherField(Context ctx, PersonInfo info) throws PersonException, BOSException, EASBizException {
        if (info.getBirthday() != null && DateTimeUtils.dayAfter((Date)info.getBirthday(), (Date)new Date())) {
            throw new PersonException(PersonException.BIRTHDAY_ERROR);
        }
        if (info.getHeight() == 0) {
            info.put("height", null);
        }
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        this.updatePersonIndex(ctx, info);
        String name = info.getName();
        info.setFullNamePingYin(CnToSpell.getSpell((String)name, (boolean)false));
        info.setSimpleNamePingYin(CnToSpell.getSpell((String)name, (boolean)true));
    }

    private void doWithPersonNumber(Context ctx, PersonInfo info) throws BOSException, EASBizException {
        if (info.get("notNeedGenerateObjectNumber") != null) {
            return;
        }
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (ctrlInfo != null) {
            if (info.getCU() != null) {
                ctrlInfo = info.getCU();
            }
            info.setCU(ctrlInfo);
            if (info.get("PersonEnroll") == null) {
                String strCurCompany;
                String number = null;
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (codingRuleManager.isExist((IObjectValue)info, strCurCompany = codingRuleManager.getCurrentAppOUID((IObjectValue)info)) && !codingRuleManager.isModifiable((IObjectValue)info, strCurCompany)) {
                    number = codingRuleManager.getNumber((IObjectValue)info, strCurCompany);
                    String oql = "select id where number='" + number + "'";
                    for (int numCount = 1; this._exists(ctx, oql) && numCount < 10000; ++numCount) {
                        number = codingRuleManager.getNumber((IObjectValue)info, strCurCompany);
                        oql = "select id where number='" + number + "'";
                    }
                    info.setNumber(number);
                }
            }
        }
    }

    private void parseNameAndIdCard(PersonInfo info) {
        String idCardNumber;
        String empName = info.getName();
        if (StringUtil.isEmpty((String)info.getName(LocaleUtils.getLocale((String)"L1")))) {
            info.setName(empName, LocaleUtils.getLocale((String)"L1"));
        }
        if (StringUtil.isEmpty((String)info.getName(LocaleUtils.getLocale((String)"L2")))) {
            info.setName(empName, LocaleUtils.getLocale((String)"L2"));
        }
        if (StringUtil.isEmpty((String)info.getName(LocaleUtils.getLocale((String)"L3")))) {
            info.setName(empName, LocaleUtils.getLocale((String)"L3"));
        }
        if (!StringUtils.isEmpty((String)(idCardNumber = info.getIdCardNO()))) {
            info.setIdCardNO(idCardNumber.toUpperCase());
        }
        if (!StringUtils.isEmpty((String)info.getIdCardNO()) && info.getBirthday() == null) {
            try {
                IDCardCommonUtil iDCardCommonUtil = new IDCardCommonUtil(info.getIdCardNO(), true);
                String birthday = iDCardCommonUtil.getBirthday();
                Genders sex = iDCardCommonUtil.getGenders();
                info.setGender(sex);
                info.setBirthday(DateTimeUtils.parseDate((String)birthday));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updatePersonIndex(Context ctx, PersonInfo info) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT MAX(T1.FIndex) ");
        sql.append("FROM T_BD_Person T1 ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int maxIndex = 0;
        try {
            while (rows.next()) {
                if (rows.getInt(1) == 0) {
                    return;
                }
                maxIndex = rows.getInt(1);
            }
            if (info.get("PositionList") != null) {
                PositionMemberCollection pmColl = null;
                pmColl = (PositionMemberCollection)info.get("PositionList");
                String positionId = null;
                int size = pmColl.size();
                for (int i = 0; i < size; ++i) {
                    if (!pmColl.get(i).isIsPrimary() || pmColl.get(i).getPosition() == null) continue;
                    positionId = pmColl.get(i).getPosition().getId().toString();
                }
                if (positionId == null) {
                    return;
                }
                sql.append("LEFT OUTER JOIN T_HR_PersonPosition T2 ");
                sql.append("ON T1.FID = T2.FPersonID ");
                sql.append("LEFT OUTER JOIN T_ORG_Admin T3 ");
                sql.append("ON T2.FPersonDep = T3.FID ");
                sql.append("WHERE T3.FID = (");
                sql.append("SELECT FAdminOrgUnitID FROM T_ORG_Position WHERE FID = '");
                sql.append(positionId);
                sql.append("') ");
            }
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rows.next()) {
                if (rows.getInt(1) > 0) {
                    info.setIndexOf(rows.getInt(1) + 1);
                    sql = new StringBuffer("UPDATE T_BD_Person SET FIndex = FIndex + 1 WHERE FIndex > " + rows.getInt(1));
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    continue;
                }
                info.setIndexOf(maxIndex + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    String getIntermitNumber(Context ctx, IObjectValue _pInfo, PersonInfo bInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyId = iCodingRuleManager.getCurrentAppOUID(_pInfo);
        if (companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(_pInfo, companyId)) {
            return iCodingRuleManager.getNumber(_pInfo, companyId);
        }
        return null;
    }

    private void checkCellorMailDup(Context ctx, String cell, String mail, String personPK) throws EASBizException, BOSException {
        String controlPolicy = "";
        try {
            Class<?> classObj = Class.forName("com.kingdee.eas.base.license.agent.LicenseSrvAgent");
            Object instance = classObj.newInstance();
            Method method = classObj.getDeclaredMethod("getControlPolicy", new Class[0]);
            controlPolicy = (String)method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (!"Register".equalsIgnoreCase(controlPolicy)) {
            return;
        }
        CommunicationInfo communicationInfo = null;
        try {
            Class<?> classObj = Class.forName("com.kingdee.eas.base.permission.service.ValidateCommunicationService");
            Object instance = classObj.newInstance();
            Method method = classObj.getDeclaredMethod("getCloudCommunicationStategy", new Class[0]);
            communicationInfo = (CommunicationInfo)method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (communicationInfo == null) {
            return;
        }
        try {
            String personNum;
            String _personNum = "";
            if (communicationInfo.getNeedPhone() == 1) {
                personNum = this.checkCellDup(ctx, cell, personPK);
                if (personNum == null) {
                    return;
                }
                throw new PersonException(PersonException.CELL_REPEAT, new Object[]{personNum});
            }
            if (communicationInfo.getNeedEmail() == 1) {
                _personNum = this.checkMailDup(ctx, mail, personPK);
                if (_personNum == null) {
                    return;
                }
                throw new PersonException(PersonException.EMAIL_REPEAT, new Object[]{_personNum});
            }
            if (communicationInfo.getNeedPhone() == 2 || communicationInfo.getNeedEmail() == 2) {
                if (cell != null && cell.trim().length() > 0 && (personNum = this.checkCellDup(ctx, cell, personPK)) != null) {
                    throw new PersonException(PersonException.CELL_REPEAT, new Object[]{personNum});
                }
                if (mail != null && mail.trim().length() > 0) {
                    _personNum = this.checkMailDup(ctx, mail, personPK);
                    if (_personNum == null) {
                        return;
                    }
                    throw new PersonException(PersonException.EMAIL_REPEAT, new Object[]{_personNum});
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PersonException(PersonException.GET_PERSON_INFO_FAIL, e);
        }
    }

    private String checkCellDup(Context ctx, String cell, String personPK) throws EASBizException, BOSException, SQLException {
        if (cell != null && cell.trim().length() > 0) {
            IRowSet rowSet;
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID,FNUMBER FROM T_BD_PERSON WHERE UPPER(FCell) =  UPPER(N'").append(cell).append("')");
            if (personPK != null) {
                sql.append(" AND FID <> '").append(personPK.toString()).append("' ");
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).next()) {
                return rowSet.getString("FNUMBER");
            }
        }
        return null;
    }

    private String checkMailDup(Context ctx, String mail, String personPK) throws EASBizException, BOSException, SQLException {
        if (mail != null && mail.trim().length() > 0) {
            IRowSet _rowSet;
            StringBuffer _sql = new StringBuffer();
            _sql.append(" SELECT FID,FNUMBER FROM T_BD_PERSON WHERE UPPER(FEMail) = UPPER(N'").append(mail).append("')");
            if (personPK != null) {
                _sql.append(" AND FID <> '").append(personPK.toString()).append("' ");
            }
            if ((_rowSet = DbUtil.executeQuery((Context)ctx, (String)_sql.toString())).next()) {
                return _rowSet.getString("FNUMBER");
            }
        }
        return null;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitInfo admin;
        PersonInfo info = (PersonInfo)model;
        this.sysnPersonCell(info);
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, (IObjectValue)info);
        this._checkNumberDup(ctx, (IObjectValue)info);
        this.checkCellorMailDup(ctx, info.getCell(), info.getEmail(), info.getId().toString());
        PersonInfo oldInfo = this.getPersonInfo(ctx, pk);
        CommonTool.trimNameAndNumberSpaceOfObjectInfo(info);
        boolean flag = false;
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        if (!info.getName().equals(oldInfo.getName()) || !info.getNumber().equals(oldInfo.getNumber())) {
            flag = true;
        }
        if (info.getBirthday() != null && DateTimeUtils.dayAfter((Date)info.getBirthday(), (Date)new Date())) {
            throw new PersonException(PersonException.BIRTHDAY_ERROR);
        }
        if (info.getHeight() == 0 && info.containsKey("height")) {
            info.put("height", null);
        }
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.get("IS_UPDATE_EMPLOYTECHPOST") == null || !((Boolean)info.get("IS_UPDATE_EMPLOYTECHPOST")).booleanValue()) {
            info.setEmployTechPost(oldInfo.getEmployTechPost());
        }
        if (info.get("IS_UPDATE_HIGHESTTECHPOST") == null || !((Boolean)info.get("IS_UPDATE_HIGHESTTECHPOST")).booleanValue()) {
            info.setHighestTechPost(oldInfo.getHighestTechPost());
        }
        if (info.get("IS_UPDATE_HIGHESTDEGREE") == null || !((Boolean)info.get("IS_UPDATE_HIGHESTDEGREE")).booleanValue()) {
            info.setHighestDegree(oldInfo.getHighestDegree());
        }
        this.applyUpdateConstraint(info, oldInfo);
        String name = info.getName();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("fullNamePingYin"));
        selector.add(new SelectorItemInfo("simpleNamePingYin"));
        PersonInfo personinfo = this.getPersonInfo(ctx, pk, selector);
        if (info.getName().equals(personinfo.getName())) {
            String fullNamePingYin = info.getFullNamePingYin();
            String simpleNamePingYin = info.getSimpleNamePingYin();
            info.setFullNamePingYin(StringUtils.isEmpty((String)fullNamePingYin) ? personinfo.getFullNamePingYin() : fullNamePingYin);
            info.setSimpleNamePingYin(StringUtils.isEmpty((String)simpleNamePingYin) ? personinfo.getSimpleNamePingYin() : simpleNamePingYin);
        } else {
            info.setFullNamePingYin(CnToSpell.getSpell((String)name, (boolean)false));
            info.setSimpleNamePingYin(CnToSpell.getSpell((String)name, (boolean)true));
        }
        String idCardNumber = info.getIdCardNO();
        if (!StringUtils.isEmpty((String)idCardNumber)) {
            info.setIdCardNO(idCardNumber.toUpperCase());
        }
        if (info.getExtendedProperty("historyOperateState") == null) {
            info.setExtendedProperty("historyOperateState", "reviseHistory");
        }
        if ("change".equals(info.getExtendedProperty("historyOperateState"))) {
            PersonHistoryRelateCheckUtil.checkPersonInAffair(ctx, info.getId().toString(), null, info.getEFFDT());
        }
        if (info.getEFFDT() == null) {
            PersonInfo oldPersonInfo = this.getPersonInfo(ctx, pk);
            info.setEFFDT(oldPersonInfo.getEFFDT());
            info.setLEFFDT(oldPersonInfo.getLEFFDT());
        }
        if ((admin = (AdminOrgUnitInfo)info.get("GKADMIN")) != null) {
            info.setGkAdmin(admin);
        }
        super._update(ctx, pk, (IObjectValue)info);
        if (info.get("IS_FROM_SHR_OPTAction") == null) {
            BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PersonAfterBusinessProcessorBuilder.ACT_UPDATE, null, new Object[]{info});
            PersonAfterBusinessProcessorBuilder builder = new PersonAfterBusinessProcessorBuilder((ExecuteContext)executeContext);
            BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
            batchResults.throwExceptions();
            this.dealWithPotionMenmber(ctx, info);
        }
        if (flag) {
            AssistUtil.updateAssist((Context)ctx, (String)pk.toString(), (BOSObjectType)info.getBOSType());
        }
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        iPerm.syncUserRealName(UserType.PERSON, pk);
    }

    private void updateUserCell(Context ctx, PersonInfo personInfo, String userID) throws BOSException, EASBizException {
        String cell = personInfo.getCell();
        if (cell != null && cell.trim().length() > 0) {
            StringBuffer user_sql = new StringBuffer();
            String userNumber = "";
            user_sql.append(" SELECT FNUMBER FROM T_PM_User WHERE UPPER(FCell) =  UPPER(N'").append(cell).append("')");
            if (userID != null) {
                user_sql.append(" AND FID <> '").append(userID).append("' ");
            }
            IRowSet user_rowSet = DbUtil.executeQuery((Context)ctx, (String)user_sql.toString());
            try {
                if (user_rowSet.next()) {
                    userNumber = user_rowSet.getString("FNUMBER");
                    throw new PersonException(PersonException.PERSONCELL_DUP_INFO, new Object[]{userNumber});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new PersonException(PersonException.GET_PERSON_INFO_FAIL, e);
            }
            StringBuffer updatesql = new StringBuffer();
            updatesql.append(" UPDATE T_PM_User SET FCELL = '").append(cell).append("',FNCELL = '").append(personInfo.getNCell()).append("',FGLOBALROAMING = '").append(personInfo.getGlobalRoaming()).append("',FISSYNTOCLOUD = 0").append(" WHERE FID = '").append(userID).append("'");
            DbUtil.execute((Context)ctx, (String)updatesql.toString());
        }
    }

    private void updateUserEmail(Context ctx, String email, String userID) throws BOSException, EASBizException {
        if (email != null && email.trim().length() > 0) {
            StringBuffer user_sql = new StringBuffer();
            String userNumber = "";
            user_sql.append(" SELECT FNUMBER FROM T_PM_User WHERE UPPER(FEMAIL) =  UPPER(N'").append(email).append("')");
            if (userID != null) {
                user_sql.append(" AND FID <> '").append(userID).append("' ");
            }
            IRowSet user_rowSet = DbUtil.executeQuery((Context)ctx, (String)user_sql.toString());
            try {
                if (user_rowSet.next()) {
                    userNumber = user_rowSet.getString("FNUMBER");
                    throw new PersonException(PersonException.PERSONMAIL_DUP_INFO, new Object[]{userNumber});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new PersonException(PersonException.GET_PERSON_INFO_FAIL, e);
            }
            StringBuffer updatesql = new StringBuffer();
            updatesql.append(" UPDATE T_PM_User SET FEMAIL = '").append(email).append("',FISSYNTOCLOUD = 0").append(" WHERE FID = '").append(userID).append("'");
            DbUtil.execute((Context)ctx, (String)updatesql.toString());
        }
    }

    protected void applyUpdateConstraint(PersonInfo person, PersonInfo oldPerson) throws BOSException, EASBizException {
        PersonUpdateConstraint cons = (PersonUpdateConstraint)person.get("PersonUpdateConstraint");
        if (cons != null) {
            cons.setPersonWithOldInfo(person, oldPerson);
        }
    }

    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        PersonInfo info = (PersonInfo)model;
        this.sysnPersonCell(info);
        if ("change".equals(info.getExtendedProperty("historyOperateState"))) {
            PersonHistoryRelateCheckUtil.checkPersonInAffair(ctx, info.getId().toString(), null, info.getEFFDT());
        }
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PersonBeforeBusinessProcessorBuilder.ACT_UPDATEPARTIAL, (BizController)this, new Object[]{info});
        PersonBeforeBusinessProcessorBuilder builder = new PersonBeforeBusinessProcessorBuilder((ExecuteContext)executeContext);
        BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
        batchResults.throwExceptions();
        super._updatePartial(ctx, model, selector);
    }

    @Override
    protected void _assignPosition(Context ctx, String[] personID, IObjectValue positionInfo) throws BOSException, EASBizException {
        PositionMemberInfo pmInfo = null;
        IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
        PersonInfo info = null;
        IPerson iPerson = PersonFactory.getLocalInstance(ctx);
        String userIDQuerySql = "SELECT FID , FISDELETE FROM T_PM_USER WHERE FPERSONID = ?";
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        ArrayList<String> list = null;
        Connection conn = this.getConnection(ctx);
        PreparedStatement userIDSqlSmt = null;
        try {
            userIDSqlSmt = conn.prepareStatement(userIDQuerySql);
            for (int i = 0; i < personID.length; ++i) {
                info = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)personID[i])));
                pmInfo = new PositionMemberInfo();
                pmInfo.setIsPrimary(true);
                pmInfo.setPosition((PositionInfo)positionInfo);
                pmInfo.setPerson(info);
                EmployeeTypeInfo typeInfo = new EmployeeTypeInfo();
                typeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000001A29E85B3"));
                info.setEmployeeType(typeInfo);
                info.put(BasePersonConstraints.BASEPERSONFLAG, BasePersonConstraints.BASEPERSONFLAG);
                PositionMemberCollection pmColl = new PositionMemberCollection();
                pmColl.add(pmInfo);
                info.put(BasePersonConstraints.PositionList, pmColl);
                info.remove(BasePersonConstraints.GKADMIN);
                iPerson.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                userIDSqlSmt.setString(1, personID[i]);
                ResultSet userIDRows = userIDSqlSmt.executeQuery();
                list = new ArrayList<String>();
                while (userIDRows.next()) {
                    if (userIDRows.getInt("FISDELETE") == 0) continue;
                    list.add(userIDRows.getString("fid"));
                }
                if (list.size() == 0) continue;
                iUser.callBackUser(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)userIDSqlSmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkEnableSHR(ctx, pk.toString());
        PersonInfo info = this.getPersonInfo(ctx, pk);
        if (info.getState().getValue() == 1) {
            throw new PersonException(PersonException.AUDITED_INFO_CANNOT_DELETE, new Object[]{info.getNumber()});
        }
        this.dispachIntermitNumber(ctx, info);
        if (this._exists(ctx, pk)) {
            IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection pmColl = this.getPMListByPerson(ctx, iPM, pk.toString());
            if (pmColl != null) {
                for (int i = 0; i < pmColl.size(); ++i) {
                    iPM.delete((IObjectPK)new ObjectUuidPK(pmColl.get(i).getId()));
                }
            }
            BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PersonBeforeBusinessProcessorBuilder.ACT_DELETE, null, new Object[]{pk});
            PersonBeforeBusinessProcessorBuilder builder = new PersonBeforeBusinessProcessorBuilder((ExecuteContext)executeContext);
            BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
            batchResults.throwExceptions();
            IAgentUserManagerFacade iAgentUser = AgentUserManagerFacadeFactory.getLocalInstance((Context)ctx);
            iAgentUser.deleteAgentUser(info.getNumber());
            super._delete(ctx, pk);
            PersonDeleteInfo personDeleteInfo = new PersonDeleteInfo();
            personDeleteInfo.setId(BOSUuid.create((String)"AF8E09F8"));
            personDeleteInfo.setPersonID(info.getId().toString());
            personDeleteInfo.setPersonNumber(info.getNumber());
            personDeleteInfo.setPersonName(info.getName());
            personDeleteInfo.setCell(info.getCell());
            personDeleteInfo.setEmail(info.getEmail());
            PersonDeleteFactory.getLocalInstance(ctx).addnew(personDeleteInfo);
        }
    }

    private void checkEnableSHR(Context ctx, String personID) throws PersonException {
        StringBuilder sql = new StringBuilder();
        try {
            sql.append("select FPERSONDEP  from t_hr_personposition where FPERSONID ='").append(personID).append("'");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String personDep = null;
            if (!rowset.next()) {
                return;
            }
            personDep = rowset.getString(1);
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminColl = iAdmin.getAdminOrgUnitCollection("where id = '" + personDep + "'");
            if (adminColl != null && adminColl.size() > 0) {
                AdminOrgUnitInfo admin = adminColl.get(0);
                boolean isStartSHR = false;
                if (isStartSHR) {
                    throw new PersonException(PersonException.PERSON_ENABLE_SHR);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        for (int i = 0; i < arrayPK.length; ++i) {
            this.checkEnableSHR(ctx, arrayPK[i].toString());
        }
        HashSet persons = this.convertPksToHashSet(arrayPK);
        if (persons == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)persons, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo(NUMBER));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("cell"));
        selector.add(new SelectorItemInfo("email"));
        PersonCollection personCol = this.getPersonCollection(ctx, viewInfo);
        CoreBaseCollection personDeleCol = new CoreBaseCollection();
        if (personCol != null) {
            int i;
            StringBuffer canNotDeletes = null;
            int size = personCol.size();
            for (int i2 = 0; i2 < size; ++i2) {
                PersonInfo personInfo = personCol.get(i2);
                if (1 == personInfo.getState().getValue()) {
                    if (canNotDeletes == null) {
                        canNotDeletes = new StringBuffer();
                    } else {
                        canNotDeletes.append(",");
                    }
                    canNotDeletes.append(personCol.get(i2).getNumber());
                    continue;
                }
                PersonDeleteInfo personDeleteInfo = new PersonDeleteInfo();
                personDeleteInfo.setId(BOSUuid.create((String)"AF8E09F8"));
                personDeleteInfo.setPersonID(personInfo.getId().toString());
                personDeleteInfo.setPersonNumber(personInfo.getNumber());
                personDeleteInfo.setPersonName(personInfo.getName());
                personDeleteInfo.setCell(personInfo.getCell());
                personDeleteInfo.setEmail(personInfo.getEmail());
                personDeleteInfo.setCreator(currentUser);
                personDeleteInfo.setCreateTime(time);
                personDeleteInfo.setLastUpdateTime(time);
                personDeleteInfo.setLastUpdateUser(currentUser);
                personDeleteInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                personDeleCol.add((CoreBaseInfo)personDeleteInfo);
            }
            if (canNotDeletes != null) {
                throw new PersonException(PersonException.AUDITED_INFO_CANNOT_DELETE, new Object[]{canNotDeletes.toString()});
            }
            IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
            FilterInfo pmFilter = new FilterInfo();
            pmFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)persons, CompareType.INCLUDE));
            iPM.delete(pmFilter);
            BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PersonBeforeBusinessProcessorBuilder.ACT_DELETE, (BizController)this, (Object[])arrayPK);
            PersonBeforeBusinessProcessorBuilder builder = new PersonBeforeBusinessProcessorBuilder((ExecuteContext)executeContext);
            BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
            batchResults.throwExceptions();
            IAgentUserManagerFacade iAgentUser = AgentUserManagerFacadeFactory.getLocalInstance((Context)ctx);
            int size2 = personCol.size();
            for (i = 0; i < size2; ++i) {
                iAgentUser.deleteAgentUser(personCol.get(i).getNumber());
            }
            for (i = 0; i < arrayPK.length; ++i) {
                this._isReferenced(ctx, arrayPK[i]);
            }
            super._delete(ctx, arrayPK);
            PersonDeleteFactory.getLocalInstance(ctx).addnewBatchData(personDeleCol);
            size2 = personCol.size();
            for (i = 0; i < size2; ++i) {
                this.dispachIntermitNumber(ctx, personCol.get(i));
            }
        }
    }

    private HashSet convertPksToHashSet(IObjectPK[] arrayPK) {
        if (arrayPK == null || arrayPK.length <= 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < arrayPK.length; ++i) {
            set.add(arrayPK[i].toString());
        }
        return set;
    }

    private void dispachIntermitNumber(Context ctx, PersonInfo bInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String comId = iCodingRuleManager.getCurrentAppOUID((IObjectValue)bInfo);
        if (comId != null && iCodingRuleManager.isExist((IObjectValue)bInfo, comId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)bInfo, comId)) {
            iCodingRuleManager.recycleNumber((IObjectValue)bInfo, comId, bInfo.getNumber());
        }
    }

    private PositionMemberCollection getPMListByPerson(Context ctx, IPositionMember iPM, String personId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("person.id", (Object)personId.trim());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sort = null;
        try {
            sort = new SorterItemCollection("order by isPrimary");
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        view.setSorter(sort);
        view.setFilter(filter);
        return iPM.getPositionMemberCollection(view);
    }

    @Override
    protected IObjectCollection _getOtherPersonCollection(Context ctx, IObjectCollection personInfos) throws EASBizException, BOSException {
        PersonCollection pInfos = (PersonCollection)personInfos;
        if (personInfos.size() == 0) {
            return null;
        }
        StringBuffer personIds = new StringBuffer();
        int size = pInfos.size();
        for (int i = 0; i < size; ++i) {
            if (pInfos.size() == 1) {
                personIds.append(pInfos.get(i).getId());
                continue;
            }
            if (i != 0) {
                personIds.append("," + pInfos.get(i).getId());
                continue;
            }
            personIds.append(pInfos.get(i).getId());
        }
        pInfos = this.getPCollections(ctx, personIds.toString());
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PersonBeforeBusinessProcessorBuilder.ACT_GETOTHERPERSONCOLLECTION, (BizController)this, pInfos.toArray());
        PersonBeforeBusinessProcessorBuilder builder = new PersonBeforeBusinessProcessorBuilder((ExecuteContext)executeContext);
        BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
        batchResults.throwExceptions();
        return pInfos;
    }

    protected PersonCollection getPCollections(Context ctx, String personIds) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItemPerson = new FilterItemInfo("id", (Object)personIds, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItemPerson);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("idCardNO"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("email"));
        viewInfo.getSelector().add(new SelectorItemInfo(NUMBER));
        viewInfo.getSelector().add(new SelectorItemInfo("passportNO"));
        viewInfo.getSelector().add(new SelectorItemInfo("gender"));
        viewInfo.getSelector().add(new SelectorItemInfo("folk.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("politicalFace.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("employeeType.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("birthday"));
        viewInfo.getSorter().add(new SorterItemInfo(NUMBER));
        PersonCollection pInfos = this.getPersonCollection(ctx, viewInfo);
        return pInfos;
    }

    @Override
    protected void _batchAudit(Context ctx, String[] ids, boolean isAudit) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        HashSet<String> personSet = new HashSet<String>();
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            personSet.add(ids[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", personSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo(NUMBER));
        selector.add(new SelectorItemInfo("name"));
        PersonCollection pCol = PersonFactory.getLocalInstance(ctx).getPersonCollection(viewInfo);
        StringBuffer buf = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"0_PersonControllerBean", (Locale)ctx.getLocale()));
        int size2 = pCol.size();
        for (int i = 0; i < size2; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(pCol.get(i).getNumber());
        }
        IObjectPK pk = null;
        pk = isAudit ? LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new PersonInfo().getBOSType(), null, (String)buf.toString(), (String)"employeeInfo_audit") : LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new PersonInfo().getBOSType(), null, (String)buf.toString(), (String)"employeeInfo_antiAudit");
        StringBuffer sb = new StringBuffer();
        sb.append("Update T_BD_Person SET FState = ");
        sb.append(isAudit ? "1" : "0");
        sb.append(" where FID IN (");
        for (int i = 0; i < ids.length; ++i) {
            if (i == 0) {
                sb.append("'");
            } else {
                sb.append(",'");
            }
            sb.append(ids[i]);
            sb.append("'");
        }
        sb.append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        if (pk != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _checkInfo(Context ctx, String personId) throws BOSException, EASBizException {
        Object[] params = null;
        try {
            PersonInfoCheck.checkInfo(ctx, personId);
            params = new Object[]{new Integer(2), personId};
            DbUtil.execute((Context)ctx, (String)"Update T_BD_Person SET FCheckState = ? Where FID = ? ", (Object[])params);
        }
        catch (PersonCheckException e) {
            params = new Object[]{new Integer(1), personId};
            DbUtil.execute((Context)ctx, (String)"Update T_BD_Person SET FCheckState = ? Where FID = ? ", (Object[])params);
            throw e;
        }
    }

    @Override
    protected String[] _checkInfo(Context ctx, String[] personIds) throws BOSException, EASBizException {
        int i;
        if (personIds.length == 1) {
            this._checkInfo(ctx, personIds[0]);
            return personIds;
        }
        String[] ids = PersonInfoCheck.checkInfo(ctx, personIds);
        StringBuffer sb = new StringBuffer();
        sb.append("Update T_BD_Person SET FCheckState = ? ");
        sb.append(" where FID IN (");
        for (i = 0; i < personIds.length; ++i) {
            if (i == 0) {
                sb.append("'");
            } else {
                sb.append(",'");
            }
            sb.append(personIds[i]);
            sb.append("'");
        }
        sb.append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{new Integer(1)});
        if (ids.length == 0) {
            return ids;
        }
        sb = new StringBuffer();
        sb.append("Update T_BD_Person SET FCheckState = ? ");
        sb.append(" where FID IN (");
        for (i = 0; i < ids.length; ++i) {
            if (i == 0) {
                sb.append("'");
            } else {
                sb.append(",'");
            }
            sb.append(ids[i]);
            sb.append("'");
        }
        sb.append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{new Integer(2)});
        return ids;
    }

    @Override
    public PersonInfo getPersonByStr(Context ctx, String str, String type, String hrOrgId) throws BOSException, EASBizException {
        return super.getPersonByStr(ctx, str, type, hrOrgId);
    }

    @Override
    protected PersonInfo _getPersonByStr(Context ctx, String str, String type) throws BOSException, EASBizException {
        return this._getPersonByStr(ctx, str, type, null);
    }

    @Override
    protected PersonInfo _getPersonByStr(Context ctx, String str, String type, String hrOrgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        PersonInfo info = new PersonInfo();
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("str", (Object)str);
        applicationContext.putData("type", (Object)type);
        applicationContext.putData("hrOrgId", (Object)hrOrgId);
        BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{info}, (BatchActionEnum)PersonBeforeBusinessProcessorBuilder.ACT_GETPERSONBYSTR, PersonBeforeBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        PersonCollection col = (PersonCollection)batchResults.getObjCollection();
        info = col != null && col.size() > 0 ? col.get(0) : null;
        return info;
    }

    @Override
    protected PersonCollection _getPersonCollectionByStrLs(Context ctx, List idCardLs, List passportLs, List numberLs) throws BOSException, EASBizException {
        return this._getPersonCollectionByStrLs(ctx, idCardLs, passportLs, numberLs, null);
    }

    @Override
    protected PersonCollection _getPersonCollectionByStrLs(Context ctx, List idCardLs, List passportLs, List numberLs, String hrOrgId) throws BOSException, EASBizException {
        PersonInfo psIn;
        PersonCollection personColl = new PersonCollection();
        if (null != idCardLs && idCardLs.size() > 0) {
            for (int i = 0; i < idCardLs.size(); ++i) {
                psIn = this._getPersonByStr(ctx, (String)idCardLs.get(i), IDCARDNUMBER, hrOrgId);
                if (null == psIn) continue;
                personColl.add(psIn);
            }
        }
        if (null != passportLs && passportLs.size() > 0) {
            for (int j = 0; j < passportLs.size(); ++j) {
                psIn = this._getPersonByStr(ctx, (String)passportLs.get(j), PASSPORTNUMBER);
                if (null == psIn) continue;
                personColl.add(psIn);
            }
        }
        if (null != numberLs && numberLs.size() > 0) {
            for (int k = 0; k < numberLs.size(); ++k) {
                psIn = this._getPersonByStr(ctx, (String)numberLs.get(k), NUMBER);
                if (null == psIn) continue;
                personColl.add(psIn);
            }
        }
        return personColl;
    }

    public boolean isIDcardVerify(Context ctx, String hrOrgId) throws BOSException, EASBizException {
        this.isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgId);
        logger.info((Object)("bd_personControlBean:Get isIDCardVerify Param " + this.isIDCardVerify + " From Hro " + hrOrgId));
        return this.isIDCardVerify;
    }

    @Override
    public void _insertPersons(Context ctx, int index, String[] persons) throws BOSException {
        if (persons == null || persons.length == 0) {
            return;
        }
        int personsCount = persons.length;
        String sql = "update t_bd_person set findex=findex+? where findex>=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(personsCount), new Integer(index)});
        sql = "update t_bd_person set findex=? where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < personsCount; ++i) {
            list.add(new Object[]{new Integer(index++), persons[i]});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
    }

    private boolean isPersonOtherInfoExcludeField(String key) {
        return key.equals("id") || key.equals("person");
    }

    @Override
    protected void _personDisable(Context ctx, String[] persons) throws BOSException {
        if (persons == null || persons.length == 0) {
            return;
        }
        String sql = "update t_bd_person set fdeletedstatus=2 where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < persons.length; ++i) {
            list.add(new Object[]{persons[i]});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
    }

    @Override
    protected void _personEnable(Context ctx, String[] persons) throws BOSException {
        if (persons == null || persons.length == 0) {
            return;
        }
        String sql = "update t_bd_person set fdeletedstatus=1 where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < persons.length; ++i) {
            list.add(new Object[]{persons[i]});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(NUMBER, (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("creator.name"));
            selector.add(new SelectorItemInfo("gkAdmin.displayName"));
            view.setSelector(selector);
            PersonCollection personCollection = this.getPersonCollection(ctx, view);
            PersonInfo repeatPersonInfo = personCollection.get(0);
            String userName = repeatPersonInfo.getCreator().getName();
            AdminOrgUnitInfo primaryAdminOrgUnit = this.getPrimaryAdminOrgUnit(ctx, repeatPersonInfo.getId());
            String displayName = "";
            if (primaryAdminOrgUnit != null) {
                displayName = primaryAdminOrgUnit.getDisplayName();
            } else if (repeatPersonInfo.getGkAdmin() != null) {
                displayName = repeatPersonInfo.getGkAdmin().getDisplayName();
            } else {
                String number = this._getPropertyAlias(ctx, dataBaseInfo, NUMBER) + " : " + dataBaseInfo.getNumber();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
            }
            throw new PersonException(PersonException.NUMBER_REPEAT_NEW, new Object[]{userName, dataBaseInfo.getNumber(), displayName});
        }
    }

    @Override
    protected void _updateUserInfo(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        if (personInfo.getId() == null) {
            return;
        }
        String controlPolicy = "";
        try {
            Class<?> classObj = Class.forName("com.kingdee.eas.base.license.agent.LicenseSrvAgent");
            Object instance = classObj.newInstance();
            Method method = classObj.getDeclaredMethod("getControlPolicy", new Class[0]);
            controlPolicy = (String)method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (!"Register".equalsIgnoreCase(controlPolicy) && !"Subscription_reg".equalsIgnoreCase(controlPolicy)) {
            return;
        }
        CommunicationInfo communicationInfo = null;
        try {
            Class<?> classObj = Class.forName("com.kingdee.eas.base.permission.service.ValidateCommunicationService");
            Object instance = classObj.newInstance();
            Method method = classObj.getDeclaredMethod("getCloudCommunicationStategy", new Class[0]);
            communicationInfo = (CommunicationInfo)method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (communicationInfo == null) {
            return;
        }
        String userID = "";
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID FROM T_PM_User WHERE FPERSONID = '").append(personInfo.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                ++count;
                userID = rowSet.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PersonException(PersonException.GET_PERSON_INFO_FAIL, e);
        }
        if (count > 1) {
            throw new PersonException(PersonException.PERSONMOREUSER_WARN);
        }
        if (count == 1) {
            this.sysnPersonCell(personInfo);
            if (communicationInfo.getNeedPhone() == 1) {
                this.updateUserCell(ctx, personInfo, userID);
            } else if (communicationInfo.getNeedEmail() == 1) {
                this.updateUserEmail(ctx, personInfo.getEmail(), userID);
            } else if (communicationInfo.getNeedPhone() == 2 || communicationInfo.getNeedEmail() == 2) {
                this.updateUserCell(ctx, personInfo, userID);
                this.updateUserEmail(ctx, personInfo.getEmail(), userID);
            }
        }
    }

    @Override
    protected boolean _checkGlobalRomingIsUse(Context ctx, String globalRoming) throws BOSException, EASBizException {
        return this.exists(ctx, "select top 1 where globalRoaming = '" + globalRoming + "'");
    }

    @Override
    protected void _updatePersonGlobalRomaing(Context ctx, String oldGlobalRomaing, String newGlobalRomaing) throws BOSException, EASBizException {
        if (oldGlobalRomaing.equals(newGlobalRomaing)) {
            return;
        }
        PersonCollection personColl = this.getPersonCollection(ctx, "select id ,ncell where globalRoaming='" + oldGlobalRomaing + "'");
        Connection conn = null;
        PreparedStatement preStmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement("update T_BD_PERSON set FGLObalRoaming=?, FCELL=? where fid = ?");
            for (int i = 0; i < personColl.size(); ++i) {
                PersonInfo personInfo = personColl.get(i);
                String id = personInfo.getId().toString();
                String ncell = personInfo.getNCell();
                if (StringUtils.isEmpty((String)ncell)) continue;
                preStmt.setString(1, newGlobalRomaing);
                if ("+86".equals(newGlobalRomaing)) {
                    preStmt.setString(2, ncell);
                } else {
                    preStmt.setString(2, newGlobalRomaing + "-" + ncell);
                }
                preStmt.setString(3, id);
                preStmt.addBatch();
            }
            preStmt.executeBatch();
            preStmt.clearBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
    }

    @Override
    protected void _toNPPerson(Context ctx, String[] personIds) throws BOSException, EASBizException {
        if (personIds.length == 0) {
            return;
        }
        IObjectPK logPK = this.toNPPersonBeginLog(ctx, personIds);
        String userIDQuerySql = "SELECT FID FROM T_PM_USER WHERE FPERSONID = ?";
        String orgIDQuerySql = "SELECT a.FID as aid,pm.fid as pmid,pm.FISPRIMARY as isprimary FROM T_BD_PERSON p LEFT OUTER JOIN T_ORG_POSITIONMEMBER pm on p.FID = pm.FPERSONID LEFT OUTER JOIN T_ORG_POSITION po on po.FID = pm.FPOSITIONID LEFT OUTER JOIN T_ORG_ADMIN a on a.FID = po.FADMINORGUNITID WHERE p.fid = ?";
        String personId = null;
        Connection conn = this.getConnection(ctx);
        PreparedStatement userIDSqlSmt = null;
        PreparedStatement orgIDSqlSmt = null;
        try {
            userIDSqlSmt = conn.prepareStatement(userIDQuerySql);
            orgIDSqlSmt = conn.prepareStatement(orgIDQuerySql);
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < personIds.length; ++i) {
                personId = personIds[i];
                userIDSqlSmt.setString(1, personId);
                orgIDSqlSmt.setString(1, personId);
                ResultSet userIDRows = userIDSqlSmt.executeQuery();
                ResultSet pmRows = orgIDSqlSmt.executeQuery();
                ArrayList<ObjectStringPK> arrayList = new ArrayList<ObjectStringPK>();
                while (userIDRows.next()) {
                    arrayList.add(new ObjectStringPK(userIDRows.getString("fid")));
                }
                IObjectPK[] userPKs = new IObjectPK[arrayList.size()];
                for (int j = 0; j < arrayList.size(); ++j) {
                    userPKs[j] = (IObjectPK)arrayList.get(j);
                }
                iUser.delete(userPKs);
                while (pmRows.next()) {
                    DbUtil.execute((Context)ctx, (String)("Delete T_ORG_POSITIONMEMBER where fid = '" + pmRows.getString("pmid") + "'"));
                    String isPrimary = pmRows.getString("isprimary");
                    if (!"1".equals(isPrimary)) continue;
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_BD_Person SET FGKADMIN = '" + pmRows.getString("aid") + "' WHERE FID = '" + personId + "'"));
                }
                DbUtil.execute((Context)ctx, (String)("UPDATE T_BD_Person SET FEmployeeTypeId = '00000000-0000-0000-0000-000000000009A29E85B3' WHERE FID = '" + personId + "'"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)userIDSqlSmt);
                SQLUtils.cleanup(orgIDSqlSmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)userIDSqlSmt);
        SQLUtils.cleanup((Statement)orgIDSqlSmt);
        SQLUtils.cleanup((Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private IObjectPK toNPPersonBeginLog(Context ctx, String[] personIds) throws BOSException {
        HashSet<String> set = new HashSet<String>(Arrays.asList(personIds));
        EntityViewInfo evw = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evw.setFilter(filterInfo);
        PersonCollection personCollection = this.getPersonCollection(ctx, evw);
        StringBuilder logMsg = new StringBuilder();
        for (int i = 0; i < personCollection.size(); ++i) {
            logMsg.append(personCollection.get(i).getNumber()).append(" ").append(personCollection.get(i).getName()).append(";");
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_toNPPerson", (BOSObjectType)this.getBOSType(), (IObjectPK)ctx.getCaller(), (String)logMsg.toString(), (String)"Person_ToNPPerson", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        return logPK;
    }

    @Override
    protected List _getAdminListByParam(Context ctx, int type, String userIdString, String orgIdString) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userIdString)) {
            userIdString = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        String cuId = orgIdString;
        if (StringUtils.isEmpty((String)orgIdString)) {
            CtrlUnitInfo currentCtrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            cuId = currentCtrlUnit.getId().toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select adminn.fid as fid from t_org_admin adminn left outer join t_pm_orgrange range on adminn.fid = range.forgId");
        sb.append(" where");
        switch (type) {
            case 1: {
                sb.append(" adminn.fcontrolunitid = '").append(cuId).append("'");
                break;
            }
            case 2: {
                sb.append(" range.fuserid = '").append(userIdString).append("'");
                sb.append(" and range.ftype = '").append(OrgRangeType.ADMIN_ORG_TYPE.getValue()).append("'");
                break;
            }
            case 3: {
                sb.append(" adminn.fcontrolunitid = '").append(cuId).append("'");
                sb.append(" and (range.fuserid = '").append(userIdString).append("'");
                sb.append(" and range.ftype = '").append(OrgRangeType.ADMIN_ORG_TYPE.getValue()).append("')");
                break;
            }
            case 4: {
                sb.append(" adminn.fcontrolunitid = '").append(cuId).append("'");
                sb.append(" or (range.fuserid = '").append(userIdString).append("'");
                sb.append(" and range.ftype = '").append(OrgRangeType.ADMIN_ORG_TYPE.getValue()).append("')");
                break;
            }
        }
        sb.append(" and adminn.FISSEALUP = 0 and (adminn.FIsVirtual = 0 or adminn.FIsVirtual is null)");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                list.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonInfo info = (PersonInfo)model;
        String isBizCheck = ParamManager.getParamValue((Context)ctx, null, (String)"IS_PERSONCANCEL_BIZCHECK");
        if (!"true".equalsIgnoreCase(isBizCheck)) {
            super._cancel(ctx, pk, model);
            return;
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)"80EF7DED", IDisableBizCheck.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            super._cancel(ctx, pk, model);
            return;
        }
        String checkerName = "";
        for (int i = 0; i < checkers.length; ++i) {
            checkerName = checkers[i];
            try {
                ((IDisableBizCheck)Class.forName(checkerName).newInstance()).disableCheck(ctx, info.getId());
                continue;
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("checkerName:" + checkerName + "is not in patch!"));
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonInfo info = (PersonInfo)model;
        super._cancelCancel(ctx, pk, model);
    }
}

