/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IKAClassfication;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.util.CommonTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class PersonDataImport
extends AbstractDataTransmission {
    private ArrayList adminRangeList = null;
    private String res = "com.kingdee.eas.basedata.person.EMPAutoGenerateResource";
    private String res2 = "com.kingdee.eas.basedata.person.EmployeeInputResource.";

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PersonFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    private ArrayList getAdminRange(Context ctx) throws TaskExternalException {
        ArrayList<String> list = new ArrayList<String>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (10 == userInfo.getType().getValue()) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT T_ORG_Admin.FID AS FID");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        sql.append("WHERE T_PM_OrgRange.FType = 20 AND T_ORG_Admin.FIsSealUp = 0 AND T_PM_OrgRange.FUserID='");
        sql.append(userInfo.getId().toString());
        sql.append("'");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rows.next()) {
                list.add(rows.getString("FID"));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return list;
    }

    private Date parseDate(String date, String format, Context ctx) throws ParseException {
        try {
            return DateTimeUtils.parseDate((String)date, (String)format);
        }
        catch (ParseException pe) {
            throw new ParseException(ResourceBase.getString((String)this.res, (String)"69_EmployeeDataImport", (Locale)ctx.getLocale()) + format + "'" + ResourceBase.getString((String)this.res, (String)"70_EmployeeDataImport", (Locale)ctx.getLocale()) + date, -1);
        }
    }

    private boolean checkPermission(String permissionItem, PersonInfo pInfo, Context ctx) {
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            ObjectUuidPK orgPk = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            boolean haspermission = permission.hasDataPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem, (IObjectValue)pInfo);
            if (!haspermission) {
                return false;
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (this.adminRangeList == null) {
            this.adminRangeList = this.getAdminRange(ctx);
        }
        PersonInfo info = new PersonInfo();
        PersonCollection personColl = null;
        IPerson iPerson = null;
        String str = null;
        str = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        Locale locale = ctx.getLocale();
        try {
            String addressTx;
            String cell;
            String email;
            String homePhone;
            iPerson = PersonFactory.getLocalInstance(ctx);
            personColl = iPerson.getPersonCollection("where number = '" + str.trim() + "'");
            if (personColl != null && personColl.size() > 0) {
                if ((Integer)this.getContextParameter().get("DATATASKMODE") == 8) {
                    throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "PERSON_IS_EXIST"), (Locale)locale));
                }
                info = personColl.get(0);
            }
            if (!StringUtils.isEmpty((String)str)) {
                info.setNumber(str);
            }
            str = (String)((DataToken)hsData.get((Object)"FName_L1")).data;
            info.setName(str, new Locale("L1"));
            str = (String)((DataToken)hsData.get((Object)"FName_L2")).data;
            info.setName(str, new Locale("L2"));
            str = (String)((DataToken)hsData.get((Object)"FName_L3")).data;
            info.setName(str, new Locale("L3"));
            str = (String)((DataToken)hsData.get((Object)"FDescription_L1")).data;
            info.setDescription(str, new Locale("L1"));
            str = (String)((DataToken)hsData.get((Object)"FDescription_L2")).data;
            info.setDescription(str, new Locale("L2"));
            str = (String)((DataToken)hsData.get((Object)"FDescription_L3")).data;
            info.setDescription(str, new Locale("L3"));
            str = (String)((DataToken)hsData.get((Object)"FGender")).data;
            if (!StringUtils.isEmpty((String)str)) {
                if (str.equals(Genders.Male.getAlias())) {
                    info.setGender(Genders.Male);
                } else {
                    if (!str.equals(Genders.Female.getAlias())) throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "EMP_GENDER"), (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)(this.res2 + "NOT_FOUND"), (Locale)locale));
                    info.setGender(Genders.Female);
                }
            }
            Date date = null;
            str = (String)((DataToken)hsData.get((Object)"FBirthday")).data;
            if (!StringUtils.isEmpty((String)str)) {
                date = this.parseDate(str, "yyyy-MM-dd", ctx);
                info.setBirthday(date);
            }
            EmployeeTypeInfo typeInfo = new EmployeeTypeInfo();
            typeInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000009A29E85B3"));
            info.setEmployeeType(typeInfo);
            HROrgUnitInfo hrOrgUnit = null;
            CtrlUnitInfo gkAdminCU = null;
            str = (String)((DataToken)hsData.get((Object)"FPersonDep")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "PERSON_DEP_IS_NULL"), (Locale)locale));
            }
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminColl = iAdmin.getAdminOrgUnitCollection("select id,name,number,isCompanyOrgUnit,CU.id,CU.name,CU.number,CU.longNumber where number = '" + str.trim() + "'");
            if (adminColl == null || adminColl.size() == 0) {
                throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "PERSON_DEP_NOT_EXIST"), (Locale)locale));
            }
            info.setGkAdmin(adminColl.get(0));
            gkAdminCU = adminColl.get(0).getCU();
            String kaNumber = (String)((DataToken)hsData.get((Object)"FClassfication")).data;
            if (!StringUtils.isEmpty((String)kaNumber)) {
                IKAClassfication iKAClassfication = KAClassficationFactory.getLocalInstance((Context)ctx);
                String oql = null;
                boolean isCompany = ContextUtil.getCurrentOrgUnit((Context)ctx).isIsCompanyOrgUnit();
                if (isCompany) {
                    oql = "where number ='" + kaNumber + "' and currencyCompany ='" + ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() + "'";
                } else {
                    if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null || !ContextUtil.getCurrentCtrlUnit((Context)ctx).isIsCompanyOrgUnit()) throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "KACLASSFICATION_ERROR"), (Locale)locale));
                    oql = "where number ='" + kaNumber + "' and currencyCompany ='" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "'";
                }
                KAClassficationCollection kaColl = iKAClassfication.getKAClassficationCollection(oql);
                if (kaColl == null || kaColl.size() <= 0) throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "KACLASSFICATION_ERROR"), (Locale)locale));
                info.setKaClassfication(kaColl.get(0));
            } else if (info.getId() == null) {
                info.setKaClassfication(null);
            }
            if (info.getId() == null) {
                try {
                    hrOrgUnit = HROrgContextManagerFacadeFactory.getLocalInstance((Context)ctx).getHROByAdminOrgUnitID(adminColl.get(0).getId().toString());
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (hrOrgUnit != null) {
                    info.setCU(hrOrgUnit.getCU());
                } else {
                    info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                }
            }
            if (this.adminRangeList != null && !this.adminRangeList.contains(adminColl.get(0).getId().toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "NO_PERMISSON_MODIFY_PERSON"), (Locale)locale));
            }
            String idNum = (String)((DataToken)hsData.get((Object)"FIdNum")).data;
            if (!StringUtils.isEmpty((String)idNum)) {
                info.setString("idNum", idNum);
                info.setIdNum(idNum);
            }
            if (!StringUtils.isEmpty((String)(homePhone = (String)((DataToken)hsData.get((Object)"FHomePhone")).data))) {
                info.setHomePhone(homePhone);
            }
            if (!StringUtils.isEmpty((String)(email = (String)((DataToken)hsData.get((Object)"FEmail")).data))) {
                info.setEmail(email);
            }
            if (!StringUtils.isEmpty((String)(cell = (String)((DataToken)hsData.get((Object)"FCell")).data))) {
                info.setCell(cell);
            }
            if (!StringUtils.isEmpty((String)(addressTx = (String)((DataToken)hsData.get((Object)"FAddressTx")).data))) {
                info.setAddressTX(addressTx);
            }
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage(), e1.getCause());
        }
        catch (ParseException e) {
            throw new TaskExternalException(ResourceBase.getString((String)(this.res2 + "DATE_ERROR"), (Locale)locale), (Throwable)e);
        }
        info.put("NOPOSITION_PERSON_SAVE", Boolean.TRUE);
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"number", "name", "idNum", "kaclassfication.number", "admin.number", "birthday", "gender", "email", "cell", "homePhone", "addressTx", "description"});
        exportMap.put("excelFiled", new String[]{"FNumber", "FName" + CommonTool.getLocal(ctx), "FIdNum", "FClassfication", "FPersonDep", "FBirthday", "FGender", "FEmail", "FCell", "FHomePhone", "FAddressTx", "FDescription" + CommonTool.getLocal(ctx)});
        exportMap.put("FiledType", new String[0]);
        return ExportUtil.transeExport((IRowSet)rs, exportMap);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("position.number", null, CompareType.EQUALS));
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.person.app.NoPositionPerson";
    }
}

