/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.express.IllegalParameterException;
import java.util.HashSet;
import java.util.Set;

public class GLAccountClientHelper {
    public static EntityViewInfo getAccountViewEvi(String cuId, String companyId, String currencyId, boolean isLeaf) throws EASBizException, BOSException {
        EntityViewInfo evi = GLAccountClientHelper.getAccountViewEvi(cuId, companyId, currencyId, isLeaf, true);
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("control", (Object)new Integer(0)));
        f.getFilterItems().add(new FilterItemInfo("control", null));
        f.setMaskString(" #0 or #1 ");
        evi.getFilter().mergeFilter(f, "AND");
        return evi;
    }

    public static EntityViewInfo getAccountViewEvi(String cuId, String companyId, String currencyId, boolean isLeaf, boolean isShowCashAndBank) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        if (!isShowCashAndBank) {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.FALSE));
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        EntityViewInfo evi = GLAccountClientHelper.getAccountViewEvi(companyId, currencyId, customEvi);
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(new SorterItemInfo("number"));
        return evi;
    }

    public static EntityViewInfo getAccountViewEvi(String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        Set set = GLAccountClientHelper.getAcctViewIdSet(companyId, currencyId, viewInfo);
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (set == null || set.size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        }
        info.setFilter(filter);
        return info;
    }

    public static Set getAcctViewIdSet(String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        AccountViewCollection acctViewColl = GLAccountClientHelper.getAccountViewCollection(null, companyId, currencyId, viewInfo);
        if (acctViewColl == null) {
            return null;
        }
        int size = acctViewColl.size();
        AccountViewInfo acctViewInfo = null;
        for (int i = 0; i < size; ++i) {
            acctViewInfo = acctViewColl.get(i);
            set.add(acctViewInfo.getId().toString());
        }
        return set;
    }

    public static AccountViewCollection getAccountViewCollection(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)companyId)) {
            throw new BOSException((Throwable)new IllegalParameterException("company is null"));
        }
        EntityViewInfo view = viewInfo;
        if (viewInfo == null) {
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
            items.add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
            items.add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        }
        return GLAccountClientHelper.getAccountViewCollectionWithDataPermission(ctx, companyId, currencyId, view);
    }

    public static AccountViewCollection getAccountViewCollectionWithDataPermission(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo comInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String strCUId = comInfo.getId().toString();
        String acctTableId = null;
        if (comInfo.getAccountTable() != null) {
            acctTableId = comInfo.getAccountTable().getId().toString();
        }
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance((Context)ctx) : AccountViewFactory.getRemoteInstance();
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)strCUId));
        if (acctTableId != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTableId));
        }
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        AccountViewCollection acctViewCol = iAccountView.getAccountViewCollection(viewInfo);
        if (acctViewCol == null || acctViewCol.size() == 0) {
            return null;
        }
        if (currencyId == null) {
            return acctViewCol;
        }
        IContextHelper iContextHelper = null;
        iContextHelper = ctx != null ? ContextHelperFactory.getLocalInstance((Context)ctx) : ContextHelperFactory.getRemoteInstance();
        CurrencyInfo baseCy = iContextHelper.getCompanyBaseCurrency(comInfo);
        String localCurrencyId = "";
        if (baseCy != null) {
            localCurrencyId = baseCy.getId().toString();
        }
        if (localCurrencyId.length() == 0) {
            return acctViewCol;
        }
        AccountViewCollection retColl = new AccountViewCollection();
        AccountCurrencyCollection acctCurColl = null;
        int size = acctViewCol.size();
        block5: for (int i = 0; i < size; ++i) {
            AccountViewInfo acctInfo = acctViewCol.get(i);
            switch (acctInfo.getAccountingcurrency().getValue()) {
                case 2: {
                    retColl.add(acctInfo);
                }
                case 0: {
                    if (localCurrencyId.equals(currencyId)) {
                        retColl.add(acctInfo);
                    }
                }
                case 1: {
                    acctCurColl = acctInfo.getAccountCurrency();
                    for (int j = 0; j < acctCurColl.size(); ++j) {
                        if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                        retColl.add(acctInfo);
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        return retColl;
    }

    public static SelectorItemCollection getAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("isChangeCurrency"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isSelfFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("mainCashFlowItem.*"));
        sic.add(new SelectorItemInfo("attCashFlowItem.*"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.number"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.number"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        return sic;
    }
}

