/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.GLException;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IGeneralAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;

public class GLUtil {
    public static boolean isCompanyUnion(CompanyOrgUnitInfo company) {
        if (company == null) {
            throw new RuntimeException("Parameter[company] is null");
        }
        if (!company.containsKey("isBizUnit")) {
            throw new RuntimeException("Please load property [company.bizUnit]");
        }
        return !company.isIsBizUnit();
    }

    public static PeriodInfo getStartPeriod(Context ctx, String comId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)comId));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("startPeriod.number"));
        sic.add(new SelectorItemInfo("startPeriod.periodYear"));
        sic.add(new SelectorItemInfo("startPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("startPeriod.beginDate"));
        sic.add(new SelectorItemInfo("startPeriod.endDate"));
        ISystemStatusCtrol ctrl = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        PeriodInfo prd = null;
        if (col.size() == 1) {
            prd = col.get(0).getStartPeriod();
        }
        if (prd == null) {
            throw new GLException(GLException.PERIOD_ERROR);
        }
        return prd;
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String comId, SelectorItemCollection sic, boolean mustBeEntity) throws BOSException, EASBizException {
        if (sic == null) {
            sic = GLUtil.getCompanySic();
        }
        ICompanyOrgUnit comCtrl = null;
        comCtrl = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo com = null;
        ObjectUuidPK comPK = null;
        try {
            comPK = new ObjectUuidPK(BOSUuid.read((String)comId));
            com = (CompanyOrgUnitInfo)comCtrl.getValue((IObjectPK)comPK, sic);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, ex);
        }
        if (mustBeEntity && !com.isIsBizUnit()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return com;
    }

    public static void checkFIUnit(boolean isSupportVirtual) throws Exception {
        GLUtil.checkFIUnit(SysContext.getSysContext().getCurrentFIUnit(), isSupportVirtual);
    }

    public static void checkFIUnit(CompanyOrgUnitInfo company, boolean isSupportVirtual) throws Exception {
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (!SysContext.getSysContext().getCurrentOrgUnit().isIsCompanyOrgUnit()) {
            throw new GLException(GLException.NOT_A_BIZUNIT);
        }
        if (!company.isIsBizUnit() && !isSupportVirtual) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)company);
    }

    public static SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        return sic;
    }

    public static String getGeneralCollection(Context ctx, String groupid) {
        String par = "";
        try {
            IGeneralAsstActType iGAAT;
            CtrlUnitInfo CU = null;
            CompanyOrgUnitInfo company = null;
            if (ctx == null) {
                iGAAT = GeneralAsstActTypeFactory.getRemoteInstance();
                CU = SysContext.getSysContext().getCurrentCtrlUnit();
                company = SysContext.getSysContext().getCurrentFIUnit();
            } else {
                iGAAT = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx);
                CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                company = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            String currentCUID = CU.getId().toString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("groupID", groupid);
            map.put("cuID", currentCUID);
            String currentCompanyID = company.getId().toString();
            map.put("companyID", currentCompanyID);
            par = iGAAT.f7getCollection(map);
        }
        catch (BOSException ex) {
            ex.printStackTrace();
        }
        if (par.length() == 0) {
            par = "00000000-0000-0000-0000-000000000000F90B0133";
        }
        return par;
    }

    public static String getGeneralCollection(String groupid) {
        return GLUtil.getGeneralCollection(null, groupid);
    }

    public static boolean getDefaultGLParam(Context ctx, String companyId, String key) throws BOSException, EASBizException {
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK comPK = null;
        if (companyId != null) {
            comPK = new ObjectUuidPK(companyId);
        }
        hmParamIn.put(key, comPK);
        IParamControl pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean value = false;
        value = hmAllParam.get(key) != null ? Boolean.valueOf(hmAllParam.get(key).toString()) : true;
        return value;
    }

    public static Object getParamByKey(Context ctx, String companyID, String key) throws BOSException, EASBizException {
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK comPK = null;
        if (companyID != null) {
            comPK = new ObjectUuidPK(companyID);
        }
        hmParamIn.put(key, comPK);
        IParamControl pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        return hmAllParam.get(key);
    }
}

