/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.excelformula;

import com.kingdee.eas.fi.rpt.excelformula.EnumAgent;
import com.kingdee.eas.fi.rpt.excelformula.IRptDataPublisher;
import com.kingdee.eas.fi.rpt.excelformula.RptFormulaDataType;
import com.kingdee.eas.fi.rpt.excelformula.RptFormulaEnumEntry;
import com.kingdee.eas.fi.rpt.excelformula.RptOperObject;
import com.kingdee.eas.fi.rpt.util.RptUtilForAPI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RptFormulaEnumType
extends RptFormulaDataType
implements IRptDataPublisher {
    private static Logger logger = Logger.getLogger(RptFormulaEnumType.class);
    protected static final int STA_ENTRY = 1;
    protected static final int STA_SOURCE = 1;
    protected Vector entrys = new Vector(3);
    protected String excludes;
    private int defaultIndex = 0;

    public RptFormulaEnumType(String name, IRptDataPublisher pb) {
        super(name, pb);
    }

    @Override
    public void clear() {
        this.entrys.removeAllElements();
        super.clear();
    }

    public Collection getEntrys() {
        return this.entrys;
    }

    public String getEntryRawName(String aname) {
        String res = aname;
        int size = this.entrys.size();
        for (int i = 0; i < size; ++i) {
            RptFormulaEnumEntry e = (RptFormulaEnumEntry)this.entrys.elementAt(i);
            if (e == null || !e.isNamedAs(aname)) continue;
            res = e.getName();
        }
        return res;
    }

    @Override
    public void goContent(String value) {
        if (this.status == 1 && value.length() > 0) {
            try {
                this.readEnum(Class.forName(value));
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) {
                    logger.error((Object)e.getMessage());
                }
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void readEnum(Class enums) {
        EnumAgent ag = EnumAgent.getInstance();
        String[] local = new String[]{"zh_CN", "zh_TW", "en_US"};
        int es = ag.Attach(enums);
        int ls = local.length;
        String str = null;
        for (int i = 0; i < es; ++i) {
            str = ag.readEntryName(i);
            if (this.filterEntry(str)) continue;
            RptFormulaEnumEntry e = new RptFormulaEnumEntry(str.trim(), null);
            for (int j = 0; j < ls; ++j) {
                str = ag.readEntryAlias(i, local[j]);
                if (str == null) continue;
                e.setLocalName(local[j], str.trim());
                e.setDescription(local[j], str.trim());
            }
            this.entrys.add(e);
        }
        ag.setCurEnum(null);
    }

    private boolean filterEntry(String ename) {
        if (ename == null) {
            return true;
        }
        return this.excludes != null && this.excludes.indexOf(',' + ename.toLowerCase() + ',') != -1;
    }

    @Override
    public void goInto(String target, Attributes atts) throws SAXException {
        if (target.equalsIgnoreCase("entry")) {
            this.status = 1;
            RptFormulaEnumEntry e = new RptFormulaEnumEntry(target, this);
            this.publisher.keep(e);
            e.goInto(target, atts);
        } else if (target.equalsIgnoreCase("enum")) {
            this.status = 0;
            String av = atts.getValue("name");
            if (av == null) {
                throw new SAXException(RptUtilForAPI.getResource("rptformula-exp-noname"));
            }
            this.name = av.trim();
            av = atts.getValue("origin");
            this.originType = av != null ? av.trim() : "string";
            av = atts.getValue("excludes");
            this.excludes = av != null ? av.trim().toLowerCase() : null;
            av = atts.getValue("default");
            av = !StringUtils.isEmpty((String)av) ? av.trim() : "0";
            try {
                this.defaultIndex = Integer.parseInt(av);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (target.equalsIgnoreCase("source")) {
            this.status = 1;
        }
    }

    @Override
    public void goOut(String target) {
        if (target.equalsIgnoreCase("entry")) {
            this.status = 0;
        } else if (target.equalsIgnoreCase("enum")) {
            this.status = 0;
            this.publisher.publish(this);
        } else if (target.equalsIgnoreCase("source")) {
            this.status = 0;
        }
    }

    @Override
    public void keep(RptOperObject ob) {
        this.publisher.keep(ob);
    }

    @Override
    public void publish(RptOperObject ob) {
        if (ob instanceof RptFormulaEnumEntry) {
            this.entrys.add(ob);
            this.status = 0;
            this.publisher.keep(this);
        } else {
            this.publisher.publish(ob);
        }
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(int defaultIndex) {
        this.defaultIndex = defaultIndex;
    }
}

