/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDBusiMaskField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public final class ClientVerifyHelper {
    public static String path = "com.kingdee.eas.fm.common.FMResource";

    public static void verifyEmpty(CoreUIObject ui, KDTable kdtEntries) {
        if (kdtEntries == null || kdtEntries.getRowCount() < 1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"EntryCanNotBeNull"));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        ClientVerifyHelper.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, JFormattedTextField txtField, String msg) {
        String txt = txtField.getText();
        if (txt == null || txt.trim().equals("")) {
            txtField.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage(txtField) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, JFormattedTextField txtNumber) {
        ClientVerifyHelper.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmptyInputF7(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null || content.toString() != null && content.toString().trim().length() == 0) {
            if (content != null && content.toString() != null && content.toString().trim().length() == 0) {
                bizBox.setData((Object)"");
            }
            bizBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = ClientVerifyHelper.getCompLabelText(component);
        return MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeNullValue"), text);
    }

    public static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        ClientVerifyHelper.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox, boolean isInputF7) {
        if (isInputF7) {
            ClientVerifyHelper.verifyEmptyInputF7(ui, null, bizBox, null);
        } else {
            ClientVerifyHelper.verifyEmpty(ui, null, bizBox, null);
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDComboBox comboBox) {
        ClientVerifyHelper.verifyEmpty(ui, null, comboBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDMultiLangBox multLangBox, String msg) {
        Object content = multLangBox.getSelectedItem();
        if (content == null || content.toString().trim().length() <= 0) {
            multLangBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)multLangBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDMultiLangBox multLangBox) {
        ClientVerifyHelper.verifyEmpty(ui, null, multLangBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox comboBox, String msg) {
        Object content = comboBox.getSelectedItem();
        if (content == null) {
            comboBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)comboBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        String content = datePicker.getText();
        if (content == null || content.equals("")) {
            datePicker.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)datePicker) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        ClientVerifyHelper.verifyEmpty(ui, null, datePicker, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea txtArea, String msg) {
        String txt = txtArea.getText();
        if (txt == null || txt.trim().length() <= 0) {
            txtArea.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ClientVerifyHelper.getMessage((Component)txtArea) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea, String name) {
        String txt = txtArea.getText();
        if (txt == null || txt.trim().length() <= 0) {
            txtArea.requestFocus(true);
            MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeNullValue"), name));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea) {
        ClientVerifyHelper.verifyEmpty(ui, null, txtArea, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDFormattedTextField txtNumber) {
        ClientVerifyHelper.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (EmptyUtil.isEmpty((Object)value)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg, String ctrlName) {
        if (EmptyUtil.isEmpty((Object)value)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            ClientVerifyHelper.setComponentFocus((JComponent)ui, ctrlName);
            SysUtil.abort();
        }
    }

    public static void setComponentFocus(JComponent ui, String componentName) {
        Component[] comps = ui.getComponents();
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof KDPanel || comps[i] instanceof KDScrollPane || comps[i] instanceof KDSplitPane || comps[i] instanceof KDTabbedPane || comps[i] instanceof KDLabelContainer || comps[i] instanceof KDContainer || comps[i] instanceof KDPanel || comps[i] instanceof JPanel) {
                    ClientVerifyHelper.setComponentFocus((JComponent)comps[i], componentName);
                    continue;
                }
                if (comps[i] == null || comps[i].getName() == null || !comps[i].getName().equals(componentName)) continue;
                comps[i].requestFocus();
            }
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (value == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
        if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(Constants.ZERO) == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, KDFormattedTextField txt) {
        ClientVerifyHelper.verifyEmpty(ui, txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(Constants.ZERO) == 0) {
            txt.requestFocus(true);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"canNotBeZeroValue"), ClientVerifyHelper.getCompLabelText((Component)txt));
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyAGreaterThanB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        ClientVerifyHelper.verifyEmpty(ui, txtA);
        ClientVerifyHelper.verifyEmpty(ui, txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (a.compareTo(b) < 1) {
            txtA.requestFocus(true);
            String aText = ClientVerifyHelper.getCompLabelText((Component)txtA);
            String bText = ClientVerifyHelper.getCompLabelText((Component)txtB);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThan"), aText, bText);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyRequire(CoreUIObject ui) {
        Component[] comps = ui.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (comp instanceof KDLabelContainer) {
                KDTextField txtEditor;
                KDLabelContainer ct = (KDLabelContainer)comp;
                JComponent editor = ct.getBoundEditor();
                if (editor instanceof KDTextField) {
                    txtEditor = (KDTextField)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, txtEditor);
                    continue;
                }
                if (editor instanceof KDBizMultiLangBox) {
                    txtEditor = (KDBizMultiLangBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDMultiLangBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDComboBox) {
                    txtEditor = (KDComboBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDComboBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDDatePicker) {
                    txtEditor = (KDDatePicker)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDDatePicker)txtEditor);
                    continue;
                }
                if (editor instanceof KDBizPromptBox) {
                    txtEditor = (KDBizPromptBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDBizPromptBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDFormattedTextField) {
                    txtEditor = (KDFormattedTextField)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDFormattedTextField)txtEditor);
                    continue;
                }
                if (!(editor instanceof KDBusiMaskField) || !(txtEditor = (KDBusiMaskField)editor).isRequired()) continue;
                ClientVerifyHelper.verifyEmpty(ui, (JFormattedTextField)txtEditor);
                continue;
            }
            if (!(comp instanceof KDPanel)) continue;
            ClientVerifyHelper.verifyRequire(ui, (KDPanel)comp);
        }
    }

    public static void verifyRequire(CoreUIObject ui, KDPanel panel) {
        Component[] comps = panel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (comp instanceof KDLabelContainer) {
                KDTextField txtEditor;
                KDLabelContainer ct = (KDLabelContainer)comp;
                JComponent editor = ct.getBoundEditor();
                if (editor instanceof KDTextField) {
                    txtEditor = (KDTextField)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, txtEditor);
                    continue;
                }
                if (editor instanceof KDBizMultiLangBox) {
                    txtEditor = (KDBizMultiLangBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDMultiLangBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDComboBox) {
                    txtEditor = (KDComboBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDComboBox)txtEditor);
                    continue;
                }
                if (editor instanceof KDDatePicker) {
                    txtEditor = (KDDatePicker)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDDatePicker)txtEditor);
                    continue;
                }
                if (editor instanceof KDBizPromptBox) {
                    txtEditor = (KDBizPromptBox)editor;
                    if (!txtEditor.isRequired()) continue;
                    ClientVerifyHelper.verifyEmpty(ui, (KDBizPromptBox)txtEditor);
                    continue;
                }
                if (!(editor instanceof KDFormattedTextField) || !(txtEditor = (KDFormattedTextField)editor).isRequired()) continue;
                ClientVerifyHelper.verifyEmpty(ui, (KDFormattedTextField)txtEditor);
                continue;
            }
            if (!(comp instanceof KDPanel)) continue;
            ClientVerifyHelper.verifyRequire(ui, (KDPanel)comp);
        }
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, Date beginDate, Date endDate) {
        if (beginDate != null && endDate != null && beginDate.after(endDate)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"beginDateNotGreaterEndDate"));
            SysUtil.abort();
        }
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, KDDatePicker pkBeginDate, KDDatePicker pkEndDate) {
        if (pkBeginDate == null || pkEndDate == null) {
            return;
        }
        if (pkBeginDate.getValue() == null || pkEndDate.getValue() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"pkDateIsNull"));
            SysUtil.abort();
        }
        Date beginDate = DateTimeUtils.truncateDate((Date)((Date)pkBeginDate.getValue()));
        Date endDate = DateTimeUtils.truncateDate((Date)((Date)pkEndDate.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel(ui, beginDate, endDate);
    }

    public static void verifyUIControlEmpty(CoreUI ui) {
        Set allLeafComponents = ClientVerifyHelper.getAllComponents((Container)ui);
        for (Component comp : allLeafComponents) {
            IKDTextComponent txtComp;
            if (!(comp instanceof IKDTextComponent) || !(txtComp = (IKDTextComponent)comp).isRequired()) continue;
            if (comp instanceof KDTextField) {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTextField)comp);
                continue;
            }
            if (comp instanceof KDBizPromptBox) {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDBizPromptBox)comp);
                continue;
            }
            if (comp instanceof KDMultiLangBox) {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDMultiLangBox)comp);
                continue;
            }
            if (comp instanceof KDComboBox) {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDComboBox)comp);
                continue;
            }
            if (comp instanceof KDDatePicker) {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDDatePicker)comp);
                continue;
            }
            if (comp instanceof KDFormattedTextField) {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)comp);
                continue;
            }
            if (!(comp instanceof KDTextArea)) continue;
            ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTextArea)comp);
        }
    }

    public static Set getAllComponents(Container container) {
        Component[] components = container.getComponents();
        HashSet<Component> compSet = new HashSet<Component>();
        for (Component comp : components) {
            compSet.add(comp);
            if (!(comp instanceof KDPanel) && !(comp instanceof KDScrollPane) && !(comp instanceof KDSplitPane) && !(comp instanceof KDTabbedPane) && !(comp instanceof KDLabelContainer) && !(comp instanceof KDContainer) && !(comp instanceof JPanel)) continue;
            compSet.addAll(ClientVerifyHelper.getAllComponents((Container)comp));
        }
        return compSet;
    }
}

