/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.ITablePrecisionFormat;
import com.kingdee.eas.base.core.fm.ITablePrecisionProvider;
import com.kingdee.eas.base.core.util.CurrencyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;

public class DefaultTablePrecisionFormat
implements ITablePrecisionFormat {
    private KDTable table = null;
    private String[] formatColNames = null;
    private ITablePrecisionProvider precProvider = null;
    private CompanyOrgUnitInfo currentcompanyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    @Override
    public void initFormat(KDTable table, String[] formatColNames) throws BOSException, EASBizException {
        if (this.precProvider == null) {
            return;
        }
        this.table = table;
        this.table.checkParsed();
        this.formatColNames = formatColNames;
        this.setAlign();
        this.table.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    DefaultTablePrecisionFormat.this.doAfterDataFill(e);
                }
                catch (EASBizException e1) {
                    DefaultTablePrecisionFormat.this.toRunTimeException(e1);
                }
                catch (BOSException e1) {
                    DefaultTablePrecisionFormat.this.toRunTimeException(e1);
                }
            }
        });
    }

    private void setAlign() {
        this.table.checkParsed();
        int len = this.formatColNames.length;
        for (int i = 0; i < len; ++i) {
            this.table.getColumn(this.formatColNames[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void toRunTimeException(Throwable e) {
        RuntimeException re = new RuntimeException(e);
        re.setStackTrace(e.getStackTrace());
        throw re;
    }

    protected void doAfterDataFill(KDTDataRequestEvent e) throws EASBizException, BOSException {
        int firstRowIndex = e.getFirstRow();
        int lastRowIndex = e.getLastRow();
        IRow row = null;
        String numFormat = null;
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            row = this.table.getRow(i);
            int prec = this.precProvider.getPrecision(row);
            int len = this.formatColNames.length;
            for (int j = 0; j < len; ++j) {
                numFormat = CurrencyUtil.getNumberFtm((int)prec);
                row.getCell(this.formatColNames[j]).getStyleAttributes().setNumberFormat(numFormat);
            }
        }
    }

    @Override
    public void setPrecProvider(ITablePrecisionProvider precProvider) {
        this.precProvider = precProvider;
    }
}

