/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.condition.InterfaceItem;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.OpenAreaCollection;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.be.app.AbstractOpenAreaControllerBean;
import com.kingdee.eas.fm.be.app.OpenAreaVerifyFromImport;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class OpenAreaControllerBean
extends AbstractOpenAreaControllerBean {
    private String srcPath = "com.kingdee.eas.fm.be.BEAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.OpenAreaControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _importFromDS(Context ctx, IObjectValue openArea) throws BOSException, EASBizException {
        OpenAreaInfo openAreaInfo = (OpenAreaInfo)openArea;
        OpenAreaVerifyFromImport verify = new OpenAreaVerifyFromImport();
        verify.verifyImport(ctx, openAreaInfo);
        this._addnew(ctx, (IObjectValue)openAreaInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected String _syncOpenArea(Context ctx) throws BOSException, EASBizException {
        StringBuffer result = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        OpenAreaCollection colls = OpenAreaFactory.getLocalInstance(ctx).getOpenAreaCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            OpenAreaInfo info = colls.get(i);
            try {
                if (EmptyUtil.isEmpty((Object)((Object)info.getBankInterfaceType())) || EmptyUtil.isEmpty((String)info.getBankInterfaceType().getAlias(ctx.getLocale()))) continue;
                InterfaceItem item = new InterfaceItem("BankFacade", "A2F61E6C", "getBankCert", "facade", new Class[]{String.class}, null);
                Object[] obj = (Object[])item.doInvoke(ctx, new Object[]{info.getBankInterfaceType().getAlias(ctx.getLocale())});
                if (obj.length == 1) {
                    info.setBankInterFaceid(((BankInterface)obj[0]).getNumber());
                    info.setBankInterfaceName(((BankInterface)obj[0]).getName().substring(0, ((BankInterface)obj[0]).getName().indexOf("-")));
                    OpenAreaFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                    result.append(info.getName() + "[" + info.getNumber() + "]: " + ResourceBase.getString((String)this.srcPath, (String)"111_AccountBank", (Locale)ctx.getLocale()) + System.getProperty("line.separator"));
                    continue;
                }
                if (obj.length > 1) {
                    result.append(info.getName() + "[" + info.getNumber() + "]: " + ResourceBase.getString((String)this.srcPath, (String)"113_OpenArea", (Locale)ctx.getLocale()) + System.getProperty("line.separator"));
                    continue;
                }
                result.append(info.getName() + "[" + info.getNumber() + "]: " + MessageFormat.format(ResourceBase.getString((String)this.srcPath, (String)"112_OpenArea", (Locale)ctx.getLocale()), info.getBankInterfaceType().getAlias(ctx.getLocale())) + System.getProperty("line.separator"));
                continue;
            }
            catch (Exception e) {
                result.append(info.getName() + "[" + info.getNumber() + "]: " + MessageFormat.format(ResourceBase.getString((String)this.srcPath, (String)"112_OpenArea", (Locale)ctx.getLocale()), info.getBankInterfaceType().getAlias(ctx.getLocale())) + System.getProperty("line.separator"));
            }
        }
        if (result.length() == 0) {
            result.append(ResourceBase.getString((String)this.srcPath, (String)"117_OpenArea", (Locale)ctx.getLocale()));
        }
        return result.toString();
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bankInterfaceType"));
        sic.add(new SelectorItemInfo("bankInterFaceid"));
        sic.add(new SelectorItemInfo("bankInterfaceName"));
        return sic;
    }

    @Override
    protected void _batchImport(Context ctx, Set set) throws BOSException, EASBizException {
        Iterator iter = set.iterator();
        HashSet<String> numberSet = new HashSet<String>();
        String interFaceID = "";
        while (iter.hasNext()) {
            OpenAreaInfo openAreaInfo = (OpenAreaInfo)iter.next();
            String number = openAreaInfo.getNumber();
            if (number == null || number.length() <= 0) {
                throw new EASBizException(EASBizException.CHECKNUMBLANK);
            }
            numberSet.add(number);
            interFaceID = openAreaInfo.getBankInterFaceid();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankInterFaceid", (Object)interFaceID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        OpenAreaCollection coll = OpenAreaFactory.getLocalInstance(ctx).getOpenAreaCollection(view);
        HashMap<String, OpenAreaInfo> exitMap = new HashMap<String, OpenAreaInfo>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int i = 0; i < coll.size(); ++i) {
                exitMap.put(coll.get(i).getNumber(), coll.get(i));
            }
        }
        for (OpenAreaInfo openAreaInfo : set) {
            String number = openAreaInfo.getNumber();
            interFaceID = openAreaInfo.getBankInterFaceid();
            if (exitMap.containsKey(number) && ((OpenAreaInfo)exitMap.get(number)).getBankInterFaceid().equals(interFaceID)) continue;
            this._addnew(ctx, (IObjectValue)openAreaInfo);
        }
    }
}

