/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.OrgStructureUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.fin.FinancingProductsCollection;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.app.AbstractFinancingProductsControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinancingProductsControllerBean
extends AbstractFinancingProductsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.FinancingProductsControllerBean");
    private String[] protectNum = new String[]{"005", "009", "008", "010", "011", "in001", "in002", "in003"};

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.isReferenced(ctx, pk);
        }
        catch (Exception e) {
            throw new BOSException("\u8be5\u6570\u636e\u8bb0\u5f55\u5df2\u88ab\u5355\u636e\u5f15\u7528");
        }
        FinancingProductsInfo info = this.getFinancingProductsInfo(ctx, pk);
        String number = info.getNumber();
        for (int i = 0; i < this.protectNum.length; ++i) {
            if (!number.equals(this.protectNum[i])) continue;
            throw new FinBaseDataException(FinBaseDataException.FINPROCANNOTDEL);
        }
        this.updateParent(ctx, info);
        super._delete(ctx, pk);
    }

    private void updateParent(Context ctx, FinancingProductsInfo info) throws BOSException {
        if (info.getLevel() != 1) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(fid) as c from T_FIN_FinancingProducts where FparentId=?", (Object[])new Object[]{info.getParent().getId().toString()});
            try {
                rs.next();
                if (rs.getInt("c") == 1) {
                    DbUtil.execute((Context)ctx, (String)"update T_FIN_FinancingProducts set FIsLeaf=1 where FID=?", (Object[])new Object[]{info.getParent().getId().toString()});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        this.checkDefaultValue4Addnew(ctx, (FinancingProductsInfo)info);
        return super._addnew(ctx, info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDefaultValue4Update(ctx, (FinancingProductsInfo)model);
        super._update(ctx, pk, model);
    }

    private void checkDefaultValue4Update(Context ctx, FinancingProductsInfo info) throws BOSException, EASBizException {
        FinancingProductsCollection col;
        EntityViewInfo evi;
        if (info.isIsFinLoanDefault()) {
            evi = this.getEvi(1);
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            col = this.getFinancingProductsCollection(ctx, evi);
            if (col != null && col.size() > 0) {
                throw new FinBaseDataException(FinBaseDataException.FINPROCANNOTDEL);
            }
        }
        if (info.isIsIvtLoanDefault()) {
            evi = this.getEvi(2);
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            col = this.getFinancingProductsCollection(ctx, evi);
            if (col != null && col.size() > 0) {
                throw new FinBaseDataException(FinBaseDataException.FINPROCANNOTDEL);
            }
        }
        if (info.isIsBondsDefault()) {
            evi = this.getEvi(3);
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            col = this.getFinancingProductsCollection(ctx, evi);
            if (col != null && col.size() > 0) {
                throw new FinBaseDataException(FinBaseDataException.FIN_BONDS_FINP_UNIQUE);
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgStructureUtils.setSysCU((IObjectValue)model);
        this.submitCheck(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        this._checkNumberDup(ctx, model);
        return pk;
    }

    private void checkDefaultValue4Addnew(Context ctx, FinancingProductsInfo info) throws EASBizException, BOSException {
        this.checkIvtLoanDefaultUnique(ctx, info);
        this.checkFinLoanDefaultUnique(ctx, info);
        this.checkBondsDefaultUnique(ctx, info);
    }

    private void checkIvtLoanDefaultUnique(Context ctx, FinancingProductsInfo info) throws EASBizException, BOSException {
        if (info.isIsIvtLoanDefault() && this.getLoanDefByModual(ctx, 2) != null) {
            throw new FinBaseDataException(FinBaseDataException.FIN_ENT_FINP_UNIQUE);
        }
    }

    private void checkFinLoanDefaultUnique(Context ctx, FinancingProductsInfo info) throws EASBizException, BOSException {
        if (info.isIsFinLoanDefault() && this.getLoanDefByModual(ctx, 1) != null) {
            throw new FinBaseDataException(FinBaseDataException.FIN_LOAN_FINP_UNIQUE);
        }
    }

    private void checkBondsDefaultUnique(Context ctx, FinancingProductsInfo info) throws EASBizException, BOSException {
        if (info.isIsBondsDefault() && this.getLoanDefByModual(ctx, 3) != null) {
            throw new FinBaseDataException(FinBaseDataException.FIN_BONDS_FINP_UNIQUE);
        }
    }

    @Override
    protected IObjectValue _getLoanDefByModual(Context ctx, int modualValue) throws BOSException, EASBizException {
        FinancingProductsCollection col;
        FinancingProductsInfo returnValue = null;
        if (modualValue == 1) {
            FinancingProductsCollection col2 = this.getFinancingProductsCollection(ctx, this.getEvi(1));
            if (col2 != null && col2.size() > 0) {
                returnValue = col2.get(0);
            }
        } else if (modualValue == 2) {
            FinancingProductsCollection col3 = this.getFinancingProductsCollection(ctx, this.getEvi(2));
            if (col3 != null && col3.size() > 0) {
                returnValue = col3.get(0);
            }
        } else if (modualValue == 3 && (col = this.getFinancingProductsCollection(ctx, this.getEvi(3))) != null && col.size() > 0) {
            returnValue = col.get(0);
        }
        return returnValue;
    }

    private EntityViewInfo getEvi(int type) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        if (type == 1) {
            f.getFilterItems().add(new FilterItemInfo("isFinLoanDefault", (Object)Boolean.TRUE));
        } else if (type == 2) {
            f.getFilterItems().add(new FilterItemInfo("isIvtLoanDefault", (Object)Boolean.TRUE));
        } else if (type == 3) {
            f.getFilterItems().add(new FilterItemInfo("isBondsDefault", (Object)Boolean.TRUE));
        }
        evi.setFilter(f);
        return evi;
    }

    @Override
    protected Set _getReferenceCollection(Context ctx) throws BOSException, EASBizException {
        IObjectPK[] pkList = super.getPKList(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        Set seferencedSet = new HashSet();
        IRefChecker irc = RefCheckerFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < pkList.length; ++i) {
            idList.add(pkList[i].toString());
        }
        if (idList != null && idList.size() > 0) {
            seferencedSet = irc.isReferenced(idList);
        }
        for (int j = 0; j < pkList.length; ++j) {
            if (seferencedSet.contains(pkList[j].toString())) continue;
            set.add(pkList[j] + "");
        }
        return set;
    }

    private void submitCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingProductsInfo info = (FinancingProductsInfo)model;
        FinancingProductsInfo parent = info.getParent();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getId() != null) {
            f.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        evi.setFilter(f);
        FinancingProductsCollection col = this.getFinancingProductsCollection(ctx, evi);
        if (col != null && col.size() > 0) {
            throw new FinBaseDataException(FinBaseDataException.MUTINUMBER);
        }
        if (parent != null) {
            info.setLevel(parent.getLevel() + 1);
            if (info.getId() == null) {
                info.setIsLeaf(true);
            }
            DbUtil.execute((Context)ctx, (String)"update T_FIN_FinancingProducts set FIsLeaf=0 where FID=?", (Object[])new Object[]{parent.getId().toString()});
        }
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FinancingProductsInfo info = this.getFinancingProductsInfo(ctx, pk);
        info.setIsUsed(false);
        this._update(ctx, pk, (IObjectValue)info);
        if (!info.isIsLeaf()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid as c from T_FIN_FinancingProducts where FparentId=?", (Object[])new Object[]{info.getId().toString()});
            try {
                while (rs.next()) {
                    String fid = rs.getString("c");
                    if (fid == null) continue;
                    ObjectUuidPK pk1 = new ObjectUuidPK(fid);
                    this._disable(ctx, (IObjectPK)pk1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FinancingProductsInfo info = this.getFinancingProductsInfo(ctx, pk);
        info.setIsUsed(true);
        this._update(ctx, pk, (IObjectValue)info);
        if (!info.isIsLeaf()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid as c from T_FIN_FinancingProducts where FparentId=?", (Object[])new Object[]{info.getId().toString()});
            try {
                while (rs.next()) {
                    String fid = rs.getString("c");
                    if (fid == null) continue;
                    ObjectUuidPK pk1 = new ObjectUuidPK(fid);
                    this._enable(ctx, (IObjectPK)pk1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

