/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fpl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fpl.FpItemCollection;
import com.kingdee.eas.fm.fpl.FpItemException;
import com.kingdee.eas.fm.fpl.FpItemFactory;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fpl.IFpItem;
import com.kingdee.eas.fm.fpl.app.AbstractFpItemControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FpItemControllerBean
extends AbstractFpItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fpl.app.FpItemControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String itemNum;
        int lastDot;
        Locale locale_L1 = LocaleUtils.getLocale((String)"L1");
        Locale locale_L2 = LocaleUtils.getLocale((String)"L2");
        Locale locale_L3 = LocaleUtils.getLocale((String)"L3");
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        FpItemInfo info = (FpItemInfo)model;
        info.setIsLeaf(true);
        if (info.getOrgUnit() == null) {
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            fullOrgInfo.setId(ContextUtil.getCurrentCostUnit((Context)ctx).getId());
            info.setOrgUnit(fullOrgInfo);
        }
        if (info.getOrgNum() == null) {
            info.setOrgNum(ContextUtil.getCurrentCostUnit((Context)ctx).getNumber());
        }
        if (info.getOrgLongNum() == null) {
            info.setOrgLongNum(ContextUtil.getCurrentCostUnit((Context)ctx).getLongNumber());
        }
        if (info.getOrgName() == null) {
            info.setOrgName(ContextUtil.getCurrentCostUnit((Context)ctx).getName(locale_L1), locale_L1);
            info.setOrgName(ContextUtil.getCurrentCostUnit((Context)ctx).getName(locale_L2), locale_L2);
            info.setOrgName(ContextUtil.getCurrentCostUnit((Context)ctx).getName(locale_L3), locale_L3);
        }
        if ((lastDot = (itemNum = info.getNumber()).lastIndexOf(".")) == -1) {
            info.setLevel(1);
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        } else {
            String itemGroupID = info.getGroup().getId().toString();
            String itemParentNum = itemNum.substring(0, lastDot);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemParentNum));
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)itemGroupID));
            view.getSelector().add("id");
            view.getSelector().add("level");
            view.setFilter(filter);
            FpItemCollection parentColl = this.getFpItemCollection(ctx, view);
            if (parentColl.size() == 0 || parentColl.get(0) == null) {
                throw new FpItemException(FpItemException.PARENTNOTEXIST, new String[]{itemParentNum});
            }
            FpItemInfo parentInfo = parentColl.get(0);
            info.setParent(parentInfo);
            info.setLevel(parentInfo.getLevel() + 1);
            this.updateParentToLeaf(ctx, parentInfo.getId().toString());
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!this.checkIsUsed(ctx, pk.toString()) && this.isLeaf(ctx, pk)) {
            this.parentHaveLeaf(ctx, pk);
            super._delete(ctx, pk);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        boolean isUpdateTitle = false;
        FpItemInfo newModel = null;
        if (model != null && model instanceof FpItemInfo) {
            newModel = (FpItemInfo)model;
            IFpItem iFpItem = FpItemFactory.getLocalInstance(ctx);
            FpItemInfo oldModel = iFpItem.getFpItemInfo(" select number , name where id = '" + newModel.getId().toString() + "' ");
            if (!(oldModel == null || newModel.getNumber().equals(oldModel.getNumber()) && newModel.getName().equals(oldModel.getName()))) {
                isUpdateTitle = true;
            }
        }
        super._update(ctx, pk, model);
        if (isUpdateTitle) {
            AssistUtil.updateAssist((Context)ctx, (String)newModel.getId().toString(), (BOSObjectType)newModel.getBOSType());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parentHaveLeaf(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFpItem iFpItem = FpItemFactory.getLocalInstance(ctx);
        FpItemInfo info = iFpItem.getFpItemInfo(pk);
        if (info.getParent() == null) {
            return;
        }
        String parentID = info.getParent().getId().toString();
        String PKID = pk.toString();
        String sql = "select fid from t_fpl_fpitem where fparentid=? and fid !=? and fid != ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, parentID);
            stmt.setString(2, parentID);
            stmt.setString(3, PKID);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                this.updateParentToLeaf(ctx, parentID);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateParentToLeaf(Context ctx, String parentID) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String sql = "update t_fpl_fpitem set fisleaf=1  where fid=?";
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, parentID);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private boolean isLeaf(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFpItem iFpItem = FpItemFactory.getLocalInstance(ctx);
        FpItemInfo info = iFpItem.getFpItemInfo(pk);
        boolean result = info.isIsLeaf();
        if (!result) {
            throw new FpItemException(FpItemException.ISNOTLEAF);
        }
        return result;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FpItemInfo info = (FpItemInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        String id = info.getId() == null ? null : info.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)info, "number") + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected boolean _checkIsUsed(Context ctx, String id) throws BOSException, EASBizException {
        boolean isUsed = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select fid from t_fpl_temRefFPItems WHERE fFPItemID = ? \n");
            sql.append("union all \n");
            sql.append("select fid from t_fpl_fpdata where ffpitemid = ?");
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, id);
            ps.setString(2, id);
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                isUsed = true;
                throw new FpItemException(FpItemException.ISUSE);
            }
            isUsed = false;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return isUsed;
    }

    protected void _isReferenced(Context arg0, IObjectPK arg1, Connection arg2) throws ObjectReferedException {
        FpItemInfo info = null;
        try {
            info = this.getFpItemInfo(arg0, arg1);
        }
        catch (EASBizException e) {
            logger.error((Object)("error occurred in " + this.getClass().getName() + "._isReferenced():"), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("error occurred in " + this.getClass().getName() + "._isReferenced():"), (Throwable)e);
        }
        if (info != null && info.getId() != null && info.getParent() != null && info.getParent().getId() != null && info.getId().equals((Object)info.getParent().getId())) {
            return;
        }
        super._isReferenced(arg0, arg1, arg2);
    }

    @Override
    protected void _autoMatchCashItem(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fpl_fpitem set fcashflowitemid=");
        sql.append("(select fid from T_BD_CashFlowItem where fnumber=t_fpl_fpitem.fnumber)");
        sql.append(" where fcashflowitemid is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _addOrgUnit(Context ctx) throws BOSException, EASBizException {
        String sqlid = "update t_fpl_fpitem set forgUnitId= '00000000-0000-0000-0000-000000000000CCE7AED4' where forgUnitid is null";
        String sqlNum = "update t_fpl_fpitem  set (forgNum, forgLongNum, ForgName_l1, forgName_l2, forgName_l3) = (select  A.fnumber, A.flongNumber, A.Fname_l1, A.fname_l2, A.fname_l3 from (select fid, fnumber, flongNumber, fname_l1, fname_l2, fname_l3 from t_org_costcenter) A where forgUnitid = A.fid)";
        DbUtil.execute((Context)ctx, (String)sqlid.toString());
        DbUtil.execute((Context)ctx, (String)sqlNum.toString());
    }

    @Override
    protected String _updateItemOrg(Context ctx, int levelNum, Map changeLevel, Map changeItem) throws BOSException, EASBizException {
        String msg = "";
        ArrayList itemNums = null;
        Vector item = null;
        Connection conn = null;
        PreparedStatement pstHad = null;
        PreparedStatement pstParent = null;
        PreparedStatement pstUp = null;
        ResultSet rst = null;
        String oneLSql = null;
        String otherSql = null;
        String updateSql = null;
        oneLSql = "select flongnumber from T_FPL_FpItem where ";
        otherSql = "select flongnumber from T_FPL_FpItem where ";
        updateSql = "update T_FPL_FpItem set FOrgUnitId = ? , FOrgNum = ? , FOrgLongnum = ? , FOrgName_l1 = ? , FOrgName_l2 = ? , FOrgName_l3 = ?, FControlUnitID = (select fControlUnitid from T_ORG_BaseUnit where fid = ?) where fid = ?";
        String itemNotIn = "";
        String itemParentIn = "";
        String[] filter = new String[2];
        String[] org = new String[8];
        HashMap updateItem = null;
        HashMap hadParentItem = new HashMap();
        try {
            conn = this.getConnection(ctx);
            for (int i = 1; i <= levelNum; ++i) {
                if (!changeLevel.containsKey(new Integer(i))) continue;
                itemNums = (ArrayList)changeLevel.get(new Integer(i));
                int n = 0;
                while (n * 30 < itemNums.size()) {
                    String longNum;
                    Iterator ite;
                    updateItem = new HashMap();
                    for (int m = 0; m < 30 && n * 30 + m != itemNums.size(); ++m) {
                        item = (Vector)changeItem.get(itemNums.get(n * 30 + m));
                        filter = this.getOrgFilter(item);
                        itemNotIn = itemNotIn + " or ( fnumber = '" + itemNums.get(n * 30 + m) + "' and " + filter[0] + ")";
                        if (i != 1) {
                            itemParentIn = itemParentIn + " or ( fid ='" + filter[1] + "'  and " + filter[0] + ")";
                        }
                        org = new String[]{((FullOrgUnitInfo)item.get(2)).getId().toString(), ((FullOrgUnitInfo)item.get(2)).getNumber(), ((FullOrgUnitInfo)item.get(2)).getLongNumber(), ((FullOrgUnitInfo)item.get(2)).getName(new Locale("L1")), ((FullOrgUnitInfo)item.get(2)).getName(new Locale("L2")), ((FullOrgUnitInfo)item.get(2)).getName(new Locale("L3")), ((FullOrgUnitInfo)item.get(2)).getId().toString(), (String)item.get(4)};
                        updateItem.put(item.get(0), org);
                    }
                    pstHad = conn.prepareStatement(oneLSql + itemNotIn.substring(3));
                    rst = pstHad.executeQuery();
                    while (rst.next()) {
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstHad);
                    if (i != 1) {
                        pstParent = conn.prepareStatement(otherSql + itemParentIn.substring(3));
                        rst = pstParent.executeQuery();
                        while (rst.next()) {
                            hadParentItem.put(rst.getString(1), null);
                        }
                        SQLUtils.cleanup((Statement)pstParent);
                        SQLUtils.cleanup((ResultSet)rst);
                        pstUp = conn.prepareStatement(updateSql);
                        ite = updateItem.keySet().iterator();
                        while (ite.hasNext()) {
                            longNum = ite.next().toString();
                            String parentNum = longNum.substring(0, longNum.lastIndexOf("!"));
                            if (!hadParentItem.containsKey(parentNum)) {
                                msg = msg + longNum + "#";
                                continue;
                            }
                            org = (String[])updateItem.get(longNum);
                            pstUp.setString(1, org[0]);
                            pstUp.setString(2, org[1]);
                            pstUp.setString(3, org[2]);
                            pstUp.setString(4, org[3]);
                            pstUp.setString(5, org[4]);
                            pstUp.setString(6, org[5]);
                            pstUp.setString(7, org[6]);
                            pstUp.setString(8, org[7]);
                            pstUp.addBatch();
                        }
                        pstUp.executeBatch();
                    } else {
                        pstUp = conn.prepareStatement(updateSql);
                        ite = updateItem.keySet().iterator();
                        while (ite.hasNext()) {
                            longNum = ite.next().toString();
                            org = (String[])updateItem.get(longNum);
                            pstUp.setString(1, org[0]);
                            pstUp.setString(2, org[1]);
                            pstUp.setString(3, org[2]);
                            pstUp.setString(4, org[3]);
                            pstUp.setString(5, org[4]);
                            pstUp.setString(6, org[5]);
                            pstUp.setString(7, org[6]);
                            pstUp.setString(8, org[7]);
                            pstUp.addBatch();
                        }
                        pstUp.executeBatch();
                    }
                    SQLUtils.cleanup((Statement)pstUp);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstUp);
            SQLUtils.cleanup(pstParent);
            SQLUtils.cleanup(rst, pstHad, (Connection)conn);
        }
        return msg;
    }

    private String[] getOrgFilter(Vector itemOrgInfo) {
        String orgFilter = null;
        String parentId = null;
        orgFilter = "( FOrgNum in ( ";
        String orgLN = ((FullOrgUnitInfo)itemOrgInfo.get(2)).getLongNumber();
        parentId = (String)itemOrgInfo.get(1);
        String[] orgs = orgLN.split("!");
        for (int i = 0; i < orgs.length; ++i) {
            orgFilter = orgFilter + " '" + orgs[i] + "' ";
            if (i == orgs.length - 1) continue;
            orgFilter = orgFilter + " , ";
        }
        orgFilter = orgFilter + " ) or fOrgLongnum like '" + orgLN + "!%')";
        String[] filter = new String[]{orgFilter, parentId};
        return filter;
    }
}

