/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.InnerAccountException;
import com.kingdee.eas.base.core.fm.builer.InnerAccountProcessorBuilder;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountApplyBillFactory;
import com.kingdee.eas.basedata.assistant.AccountApplyBillInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.InnerAccountResultEnum;
import com.kingdee.eas.basedata.assistant.app.builder.AccountBankProcessorBuiler;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.app.AbstractInnerAccountControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class InnerAccountControllerBean
extends AbstractInnerAccountControllerBean {
    @Override
    protected void _shut(Context ctx, String id, String destId) throws BOSException, EASBizException {
        if (!this.checkInnerAcctCanShut(ctx, id)) {
            throw new InnerAccountException(InnerAccountException.CANNOTSHUT);
        }
        InnerAccountCollection col = this.getInnerAccountCol(ctx, id, destId);
        InnerAccountInfo baseInnerAccountInfo = this.getAcctInfoByID(id, col);
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("destId", (Object)destId);
        applicationContext.putData("col", (Object)col);
        applicationContext.putData("InnerAccountResult", (Object)InnerAccountResultEnum.ACCOUNT);
        BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{baseInnerAccountInfo}, (BatchActionEnum)InnerAccountProcessorBuilder.ACT_SHUT, (ApplicationContext)applicationContext);
        IObjectPK pkLog = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"39_InnerAccountControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new InnerAccountInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(id), (String)this.getInnerAcctNumber(ctx, id), (String)"fs_innerAccount_shut");
        this.setShutSymbol(ctx, baseInnerAccountInfo, true);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkLog);
    }

    private InnerAccountCollection getInnerAccountCol(Context ctx, String id, String destid) throws BOSException, EASBizException {
        IInnerAccount iInnerAccount = InnerAccountFactory.getLocalInstance(ctx);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        if (!EmptyUtil.isEmpty((String)destid)) {
            idSet.add(destid);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        evi.setFilter(f);
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("applyUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("applyUnit.number"));
        evi.getSelector().add(new SelectorItemInfo("applyUnit.name"));
        InnerAccountCollection innerCol = iInnerAccount.getInnerAccountCollection(evi);
        return innerCol;
    }

    private InnerAccountInfo getAcctInfoByID(String id, InnerAccountCollection col) {
        for (int i = 0; i < col.size(); ++i) {
            if (!id.equals(col.get(i).getId().toString())) continue;
            return col.get(i);
        }
        return null;
    }

    private String getInnerAcctNumber(Context ctx, String id) throws BOSException, EASBizException {
        IInnerAccount iInnerAccount = InnerAccountFactory.getLocalInstance(ctx);
        InnerAccountInfo innerAccountInfo = iInnerAccount.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        return innerAccountInfo.getNumber();
    }

    public static String getNumber(Context ctx, CoreBaseInfo info, String currencyId, String strNumber) throws CodingRuleException, EASBizException, BOSException {
        if (info == null || currencyId == null || currencyId.equals("")) {
            return strNumber;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean result = codingRuleManager.isExist((IObjectValue)info, currencyId);
        if (result) {
            return codingRuleManager.getNumber((IObjectValue)info, currencyId);
        }
        return strNumber;
    }

    private boolean checkInnerAcctCanShut(Context ctx, String id) throws EASBizException, BOSException {
        InnerAccountInfo innerAccInfo = this.getInnerAccountInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        java.util.Date settleDate = InnerAccountControllerBean.getClearingHouseInfo(ctx, null).getSettleDate();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT TOP 1 FID FROM T_FS_SubsidiaryLedger ").append(" \tWHERE FInnerAccountID = ? AND FDate >= ?");
            Date sqlDate = new Date(settleDate.getTime());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id, sqlDate});
            if (rs.next()) {
                return false;
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return true;
    }

    private void setShutSymbol(Context ctx, InnerAccountInfo InnerAcct, boolean isShut) throws EASBizException, BOSException {
        if (isShut) {
            InnerAcct.setClosed(true);
            BankInfo clearingHouse = InnerAccountControllerBean.getClearingHouseInfo(ctx, null);
            InnerAcct.setClosingDate(TypeConversionUtils.objToDate((Object)clearingHouse.getSettleDate()));
            UserInfo user = ContextHelperFactory.getLocalInstance(ctx).getCurrentUser();
            InnerAcct.setShutter(user);
        } else {
            InnerAcct.setClosed(false);
            InnerAcct.setClosingDate(null);
            InnerAcct.setShutter(null);
        }
        ObjectUuidPK pk = new ObjectUuidPK(InnerAcct.getId().toString());
        InnerAccountFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)InnerAcct);
    }

    @Override
    protected boolean _checkInUse(Context ctx, String id) throws BOSException, EASBizException {
        boolean flag = false;
        InnerAccountInfo innerAccInfo = this.getInnerAccountInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        String sql = "SELECT TOP 1 FID FROM T_FS_SettlementBill WHERE FPayeeInnerAcctID = ? or FPayerInnerAcctID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)innerAccInfo.getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)2, (String)innerAccInfo.getId().toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                flag = true;
            }
            sql = "SELECT TOP 1 FID FROM T_FS_SummaryLedger WHERE FBizDate IS NOT NULL AND FInnerAccountID = ? ";
            stmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                flag = true;
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return flag;
    }

    @Override
    protected boolean _checkCanShut(Context ctx, String id) throws BOSException, EASBizException {
        return this.checkInnerAcctCanShut(ctx, id);
    }

    @Override
    protected void _cancelShut(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        InnerAccountInfo InnerAccount2 = this.getInnerAccountInfo(ctx, (IObjectPK)pk);
        this.setShutSymbol(ctx, InnerAccount2, false);
        IObjectPK pkLog = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"40_InnerAccountControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new InnerAccountInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(id), (String)this.getInnerAcctNumber(ctx, id), (String)"fs_innerAccount_cancelShut");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkLog);
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("InnerAccountResult", (Object)InnerAccountResultEnum.NOACCOUNT);
        BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{id}, (BatchActionEnum)InnerAccountProcessorBuilder.ACT_SHUT, (ApplicationContext)applicationContext);
        String sql = "Update T_BD_DestroyAccountApply set FInnerAccountResult =? where FAccountBankID in (select fid from T_BD_AccountBanks where FINNERACCTID = ? )";
        com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{String.valueOf(1), id});
    }

    @Override
    protected void _setUsed(Context ctx, String id) throws BOSException, EASBizException {
        this.setUsedSymbol(ctx, id, true);
    }

    @Override
    protected void _setUnUsed(Context ctx, String id) throws BOSException, EASBizException {
        this.setUsedSymbol(ctx, id, false);
    }

    private void setUsedSymbol(Context ctx, String id, boolean isUsed) throws EASBizException, BOSException {
        String sql = "UPDATE T_FS_INNERACCOUNT SET FisUsed = ?, FsetUsedDate = ?  WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            if (isUsed) {
                stmt.setInt(1, 1);
                BankInfo clearingHouse = InnerAccountControllerBean.getClearingHouseInfo(ctx, null);
                stmt.setDate(2, TypeConversionUtils.objToDate((Object)clearingHouse.getSettleDate()));
            } else {
                stmt.setInt(1, 0);
                stmt.setNull(2, 91);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)3, (String)id);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._isReferenced(ctx, pk);
        BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        BankInfo clearingHouse = InnerAccountControllerBean.getClearingHouseInfo(ctx, null);
        InnerAccountInfo info = this.getInnerAccountInfo(ctx, pk);
        if (clearingHouse.isUsed() && info.getOpenDepositDate().before(clearingHouse.getOpenDate())) {
            throw new InnerAccountException(InnerAccountException.INITACCOUNT);
        }
        this.deleteRefIntObject(ctx, pk);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        this._disposeAccApply(ctx, info.getApplyBillId(), false);
        String srcBosType = "";
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        iBOTRelation.removeRelationByDestObjId(info.getId().toString(), srcBosType);
        super._delete(ctx, pk);
    }

    private void deleteRefIntObject(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("sourceId", (Object)pk.toString()));
        ((ICoreBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"C5AD9BF9"))).delete(filter);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InnerAccountInfo newInfo = (InnerAccountInfo)model;
        this._checkNumberDup(ctx, (IObjectValue)newInfo);
        InnerAccountInfo oldInfo = this.getInnerAccountInfo(ctx, pk);
        if (((InnerAccountInfo)model).isIsDefaultReck() && !oldInfo.isIsDefaultReck()) {
            this.cancelDefault(ctx, newInfo);
        }
        newInfo.setIsUsed(oldInfo.isIsUsed());
        super._update(ctx, pk, model);
        if (!EqualsUtil.equals((String)oldInfo.getNumber(), (String)newInfo.getNumber()) || !EqualsUtil.equals((String)oldInfo.getName(), (String)newInfo.getName())) {
            AssistUtil.updateAssist((Context)ctx, (String)pk.toString(), (BOSObjectType)new InnerAccountInfo().getBOSType());
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String accApplyBillId;
        InnerAccountInfo info = (InnerAccountInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            info.setNumber(NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
        }
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK, new Object[0]);
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        if (((InnerAccountInfo)model).isIsDefaultReck()) {
            this.cancelDefault(ctx, info);
        }
        if ((accApplyBillId = info.getApplyBillId()) != null && !"".equals(accApplyBillId.trim())) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(accApplyBillId, info.getId().toString());
            BOTPUtil.saveBOTRelation((Context)ctx, idMap);
        }
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InnerAccountInfo dataBaseInfo = (InnerAccountInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected String _getPropertyAlias(Context ctx, InnerAccountInfo dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getLogInfo(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        InnerAccountInfo innerAccountInfo = (InnerAccountInfo)model;
        IObjectPK innerAccountPK = super._submit(ctx, (IObjectValue)innerAccountInfo);
        this.saveIntObjectInfo(ctx, innerAccountInfo);
        this._disposeAccApply(ctx, innerAccountInfo.getApplyBillId(), true);
        return innerAccountPK;
    }

    private void saveIntObjectInfo(Context ctx, InnerAccountInfo innerAccountInfo) throws EASBizException, BOSException {
        CoreBaseInfo intObjectInfo = (CoreBaseInfo)innerAccountInfo.get("intObjectInfo");
        String sql = "update T_INT_IntObject set fnumber ='" + innerAccountInfo.getNumber() + "' where FsourceId='" + innerAccountInfo.getId() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        if (intObjectInfo != null) {
            intObjectInfo.setString("sourceId", innerAccountInfo.getId().toString());
            ((ICoreBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)BOSObjectType.create((String)intObjectInfo.getBOSType().toString()))).submit(intObjectInfo);
        }
    }

    protected void cancelDefault(Context ctx, InnerAccountInfo info) throws EASBizException, BOSException {
        InnerAccountInfo oldVO = this.getDefault(ctx, info);
        if (oldVO != null) {
            oldVO.setIsDefaultReck(false);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(oldVO.getId()), (CoreBaseInfo)oldVO);
        }
    }

    @Override
    protected IObjectValue _getDefault(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InnerAccountInfo info = (InnerAccountInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefaultReck", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReckoning", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("applyUnit", (Object)info.getApplyUnit().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("clearingHouse", (Object)info.getClearingHouse().getId(), CompareType.EQUALS));
        IObjectPK[] pks = this._getPKList(ctx, filter, null);
        if (pks == null || pks.length == 0) {
            return null;
        }
        if (pks.length > 1) {
            this.setRollbackOnly();
            throw new InnerAccountException(InnerAccountException.DEFAULT_ACCOUNTRECK_NOT_UNIQUE);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("applyUnit.name");
        sic.add("acctView.id");
        sic.add("acctView.name");
        sic.add("acctView.number");
        return this.getInnerAccountInfo(ctx, pks[0], sic);
    }

    @Override
    protected IObjectValue _applyToInner(Context ctx, String accApplyID) throws BOSException, EASBizException {
        try {
            BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{accApplyID}, (BatchActionEnum)AccountBankProcessorBuiler.ACT_INNERACCOUNTBANK, AccountBankProcessorBuiler.class, null);
            return (IObjectValue)batchResults.getResponse().get((Object)"innerAccountInfo");
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _disposeAccApply(Context ctx, String accApplyID, boolean isCreateToInner) throws BOSException, EASBizException {
        if (accApplyID == null || "".equals(accApplyID.trim()) || "0".equals(accApplyID.trim()) || new Boolean(isCreateToInner) == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isCreateToInner"));
        AccountApplyBillInfo accApplyInfo = AccountApplyBillFactory.getLocalInstance(ctx).getAccountApplyBillInfo((IObjectPK)new ObjectUuidPK(accApplyID), sic);
        if (accApplyInfo == null || accApplyInfo.isEmpty()) {
            return;
        }
        accApplyInfo.setIsCreateToInner(isCreateToInner);
        AccountApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)accApplyInfo, sic);
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("isCreateToInner", (Object)new Boolean(isCreateToInner));
        BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{accApplyID}, (BatchActionEnum)AccountBankProcessorBuiler.ACT_INNERDISPOSE, AccountBankProcessorBuiler.class, (ApplicationContext)applicationContext);
    }

    public static BankInfo getClearingHouseInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        IBank iBank = null;
        if (ctx == null) {
            if (EmptyUtil.isEmpty((String)companyId)) {
                companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            }
            iBank = BankFactory.getRemoteInstance();
        } else {
            if (EmptyUtil.isEmpty((String)companyId)) {
                companyId = ContextHelperFactory.getLocalInstance(ctx).getCurrentCompany().getId().toString();
            }
            iBank = BankFactory.getLocalInstance((Context)ctx);
        }
        return iBank.getClearingHouse(companyId);
    }
}

