/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestListings
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestListings.java,v 1.1 2008-12-16 05:14:14 pengxu_ge Exp $";

    @Override
    protected String getLogName() {
        return "TestListings.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDir() throws Exception {
        this.log.debug("testDir() - ENTRY");
        try {
            block6: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir();
                this.print(list);
                list = this.ftp.dir(".");
                this.print(list);
                this.log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir);
                this.print(list);
                this.log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                try {
                    list = this.ftp.dir(randomName);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block6;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550 for non-existent dir"));
                }
            }
            this.ftp.quit();
        }
        finally {
            this.log.debug("testDir() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirFull() throws Exception {
        this.log.debug("testDirFull() - ENTRY");
        try {
            block6: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir(".", true);
                this.print(list);
                this.log.debug("******* dirDetails *******");
                FTPFile[] files = this.ftp.dirDetails(".");
                this.print(files);
                this.log.debug("******* end dirDetails *******");
                this.log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir, true);
                this.print(list);
                this.log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                this.log.debug("Testing for non-existent dir: " + randomName);
                try {
                    list = this.ftp.dir(randomName, true);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block6;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550/2 for non-existent dir"));
                }
            }
            this.ftp.quit();
        }
        finally {
            this.log.debug("testDirFull() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestListings.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestListings.suite());
    }
}

