/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferClient;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.util.safe.SafeCheckUtils;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.ftp.FMEFtpInputStream;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.ftp.IFMEFtp;
import com.kingdee.eas.base.fme.service.FtpDocumentInfo;
import com.kingdee.eas.base.fme.util.FMEDataZipUtils;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;

public class FMEEdFtpImpl
implements IFMEFtp {
    private FileTransferClient ftp;
    private FileTransferClient ftp2;
    private FileInputStream fis = null;
    private FtpConfig config;
    private static int TransferFile_Cache = 262144;
    public static final String EXT_FLAG = "KingdeeFME";
    public static final String PARENT_DIR = ".";
    public static final String ROOT_DIR = "/";

    public FMEEdFtpImpl(FtpConfig config) throws Exception {
        System.out.println("FMEEdFtpImpl");
        this.config = config;
        try {
            this.ftp = new FileTransferClient();
            String accessUrl = FMEUIUtils.getLocationURL();
            System.out.println("\u8bbf\u95ee\u5f62\u5f0f:" + accessUrl);
            String ss = null != accessUrl && !"".equals(accessUrl) ? accessUrl.substring(accessUrl.indexOf(":") + 3, accessUrl.indexOf("easweb") - 1) : "";
            System.out.println("\u8bbf\u95eeftp\u7684\u5f62\u5f0f\u4e3a:" + ss);
            System.out.println("\u914d\u7f6e\u7684\u8bbf\u95ee\u5f62\u5f0f\u4e3a:" + config.getAccessaddress());
            String accessAddress = config.getAccessaddress();
            if (accessAddress != null && accessAddress != "") {
                String[] access = accessAddress.split(",");
                int index = -1;
                for (int i = 0; i < access.length; ++i) {
                    System.out.println("********************" + i + "**************" + access[i]);
                    if (!ss.equals(access[i])) continue;
                    index = i;
                }
                System.out.println("***********************index=" + index);
                if (index == -1) {
                    System.out.println("\u8bbf\u95ee\u5f62\u5f0f\u4e3a\u5185\u7f51\u8bbf\u95ee\uff0c\u8bbf\u95ee\u7684\u5185\u7f51Ip\u4e3a\uff1a" + config.getHost());
                    this.ftp.setRemoteHost(config.getHost());
                } else {
                    String internetIP = config.getInternetIP();
                    System.out.println("\u914d\u7f6eFTP\u5916\u7f51\u5730\u5740\u4e3a\uff1a" + config.getInternetIP());
                    if (internetIP != null && internetIP != "") {
                        String[] internet = internetIP.split(",");
                        if (internet.length > index) {
                            System.out.println("\u8bbf\u95ee\u5f62\u5f0f\u4e3a\u5916\u7f51\u8bbf\u95ee\uff0c\u8bbf\u95ee\u7684\u5916\u7f51Ip\u4e3a\uff1a" + internet[index]);
                            this.ftp.setRemoteHost(internet[index]);
                        } else {
                            System.out.println("\u8bbf\u95ee\u5f62\u5f0f\u4e3a\u5185\u7f51\u8bbf\u95ee\uff0c\u8bbf\u95ee\u7684\u5185\u7f51Ip\u4e3a\uff1a" + config.getHost());
                            this.ftp.setRemoteHost(config.getHost());
                        }
                    } else {
                        System.out.println("\u8bbf\u95ee\u5f62\u5f0f\u4e3a\u5185\u7f51\u8bbf\u95ee\uff0c\u8bbf\u95ee\u7684\u5185\u7f51Ip\u4e3a\uff1a" + config.getHost());
                        this.ftp.setRemoteHost(config.getHost());
                    }
                }
            } else {
                System.out.println("\u8bbf\u95ee\u5f62\u5f0f\u4e3a\u5185\u7f51\u8bbf\u95ee\uff0c\u8bbf\u95ee\u7684\u5185\u7f51Ip\u4e3a\uff1a" + config.getHost());
                this.ftp.setRemoteHost(config.getHost());
            }
            this.ftp.setUserName(config.getUsername());
            this.ftp.setPassword(config.getPassword());
            this.ftp.setRemotePort(config.getPort());
            this.ftp.setContentType(FTPTransferType.BINARY);
            this.ftp.getAdvancedFTPSettings().setConnectMode(FTPConnectMode.PASV);
            System.out.println("-----------------------------------------------------------------------------------");
            System.out.println("\u8bbf\u95ee\u5f62\u5f0f:" + accessUrl);
            System.out.println("---\tFtp host is:" + this.ftp.getRemoteHost() + "\t\t\t -----");
            System.out.println("---\tFtp port is:" + config.getPort() + "\t\t\t           -----");
            System.out.println("-----------------------------------------------------------------------------------");
        }
        catch (FTPException ftpe) {
            System.out.println("\u5efa\u7acb\u8fde\u63a5\u629b\u51fa\u5f02\u5e38:" + ftpe.getMessage());
            ftpe.printStackTrace();
            System.err.println("\u5b9e\u4f8b\u5316FileTransferClient \u629b\u51fa\u5f02\u5e38" + ftpe.getMessage());
            throw new Exception("\u5b9e\u4f8b\u5316FileTransferClient \u629b\u51fa\u5f02\u5e38", ftpe);
        }
    }

    public FMEEdFtpImpl(String host, int port, String username, String password) throws Exception {
        System.out.println("FMEEdFtpImpl");
        try {
            this.ftp = new FileTransferClient();
            this.config = new FtpConfig();
            this.ftp.setRemoteHost(host);
            this.config.setHost(host);
            this.ftp.setUserName(username);
            this.config.setUsername(username);
            this.ftp.setPassword(password);
            this.config.setPassword(password);
            this.config.setPort(port);
            this.ftp.setRemotePort(port);
            this.ftp.setContentType(FTPTransferType.BINARY);
        }
        catch (FTPException ftpe) {
            System.out.println("\u5efa\u7acb\u8fde\u63a5\u629b\u51fa\u5f02\u5e38:" + ftpe.getMessage());
            ftpe.printStackTrace();
            throw new Exception("\u5b9e\u4f8b\u5316FileTransferClient \u629b\u51fa\u5f02\u5e38", ftpe);
        }
    }

    private void createNewFtp() throws Exception {
        try {
            this.ftp2 = new FileTransferClient();
            this.ftp2.setRemoteHost(this.config.getHost());
            this.ftp2.setUserName(this.config.getUsername());
            this.ftp2.setPassword(this.config.getPassword());
        }
        catch (FTPException ftpe) {
            System.err.println("\u5b9e\u4f8b\u5316FileTransferClient \u629b\u51fa\u5f02\u5e38" + ftpe.getMessage());
            throw new Exception("\u5b9e\u4f8b\u5316FileTransferClient \u629b\u51fa\u5f02\u5e38", ftpe);
        }
    }

    private FileTransferClient createExtFtp(FtpConfig extConfig) throws Exception {
        FileTransferClient ftp3 = null;
        try {
            ftp3 = new FileTransferClient();
            ftp3.setRemoteHost(extConfig.getHost());
            ftp3.setUserName(extConfig.getUsername());
            ftp3.setPassword(extConfig.getPassword());
        }
        catch (FTPException ftpe) {
            System.err.println("\u5b9e\u4f8b\u5316createExtFtp FileTransferClient \u629b\u51fa\u5f02\u5e38" + ftpe.getMessage());
            throw new Exception("\u5b9e\u4f8b\u5316createExtFtp FileTransferClient \u629b\u51fa\u5f02\u5e38", ftpe);
        }
        return ftp3;
    }

    @Override
    public boolean connect() {
        boolean conResult = false;
        try {
            System.out.println("\u5efa\u7acb\u8054\u7ed3");
            if (this.ftp == null) {
                System.err.println("FMEEdFtpImpl\u5b9e\u4f8b\u6ca1\u6709\u521b\u5efa\uff0c\u65e0\u6cd5\u5efa\u7acb\u8ddf\u670d\u52a1\u5668\u7684\u8054\u7ed3");
                conResult = false;
            } else if (!this.ftp.isConnected()) {
                this.ftp.connect();
                System.out.println("<<<<<<<<<<<<<<<<<<<\u5efa\u7acb\u8ddfFTP\u670d\u52a1\u5668\u7684\u8054\u7ed3");
                conResult = true;
            } else {
                System.out.println("\u5df2\u7ecf\u5efa\u7acb\u8ddfFTP\u670d\u52a1\u5668\u7684\u8054\u7ed3\uff0c\u65e0\u9700\u91cd\u65b0\u5efa\u7acb\u8054\u7ed3");
                conResult = true;
            }
        }
        catch (Exception se) {
            System.out.println("\u5efa\u7acb\u8fde\u63a5\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            se.printStackTrace();
            conResult = false;
        }
        System.out.println("\u5efa\u7acb\u8054\u7ed3\u7684\u7ed3\u679c\uff1aconResult=" + conResult);
        return conResult;
    }

    @Override
    public boolean disconnect() {
        boolean discResult = false;
        try {
            if (this.ftp.isConnected()) {
                this.ftp.disconnect();
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>\u65ad\u5f00\u8ddfFTP\u670d\u52a1\u5668\u7684\u8054\u7ed3");
                discResult = true;
            } else {
                System.out.println("\u6587\u4ef6\u670d\u52a1\u5668\u6ca1\u6709\u5efa\u7acb\u8054\u7ed3\uff0c\u4e0d\u9700\u8981\u5173\u95ed");
                discResult = true;
            }
        }
        catch (Exception se) {
            System.out.println("\u5efa\u7acb\u8fde\u63a5\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            se.printStackTrace();
            discResult = false;
        }
        return discResult;
    }

    public void checkConnect() {
        if (!this.ftp.isConnected()) {
            System.out.println("\u8ddfFtp\u670d\u52a1\u5668\u6ca1\u6709\u5efa\u7acb\u8054\u7ed3");
            this.connect();
        } else {
            System.out.println("\u8ddfFtp\u670d\u52a1\u5668\u5df2\u7ecf\u5efa\u7acb\u8054\u7ed3");
        }
    }

    @Override
    public boolean exists(String remoteFileName) throws Exception {
        boolean retResult = false;
        this.checkConnect();
        retResult = this.ftp.exists(remoteFileName);
        System.out.println("\u5224\u65adFTP\u670d\u52a1\u6587\u4ef6\u662f\u5426\u5b58\u5728:" + remoteFileName);
        this.disconnect();
        return retResult;
    }

    @Override
    public boolean delete(String remoteFileName) throws Exception {
        boolean delResult = false;
        this.checkConnect();
        if (this.ftp.exists(remoteFileName)) {
            this.ftp.deleteFile(remoteFileName);
            delResult = true;
        } else {
            System.out.println("\u8981\u5220\u9664\u7684\u6587\u4ef6" + remoteFileName + "\u4e0d\u5b58\u5728 \u4e0d\u9700\u8981\u5220\u9664");
            delResult = true;
        }
        System.out.println("\u5220\u9664FTP\u670d\u52a1\u6587\u4ef6:" + remoteFileName);
        this.disconnect();
        return delResult;
    }

    @Override
    public void download(String localFileName, String remoteFileName) throws Exception {
        this.checkConnect();
        this.ftp.downloadFile(localFileName, remoteFileName);
        System.out.println("\u4eceFTP\u670d\u52a1\u5668\u4e0a\u4e0b\u8f7d\u6587\u4ef6:" + remoteFileName);
        System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u672c\u5730\u4fdd\u5b58\u4e3a:" + localFileName);
    }

    @Override
    public void rename(String ftpName, String newName) {
        this.checkConnect();
        try {
            this.ftp.rename(ftpName, newName);
        }
        catch (Exception se) {
            System.err.println("\u91cd\u547d\u540d\u6587\u4ef6" + ftpName + "\u4e3a" + newName + "\u629b\u51fa\u5f02\u5e38" + se.getMessage());
        }
    }

    @Override
    public String upload(String localFileName, String remoteFileName) throws Exception {
        this.checkConnect();
        String uploadResult = "";
        try {
            uploadResult = this.ftp.uploadFile(localFileName, remoteFileName);
            System.out.println("\u4e0a\u4f20\u672c\u5730\u6587\u4ef6:" + localFileName);
            System.out.println("\u4e0a\u4f20\u5230FTP\u8def\u5f84:" + remoteFileName);
        }
        catch (Exception se) {
            System.err.println("FMEEdFtpImpl\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u53ef\u80fd\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728" + se.getMessage());
            throw new Exception("FMEEdFtpImpl\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u53ef\u80fd\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728", se);
        }
        return uploadResult;
    }

    public void uploadStream(String remoteFileName) throws Exception {
        this.checkConnect();
        FileTransferOutputStream ftos = this.ftp.uploadStream(remoteFileName);
        byte[] buffer = new byte[TransferFile_Cache];
        int readV = -1;
        while ((readV = this.fis.read(buffer)) != -1) {
            ftos.write(buffer, 0, readV);
        }
        ftos.close();
        this.fis.close();
        System.out.println("\u4e0a\u4f20\u5230FTP\u8def\u5f84:" + remoteFileName);
    }

    public static String[] getUploadSaveDirAndName(String uploadFileName) {
        String[] dnArray = new String[2];
        int fpos = uploadFileName.lastIndexOf(ROOT_DIR);
        if (fpos != -1) {
            dnArray[0] = uploadFileName.substring(0, fpos);
            dnArray[1] = uploadFileName.substring(fpos + 1);
        } else {
            dnArray[0] = "";
            dnArray[1] = uploadFileName;
        }
        return dnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uploadStream_back(InputStream is, String remoteFileName) throws Exception {
        int uploadResult = 2;
        try {
            this.checkConnect();
            remoteFileName = SafeCheckUtils.cleanPathString(remoteFileName);
            int isAV = is.available();
            System.out.println("\u8f93\u5165\u6d41\u53ef\u7528\u7684\u4e3a:" + isAV);
            System.out.println("\u9884\u4e0a\u4f20\u6587\u4ef6\u4e3a:" + remoteFileName);
            String[] fileDirNameArray = FMEEdFtpImpl.getUploadSaveDirAndName(remoteFileName);
            System.out.println("\u83b7\u53d6\u4e0a\u4f20\u7684\u6587\u4ef6\u8def\u5f84:" + fileDirNameArray[0] + "---" + fileDirNameArray[1]);
            String fileDirs = fileDirNameArray[0];
            String[] dirArray = fileDirs.split(ROOT_DIR);
            StringBuffer filePathBuffer = new StringBuffer();
            for (int di = 0; di < dirArray.length; ++di) {
                String oneDir = dirArray[di];
                try {
                    filePathBuffer.append(oneDir);
                    this.ftp.createDirectory(filePathBuffer.toString());
                    System.out.println("\u521b\u5efa\u76ee\u5f55" + oneDir);
                    continue;
                }
                catch (Exception se) {
                    System.out.println("\u76ee\u5f55" + filePathBuffer.toString() + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u521b\u5efa");
                    continue;
                }
                finally {
                    filePathBuffer.append(ROOT_DIR);
                }
            }
            try {
                if (!this.ftp.exists(fileDirs)) {
                    this.ftp.createDirectory(fileDirs);
                    System.out.println("\u521b\u5efa\u76ee\u5f55" + fileDirs);
                }
            }
            catch (Exception se) {
                System.out.println("\u76ee\u5f55" + fileDirs + "\u5df2\u7ecf\u5b58\u5728");
            }
            this.changeDir(fileDirNameArray[0]);
            System.out.println("\u6267\u884c\u6587\u4ef6\u4e0a\u4f20");
            FileTransferOutputStream ftos = this.ftp.uploadStream(fileDirNameArray[1]);
            byte[] buffer = new byte[TransferFile_Cache];
            int readV = -1;
            String blockArray = "";
            boolean isCancel = false;
            try {
                while ((readV = is.read(buffer)) != -1) {
                    byte[] temp = FMEDataZipUtils.pack(buffer);
                    blockArray = blockArray + temp.length + ",";
                    ftos.write(temp);
                }
                uploadResult = 0;
            }
            catch (InterruptedIOException iio) {
                System.out.println("\u9644\u4ef6\u4e0a\u4f20\u88ab\u4e2d\u6b62" + iio.getMessage());
                isCancel = true;
            }
            finally {
                ftos.close();
                is.close();
            }
            String extFileName = fileDirNameArray[1].substring(0, fileDirNameArray[1].indexOf(PARENT_DIR) + 1) + "ext";
            FileTransferOutputStream ftosExt = this.ftp.uploadStream(extFileName);
            File extFile = new File(FMEUIUtils.getClientTempDir() + File.separator + extFileName);
            BufferedWriter output = new BufferedWriter(new FileWriter(extFile));
            output.write(blockArray);
            output.close();
            FileInputStream extIs = new FileInputStream(extFile);
            buffer = new byte[TransferFile_Cache];
            readV = -1;
            isCancel = false;
            try {
                while ((readV = extIs.read(buffer)) != -1) {
                    ftosExt.write(buffer, 0, readV);
                }
                uploadResult = 0;
            }
            catch (InterruptedIOException iio) {
                System.out.println("\u9644\u4ef6\u4e0a\u4f20\u88ab\u4e2d\u6b62" + iio.getMessage());
                isCancel = true;
            }
            finally {
                ftosExt.close();
                extIs.close();
            }
            try {
                extFile.delete();
            }
            catch (Exception e) {
                System.out.println("\u5220\u9664\u52a0\u5bc6\u9644\u52a0\u6587\u4ef6\u51fa\u9519!" + e.getMessage());
            }
            if (isCancel) {
                System.out.println("\u6b63\u5728\u4e0a\u4f20\u7684\u6587\u4ef6\u88ab\u4e2d\u6b62\uff0c\u9700\u8981\u6e05\u9664\u5783\u573e\u6587\u4ef6");
                this.changeDir(PARENT_DIR);
                this.changeDir(PARENT_DIR);
                boolean deleteCancelResult = this.delete(remoteFileName);
                System.out.println("\u6e05\u9664\u88ab\u4e2d\u6b62\u7684\u6587\u4ef6\u7ed3\u679c\u4e3a:" + deleteCancelResult);
                uploadResult = 1;
            } else {
                System.out.println("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5");
                System.out.println("\u4e0a\u4f20\u5230FTP\u8def\u5f84:" + remoteFileName);
            }
        }
        catch (Exception se) {
            se.printStackTrace();
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            uploadResult = 2;
        }
        finally {
            this.disconnect();
        }
        return uploadResult;
    }

    private boolean fobidZipFileType(String uploadFileName) {
        boolean allowZip = false;
        ArrayList<String> fileType = new ArrayList<String>();
        fileType.add("pdf");
        fileType.add("xlsx");
        fileType.add("pptx");
        fileType.add("wmv");
        fileType.add("asf");
        fileType.add("wma");
        fileType.add("wm");
        fileType.add("avi");
        fileType.add("mpg");
        fileType.add("mpeg");
        fileType.add("mp3");
        fileType.add("mid");
        fileType.add("midi");
        fileType.add("rmi");
        fileType.add("wav");
        fileType.add("vob");
        fileType.add("txt");
        int index = uploadFileName.lastIndexOf(PARENT_DIR);
        String uploadFileType = "";
        if (index != -1) {
            uploadFileType = uploadFileName.substring(index + 1);
            uploadFileType = uploadFileType.toLowerCase();
        }
        if (fileType.indexOf(uploadFileType) != -1) {
            allowZip = true;
        }
        return allowZip;
    }

    @Override
    public int uploadStream(InputStream is, String remoteFileName) throws Exception {
        return this.uploadStream(is, remoteFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int uploadStream(InputStream is, String remoteFileName, boolean isNewPackMethod) throws Exception {
        System.out.println("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a:" + remoteFileName);
        System.out.println("uploadStream(InputStream is, String remoteFileName)");
        int uploadResult = 2;
        try {
            this.checkConnect();
            int isAV = is.available();
            System.out.println("\u8f93\u5165\u6d41\u53ef\u7528\u7684\u4e3a:" + isAV);
            System.out.println("\u9884\u4e0a\u4f20\u6587\u4ef6\u4e3a:" + remoteFileName);
            String[] fileDirNameArray = FMEEdFtpImpl.getUploadSaveDirAndName(remoteFileName);
            System.out.println("\u83b7\u53d6\u4e0a\u4f20\u7684\u6587\u4ef6\u8def\u5f84:" + fileDirNameArray[0] + "---" + fileDirNameArray[1]);
            String fileDirs = fileDirNameArray[0];
            String[] dirArray = fileDirs.split(ROOT_DIR);
            StringBuffer filePathBuffer = new StringBuffer();
            for (int di = 0; di < dirArray.length; ++di) {
                String oneDir = dirArray[di];
                try {
                    filePathBuffer.append(oneDir);
                    this.ftp.createDirectory(filePathBuffer.toString());
                    System.out.println("\u521b\u5efa\u76ee\u5f55" + oneDir);
                    continue;
                }
                catch (Exception se) {
                    System.out.println("\u76ee\u5f55" + filePathBuffer.toString() + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u521b\u5efa");
                    continue;
                }
                finally {
                    filePathBuffer.append(ROOT_DIR);
                }
            }
            try {
                if (!this.ftp.exists(fileDirs)) {
                    this.ftp.createDirectory(fileDirs);
                    System.out.println("\u521b\u5efa\u76ee\u5f55" + fileDirs);
                }
            }
            catch (Exception se) {
                System.out.println("\u76ee\u5f55" + fileDirs + "\u5df2\u7ecf\u5b58\u5728");
            }
            this.changeDir(fileDirNameArray[0]);
            System.out.println("\u6267\u884c\u6587\u4ef6\u4e0a\u4f20");
            FileTransferOutputStream ftos = this.ftp.uploadStream(fileDirNameArray[1]);
            byte[] buffer = new byte[TransferFile_Cache];
            int readV = -1;
            StringBuffer blockSB = new StringBuffer();
            boolean isCancel = false;
            boolean isAllowZip = this.fobidZipFileType(remoteFileName);
            System.out.println("isAllowZip:" + isAllowZip);
            try {
                String blockStr;
                byte[] temp;
                if (isAllowZip) {
                    while ((readV = is.read(buffer)) != -1) {
                        ftos.write(buffer, 0, readV);
                    }
                } else if (isNewPackMethod) {
                    while ((readV = is.read(buffer)) != -1) {
                        if (readV != buffer.length) {
                            byte[] tmpBuffer = new byte[readV];
                            System.arraycopy(buffer, 0, tmpBuffer, 0, Math.min(buffer.length, readV));
                            byte[] temp2 = FMEDataZipUtils.pack(tmpBuffer);
                            blockSB.append(temp2.length).append(",");
                            ftos.write(temp2);
                            continue;
                        }
                        temp = FMEDataZipUtils.pack(buffer);
                        blockSB.append(temp.length).append(",");
                        ftos.write(temp);
                    }
                    blockStr = blockSB.toString();
                    int blockLength = blockStr.length();
                    String blockFoot = "" + blockLength;
                    int blockFootLength = 10 - blockFoot.length();
                    for (int i = 0; i < blockFootLength; ++i) {
                        blockFoot = blockFoot + "#";
                    }
                    blockFoot = blockFoot + EXT_FLAG;
                    String prefixBlockInfo = blockStr + blockFoot;
                    ftos.write(prefixBlockInfo.getBytes());
                } else {
                    while ((readV = is.read(buffer)) != -1) {
                        temp = FMEDataZipUtils.pack(buffer);
                        blockSB.append(temp.length).append(",");
                        ftos.write(temp);
                    }
                    blockStr = blockSB.toString();
                    int blockLength = blockStr.length();
                    String blockFoot = "" + blockLength;
                    int blockFootLength = 10 - blockFoot.length();
                    for (int i = 0; i < blockFootLength; ++i) {
                        blockFoot = blockFoot + "#";
                    }
                    blockFoot = blockFoot + EXT_FLAG;
                    String prefixBlockInfo = blockStr + blockFoot;
                    ftos.write(prefixBlockInfo.getBytes());
                }
                uploadResult = 0;
            }
            catch (InterruptedIOException iio) {
                System.out.println("\u9644\u4ef6\u4e0a\u4f20\u88ab\u4e2d\u6b62" + iio.getMessage());
                isCancel = true;
            }
            finally {
                ftos.close();
                is.close();
            }
            if (isCancel) {
                System.out.println("\u6b63\u5728\u4e0a\u4f20\u7684\u6587\u4ef6\u88ab\u4e2d\u6b62\uff0c\u9700\u8981\u6e05\u9664\u5783\u573e\u6587\u4ef6");
                this.changeDir(PARENT_DIR);
                this.changeDir(PARENT_DIR);
                boolean deleteCancelResult = this.delete(remoteFileName);
                System.out.println("\u6e05\u9664\u88ab\u4e2d\u6b62\u7684\u6587\u4ef6\u7ed3\u679c\u4e3a:" + deleteCancelResult);
                uploadResult = 1;
            } else {
                System.out.println("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5");
                System.out.println("\u4e0a\u4f20\u5230FTP\u8def\u5f84:" + remoteFileName);
            }
        }
        catch (Exception se) {
            se.printStackTrace();
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            uploadResult = 2;
        }
        finally {
            this.disconnect();
        }
        return uploadResult;
    }

    public void showDirOrFileInfo(String dir) throws Exception {
        System.out.println("Dir " + dir + "file is follows :");
        String[] descriptions = this.ftp.directoryNameList(dir, true);
        for (int i = 0; i < descriptions.length; ++i) {
            System.out.println("Dir Or File " + i + " is:" + descriptions[i]);
        }
    }

    public void showFileDetailInfo() throws Exception {
        FTPFile[] files = this.ftp.directoryList();
        for (int i = 0; i < files.length; ++i) {
            FTPFile oneFTPFile = files[i];
            StringBuffer sb = new StringBuffer();
            sb.append("Group ").append(oneFTPFile.getGroup()).append("\nLinkedName ").append(oneFTPFile.getLinkedName()).append("\nName ").append(oneFTPFile.getName()).append("\nOwner ").append(oneFTPFile.getOwner()).append("\nPath ").append(oneFTPFile.getPath()).append("\nPermissions ").append(oneFTPFile.getPermissions()).append("\nRaw ").append(oneFTPFile.getRaw());
            System.out.println(sb.toString());
        }
    }

    @Override
    public void changeDir(String newDir) throws Exception {
        this.checkConnect();
        String directory = this.ftp.getRemoteDirectory();
        System.out.println("currentRemoteDirection is:" + directory);
        if (newDir.equals(PARENT_DIR)) {
            this.ftp.changeToParentDirectory();
            System.out.println("\u5207\u6362\u5230\u4e0a\u5c42\u76ee\u5f55");
        } else {
            String[] pathGrade = newDir.split(ROOT_DIR);
            for (int i = 0; i < pathGrade.length; ++i) {
                this.ftp.changeDirectory(pathGrade[i]);
            }
            System.out.println("\u5207\u6362\u5230\u76ee\u5f55" + newDir);
        }
    }

    public void makeDir(String newDir) throws Exception {
        this.checkConnect();
        System.out.println("currentRemoteDirection is:" + this.ftp.getRemoteDirectory());
        System.out.println("\u4f60\u9700\u8981\u521b\u5efa\u7684\u76ee\u5f55\u4e3a:" + newDir);
        try {
            this.ftp.createDirectory(newDir);
        }
        catch (Exception se) {
            System.err.println("\u521b\u5efaFTP\u76ee\u5f55" + newDir + "\u5931\u8d25" + se.getMessage());
        }
    }

    public void deleteDir(String delDir) throws Exception {
        this.checkConnect();
        System.out.println("currentRemoteDirection is:" + this.ftp.getRemoteDirectory());
        System.out.println("\u4f60\u9700\u8981\u5220\u9664\u7684\u76ee\u5f55\u4e3a:" + delDir);
        try {
            this.ftp.deleteDirectory(delDir);
        }
        catch (Exception se) {
            System.err.println("\u5220\u9664FTP\u76ee\u5f55" + delDir + "\u5931\u8d25" + se.getMessage());
        }
    }

    @Override
    public InputStream getInputStream(String uploadFile) {
        try {
            if (this.fis == null) {
                this.fis = new FileInputStream(new File(uploadFile));
            }
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        return this.fis;
    }

    @Override
    public FileTransferInputStream getUploadStream(String remoteFile) {
        this.checkConnect();
        FileTransferInputStream downStream = null;
        try {
            downStream = this.ftp.downloadStream(remoteFile);
        }
        catch (Exception se) {
            System.err.println("\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u6d41\u629b\u51fa\u5f02\u5e38" + se.getMessage());
        }
        return downStream;
    }

    @Override
    public boolean downloadStream(FMEFtpInputStream dis, String localFileName) throws Exception {
        this.checkConnect();
        boolean downloadResult = false;
        FileOutputStream fos = new FileOutputStream(localFileName);
        byte[] buffer = new byte[TransferFile_Cache];
        int readV = -1;
        try {
            while ((readV = dis.read(buffer)) != -1) {
                fos.write(buffer, 0, readV);
            }
            downloadResult = true;
        }
        catch (InterruptedIOException iio) {
            System.out.println("\u9644\u4ef6\u4e0b\u8f7d\u88ab\u4e2d\u6b62" + iio.getMessage());
        }
        fos.close();
        dis.close();
        System.out.println("\u4e0b\u8f7dFTP\u6587\u4ef6\u5230\u672c\u5730:" + localFileName);
        this.disconnect();
        return downloadResult;
    }

    @Override
    public boolean downloadStreamByFileName(String remoteFileName, String localFileName) throws Exception {
        localFileName = SafeCheckUtils.cleanPathString(localFileName);
        System.out.println("FMEEdFtpImpl::downloadStreamByFileName()-----parameters are ,remoteFileName=" + remoteFileName + ",localFileName=" + localFileName);
        this.checkConnect();
        byte[] buffer = new byte[TransferFile_Cache];
        int readV = -1;
        String[] blockArry = this.getFileZipBlockArray(this.ftp, remoteFileName);
        System.out.println("FMEEdFtpImpl::downloadStreamByFileName()-----blockArry=" + blockArry);
        boolean downloadResult = false;
        System.out.println("FMEEdFtpImpl::downloadStreamByFileName()-----ftp.downloadStream(remoteFileName)--begin,remoteFileName=" + remoteFileName);
        FileTransferInputStream ftis = this.ftp.downloadStream(remoteFileName);
        System.out.println("FMEEdFtpImpl::downloadStreamByFileName()-----ftp.downloadStream(remoteFileName)--end,remoteFileName=" + remoteFileName);
        FileOutputStream fos = new FileOutputStream(localFileName);
        buffer = new byte[TransferFile_Cache];
        readV = -1;
        try {
            if (blockArry != null) {
                for (int i = 0; i < blockArry.length; ++i) {
                    buffer = new byte[Integer.parseInt(blockArry[i])];
                    if (ftis.read(buffer) == -1) continue;
                    byte[] temp = FMEDataZipUtils.unpack(buffer);
                    fos.write(temp);
                }
            } else {
                while ((readV = ftis.read(buffer)) != -1) {
                    fos.write(buffer, 0, readV);
                }
            }
            downloadResult = true;
            System.out.println("FMEEdFtpImpl::downloadStreamByFileName()-----FMEDataZipUtils.unpack() is ok! downloadResult=" + downloadResult);
        }
        catch (InterruptedIOException iio) {
            System.out.println("\u9644\u4ef6\u4e0b\u8f7d\u88ab\u4e2d\u6b62" + iio.getMessage());
        }
        fos.close();
        ftis.close();
        System.out.println("\u4e0b\u8f7dFTP\u6587\u4ef6\u5230\u672c\u5730:" + localFileName);
        this.disconnect();
        return downloadResult;
    }

    @Override
    public boolean downloadStreamByFileName(String remoteFileName, OutputStream ots, DocumentBO oneBO) throws Exception {
        this.checkConnect();
        byte[] buffer = new byte[TransferFile_Cache];
        int readV = -1;
        String[] blockArry = this.getFileZipBlockArray(this.ftp, remoteFileName);
        boolean downloadResult = false;
        FileTransferInputStream ftis = this.ftp.downloadStream(remoteFileName);
        try {
            if (blockArry != null) {
                int len = blockArry.length;
                for (int i = 0; i < len; ++i) {
                    buffer = new byte[Integer.parseInt(blockArry[i])];
                    if (ftis.read(buffer) == -1) continue;
                    byte[] temp = FMEDataZipUtils.unpack(buffer);
                    if (i == len - 1) {
                        int disIndex = oneBO.getSize() % TransferFile_Cache;
                        byte[] temp2 = new byte[disIndex];
                        System.arraycopy(temp, 0, temp2, 0, disIndex);
                        ots.write(temp2);
                        continue;
                    }
                    ots.write(temp);
                }
            } else {
                while ((readV = ftis.read(buffer)) != -1) {
                    ots.write(buffer, 0, readV);
                }
            }
            downloadResult = true;
        }
        catch (InterruptedIOException iio) {
            System.out.println("\u9644\u4ef6\u4e0b\u8f7d\u88ab\u4e2d\u6b62" + iio.getMessage());
        }
        ots.flush();
        ots.close();
        ftis.close();
        this.disconnect();
        return downloadResult;
    }

    @Override
    public boolean downloadStreamByFileName(String remoteFileName, String localFileName, DocumentBO oneBO) throws Exception {
        this.checkConnect();
        byte[] buffer = new byte[TransferFile_Cache];
        int readV = -1;
        String[] blockArry = this.getFileZipBlockArray(this.ftp, remoteFileName);
        boolean downloadResult = false;
        FileTransferInputStream ftis = this.ftp.downloadStream(remoteFileName);
        FileOutputStream fos = new FileOutputStream(SafeCheckUtils.cleanPathString(localFileName));
        buffer = new byte[TransferFile_Cache];
        readV = -1;
        try {
            if (blockArry != null) {
                int len = blockArry.length;
                for (int i = 0; i < len; ++i) {
                    buffer = new byte[Integer.parseInt(blockArry[i])];
                    if (ftis.read(buffer) == -1) continue;
                    byte[] temp = FMEDataZipUtils.unpack(buffer);
                    if (i == len - 1 && oneBO != null) {
                        int disIndex = oneBO.getSize() % TransferFile_Cache;
                        byte[] temp2 = new byte[disIndex];
                        System.arraycopy(temp, 0, temp2, 0, disIndex);
                        fos.write(temp2);
                        continue;
                    }
                    fos.write(temp);
                }
            } else {
                while ((readV = ftis.read(buffer)) != -1) {
                    fos.write(buffer, 0, readV);
                }
            }
            downloadResult = true;
        }
        catch (InterruptedIOException iio) {
            System.out.println("\u9644\u4ef6\u4e0b\u8f7d\u88ab\u4e2d\u6b62" + iio.getMessage());
        }
        fos.close();
        ftis.close();
        System.out.println("\u4e0b\u8f7dFTP\u6587\u4ef6\u5230\u672c\u5730:" + localFileName);
        this.disconnect();
        return downloadResult;
    }

    public String[] getFileZipBlockArray(FileTransferClient ftp, String remoteFileName) {
        String[] blockArry;
        block16: {
            remoteFileName = SafeCheckUtils.cleanPathString(remoteFileName);
            blockArry = null;
            int readV = -1;
            byte[] buffer = new byte[TransferFile_Cache];
            String extFileName = remoteFileName.substring(0, remoteFileName.lastIndexOf(PARENT_DIR) + 1) + "ext";
            try {
                boolean existZipExtFile = ftp.exists(extFileName);
                if (existZipExtFile) {
                    System.out.println("\u5b58\u5728\u52a0\u5bc6\u8f85\u52a9\u6587\u4ef6\uff0c\u6839\u636e\u7b2c\u4e00\u79cd\u52a0\u5bc6\u65b9\u5f0f\u89e3\u5bc6\u5904\u7406");
                    FileTransferInputStream extftis = null;
                    try {
                        extftis = ftp.downloadStream(extFileName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (extftis != null) {
                        String[] fileDirNameArray = FMEEdFtpImpl.getUploadSaveDirAndName(SafeCheckUtils.cleanPathString(extFileName));
                        File extFile = new File(FMEUIUtils.getClientTempDir() + fileDirNameArray[1]);
                        FileOutputStream extFos = new FileOutputStream(extFile);
                        while ((readV = extftis.read(buffer)) != -1) {
                            extFos.write(buffer, 0, readV);
                        }
                        extftis.close();
                        extFos.close();
                        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(extFile)));
                        String lineString = "";
                        while ((lineString = br.readLine()) != null) {
                            blockArry = lineString.split(",");
                        }
                        br.close();
                        try {
                            extFile.delete();
                        }
                        catch (Exception e) {
                            System.out.println("\u5220\u9664\u52a0\u5bc6\u9644\u52a0\u6587\u4ef6\u51fa\u9519:" + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    break block16;
                }
                System.out.println("\u4e0d\u5b58\u5728\u52a0\u5bc6\u8f85\u52a9\u6587\u4ef6\uff0c\u6839\u636e\u7b2c\u4e8c\u79cd\u52a0\u5bc6\u65b9\u5f0f\u89e3\u5bc6\u5904\u7406");
                long fileSize = ftp.getSize(remoteFileName);
                if (fileSize > 20L) {
                    FileTransferInputStream ftis = ftp.downloadStream(remoteFileName);
                    byte[] end20Byte = new byte[20];
                    ftis.skip(fileSize - 20L);
                    int readCount = ftis.read(end20Byte, 0, 20);
                    ftis.close();
                    String lastEnd = new String(end20Byte);
                    if (lastEnd.endsWith(EXT_FLAG)) {
                        int firstPos = lastEnd.indexOf("#");
                        if (firstPos != -1) {
                            String extraBlockSize = lastEnd.substring(0, firstPos);
                            int blockLength = Integer.parseInt(extraBlockSize);
                            byte[] blockByte = new byte[blockLength];
                            ftis = ftp.downloadStream(remoteFileName);
                            ftis.skip(fileSize - (long)blockLength - 20L);
                            ftis.read(blockByte, 0, blockLength);
                            ftis.close();
                            String blockStr = new String(blockByte);
                            blockArry = blockStr.split(",");
                        } else {
                            System.out.println("\u6587\u4ef6\u7684\u52a0\u5bc6block\u957f\u5ea6\u8d85\u8fc710G,\u89e3\u5bc6\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38");
                        }
                    } else {
                        System.out.println("\u6ca1\u6709\u52a0\u5bc6\u6587\u4ef6\u6807\u8bc6");
                    }
                } else {
                    System.out.println("\u6587\u4ef6\u6ca1\u6709\u7ecf\u8fc7\u52a0\u5bc6\u5904\u7406");
                }
            }
            catch (Exception se) {
                System.out.println("\u83b7\u53d6\u52a0\u5bc6\u6587\u4ef6\u7684\u538b\u7f29Block\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
            }
        }
        return blockArry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int downloadStream(Component monitorParentCom, Object monitorMessage, String remoteFileName, String localFileName, String downloadIndex, DocumentBO docBo) throws Exception {
        int downloadStatus = -1;
        try {
            this.checkConnect();
            if (!this.ftp.isConnected()) {
                System.out.println("================================\u670d\u52a1\u5668\u5efa\u7acb\u8054\u7ed3\u5931\u8d25");
                downloadStatus = -1;
                return downloadStatus;
            }
        }
        catch (Exception se) {
            System.out.println("================================\u670d\u52a1\u5668\u5efa\u7acb\u8054\u7ed3\u5931\u8d25");
            downloadStatus = -1;
            return downloadStatus;
        }
        try {
            byte[] buffer = new byte[TransferFile_Cache];
            int readV = -1;
            String[] blockArry = this.getFileZipBlockArray(this.ftp, remoteFileName);
            FileOutputStream fos = new FileOutputStream(localFileName);
            long fileSize = this.ftp.getSize(remoteFileName);
            FileTransferInputStream ftis = this.ftp.downloadStream(remoteFileName);
            FMEFtpInputStream dis = new FMEFtpInputStream(monitorParentCom, monitorMessage, ftis, (int)fileSize);
            dis.setUpload(false);
            dis.setProgressIndex(downloadIndex);
            try {
                if (blockArry != null) {
                    int len = blockArry.length;
                    for (int i = 0; i < len; ++i) {
                        int blockArrInt = Integer.parseInt(blockArry[i]);
                        buffer = new byte[blockArrInt];
                        if (dis.read(buffer) == -1) continue;
                        byte[] temp = FMEDataZipUtils.unpack(buffer);
                        if (i == len - 1) {
                            int disIndex = docBo.getSize() % TransferFile_Cache;
                            byte[] temp2 = new byte[disIndex];
                            System.arraycopy(temp, 0, temp2, 0, disIndex);
                            fos.write(temp2);
                            continue;
                        }
                        fos.write(temp);
                    }
                    dis.updateUnzipPregress();
                } else {
                    while ((readV = dis.read(buffer)) != -1) {
                        fos.write(buffer, 0, readV);
                    }
                }
                downloadStatus = 1;
            }
            catch (InterruptedIOException iio) {
                System.out.println("---------------------------------\u9644\u4ef6\u4e0b\u8f7d\u88ab\u4e2d\u6b62" + iio.getMessage());
                downloadStatus = 0;
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (dis != null) {
                        dis.close();
                    }
                    if (ftis != null) {
                        ftis.close();
                    }
                }
                catch (Exception se) {
                    System.out.println("\u53d6\u6d88\u4e0b\u8f7d\u6587\u4ef6\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
                    se.printStackTrace();
                }
                if (downloadStatus == 0) {
                    try {
                        File cancelDownloadFile = new File(localFileName);
                        if (cancelDownloadFile.exists()) {
                            boolean deleteCancelDownloadFile = cancelDownloadFile.delete();
                            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u8fc7\u7a0b\u88ab\u4e2d\u6b62\uff0c\u5220\u9664\u53d6\u6d88\u7684\u6587\u4ef6" + localFileName + " \u7ed3\u679c\u4e3a\uff1a" + deleteCancelDownloadFile);
                        }
                    }
                    catch (Exception rcEx) {
                        System.out.println("\u5220\u9664\u53d6\u6d88\u4e0b\u8f7d\u7684\u6587\u4ef6\u629b\u51fa\u5f02\u5e38:" + rcEx.getMessage());
                    }
                }
            }
        }
        catch (Exception se) {
            se.printStackTrace();
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u539f\u56e0\u53ef\u80fd\u4e3a\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\u4e86\uff1a" + se.getMessage());
            downloadStatus = -2;
        }
        System.out.println("\u4e0b\u8f7dFTP\u6587\u4ef6\u5230\u672c\u5730:" + localFileName);
        this.disconnect();
        return downloadStatus;
    }

    @Override
    public long getFileSize(String file) {
        long size = 0L;
        this.checkConnect();
        try {
            size = this.ftp.getSize(file);
        }
        catch (Exception se) {
            System.err.println("\u83b7\u53d6Ftp\u6587\u4ef6\u5927\u5c0f\u629b\u51fa\u5f02\u5e38" + se.getMessage());
            size = -1L;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String initFileName, String destFileName) throws Exception {
        this.checkConnect();
        try {
            long beginTime = System.currentTimeMillis();
            if (destFileName == null || destFileName.trim().length() <= 0) {
                destFileName = "temp" + initFileName;
            } else if (destFileName.trim().equalsIgnoreCase(initFileName)) {
                destFileName = "\u590d\u4ef6" + initFileName;
            }
            this.ftp.getAdvancedFTPSettings().setConnectMode(FTPConnectMode.PASV);
            FileTransferInputStream fis = this.ftp.downloadStream(initFileName);
            try {
                if (this.ftp2 == null) {
                    this.createNewFtp();
                }
                this.ftp2.connect();
                FileTransferOutputStream fos = this.ftp2.uploadStream(destFileName);
                byte[] buffer = new byte[TransferFile_Cache];
                int readSize = 0;
                while ((readSize = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, readSize);
                }
                fos.close();
                fis.close();
            }
            catch (Exception se) {
                System.err.println("\u901a\u8fc7\u4e24\u4e2a\u6d41\u590d\u5236\u6587\u4ef6\u629b\u51fa\u5f02\u5e38" + se.getMessage());
            }
            finally {
                if (this.ftp2 != null && this.ftp2.isConnected()) {
                    this.ftp2.disconnect();
                }
            }
            long endTime = System.currentTimeMillis();
            System.out.println("\u590d\u5236\u6587\u4ef6:" + initFileName + "\u8d39\u65f6\u4e3a:" + (endTime - beginTime));
        }
        catch (Exception se) {
            throw new Exception("\u590d\u5236\u6587\u4ef6\u629b\u51fa\u5f02\u5e38" + se.getMessage(), se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String initFileName, String destFileName, FileTransferClient targetFtpClient) throws Exception {
        this.checkConnect();
        try {
            long beginTime = System.currentTimeMillis();
            if (destFileName == null || destFileName.trim().length() <= 0) {
                destFileName = "temp" + initFileName;
            } else if (destFileName.trim().equalsIgnoreCase(initFileName)) {
                destFileName = "\u590d\u4ef6" + initFileName;
            }
            this.ftp.getAdvancedFTPSettings().setConnectMode(FTPConnectMode.PASV);
            FileTransferInputStream fis = this.ftp.downloadStream(initFileName);
            try {
                targetFtpClient.connect();
                FileTransferOutputStream fos = targetFtpClient.uploadStream(destFileName);
                byte[] buffer = new byte[TransferFile_Cache];
                int readSize = 0;
                while ((readSize = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, readSize);
                }
                fos.close();
                fis.close();
            }
            catch (Exception se) {
                System.err.println("\u901a\u8fc7\u4e24\u4e2a\u6d41\u590d\u5236\u6587\u4ef6\u629b\u51fa\u5f02\u5e38" + se.getMessage());
            }
            finally {
                if (targetFtpClient != null && targetFtpClient.isConnected()) {
                    targetFtpClient.disconnect();
                }
            }
            long endTime = System.currentTimeMillis();
            System.out.println("\u590d\u5236\u6587\u4ef6:" + initFileName + "\u8d39\u65f6\u4e3a:" + (endTime - beginTime));
        }
        catch (Exception se) {
            throw new Exception("\u590d\u5236\u6587\u4ef6\u629b\u51fa\u5f02\u5e38" + se.getMessage(), se);
        }
    }

    @Override
    public List checkFtpLink() {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (this.ftp == null) {
            retList.add(new Boolean(false));
            retList.add("\u83b7\u53d6\u5bf9\u5e94\u7684FTP Instance \u4e3anull");
        } else if (this.connect() && this.disconnect()) {
            retList.add(new Boolean(true));
            retList.add("\u6d4b\u8bd5\u8fde\u63a5\u6b63\u5e38");
        } else {
            retList.add(new Boolean(false));
            retList.add("\u6d4b\u8bd5\u8fde\u63a5\u3001\u65ad\u5f00\u8fde\u63a5\u5931\u8d25!!!");
        }
        return retList;
    }

    @Override
    public boolean renameRootPath(String sourceFtpRootPath, String targetFtpRootPath) {
        boolean renameResult = false;
        this.checkConnect();
        try {
            this.ftp.rename(sourceFtpRootPath, targetFtpRootPath);
            renameResult = true;
        }
        catch (Exception se) {
            System.err.println("renameRootPath\u629b\u51fa\u5f02\u5e38" + se.getMessage());
            renameResult = false;
        }
        return renameResult;
    }

    @Override
    public boolean transferOneDocument(String sourceFilePath, String taregetFilePath) throws Exception {
        boolean transResult = false;
        try {
            this.copyFile(sourceFilePath, taregetFilePath);
            transResult = true;
        }
        catch (Exception se) {
            transResult = false;
            System.out.println("\u4f20\u8f93\u5355\u4e2a\u6587\u4ef6,\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
        }
        return transResult;
    }

    @Override
    public boolean transferOneDocumentWithMutilFtp(String sourceFilePath, String taregetFilePath, FtpConfig extConfig) throws Exception {
        boolean transResult = false;
        try {
            FileTransferClient extFtp = this.createExtFtp(extConfig);
            this.copyFile(sourceFilePath, taregetFilePath, extFtp);
            extFtp.disconnect();
            transResult = true;
        }
        catch (Exception se) {
            transResult = false;
            System.out.println("\u4f20\u8f93\u5355\u4e2a\u6587\u4ef6,\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
        }
        return transResult;
    }

    private List getDirectoryFileList(String dir, String parentDir) throws IOException, FTPException {
        ArrayList<String> fileList = new ArrayList<String>();
        System.out.println("\u5b9a\u4f4d\u7236\u76ee\u5f55\u4e3a\uff1a" + parentDir);
        System.out.println("\u5b9a\u4f4d\u5f53\u524d\u76ee\u5f55\u4e3a\uff1a" + dir);
        String currentParentDir = parentDir;
        if (!FMEUIUtils.isBlankString(currentParentDir)) {
            this.ftp.changeDirectory(ROOT_DIR + parentDir);
        }
        this.ftp.changeDirectory(dir);
        String[] filelist = this.ftp.directoryNameList();
        boolean modifyParentDir = false;
        for (int i = 0; i < filelist.length; ++i) {
            String oneDirFile = filelist[i];
            if (oneDirFile.indexOf(PARENT_DIR) == -1) {
                if (!modifyParentDir) {
                    currentParentDir = FMEUIUtils.isBlankString(currentParentDir) ? dir : currentParentDir + ROOT_DIR + dir;
                    modifyParentDir = true;
                }
                List subDirFile = this.getDirectoryFileList(oneDirFile, currentParentDir);
                System.out.println("\u589e\u52a0\u5b50\u6587\u4ef6\uff1a" + subDirFile.size());
                fileList.addAll(subDirFile);
                continue;
            }
            if (!FMEUIUtils.isBlankString(parentDir)) {
                fileList.add(parentDir + ROOT_DIR + dir + ROOT_DIR + oneDirFile);
                continue;
            }
            fileList.add(dir + ROOT_DIR + oneDirFile);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FtpDocumentInfo getFtpDocumentInfo(String serverID, String rootPath) throws Exception {
        FtpDocumentInfo ftpDocInfo = new FtpDocumentInfo(serverID, rootPath);
        try {
            this.ftp.connect();
            List fileList = this.getDirectoryFileList(rootPath, "");
            for (int i = 0; i < fileList.size(); ++i) {
                ftpDocInfo.addDocument((String)fileList.get(i));
            }
        }
        catch (ConnectException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception sex) {
            System.out.println("\u83b7\u53d6\u6307\u5b9aFTP\u670d\u52a1\u5668\u7684\u6839\u76ee\u5f55\u4e0b\u7684\u6240\u6709\u6587\u4ef6\u4fe1\u606f\uff0c\u629b\u51fa\u5f02\u5e38:" + sex.getMessage());
            sex.printStackTrace();
        }
        finally {
            if (this.ftp.isConnected()) {
                this.ftp.disconnect();
            }
        }
        return ftpDocInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createSavePath(String rootPath, String pathName) throws Exception {
        boolean createResult = false;
        try {
            this.ftp.connect();
            this.changeDirToRootPath(rootPath);
            try {
                if (!this.ftp.exists(pathName)) {
                    this.ftp.createDirectory(pathName);
                    System.out.println("\u521b\u5efa\u5b58\u50a8\u8def\u5f84:" + pathName);
                }
            }
            catch (Exception se) {
                System.out.println("\u5b58\u50a8\u8def\u5f84:" + pathName + "\u5df2\u7ecf\u5b58\u5728");
            }
            createResult = true;
        }
        catch (Exception sex) {
            System.out.println("createSavePath\u629b\u51fa\u5f02\u5e38:" + sex.getMessage());
            sex.printStackTrace();
        }
        finally {
            this.ftp.disconnect();
        }
        return createResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateSavePath(String rootPath, String oldPathName, String newPathName) throws Exception {
        boolean updateResult = false;
        try {
            this.ftp.connect();
            this.changeDirToRootPath(rootPath);
            try {
                this.ftp.changeDirectory(oldPathName);
                this.ftp.changeToParentDirectory();
                this.ftp.rename(oldPathName, newPathName);
                System.out.println("\u5b58\u50a8\u8def\u5f84\u6709" + oldPathName + "\u6539\u540d\u4e3a" + newPathName);
            }
            catch (Exception se) {
                System.out.println("\u65e7\u7684\u5b58\u50a8\u8def\u5f84:" + oldPathName + "\u4e0d\u5b58\u5728");
                try {
                    if (!this.ftp.exists(newPathName)) {
                        this.ftp.createDirectory(newPathName);
                        System.out.println("\u521b\u5efa\u5b58\u50a8\u8def\u5f84:" + newPathName);
                    }
                }
                catch (Exception se2) {
                    System.out.println("\u5b58\u50a8\u8def\u5f84:" + newPathName + "\u5df2\u7ecf\u5b58\u5728");
                }
                updateResult = true;
            }
            updateResult = true;
        }
        catch (Exception sex) {
            System.out.println("updateSavePath\u629b\u51fa\u5f02\u5e38:" + sex.getMessage());
            sex.printStackTrace();
        }
        finally {
            this.ftp.disconnect();
        }
        return updateResult;
    }

    @Override
    public void changeDirToRootPath(String rootPath) throws Exception {
        try {
            if (!this.ftp.exists(rootPath)) {
                this.ftp.createDirectory(rootPath);
                System.out.println("\u521b\u5efa\u5b58\u50a8\u6839\u8def\u5f84:" + rootPath);
            }
        }
        catch (Exception se) {
            System.out.println("\u5b58\u50a8\u6839\u8def\u5f84:" + rootPath + "\u5df2\u7ecf\u5b58\u5728");
        }
        this.ftp.changeDirectory(rootPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteSavePath(String rootPath, String pathName) throws Exception {
        boolean delResult = false;
        try {
            this.ftp.connect();
            this.changeDirToRootPath(rootPath);
            try {
                this.ftp.changeDirectory(pathName);
                this.ftp.changeToParentDirectory();
                System.out.println("\u5b58\u50a8\u8def\u5f84:" + pathName + "\u5df2\u7ecf\u5b58\u5728,\u51c6\u5907\u5220\u9664");
                this.ftp.deleteDirectory(pathName);
                try {
                    this.ftp.changeDirectory(pathName);
                    this.ftp.changeToParentDirectory();
                    System.out.println("\u5b58\u50a8\u8def\u5f84:" + pathName + "\u5220\u9664\u4e0d\u6210\u529f");
                    delResult = false;
                }
                catch (Exception ssse) {
                    System.out.println("\u5b58\u50a8\u8def\u5f84:" + pathName + "\u5df2\u7ecf\u5220\u9664");
                    delResult = true;
                }
            }
            catch (Exception se) {
                System.out.println("\u5b58\u50a8\u8def\u5f84:" + pathName + "\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u5220\u9664");
                delResult = true;
            }
        }
        catch (Exception sex) {
            System.out.println("deleteSavePath\u629b\u51fa\u5f02\u5e38:" + sex.getMessage());
            sex.printStackTrace();
        }
        finally {
            this.ftp.disconnect();
        }
        return delResult;
    }
}

