/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ftp;

import com.kingdee.eas.base.fme.ui.IFMEUI;
import com.kingdee.eas.base.fme.util.FtpUtils;
import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.ProgressMonitor;

public class FMEFtpInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private int nread = 0;
    private int size = 0;
    private static int GRESS_FLAG = 0x100000;
    private int readAllCount = 0;
    private int readingCountInOneUpdate = 0;
    private long oneUpdateBeginTime = 0L;
    private long oneUpdateEndTime = 0L;
    private boolean beginUpdateCaculate = true;
    private String progressPercentValue;
    private String progressVelocityValue;
    private IFMEUI progessObj;
    private boolean showMoniter = false;
    private String progressIndex;
    private boolean isUpload = true;

    public FMEFtpInputStream(Component parentComponent, Object message, InputStream in) {
        super(in);
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0;
        }
        this.monitor = new ProgressMonitor(parentComponent, message, null, 0, this.size);
    }

    public FMEFtpInputStream(Component parentComponent, Object message, InputStream in, int isSize) {
        super(in);
        this.size = isSize;
        System.out.println("\u64cd\u4f5c\u6587\u4ef6\u7684\u5927\u5c0f\u4e3a:" + isSize);
        this.beginUpdateCaculate = true;
        this.readingCountInOneUpdate = 0;
        this.readAllCount = 0;
        if (parentComponent instanceof IFMEUI) {
            this.progessObj = (IFMEUI)((Object)parentComponent);
        }
        this.monitor = new ProgressMonitor(parentComponent, message, null, 0, this.size);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public String getProgressPercentValue() {
        return this.progressPercentValue;
    }

    public void setProgressPercentValue(String progressPercentValue) {
        this.progressPercentValue = progressPercentValue;
    }

    public String getProgressVelocityValue() {
        return this.progressVelocityValue;
    }

    public void setProgressVelocityValue(String progressVelocityValue) {
        this.progressVelocityValue = progressVelocityValue;
    }

    public void setShowMoniter(boolean showMoniter) {
        this.showMoniter = showMoniter;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.monitor.setProgress(++this.nread);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nread;
            throw exc;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        this.readingCountInOneUpdate += nr;
        this.readAllCount += nr;
        if (this.beginUpdateCaculate) {
            this.oneUpdateBeginTime = System.currentTimeMillis();
            this.beginUpdateCaculate = false;
        }
        if (this.readingCountInOneUpdate > GRESS_FLAG) {
            float uploadPercent = (float)this.readAllCount / (float)this.size;
            String percentStr = "" + (uploadPercent *= 100.0f);
            int pPos = percentStr.indexOf(".");
            String perValue = "";
            perValue = pPos != -1 ? Integer.parseInt(("" + uploadPercent).substring(0, pPos)) + "%" : percentStr + "%";
            this.oneUpdateEndTime = System.currentTimeMillis();
            long wastedTime = this.oneUpdateEndTime - this.oneUpdateBeginTime;
            String downloadV = "";
            if (wastedTime != 0L) {
                float transferV = (float)this.readingCountInOneUpdate / (float)wastedTime;
                String floatVStr = "" + transferV;
                int fpos = floatVStr.indexOf(".");
                if (fpos != -1) {
                    floatVStr = floatVStr.substring(0, fpos);
                }
                String speedValue = "";
                try {
                    speedValue = FtpUtils.getFileSize(Integer.parseInt(floatVStr) * 1000);
                }
                catch (Exception se) {
                    System.out.println("\u8f6c\u5316\u901f\u7387\u9519\u8bef\uff0c\u4e0d\u6267\u884c\u8f6c\u5316\u5904\u7406" + se.getMessage());
                    speedValue = floatVStr + "kb";
                }
                downloadV = speedValue + "/sec";
            }
            this.setProgressPercentValue(perValue);
            this.setProgressVelocityValue(downloadV);
            if (this.progessObj != null) {
                this.progessObj.updateProgress(this);
            }
            this.beginUpdateCaculate = true;
            this.readingCountInOneUpdate = 0;
        }
        if (this.readAllCount == this.size) {
            System.out.println("\u5f53\u524d\u8bfb\u53d6\u7684\u6587\u4ef6\u5927\u5c0f:" + this.readAllCount + "-------\u8bbe\u7f6e\u5927\u5c0f\u4e3a" + this.size);
            this.setProgressPercentValue("100%");
            if (this.progessObj != null) {
                this.progessObj.updateProgress(this);
            }
        }
        if (this.progessObj != null && this.progessObj.cancelProgress()) {
            InterruptedIOException exc = new InterruptedIOException("\u4e0b\u8f7d\u88ab\u4e2d\u6b62\u53d6\u6d88");
            exc.bytesTransferred = this.nread;
            throw exc;
        }
        if (this.showMoniter) {
            if (nr > 0) {
                this.monitor.setProgress(this.nread += nr);
            }
            if (this.monitor.isCanceled()) {
                InterruptedIOException exc = new InterruptedIOException("progress");
                exc.bytesTransferred = this.nread;
                throw exc;
            }
        }
        return nr;
    }

    public void updateUnzipPregress() {
        this.setProgressPercentValue("100%");
        if (this.progessObj != null) {
            this.progessObj.updateProgress(this);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        System.out.println("\u8bfb\u53d6\u5b57\u8282:" + nr);
        if (nr > 0) {
            this.monitor.setProgress(this.nread += nr);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.nread;
            throw exc;
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.monitor.setProgress(this.nread);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.monitor.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.monitor.setProgress(this.nread);
    }

    public String getProgressIndex() {
        return this.progressIndex;
    }

    public void setProgressIndex(String progressIndex) {
        this.progressIndex = progressIndex;
    }

    public boolean isUpload() {
        return this.isUpload;
    }

    public void setUpload(boolean isUpload) {
        this.isUpload = isUpload;
    }
}

