/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ftp;

import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferClient;
import com.kingdee.eas.base.fme.ftp.ConnectionObject;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.ftp.TimerListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FtpConnectionPool
implements TimerListener {
    private static final int MAX_FTPLINK = 3;
    private List ftpConn;
    private FtpConfig config;
    private static FtpConnectionPool connPool;

    private FtpConnectionPool(FtpConfig config) {
        this.config = config;
        this.initialize();
    }

    public boolean initialize() {
        boolean initializeResult = false;
        this.ftpConn = new ArrayList();
        try {
            for (int i = 0; i < 3; ++i) {
                FileTransferClient ftp = new FileTransferClient();
                ftp.setRemoteHost(this.config.getHost());
                ftp.setUserName(this.config.getUsername());
                ftp.setPassword(this.config.getPassword());
                ftp.setRemotePort(this.config.getPort());
                ftp.setContentType(FTPTransferType.BINARY);
                ConnectionObject oneConntionObj = new ConnectionObject(ftp, false);
                this.ftpConn.add(oneConntionObj);
            }
            System.out.println(">>>>>>>>>>>>>>>>>>===========================\u521d\u59cb\u5316\u5efa\u7acb3\u4e2a\u5ba2\u6237\u7aefFTP\u8054\u7ed3");
        }
        catch (Exception se) {
            se.printStackTrace();
            System.out.println("\u5b9e\u4f8b\u5316Ftp\u8054\u7ed3\u6c60\u629b\u51fa\u5f02\u5e38" + se.getMessage());
            initializeResult = false;
        }
        return initializeResult;
    }

    public void destroy() {
        int connectionObjectSize = this.ftpConn.size();
        if (connectionObjectSize > 0) {
            System.out.println("\u8fde\u63a5\u6570\u4e3a\uff1a" + connectionObjectSize);
            for (ConnectionObject oneConn : this.ftpConn) {
                try {
                    if (oneConn == null) continue;
                    oneConn.getFtp().disconnect();
                }
                catch (Exception se) {
                    System.out.println("\u91ca\u653eFtp\u8fde\u63a5\u6c60");
                }
            }
        } else {
            System.out.println("\u8fde\u63a5\u4e2a\u6570\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u9500\u6bc1");
        }
    }

    public synchronized FileTransferClient getFtp() {
        FileTransferClient oneFtp = null;
        Iterator iter = this.ftpConn.iterator();
        boolean hasUnUsing = false;
        while (iter.hasNext()) {
            ConnectionObject oneConn = (ConnectionObject)iter.next();
            try {
                if (oneConn.isInUse()) continue;
                oneFtp = oneConn.getFtp();
                hasUnUsing = true;
            }
            catch (Exception se) {
                System.out.println("\u91ca\u653eFtp\u8fde\u63a5\u6c60");
            }
        }
        if (!hasUnUsing) {
            System.out.println("\u5f53\u524d\u5ba2\u6237\u7aef\u7684\u5355\u6b21\u7684\u8fde\u63a5\u6570\u5df2\u7ecf\u8d85\u8fc7\u4e863\u4e2a,\u6ca1\u6709\u53ef\u7528\u7684\u8054\u7ed3");
        }
        return oneFtp;
    }

    public synchronized void close() {
    }

    @Override
    public synchronized void timerEvent() {
    }
}

