/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.ui;

import com.kingdee.eas.base.fme.action.FMECancelServiceAction;
import com.kingdee.eas.base.fme.action.FMEDeleteServiceAction;
import com.kingdee.eas.base.fme.action.FMEQueryServiceAction;
import com.kingdee.eas.base.fme.action.FMERenameServiceAction;
import com.kingdee.eas.base.fme.action.FMEReplyServiceAction;
import com.kingdee.eas.base.fme.action.FMEUploadOpenFileServiceAction;
import com.kingdee.eas.base.fme.action.FMEUploadServiceAction;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.ftp.FMEFtpInputStream;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.ui.AbstractFMEUI;
import com.kingdee.eas.base.fme.ui.FMECustomLabel;
import com.kingdee.eas.base.fme.ui.FMEProgressFactory;
import com.kingdee.eas.base.fme.ui.FMEUIPanel;
import com.kingdee.eas.base.fme.ui.FMEUIRes;
import com.kingdee.eas.base.fme.ui.IFMEProgressBar;
import com.kingdee.eas.base.fme.uimodel.FMEFileElement;
import com.kingdee.eas.base.fme.uimodel.FMEFileObject;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FtpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.json.JSONArray;

public class FMEUploadPanel
extends AbstractFMEUI
implements ActionListener {
    private JButton addButton;
    private JButton uploadLB;
    private JButton loginB;
    private GridBagConstraints gbdc = null;
    private static Map limitSizeMap = new HashMap();
    private static Map cumulateTypeSizeMap = new HashMap();
    private JLabel messageLabel = null;
    private JPanel progressPanel = null;
    private JLabel progressLabel = null;
    private String[] uploadFileUUIDArray = null;
    private int currentUUID = 0;
    private JButton loadFileB;
    private IFMEProgressBar fmePBPanel;
    private FMECustomLabel addFileLinkLabel;
    private FMECustomLabel newFileLinkLabel;
    private JLabel cancelUploadLinkLabel;
    private boolean needNotify = true;
    private boolean canCancel = false;

    public FMEUploadPanel(int clientType, int onlineSave, int onlineOpen) {
        super(clientType, onlineSave, onlineOpen);
        this.setLayout(new GridBagLayout());
        this.createFileInfoPanel(clientType);
        this.setPreferredSize(new Dimension(600, 200));
        this.gbdc = new GridBagConstraints();
        this.gbdc.anchor = 13;
        this.gbdc.fill = 1;
        this.gbdc.weightx = 0.0;
        this.gbdc.weighty = 0.0;
        JPanel operPanel = this.createOperStatuePanel();
        operPanel.addMouseListener(this.fmePanel);
        this.add((Component)operPanel, this.gbdc);
        this.gbdc.gridx = 0;
        this.gbdc.gridheight = 1;
        this.add((Component)this.fmePanel, this.gbdc);
        this.setBackground(Color.white);
        this.setForeground(Color.white);
    }

    public void resizePanel(int fileSize, int uiPanelHeight) {
        int panelHeight = 200 + fileSize * 50;
        panelHeight = uiPanelHeight + 50;
        this.getApplet().resSizeAppletSize(600, panelHeight);
        this.getApplet().validate();
        this.getApplet().repaint();
        this.setPreferredSize(new Dimension(600, panelHeight));
        this.validate();
        this.repaint();
        this.getApplet().validate();
        this.getApplet().repaint();
    }

    private JPanel createOperStatuePanel() {
        FlowLayout fLT = new FlowLayout();
        fLT.setAlignment(0);
        JPanel operPanel = new JPanel(fLT);
        operPanel.setBackground(Color.white);
        operPanel.setForeground(Color.white);
        boolean allowUpload = this.getParam().isAllowUpload();
        this.newFileLinkLabel = new FMECustomLabel("\u521b\u5efa\u65b0\u6587\u4ef6", false);
        this.newFileLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FMEUploadPanel.this.getApplet().createNewFile();
            }
        });
        operPanel.add((Component)this.newFileLinkLabel, 0);
        int onlineSave = this.getParam().getOnlineCreate();
        if (onlineSave != 1) {
            this.newFileLinkLabel.setVisible(false);
        }
        this.addFileLinkLabel = new FMECustomLabel("\u6dfb\u52a0\u65b0\u6587\u4ef6", false);
        String allowAdd = this.getParam().getAllowAdd();
        this.addFileLinkLabel.setVisible(null == allowAdd ? allowUpload : "1".equals(allowAdd));
        this.addFileLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FMECustomLabel fmecLable = (FMECustomLabel)e.getSource();
                    if (fmecLable.enabled) {
                        FMEUploadPanel.this.browserFile(FMEUIRes.DEFAULT_DIR_PATH);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        if (!allowUpload) {
            // empty if block
        }
        operPanel.add((Component)this.addFileLinkLabel, 0);
        this.cancelUploadLinkLabel = new FMECustomLabel("\u53d6\u6d88\u4e0a\u4f20", false);
        this.cancelUploadLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FMEUploadPanel.this.stopProgress();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.cancelUploadLinkLabel.setVisible(false);
        operPanel.add(this.cancelUploadLinkLabel);
        this.fmePBPanel = FMEProgressFactory.createFMEProgressBar();
        this.uploadLB = new JButton("\u4e0a\u4f20");
        operPanel.add(this.uploadLB);
        this.uploadLB.setVisible(false);
        this.uploadLB.addActionListener(this);
        this.loginB = new JButton("\u767b\u9646");
        this.loginB.addActionListener(this);
        operPanel.add(this.loginB);
        this.loadFileB = new JButton("\u52a0\u8f7d\u6587\u4ef6");
        operPanel.add(this.loadFileB);
        this.loadFileB.addActionListener(this);
        if (this.getClientType() == 1) {
            this.loginB.setVisible(false);
            this.loadFileB.setVisible(false);
        } else {
            this.uploadLB.setVisible(false);
            this.loginB.setVisible(false);
            this.loadFileB.setVisible(false);
        }
        this.messageLabel = new FMECustomLabel("");
        operPanel.add(this.messageLabel);
        operPanel.add((JPanel)((Object)this.fmePBPanel));
        return operPanel;
    }

    public void initialLimitFileSize(String allowTypeFilesSize) {
        System.out.println("allowTypeFilesSize = " + allowTypeFilesSize);
        limitSizeMap.clear();
        String[] fileTypeStr = allowTypeFilesSize.split(",");
        for (int i = 0; i < fileTypeStr.length; ++i) {
            if ("".equals(fileTypeStr[i])) continue;
            String[] limits = fileTypeStr[i].split(":");
            limitSizeMap.put(limits[0].toUpperCase(), FtpUtils.convertFileSizeToBytes(limits[1]));
        }
        System.out.println("size of limitSizeMap: " + limitSizeMap.size());
    }

    private void createFileInfoPanel(int clientType) {
        this.fmePanel = new FMEUIPanel(clientType);
        this.fmePanel.setPanelType(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.addButton) {
            this.browserFile(FMEUIRes.DEFAULT_DIR_PATH);
        } else if (src == this.uploadLB) {
            this.uploadFile(this.getNewBusinessID());
        } else if (src == this.loadFileB) {
            this.loadDownloadFile("");
        } else {
            System.out.println("\u64cd\u4f5c\u5bf9\u8c61:" + src.getClass());
        }
    }

    public List getUploadFile(String dir) {
        String openFile;
        ArrayList<String[]> retList = new ArrayList<String[]>();
        Frame myFrame = new Frame();
        FileDialog cfd = new FileDialog(myFrame, "\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", 0);
        String[] pathAndName = new String[]{"", ""};
        cfd.setFile("*.*");
        System.out.println(cfd.getDirectory());
        cfd.setDirectory(dir);
        cfd.setVisible(true);
        String retPath = "";
        if (limitSizeMap.size() == 0) {
            this.initialLimitFileSize(this.getParam().getAllowTypeFilesSize());
        }
        if ((openFile = cfd.getFile()) != null) {
            Object[] options;
            int res;
            String openFileType = FMEUIUtils.getFileExtName(openFile);
            String openFilePath = cfd.getDirectory();
            String forbidFileType = this.getParam().getForbidFileType();
            String allowFileType = this.getParam().getAllowFileType();
            boolean needAlert = false;
            String confirmInfo = "";
            if (!FMEUIUtils.isBlankString(allowFileType) && !FMEUIUtils.isAllowFile(openFileType, allowFileType)) {
                confirmInfo = "\u9009\u62e9\u7684" + openFileType + "\u7c7b\u578b\u6587\u4ef6,\u4e0d\u662f\u5141\u8bb8\u4e0a\u4f20\u7684" + allowFileType + "\u7c7b\u578b\u6587\u4ef6!";
                needAlert = true;
            } else if (FMEUIUtils.isForbidFile(openFileType, forbidFileType + "," + "udd")) {
                confirmInfo = openFileType.equals("udd") ? "\u7981\u6b62\u4e0a\u4f20\u672a\u77e5\u7c7b\u578b\u7684\u6587\u4ef6" : "\u7981\u6b62\u4e0a\u4f20\u7c7b\u578b\u4e3a" + openFileType + "\u6587\u4ef6";
                needAlert = true;
            }
            if (!needAlert) {
                String uploadFilePathName = cfd.getDirectory() + openFile;
                long allowMaxSize = this.getParam().getAllowSize();
                String sizeUnit = this.getParam().getSizeUnit();
                long fileNumSize = FtpUtils.getFileNumberSize(uploadFilePathName);
                long specFileSize = this.getAllowTypeFileSize(openFileType.toUpperCase());
                long updateFileSize = this.fmePanel.getAllFileSize();
                if (specFileSize != -1L && specFileSize < allowMaxSize - updateFileSize) {
                    if (specFileSize < fileNumSize) {
                        needAlert = true;
                        confirmInfo = "" + openFileType.toUpperCase() + "\u683c\u5f0f\u6587\u6863\u4e0a\u4f20\u603b\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + FtpUtils.convertSizeBySizeUnit(specFileSize, sizeUnit) + sizeUnit;
                    }
                } else if (allowMaxSize > 0L) {
                    if (allowMaxSize < fileNumSize + updateFileSize) {
                        needAlert = true;
                        long totalSize = FtpUtils.convertSizeBySizeUnit(fileNumSize + updateFileSize, sizeUnit);
                        long unitSize = FtpUtils.convertSizeBySizeUnit(allowMaxSize, sizeUnit);
                        confirmInfo = "\u4e0a\u4f20\u6587\u4ef6\u7684\u603b\u5927\u5c0f" + totalSize + sizeUnit + "\uff0c\u5df2\u8d85\u8fc7\u4e86\u6700\u5927\u5141\u8bb8\u8303\u56f4" + unitSize + sizeUnit;
                    }
                } else {
                    System.out.println("\u6ca1\u6709\u8bbe\u7f6e\u9650\u5236\u6587\u6863\u7684\u5927\u5c0f");
                }
            }
            retPath = needAlert ? ((res = JOptionPane.showOptionDialog(this, confirmInfo, "\u8b66\u544a", 0, 2, null, options = new Object[]{"\u786e\u5b9a"}, options[0])) == 0 ? "reChooseNewFile" : "") : cfd.getDirectory() + openFile;
            pathAndName[0] = openFilePath;
            pathAndName[1] = retPath;
        } else {
            this.showFMEMessage("\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6");
            this.getApplet().resetAppletFocus();
        }
        cfd.setVisible(false);
        myFrame.setVisible(false);
        this.fmePanel.repaint();
        this.validate();
        this.repaint();
        this.getParent().validate();
        this.getParent().repaint();
        this.updateUI();
        System.out.println("\u7236\u7a97\u4f53\u91cd\u7ed8\u5236updateUI");
        retList.add(pathAndName);
        return retList;
    }

    private boolean excessTypeSize(String openFileType, long fileNumSize) {
        long allowTypeSize;
        boolean rtnVal = false;
        if (limitSizeMap.containsKey(openFileType) && fileNumSize > (allowTypeSize = ((Long)limitSizeMap.get(openFileType)).longValue())) {
            rtnVal = true;
        }
        return rtnVal;
    }

    private long getAllowTypeFileSize(String openFileType) {
        long rtnVal = -1L;
        if (limitSizeMap.containsKey(openFileType)) {
            rtnVal = (Long)limitSizeMap.get(openFileType);
        }
        return rtnVal;
    }

    public List getUploadFileExt(String dir) {
        ArrayList<String[]> selectFile = new ArrayList<String[]>();
        String[] pathAndName = new String[]{"", ""};
        JFileChooser cfd = new JFileChooser();
        this.showFMEMessage("\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6");
        cfd.setMultiSelectionEnabled(true);
        String allowFileType = this.getParam().getAllowFileType();
        cfd.setFileSelectionMode(0);
        cfd.setFont(new Font("\u5b8b\u4f53", 0, 12));
        if (!FMEUIUtils.isBlankString(allowFileType)) {
            List filterList = FMEUIUtils.getAllowFileFMEFilter(allowFileType);
            int filterListSize = filterList.size();
            System.out.println("\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e3a:" + allowFileType + "--size :" + filterListSize);
            if (filterListSize > 0) {
                cfd.setAcceptAllFileFilterUsed(false);
                cfd.removeChoosableFileFilter(cfd.getFileFilter());
            }
            for (int i = 0; i < filterList.size(); ++i) {
                cfd.addChoosableFileFilter((FileFilter)filterList.get(i));
            }
        } else {
            System.out.println("\u6ca1\u6709\u8bbe\u7f6e\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4e3a\u6240\u6709\u6587\u4ef6\u7c7b\u578b");
            cfd.setAcceptAllFileFilterUsed(true);
        }
        File currentDir = null;
        currentDir = dir == null ? new File(".") : new File(dir);
        cfd.setCurrentDirectory(currentDir);
        cfd.setVisible(true);
        String retPath = "";
        int returnVal = cfd.showOpenDialog(this.addFileLinkLabel);
        if (returnVal == 0) {
            File[] files = cfd.getSelectedFiles();
            StringBuffer fbSB = new StringBuffer();
            int chooseFileCount = 0;
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String openFile = file.getName();
                String openFileType = FMEUIUtils.getFileExtName(openFile);
                String openFilePath = file.getParentFile().getAbsolutePath();
                if (FMEUIUtils.isForbidFile(openFileType, this.getParam().getForbidFileType() + "," + "udd")) {
                    if (fbSB.toString().indexOf(openFileType) != -1) continue;
                    if (openFileType.equals("udd")) {
                        if (fbSB.length() > 0) {
                            fbSB.append(",");
                        }
                        fbSB.append(openFileType);
                        continue;
                    }
                    if (fbSB.length() > 0) {
                        fbSB.append(",");
                    }
                    fbSB.append(openFileType);
                    continue;
                }
                pathAndName = new String[]{"", ""};
                retPath = openFilePath + File.separator + openFile;
                System.out.println("\u9009\u62e9\u7684\u6587\u4ef6:" + retPath);
                pathAndName[0] = openFilePath;
                pathAndName[1] = retPath;
                selectFile.add(pathAndName);
                ++chooseFileCount;
            }
            if (fbSB.length() > 0) {
                String confirmInfo = "\u7981\u6b62\u4e0a\u4f20\u7c7b\u578b\u4e3a" + fbSB.toString() + "\u7684\u6587\u4ef6";
                Object[] options = new Object[]{"\u786e\u5b9a"};
                pathAndName[0] = "";
                int res = JOptionPane.showOptionDialog(this, confirmInfo, "\u8b66\u544a", 0, 2, null, options, options[0]);
                if (res == 0 && chooseFileCount == 0) {
                    pathAndName[1] = retPath = "reChooseNewFile";
                    selectFile.add(pathAndName);
                }
            }
        } else {
            this.showFMEMessage("\u6ca1\u6709\u6307\u5b9a\u6587\u4ef6");
        }
        cfd.setVisible(false);
        this.fmePanel.repaint();
        this.updateUI();
        System.out.println("\u7236\u7a97\u4f53\u91cd\u7ed8\u5236updateUI");
        return selectFile;
    }

    public String getUploadFile_old() {
        Frame myFrame = new Frame();
        FileDialog cfd = new FileDialog(myFrame, "\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", 0);
        cfd.setFile("*.*");
        cfd.setDirectory(".");
        cfd.setVisible(true);
        String retPath = "";
        String openFile = cfd.getFile();
        if (openFile != null) {
            retPath = cfd.getDirectory() + openFile;
        }
        cfd.setVisible(false);
        myFrame.setVisible(false);
        System.out.println("\u5237\u65b0Panel");
        this.fmePanel.repaint();
        this.validate();
        this.repaint();
        this.getParent().validate();
        this.getParent().repaint();
        this.updateUI();
        System.out.println("\u7236\u7a97\u4f53\u91cd\u7ed8\u5236updateUI");
        return retPath;
    }

    public void browserFile(String dir) {
        System.out.println("=======================================================\u6d4f\u89c8\u6587\u4ef6=========");
        List chooseFile = new ArrayList();
        int allowFileType = this.getParam().getAllowMultiSelect();
        if (allowFileType == 0) {
            System.out.println("===================\u4e0d\u5141\u8bb8\u591a\u9009\u6587\u4ef6=========");
            chooseFile = this.getUploadFile(dir);
        } else {
            System.out.println("===================\u8bbe\u7f6e\u4e86\u5141\u8bb8\u591a\u9009\u6587\u4ef6=========");
            chooseFile = this.getUploadFileExt(dir);
        }
        for (int i = 0; i < chooseFile.size(); ++i) {
            String[] fileName = (String[])chooseFile.get(i);
            String fileNameValue = fileName[1];
            System.out.println("\u9009\u62e9\u6587\u4ef6:" + i + "" + fileNameValue);
            if (FtpUtils.isBlankString(fileNameValue)) continue;
            if (fileNameValue.equalsIgnoreCase("reChooseNewFile")) {
                this.browserFile(FMEUIRes.DEFAULT_DIR_PATH);
                continue;
            }
            System.out.println("=============================\u4e0a\u4f20\u9009\u62e9\u7684\u6587\u4ef6\u4e3a\uff1a" + fileNameValue);
            long fileNumSize = FtpUtils.getFileNumberSize(fileNameValue);
            if (fileNumSize > 0L) {
                this.showFMEMessage("");
                try {
                    this.fmePanel.addOneFile(fileNameValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("0\u5b57\u8282\u6587\u4ef6\u4e0d\u80fd\u4e0a\u4f20");
            this.showFMEMessage("\u4e0d\u80fd\u4e0a\u4f200\u5b57\u8282\u6587\u4ef6");
        }
    }

    @Override
    public void uploadFile(String businessID) {
        System.out.println("^^^^^^^^^^^^^^^*******************\u4e0a\u4f20\u524d\u6267\u884c\u9884\u6392\u5e8f\u5904\u7406");
        FMEFileObject fuObj = this.fmePanel.getUploadFileInfo();
        int uploadFileCount = fuObj.getUploadFileCount();
        System.out.println("\u9700\u8981\u4ece\u672c\u6b21\u4e0a\u4f20\u7684\u6587\u4ef6\u6709:" + uploadFileCount);
        this.showFMEMessage("");
        this.resetProgress();
        if (uploadFileCount > 0) {
            System.out.println("\u4e0a\u4f20" + uploadFileCount + "\u4efd\u6587\u4ef6:");
            this.uploadFileUUIDArray = fuObj.getUuid();
            System.out.println("\u4e0a\u4f20\u6587\u4ef6UUID is:" + this.uploadFileUUIDArray.length);
            this.currentUUID = 0;
            this.upload = true;
            FMEUploadServiceAction uploadCommand = new FMEUploadServiceAction(this, fuObj, businessID, this.getParam());
            Thread ts = new Thread(uploadCommand);
            ts.start();
            this.beginUploadShowProgress();
        } else {
            System.out.println("\u6ca1\u6709\u6587\u4ef6\u9700\u8981\u4e0a\u4f20");
            ServiceResult sr = new ServiceResult();
            sr.setResult(false, "\u6ca1\u6709\u6587\u4ef6\u9700\u8981\u4e0a\u4f20");
            this.doForwardWork(businessID, sr);
        }
    }

    @Override
    public void saveOpenFile(String[] filePath, String[] documentID) {
        String businessID = this.getParam().getQueryBusinessID();
        System.out.println("======saveOpenFile 20091130 fmeuploadPanel================" + filePath);
        System.out.println(businessID + "===================================");
        System.out.println(filePath[0] + "===================================");
        System.out.println("\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + businessID);
        if (FtpUtils.isBlankString(businessID)) {
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u6307\u5b9a\u7684BusinessID\u4e3a\u7a7a");
        } else {
            FMEFileObject uploadFileObj = new FMEFileObject(1);
            uploadFileObj.setFilePath(filePath);
            uploadFileObj.setDocumentID(documentID);
            FMEUploadOpenFileServiceAction uploadCommand = new FMEUploadOpenFileServiceAction(this, uploadFileObj, businessID, this.getParam());
            DocumentBO[] boinfo = uploadCommand.updateFile();
            if (boinfo != null && boinfo.length > 0) {
                System.out.println("loadFMEDocumentWithOperation ------------" + boinfo.length);
                FMEFileObject unLoadFiles = this.fmePanel.getUploadFileInfo();
                try {
                    this.fmePanel.loadFMEDocumentWithOperation(boinfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int unLoadFileCount = unLoadFiles.getUploadFileCount();
                System.out.println("\u9700\u8981\u589e\u52a0\u7684\u6587\u4ef6\u5305\u62ec\uff1a" + unLoadFileCount);
                for (int j = 0; j < unLoadFileCount; ++j) {
                    FMEFileElement fileEL = new FMEFileElement(unLoadFiles.getUuid()[j], unLoadFiles.getFilePath()[j], unLoadFiles.getFileName()[j], unLoadFiles.getFileSize()[j]);
                    System.out.println("fileEL is:" + fileEL.toJSON().toString());
                    try {
                        this.fmePanel.addOneFile(fileEL);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.validate();
                this.repaint();
                this.getParent().validate();
                this.getParent().repaint();
                this.updateUI();
            } else {
                ServiceResult sr = new ServiceResult();
                sr.setResult(false);
                sr.setResultMessge("\u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
                this.applet.notifyOuterServiceResult(sr);
                System.out.println(filePath[0] + "   \u4fdd\u5b58\u6587\u4ef6\u5931\u8d25!");
            }
        }
    }

    public void beginUploadShowProgress() {
        this.fmePBPanel.beginPB();
        this.addFileLinkLabel.setDisabled();
        this.newFileLinkLabel.setDisabled();
        this.fmePanel.setDisabled();
        this.cancelUploadLinkLabel.setVisible(true);
    }

    public void endUploadShowProgress() {
        this.fmePBPanel.endPB();
        this.cancelUploadLinkLabel.setVisible(false);
        this.addFileLinkLabel.setEnabled();
        this.newFileLinkLabel.setEnabled();
        this.fmePanel.setEnabled();
        this.fmePBPanel.endPB();
        this.upload = false;
    }

    private void doForwardWork(String businessID, ServiceResult sr) {
        FMEFileObject replyObj = this.fmePanel.getReplyFileInfo(this.getNewBusinessID());
        int replayFileCount = replyObj.getUuid().length;
        System.out.println("\u9700\u8981\u91cd\u65b0\u8f6c\u53d1\u7684\u6587\u4ef6\u6709:" + replayFileCount);
        if (replayFileCount > 0) {
            System.out.println("\u8f6c\u53d1" + replayFileCount + "\u4efd\u6587\u4ef6:");
            this.uploadFileUUIDArray = replyObj.getUuid();
            System.out.println("\u8f6c\u53d1\u6587\u4ef6UUID is:" + this.uploadFileUUIDArray.length);
            this.currentUUID = 0;
            this.upload = true;
            FMEReplyServiceAction uploadCommand = new FMEReplyServiceAction(this, replyObj.getFileName(), replyObj.getDocumentID(), businessID, this.getClientType());
            Thread ts = new Thread(uploadCommand);
            ts.start();
            this.beginUploadShowProgress();
        } else {
            System.out.println("\u6ca1\u6709\u9700\u8981\u8f6c\u53d1\u7684\u6587\u4ef6");
            this.endUploadShowProgress();
            this.applet.notifyOuterServiceResult(sr);
        }
    }

    @Override
    public void showFMEMessage(String message) {
        this.messageLabel.setText(message);
    }

    @Override
    public void updateProgress(FMEFtpInputStream fdis) {
        String percentV = fdis.getProgressPercentValue();
        String velocityV = fdis.getProgressVelocityValue();
        String uploadIndex = fdis.getProgressIndex();
        if (fdis.isUpload()) {
            this.fmePanel.updateUploadInfo(uploadIndex, percentV, velocityV);
        } else {
            String downloadIndex = fdis.getProgressIndex();
            this.fmePanel.updateDownInfo(downloadIndex, percentV, velocityV);
        }
    }

    @Override
    public void stopProgress() {
        this.cancelProgress = true;
        this.fmePBPanel.endPB();
    }

    public void stopProgressNotNotify() {
        this.cancelProgress = true;
        this.fmePBPanel.endPB();
        this.needNotify = false;
        this.canCancel = false;
    }

    @Override
    public void resetProgress() {
        this.cancelProgress = false;
        this.needNotify = true;
        this.canCancel = false;
    }

    @Override
    public boolean cancelProgress() {
        return this.cancelProgress;
    }

    @Override
    public void notifyServiceResult(ServiceResult serviceResult) {
        if (!this.needNotify) {
            System.out.println("\u53d6\u6d88\u4e0a\u4f20\u64cd\u4f5c\uff0c\u4e0d\u9700\u8981\u56de\u8c03\u901a\u77e5");
            this.canCancel = true;
            return;
        }
        String[] uploadDocmentID = serviceResult.getResultID();
        String newBusinessID = this.getNewBusinessID();
        this.fmePanel.setUploadFileResult(this.uploadFileUUIDArray, uploadDocmentID, newBusinessID);
        boolean canInvokeResult = false;
        switch (this.getParam().getOperType()) {
            case 0: {
                System.out.println("\u65b0\u589e\u7684\u6700\u540e\u4e00\u6b21\u901a\u77e5\uff0c\u9700\u8981\u901a\u77e5\u5916\u90e8Observer");
                canInvokeResult = true;
                break;
            }
            case 1: {
                if (serviceResult.isForword()) {
                    canInvokeResult = true;
                    System.out.println("\u8f6c\u53d1\u7684\u6700\u540e\u4e00\u6b21\u901a\u77e5\uff0c\u9700\u8981\u901a\u77e5\u5916\u90e8Observer");
                    break;
                }
                canInvokeResult = false;
                System.out.println("\u8f6c\u53d1\u7684\u7b2c\u4e00\u6b21\u901a\u77e5\uff0c\u4e0d\u9700\u8981\u901a\u77e5\u5916\u90e8Observer");
                serviceResult.setForword(true);
                if (null != serviceResult.getResultMessge()) break;
                this.doForwardWork(newBusinessID, serviceResult);
                break;
            }
            case 2: {
                System.out.println("\u56de\u590d\u7684\u6700\u540e\u4e00\u6b21\u901a\u77e5\uff0c\u9700\u8981\u901a\u77e5\u5916\u90e8Observer");
                canInvokeResult = true;
                break;
            }
            case 3: {
                System.out.println("\u67e5\u770b\u7684\u6700\u540e\u4e00\u6b21\u901a\u77e5\uff0c\u9700\u8981\u901a\u77e5\u5916\u90e8Observer");
                canInvokeResult = true;
                break;
            }
            default: {
                System.out.println("\u672a\u8bc6\u522b\u7684\u64cd\u4f5c\u72b6\u6001\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u5904\u7406");
            }
        }
        if (canInvokeResult) {
            this.endUploadShowProgress();
            if (serviceResult.isResult()) {
                this.showFMEMessage("\u4e0a\u4f20\u5b8c\u6210");
            } else {
                this.showFMEMessage(serviceResult.getResultMessge());
            }
            this.addFileLinkLabel.setEnabled(true);
            this.fmePanel.setEnabled(true);
            this.applet.notifyOuterServiceResult(serviceResult);
        }
    }

    @Override
    public boolean removeServerFile(String index, String documentID) {
        boolean deleteResult = false;
        String businessID = "";
        int operType = this.getParam().getOperType();
        if (operType == 0 || operType == 2) {
            System.out.println("\u5f53\u524d\u72b6\u6001\u4e3a\u65b0\u589e\u3001\u6216\u8005\u56de\u590d\uff0c\u53d6\u65b0\u589eBusinessID\u4e3a\u5220\u9664BID");
            businessID = this.getNewBusinessID();
        } else {
            System.out.println("\u5f53\u524d\u72b6\u6001\u4e3a\u8f6c\u53d1\uff0c\u4e5f\u53d6\u65b0\u589eBusinessID\u4e3a\u5220\u9664BID");
            businessID = this.getNewBusinessID();
        }
        if (FtpUtils.isBlankString(businessID)) {
            System.out.println("\u65e0\u6cd5\u5220\u9664BusinessID\u4e3a\u7a7a\u7684\u6587\u4ef6");
        } else {
            FMEDeleteServiceAction deleteSA = new FMEDeleteServiceAction(businessID, documentID, this.getClientType());
            deleteResult = deleteSA.delete();
        }
        return deleteResult;
    }

    @Override
    public String getUploadFileInfo() {
        StringBuffer sb = new StringBuffer();
        return this.fmePanel.getUploadFileJSONInfo();
    }

    @Override
    public String renameServerFile(String index, String documentID, String newName) {
        String businessID = this.getNewBusinessID();
        FMERenameServiceAction renameSA = new FMERenameServiceAction(businessID, documentID, newName, this.getClientType());
        return renameSA.rename();
    }

    @Override
    public void loadDownloadFile(String busiID) {
        String businessID = "";
        businessID = FMEUIUtils.isBlankString(busiID) ? this.getQueryBusinessID() : busiID;
        System.out.println("\u9884\u4e0b\u8f7d\u7684\u6587\u4ef6BusinessID is:" + businessID);
        FMEQueryServiceAction querySA = new FMEQueryServiceAction(businessID, this.getClientType());
        DocumentBO[] boinfo = querySA.queryBO();
        if (boinfo == null || boinfo.length <= 0) {
            System.out.println("\u9884\u52a0\u8f7d\u7684\u4e1a\u52a1ID\u5bf9\u5e94\u6ca1\u6709\u6587\u4ef6\u8d44\u6599\u5b58\u5728");
        } else {
            try {
                this.fmePanel.loadFMEDocument(boinfo, 1, false, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.validate();
            this.repaint();
            this.getParent().validate();
            this.getParent().repaint();
            this.updateUI();
        }
    }

    @Override
    public boolean cancelUploadFile(String businessID) {
        boolean retValue = false;
        System.out.println("-----------------------------\u53d6\u6d88\u4e0a\u4f20\u64cd\u4f5cID\u4e3a:" + businessID);
        FMECancelServiceAction csAction = new FMECancelServiceAction(businessID, this.getClientType());
        ServiceResult sr = null;
        if (this.upload) {
            this.stopProgressNotNotify();
        }
        try {
            sr = csAction.cancel();
            retValue = sr.isResult();
        }
        catch (Exception se) {
            se.printStackTrace();
            retValue = false;
        }
        return retValue;
    }

    @Override
    public int getWaitingUploadFileCount() {
        return this.fmePanel.getWaitingUploadFileCount();
    }

    @Override
    public JSONArray getUnloadFileInfo() {
        JSONArray unloadArray = this.fmePanel.getUploadFileInfo_JSON();
        return unloadArray;
    }

    @Override
    public void loadUnloadFile(String unloadFileInfo) {
        List needUploadObjList = FMEUIUtils.parseJSONNeedOperObject(unloadFileInfo);
        int needObjSize = needUploadObjList.size();
        System.out.println("needObjSize is:" + needObjSize);
        for (int i = 0; i < needObjSize; ++i) {
            FMEFileElement oneObj = (FMEFileElement)needUploadObjList.get(i);
            System.out.println("addFileElement" + i);
            try {
                this.fmePanel.addFileElement(oneObj);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showAlertInfo(String info) {
        Object[] options = new Object[]{"\u786e\u5b9a"};
        int res = JOptionPane.showOptionDialog(this, info, "\u8b66\u544a", 0, 2, null, options, options[0]);
    }

    public void enabledAllowUpload(boolean enabledAllowUpload) {
        this.addFileLinkLabel.enabled = enabledAllowUpload;
    }

    public void setVisibleAllowUpload(boolean visible) {
        this.addFileLinkLabel.setVisible(visible);
    }
}

