/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.util;

import com.enterprisedt.util.safe.SafeCheckUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;

public class FileConvertUtil {
    private static int socketTimeout = Integer.parseInt(System.getProperty("SocketTimeOut", "3000"));

    public static void main(String[] args) {
        String dir = "/opt/jdk/";
        String fileName = "mxn.doc";
        try {
            FileConvertUtil.convertFile(dir, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean startOpenOffice() {
        Properties props = System.getProperties();
        String OpenOffice_HOME = System.getProperty("openOfficeHome", "/opt/OpenOffice4");
        if (props.getProperty("os.name").indexOf("Windows") == 0) {
            OpenOffice_HOME = System.getProperty("openOfficeHome", "C:\\Program Files\\OpenOffice 4");
        }
        if (OpenOffice_HOME.charAt(OpenOffice_HOME.length() - 1) != '/') {
            OpenOffice_HOME = OpenOffice_HOME + "/";
        }
        String command = "";
        command = props.getProperty("os.name").indexOf("Windows") == 0 ? OpenOffice_HOME + "program/soffice.exe -headless -accept=\"socket,host=127.0.0.1,port=8100;urp;\" -nofirststartwizard" : OpenOffice_HOME + "program/soffice.bin -headless -accept=\"socket,host=127.0.0.1,port=8100;urp;\" -nofirststartwizard";
        try {
            Process pro = Runtime.getRuntime().exec(command);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnection(String ip, int port) {
        Socket socket = new Socket();
        try {
            InetSocketAddress addr = new InetSocketAddress(ip, port);
            socket.connect(addr, socketTimeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String convertFile(String fullDirPath, String fileName) throws Exception {
        block7: {
            try {
                if (!FileConvertUtil.testConnection("127.0.0.1", 8100)) {
                    int times = 1;
                    FileConvertUtil.startOpenOffice();
                    while (!FileConvertUtil.testConnection("127.0.0.1", 8100) && times < 120) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (FileConvertUtil.testConnection("127.0.0.1", 8100)) {
                        return FileConvertUtil.realConvertFile(fullDirPath, fileName);
                    }
                    break block7;
                }
                return FileConvertUtil.realConvertFile(fullDirPath, fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String realConvertFile(String fullDirPath, String fileName) throws Exception {
        fullDirPath = SafeCheckUtils.cleanPathString(fullDirPath);
        fileName = SafeCheckUtils.cleanPathString(fileName);
        int index = fileName.lastIndexOf(".");
        String fileType = fileName.substring(index + 1);
        String previewFlag = "";
        String returnValue = "";
        if (fileType.equalsIgnoreCase("XLS") || fileType.equalsIgnoreCase("PPT") || fileType.equalsIgnoreCase("DOC") || fileType.equalsIgnoreCase("PDF") || fileType.equalsIgnoreCase("TXT") || fileType.equalsIgnoreCase("MP3") || fileType.equalsIgnoreCase("SWF") || fileType.equalsIgnoreCase("docx")) {
            previewFlag = "0";
            returnValue = "nomp4";
        } else if (fileType.indexOf(".MP4") > 0) {
            returnValue = "mp4";
            previewFlag = "2";
        } else {
            returnValue = "nomp4";
            previewFlag = "1";
        }
        System.out.println("fileType===========" + fileType + "==========" + previewFlag + previewFlag.equals("0"));
        if (previewFlag.equals("0")) {
            Properties props = System.getProperties();
            String separator = props.getProperty("file.separator");
            String os_name = props.getProperty("os.name");
            String os_flag = "";
            if (os_name.indexOf("Linux") == 0) {
                os_flag = "linux";
            } else if (os_name.indexOf("Windows") == 0) {
                os_flag = "window";
            }
            String sysFileName = fileName;
            String fullPath = "F:\\Apusic-4.0.3\\applications\\fileconvert\\upload\\knowledge\\" + sysFileName;
            if (fullDirPath != null) {
                fullPath = fullDirPath + File.separator + sysFileName;
            }
            String folderName = fullPath.substring(0, fullPath.lastIndexOf(separator));
            String sysFileName_temp = sysFileName.substring(0, sysFileName.lastIndexOf("."));
            String finalFilePath = "";
            String swfToolsPath = "";
            swfToolsPath = os_flag.equals("linux") ? System.getProperty("swftoolsHome", "/usr/local/bin/") : System.getProperty("swftoolsHome", "C:\\Program Files\\SWFTools\\");
            if (fileType.equalsIgnoreCase("SWF")) {
                System.out.println("It's SWF==================" + finalFilePath);
            } else if (fileType.equalsIgnoreCase("PDF")) {
                Runtime rt = Runtime.getRuntime();
                File sourceFile = new File(fullPath);
                File createPath = new File(folderName + separator + "swfFiles" + separator);
                if (!createPath.isDirectory()) {
                    createPath.mkdirs();
                }
                File swfFile = new File(folderName + separator + "swfFiles" + separator + sysFileName_temp + ".swf");
                Process p = null;
                p = os_flag.equals("window") ? rt.exec(swfToolsPath + "pdf2swf.exe" + sourceFile.getPath() + " -o " + swfFile.getPath() + " -T 9") : rt.exec("pdf2swf -slanguagedir=/usr/local/xpdf-chinese-simplified -T 9 -s poly2bitmap -s zoom=150-s flashversion=9 " + sourceFile.getPath() + " -o " + swfFile.getPath());
                if (os_flag.equals("window")) {
                    FileConvertUtil.clearCache(p.getInputStream(), p.getErrorStream());
                } else if (os_flag.equals("linux")) {
                    String line;
                    InputStreamReader ir = new InputStreamReader(p.getInputStream());
                    LineNumberReader input = new LineNumberReader(ir);
                    while ((line = input.readLine()) != null) {
                        System.out.println("linux clear====================" + line);
                    }
                }
                System.out.println("It'sPDF=========sourceFile" + sourceFile.getPath() + "=========" + swfFile + "=========" + finalFilePath);
            } else {
                System.out.println("It's " + fileType + "====================" + sysFileName_temp);
                if (FileConvertUtil.isLegal(fileType.toUpperCase())) {
                    File sourceFile = new File(fullPath);
                    File pdfFile = new File(folderName + separator + "swfFiles" + separator + sysFileName_temp + ".pdf");
                    File swfFile = new File(folderName + separator + "swfFiles" + separator + sysFileName_temp + ".swf");
                    if (!pdfFile.exists()) {
                        System.out.println("create a new pdf==========" + pdfFile.getParent());
                        if (!swfFile.exists()) {
                            Runtime rt = Runtime.getRuntime();
                            Process p = null;
                            p = os_flag.equals("window") ? rt.exec(swfToolsPath + "pdf2swf.exe " + pdfFile.getPath() + " -o " + swfFile.getPath() + " -T 9") : rt.exec("pdf2swf -s languagedir=/usr/local/xpdf-chinese-simplified -T 9 -spoly2bitmap -s zoom=150 -s flashversion=9 " + pdfFile.getPath() + " -o " + swfFile.getPath());
                            if (os_flag.equals("window")) {
                                FileConvertUtil.clearCache(p.getInputStream(), p.getErrorStream());
                            } else if (os_flag.equals("linux")) {
                                String line;
                                InputStreamReader ir = new InputStreamReader(p.getInputStream());
                                LineNumberReader input = new LineNumberReader(ir);
                                while ((line = input.readLine()) != null) {
                                    System.out.println("linux clear====================" + line);
                                }
                            }
                            System.out.println("create a new swf==========" + swfFile.getParent());
                        }
                    } else {
                        if (!swfFile.exists()) {
                            Runtime rt = Runtime.getRuntime();
                            Process p = null;
                            p = os_flag.equals("window") ? rt.exec(swfToolsPath + "pdf2swf.exe" + pdfFile.getPath() + " -o " + swfFile.getPath() + " -T 9") : rt.exec("pdf2swf -s languagedir=/usr/local/xpdf-chinese-simplified-T 9 -s poly2bitmap -s zoom=150 -s flashversion=9 " + pdfFile.getPath() + " -o " + swfFile.getPath());
                            if (os_flag.equals("window")) {
                                FileConvertUtil.clearCache(p.getInputStream(), p.getErrorStream());
                            } else if (os_flag.equals("linux")) {
                                String line;
                                InputStreamReader ir = new InputStreamReader(p.getInputStream());
                                LineNumberReader input = new LineNumberReader(ir);
                                while ((line = input.readLine()) != null) {
                                    System.out.println("linux clear====================" + line);
                                }
                            }
                            System.out.println("pdf exists,but create a new swf==========" + swfFile.getParent());
                        }
                        System.out.println("pdf exists==========" + swfFile.getParent());
                    }
                } else {
                    System.out.println("Not support file type [" + fileType + "]");
                }
            }
        } else {
            System.out.println("Not support file type [" + fileType + "]");
        }
        return returnValue;
    }

    public static boolean isLegal(String getFileType) {
        boolean fileLegalFlag = false;
        if (getFileType.equalsIgnoreCase("TXT")) {
            fileLegalFlag = true;
        } else if (getFileType.equalsIgnoreCase("DOC") || getFileType.equalsIgnoreCase("DOCX")) {
            fileLegalFlag = true;
        } else if (getFileType.equalsIgnoreCase("PPT") || getFileType.equalsIgnoreCase("PPTX")) {
            fileLegalFlag = true;
        } else if (getFileType.equalsIgnoreCase("XLS") || getFileType.equalsIgnoreCase("XLSX")) {
            fileLegalFlag = true;
        }
        return fileLegalFlag;
    }

    private static void clearCache(InputStream isi, InputStream ise) {
        try {
            System.out.println("clearCache===========" + isi.toString() + "============" + ise.toString());
            final InputStream is1 = isi;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("before BufferedReader=========================");
                    BufferedReader br = new BufferedReader(new InputStreamReader(is1));
                    try {
                        while (br.readLine() != null) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            BufferedReader br = new BufferedReader(new InputStreamReader(ise));
            StringBuilder buf = new StringBuilder();
            String line = null;
            try {
                System.out.println("beforereadLine==================");
                line = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            while (line != null) {
                buf.append(line);
            }
            is1.close();
            ise.close();
            br.close();
        }
        catch (Exception e) {
            System.out.println("clearCacheException===========" + e + "============");
            e.printStackTrace();
        }
    }
}

