/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.util;

import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.util.FMEUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class FtpUtils {
    public static final String FTP_HOST = "ftphost";
    public static final String FTP_PORT = "ftpport";
    public static final String FTP_USERNAME = "ftpusername";
    public static final String FTP_PASSWORD = "ftppassword";
    public static final String FTPCONFIG_PROPERTIES_NAME = "ftpconfig.properties";
    private static FtpConfig ftpconfig;

    public static FtpConfig getFtpConfig() {
        if (ftpconfig == null) {
            ftpconfig = new FtpConfig();
            Properties ftpProp = new Properties();
            InputStream in = FtpUtils.getFtpPropertyFile(FtpUtils.class, FTPCONFIG_PROPERTIES_NAME);
            try {
                if (in != null) {
                    ftpProp.load(in);
                    ftpconfig.setHost(ftpProp.getProperty(FTP_HOST));
                    ftpconfig.setPort(Integer.parseInt(ftpProp.getProperty(FTP_PORT)));
                    ftpconfig.setUsername(ftpProp.getProperty(FTP_USERNAME));
                    ftpconfig.setPassword(ftpProp.getProperty(FTP_PASSWORD));
                }
            }
            catch (Exception se) {
                System.out.println("\u52a0\u8f7dftpconfig.property throws exception is:" + se.getMessage());
            }
        }
        return ftpconfig;
    }

    public static InputStream getFtpPropertyFile(Class cls, String propFile) {
        try {
            ClassLoader loader = cls.getClassLoader();
            InputStream in = loader.getResourceAsStream(propFile);
            if (in != null) {
                return in;
            }
            Package pack = cls.getPackage();
            if (pack != null) {
                String packName = pack.getName();
                String path = "";
                if (packName.indexOf(".") < 0) {
                    path = packName + "/";
                } else {
                    int start = 0;
                    int end = 0;
                    end = packName.indexOf(".");
                    while (end != -1) {
                        path = path + packName.substring(start, end) + "/";
                        start = end + 1;
                        end = packName.indexOf(".", start);
                    }
                    path = path + packName.substring(start) + "/";
                }
                in = loader.getResourceAsStream(path + propFile);
                if (in != null) {
                    return in;
                }
            }
            File f = null;
            String curDir = System.getProperty("user.dir");
            f = new File(curDir, propFile);
            if (f.exists()) {
                return new FileInputStream(f);
            }
            String classpath = System.getProperty("java.class.path");
            String[] cps = classpath.split(System.getProperty("path.separator"));
            for (int i = 0; i < cps.length && !(f = new File(cps[i], propFile)).exists(); ++i) {
                f = null;
            }
            if (f != null) {
                return new FileInputStream(f);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFileSize(String fileName) {
        String fileSize = "";
        try {
            File uFile = new File(fileName);
            if (uFile != null) {
                fileSize = FtpUtils.getFileSize(uFile.length());
            }
        }
        catch (Exception se) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u83b7\u53d6\u5927\u5c0f");
        }
        return fileSize;
    }

    public static long getFileNumberSize(String fileName) {
        long fileSize = 0L;
        try {
            File uFile = new File(fileName);
            if (uFile != null) {
                fileSize = uFile.length();
            }
        }
        catch (Exception se) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u83b7\u53d6\u5927\u5c0f");
        }
        return fileSize;
    }

    public static String getFileSize(long fileLen) {
        String fileSize = "";
        String fileSizeStr = "" + fileLen;
        String endSizeName = "KB";
        if (fileLen < 1000L) {
            endSizeName = "byte";
            fileSize = fileSizeStr + endSizeName;
        } else if (fileLen < 1000000L) {
            endSizeName = "KB";
            int endPos = fileSizeStr.length() - 3;
            fileSize = fileSizeStr.substring(0, endPos) + "." + fileSizeStr.substring(endPos, endPos + 1) + endSizeName;
        } else if (fileLen < 1000000000L) {
            endSizeName = "MB";
            int endPos = fileSizeStr.length() - 6;
            fileSize = fileSizeStr.substring(0, endPos) + "." + fileSizeStr.substring(endPos, endPos + 1) + endSizeName;
        } else {
            endSizeName = "GB";
            int endPos = fileSizeStr.length() - 9;
            fileSize = fileSizeStr.substring(0, endPos) + "." + fileSizeStr.substring(endPos, endPos + 1) + endSizeName;
        }
        return fileSize;
    }

    public static String getFileByteSize(long fileLen) {
        int fz = 0;
        String fileSizeStr = "" + fileLen;
        String fileSize = "";
        for (int i = fileSizeStr.length() - 1; i >= 0; --i) {
            char oneChar = fileSizeStr.charAt(i);
            fileSize = oneChar + fileSize;
            if (++fz != 3 || i == 0) continue;
            fileSize = "," + fileSize;
            fz = 0;
        }
        return fileSize + "\u5b57\u8282";
    }

    public static String getDefaultSavePath(String rootPath, String userID) {
        StringBuffer sb = new StringBuffer();
        if (FMEUtils.isBlankString(rootPath)) {
            System.out.println("\u6ca1\u6709\u8bbe\u7f6e\u786e\u5b9a\u7684\u5b58\u50a8\u6839\u76ee\u5f55\uff0c\u83b7\u53d6\u7f3a\u7701\u6839\u8def\u5f84:root/");
            sb.append("root/");
        } else {
            sb.append(rootPath);
            if (!rootPath.endsWith("/")) {
                sb.append("/");
            }
        }
        if (!FMEUtils.isBlankString(userID)) {
            sb.append(userID).append("/");
        }
        return sb.toString();
    }

    public static String[] getUploadSaveDirAndName(String uploadFileName) {
        String[] dnArray = new String[2];
        int fpos = uploadFileName.lastIndexOf("/");
        if (fpos != -1) {
            dnArray[0] = uploadFileName.substring(0, fpos);
            dnArray[1] = uploadFileName.substring(fpos + 1);
        } else {
            dnArray[0] = "";
            dnArray[1] = uploadFileName;
        }
        return dnArray;
    }

    public static String getUploadSaveDir(String uploadFileName) {
        int fpos = uploadFileName.lastIndexOf("/");
        if (fpos != -1) {
            return uploadFileName.substring(0, fpos);
        }
        return "";
    }

    public static String getFileNameFromAbsolutePath(String name) {
        String fileName = "";
        int lastPos = name.lastIndexOf(File.separator);
        if (lastPos != -1) {
            fileName = name.substring(lastPos + 1);
        } else {
            lastPos = name.lastIndexOf("/");
            if (lastPos != -1) {
                fileName = name.substring(lastPos + 1);
            }
        }
        return fileName;
    }

    public static String getFileType(String name) {
        String fileType = "";
        int index = name.lastIndexOf(".");
        fileType = name.substring(index + 1);
        return fileType;
    }

    public static boolean isBlankString(String validateStr) {
        if (validateStr == null) {
            return true;
        }
        return validateStr.trim().length() <= 0;
    }

    public static String getDefaultDownloadFileName(String fileIndex, String fileName) {
        String returnFileName = "";
        int fPos = fileName.lastIndexOf(".");
        returnFileName = fPos != -1 ? fileName.substring(0, fPos) + "-" + fileIndex + fileName.substring(fPos) : fileName + "-" + fileIndex;
        return returnFileName;
    }

    public static String getSuitableFileName(String setFileName) {
        int maxFileLength;
        String retFileName = setFileName;
        int retFileLength = retFileName.length();
        if (retFileLength > (maxFileLength = 255)) {
            String fileExtName = "";
            int endEPos = setFileName.lastIndexOf(".");
            if (endEPos != -1) {
                fileExtName = setFileName.substring(endEPos);
                retFileName = retFileName.substring(0, maxFileLength - fileExtName.length()) + fileExtName;
            } else if (retFileLength > maxFileLength) {
                retFileName = retFileName.substring(0, maxFileLength);
            }
        }
        return retFileName;
    }

    public static Long convertFileSizeToBytes(String size) {
        String unit = "";
        long kb = 1024L;
        long rtnVal = 1L;
        char[] unitChar = size.substring(size.length() - 2, size.length() - 1).toCharArray();
        if (unitChar[0] >= '0' && unitChar[0] <= '9') {
            unit = size.substring(size.length() - 1).toUpperCase();
            size = size.substring(0, size.length() - 1);
        } else {
            unit = size.substring(size.length() - 2, size.length() - 1).toUpperCase();
            size = size.substring(0, size.length() - 2);
        }
        if ("K".equals(unit)) {
            rtnVal = Long.valueOf(size);
        } else if ("M".equals(unit)) {
            rtnVal = Long.valueOf(size) * kb;
        } else if ("G".equals(unit)) {
            rtnVal = Long.valueOf(size) * kb * kb;
        }
        return new Long(rtnVal * 1024L);
    }

    public static long convertSizeBySizeUnit(long fileSize, String sizeUnit) {
        long size = fileSize;
        if (null != sizeUnit) {
            if (sizeUnit.equalsIgnoreCase("MB")) {
                size = fileSize / 1024L / 1024L;
            } else if (sizeUnit.equalsIgnoreCase("GB")) {
                size = fileSize / 1024L / 1024L / 1024L;
            } else if (sizeUnit.equalsIgnoreCase("KB")) {
                size = fileSize / 1024L;
            }
        }
        return size;
    }
}

