/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.engine.RunFormulaException;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnMessageInfo;
import com.kingdee.eas.base.forewarn.Priority;
import com.kingdee.eas.base.forewarn.app.ForewarnFormulaAdapter;
import com.kingdee.eas.base.forewarn.app.ForewarnMsgFactory;
import com.kingdee.eas.base.forewarn.app.ForewarnRunContext;
import com.kingdee.eas.base.forewarn.app.SSCForewarnUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ForewarnMailMsgFactory
extends ForewarnMsgFactory {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.forewarn.app.ForewarnMailMsgFactory");

    @Override
    public Message createComboMsg(ArrayList units, String userList, EntityObjectInfo eoInfo) throws Exception {
        return this.buildComboMessage(units, userList, eoInfo);
    }

    @Override
    public Message createMsg(ArrayList oneUnit, String userList, EntityObjectInfo eoInfo) throws Exception {
        ArrayList<ArrayList> tmpArray = new ArrayList<ArrayList>();
        tmpArray.add(oneUnit);
        return this.buildComboMessage(tmpArray, userList, eoInfo);
    }

    public ForewarnMailMsgFactory() {
    }

    public ForewarnMailMsgFactory(Context ctx, ForewarnItemInfo forewarnItemInfo, IVarInfo[] forewarnVars, Map businessCollections, Map businessFacades) {
        super(ctx, forewarnItemInfo, forewarnVars, businessCollections, businessFacades);
    }

    private String buildTitle(ArrayList unit) throws BOSException, ParseException, RunFormulaException {
        StringBuffer title = new StringBuffer();
        String script = this.forewarnItemInfo.getMessage().getTitleScript();
        if (script != null && script.length() > 0) {
            Map titleContext;
            ForewarnFormulaAdapter formulaAdapter;
            Object result;
            String titleScript = script;
            ForewarnRunContext runContext = new ForewarnRunContext(this.ctx, this.forewarnItemInfo, this.businessCollections, this.businessFacades);
            ArrayList oneU = null;
            if (unit != null && !unit.isEmpty()) {
                oneU = (ArrayList)unit.get(0);
            }
            title.append((result = (formulaAdapter = new ForewarnFormulaAdapter(this.ctx)).execScript(titleScript, titleContext = runContext.getFormulaContext(oneU, titleScript, this.forewarnVars), null)) == null ? "" : result.toString());
            this.formulaEngineTime = formulaAdapter.getFormulaEngineTime();
        } else {
            title.append(this.forewarnItemInfo.getMessage().getTitle());
        }
        return title.toString();
    }

    public String buildBody(ArrayList units, Locale locale) throws BOSException, ParseException, RunFormulaException {
        if (units == null) {
            return this.bodyStr(null, locale);
        }
        int unitSize = units.size();
        StringBuffer body = new StringBuffer();
        for (int i = 0; i < unitSize; ++i) {
            ArrayList unitList = (ArrayList)units.get(i);
            body.append(this.bodyStr(unitList, locale));
        }
        return body.toString();
    }

    private String bodyStr(ArrayList unitList, Locale locale) throws BOSException, ParseException, RunFormulaException {
        String script = this.forewarnItemInfo.getMessage().getBodyScript(locale);
        if (StringUtils.isEmpty((String)script)) {
            LanguageCollection languageCollection = this.solutionInfo.getLanguages();
            for (int i = 0; i < languageCollection.size() && (script = this.forewarnItemInfo.getMessage().getBodyScript(languageCollection.get(i).getLocale())) == null; ++i) {
            }
        }
        ForewarnRunContext runContext = new ForewarnRunContext(this.ctx, this.forewarnItemInfo, this.businessCollections, this.businessFacades);
        String appendMsg = this.forewarnItemInfo.getMessage().getAppendMsg(locale) == null ? "" : this.forewarnItemInfo.getMessage().getAppendMsg(locale);
        ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
        StringBuffer body = new StringBuffer("");
        Map bodyContext = runContext.getFormulaContext(unitList, script, this.forewarnVars);
        if (script != null && script.length() > 0) {
            Object result = formulaAdapter.execScript(script, bodyContext, locale);
            body.append(result == null ? "" : result.toString()).append("\n").append(appendMsg);
            this.formulaEngineTime = formulaAdapter.getFormulaEngineTime();
        } else {
            body.append(new String(this.forewarnItemInfo.getMessage().getBody())).append("\n").append(appendMsg);
        }
        return body.toString();
    }

    private Message buildComboMessage(ArrayList units, String userList, EntityObjectInfo eoInfo) throws Exception {
        String solution = this.ctx.getSolution();
        String databaseCenter = this.ctx.getAIS();
        Message message = MessageFactory.newMessage((String)"kingdee.forewarn");
        message.setStringHeader("databaseCenter", databaseCenter);
        message.setStringHeader("solution", solution);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        if (this.forewarnItemInfo.getMessage() != null && this.forewarnItemInfo.getMessage().getPriority() != null) {
            message.setIntHeader("priority", this.forewarnItemInfo.getMessage().getPriority().getValue());
        } else {
            message.setIntHeader("priority", Priority.MIDDLE.getValue());
        }
        LanguageCollection languageCollection = this.solutionInfo.getLanguages();
        int languageSize = languageCollection.size();
        Locale ctxLocale = this.ctx.getLocale();
        this.setLocalMessage(units, message, ctxLocale);
        for (int j = 0; j < languageSize; ++j) {
            Locale locale = languageCollection.get(j).getLocale();
            if (locale.getLanguage().equals(ctxLocale.getLanguage())) continue;
            this.setLocalMessage(units, message, locale);
        }
        message.setStringHeader("itemId", this.forewarnItemInfo.getId().toString());
        message.setStringHeader("senderId", this.forewarnItemInfo.getCreator() == null ? "" : this.forewarnItemInfo.getCreator().getId().toString());
        message.setStringHeader("sourceIDs", this.getSourceIDs(units, eoInfo));
        message.setStringHeader("sourceID", this.getSourceID(units, eoInfo));
        message.setStringHeader("receiver", userList);
        message.setStringHeader("url", this.buildUrl(units));
        return message;
    }

    private void setLocalMessage(ArrayList units, Message message, Locale locale) throws BOSException, ParseException, RunFormulaException {
        message.setLocaleStringHeader("title", this.buildTitle(units), locale);
        message.setLocaleStringHeader("body", this.buildBody(units, locale), locale);
        message.setLocaleStringHeader("Vars", this.buildVars(units, locale), locale);
        message.setLocaleStringHeader("sender", this.forewarnItemInfo.getCreator() == null ? "" : this.forewarnItemInfo.getCreator().getName(), locale);
        message.setLocaleStringHeader("initiatorName", this.forewarnItemInfo.getCreator() == null ? "" : this.forewarnItemInfo.getCreator().getNumber(), locale);
    }

    private String buildVars(ArrayList units, Locale locale) throws BOSException, ParseException, RunFormulaException {
        if (units == null) {
            return this.VarsStr(null, locale);
        }
        int unitSize = units.size();
        StringBuffer body = new StringBuffer();
        for (int i = 0; i < unitSize; ++i) {
            ArrayList unitList = (ArrayList)units.get(i);
            body.append(this.VarsStr(unitList, locale));
        }
        return body.toString();
    }

    private String VarsStr(ArrayList unitList, Locale locale) throws BOSException, ParseException, RunFormulaException {
        ForewarnMessageInfo message = this.forewarnItemInfo.getMessage();
        String attrScript = message.getAttrScript();
        String attrKeys = message.getAttrKeys();
        StringBuffer Vars = new StringBuffer("");
        if (!StringUtils.isEmpty((String)attrScript) && !StringUtils.isEmpty((String)attrKeys)) {
            ForewarnRunContext runContext = new ForewarnRunContext(this.ctx, this.forewarnItemInfo, this.businessCollections, this.businessFacades);
            ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
            Map attrContext = runContext.getFormulaContext(unitList, attrScript, this.forewarnVars);
            String[] keys = attrKeys.split("&&");
            Object result = formulaAdapter.execScript(attrScript, attrContext, locale);
            String[] vals = new String[]{""};
            if (result != null) {
                vals = result.toString().split("&&");
            }
            LinkedHashMap<String, String> attrVals = new LinkedHashMap<String, String>();
            if (keys != null && keys.length > 0) {
                String val = "";
                for (int i = 0; i < keys.length; ++i) {
                    try {
                        val = vals[i];
                    }
                    catch (Exception e) {
                        val = "";
                    }
                    val = val.replace("null", "");
                    attrVals.put(keys[i], val);
                }
            }
            if (attrVals.size() > 0) {
                String attrValsJson = JSON.toJSONString(attrVals);
                Vars.append(attrValsJson);
            }
        }
        return Vars.toString();
    }

    public String getUrl(ArrayList unitList) throws BOSException, ParseException, RunFormulaException {
        String paramScript = this.forewarnItemInfo.getMessage().getParamScript();
        ForewarnRunContext runContext = new ForewarnRunContext(this.ctx, this.forewarnItemInfo, this.businessCollections, this.businessFacades);
        StringBuffer url = new StringBuffer("");
        ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
        if (paramScript != null && paramScript.length() > 0) {
            Map bodyContext = runContext.getFormulaContext(unitList, paramScript, this.forewarnVars);
            Object execScript = formulaAdapter.execScript(paramScript, bodyContext, null);
            if (execScript != null) {
                String urlexecScript = execScript.toString();
                url.append(urlexecScript);
            }
            this.formulaEngineTime = formulaAdapter.getFormulaEngineTime();
        }
        return url.toString();
    }

    public String buildUrl(ArrayList units) throws BOSException, ParseException, RunFormulaException {
        if (units == null) {
            return this.getUrl(null);
        }
        int unitSize = units.size();
        StringBuffer url = new StringBuffer();
        for (int i = 0; i < unitSize; ++i) {
            ArrayList unitList = (ArrayList)units.get(i);
            url.append(this.getUrl(unitList));
            url.append("\n");
        }
        return url.toString();
    }

    private String getSourceID(ArrayList units, EntityObjectInfo eoInfo) {
        if (units == null || units.size() == 0) {
            return null;
        }
        Object atmp = null;
        ArrayList btmp = null;
        Object ctmp = null;
        StringBuffer result = new StringBuffer("");
        boolean bTmpSize = false;
        atmp = units.get(0);
        if (atmp instanceof ArrayList && (ctmp = (Object)(btmp = (ArrayList)atmp).get(0)) instanceof IObjectValue && eoInfo != null && ctmp.getClass().getName().equals(eoInfo.getObjectValueClass())) {
            result.append(((IObjectValue)ctmp).get("id"));
        }
        return result.toString();
    }

    private String getSourceIDs(ArrayList units, EntityObjectInfo eoInfo) {
        if (units == null || units.size() == 0) {
            return null;
        }
        Object atmp = null;
        ArrayList btmp = null;
        Object ctmp = null;
        StringBuffer result = new StringBuffer("(");
        int unitsSize = units.size();
        int bTmpSize = 0;
        for (int i = 0; i < unitsSize; ++i) {
            atmp = units.get(i);
            if (!(atmp instanceof ArrayList)) continue;
            btmp = atmp;
            bTmpSize = btmp.size();
            for (int j = 0; j < bTmpSize; ++j) {
                ctmp = btmp.get(j);
                if (!(ctmp instanceof IObjectValue) || eoInfo == null || !ctmp.getClass().getName().equals(eoInfo.getObjectValueClass())) continue;
                result.append("'").append(((IObjectValue)ctmp).get("id")).append("',");
            }
        }
        if (result.lastIndexOf(",") != -1) {
            result.deleteCharAt(result.lastIndexOf(","));
        }
        result.append(")");
        if (result.indexOf("'") == -1) {
            return null;
        }
        return result.toString();
    }

    @Override
    public void sendMsg(List msgList) {
        int size = msgList.size();
        for (int i = 0; i < size; ++i) {
            Message tMessage = (Message)msgList.get(i);
            String receiver = tMessage.getStringHeader("receiver");
            if (receiver.indexOf(SSCForewarnUtil.SSC_FOREWARN) >= 0) {
                SSCForewarnUtil.sendMsgToOtherSyS(this.ctx, tMessage);
                continue;
            }
            this.sendMsg(tMessage);
        }
    }

    @Override
    public void sendMsg(Message msg) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        senderAgent.sendMessage(msg);
    }

    public String buildExtendParam(ArrayList units, Locale locale) throws BOSException, ParseException, RunFormulaException {
        if (units == null) {
            return this.extendParamStr(null, locale);
        }
        int unitSize = units.size();
        StringBuffer body = new StringBuffer();
        for (int i = 0; i < unitSize; ++i) {
            ArrayList unitList = (ArrayList)units.get(i);
            body.append(this.extendParamStr(unitList, locale));
        }
        if (!StringUtils.isEmpty((String)body.toString())) {
            return "[" + body.toString() + "]";
        }
        return body.toString();
    }

    private String extendParamStr(ArrayList unitList, Locale locale) throws BOSException, ParseException, RunFormulaException {
        String script = this.forewarnItemInfo.getMessage().getParamScript();
        ForewarnRunContext runContext = new ForewarnRunContext(this.ctx, this.forewarnItemInfo, this.businessCollections, this.businessFacades);
        String appendMsg = this.forewarnItemInfo.getMessage().getParamScript(locale) == null ? "" : this.forewarnItemInfo.getMessage().getParamScript(locale);
        ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
        StringBuffer param = new StringBuffer("");
        if (script != null && script.length() > 0) {
            Map bodyContext = runContext.getFormulaContext(unitList, script, this.forewarnVars);
            param.append(formulaAdapter.execScript(script, bodyContext, null).toString());
            this.formulaEngineTime = formulaAdapter.getFormulaEngineTime();
        }
        return param.toString();
    }
}

