/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.forewarn.ForewarnDynVarsFactory;
import com.kingdee.eas.base.forewarn.ForewarnDynVarsInfo;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnMessageInfo;
import com.kingdee.eas.base.forewarn.IForewarnDynVars;
import com.kingdee.eas.base.forewarn.app.CloudMsgInfo;
import com.kingdee.eas.base.forewarn.app.ForewarnMailMsgFactory;
import com.kingdee.eas.base.forewarn.app.ForewarnMobileMsgFactory;
import com.kingdee.eas.base.forewarn.app.ForewarnMsgCenter;
import com.kingdee.eas.base.forewarn.app.ForewarnMsgFactory;
import com.kingdee.eas.base.forewarn.app.ForewarnUserInfo;
import com.kingdee.eas.base.forewarn.app.MailMsgInfo;
import com.kingdee.eas.base.forewarn.app.WeiboMsgInfo;
import com.kingdee.eas.base.forewarn.app.merge.IMergeMessage;
import com.kingdee.eas.base.forewarn.app.merge.MergeConvertFactory;
import com.kingdee.eas.base.forewarn.utils.HTMLElementUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ForewarnMsgCenterImpl
extends ForewarnMsgCenter {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.forewarn.app.ForewarnMsgCenterImpl");
    private final int MESSAGE_BODY_CAPACITY = 10000;
    private final int MESSAGE_BODY_CAPACITY_APUSIC = 60000;
    private SolutionInfo solutionInfo = null;
    private Message errorMsg = null;
    private static String Vars = "Vars";
    private IForewarnDynVars iDynVars;

    public ForewarnMsgCenterImpl(Context ctx, ForewarnItemInfo forewarnItemInfo, IVarInfo[] forewarnVars, EntityObjectInfo eoInfo, Map businessCollections, Map businessFacades) {
        super(ctx, forewarnItemInfo, forewarnVars, eoInfo, businessCollections, businessFacades);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        this.solutionInfo = metaDataLoader.getSolution();
        try {
            this.iDynVars = ForewarnDynVarsFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void buildMessage(ArrayList units, ForewarnUserInfo userInfo, EntityObjectInfo eoInfo) throws Exception {
        ForewarnMailMsgFactory msgFactory = new ForewarnMailMsgFactory(this.ctx, this.forewarnItemInfo, this.forewarnVars, this.businessCollections, this.businessFacades);
        this.userTimeZoneMap = userInfo.userTimeZoneMap;
        this.readyUserTimeZoneMap = userInfo.readyUserTimeZoneMap;
        Message msg = null;
        for (Object obj : userInfo.setUsers) {
            String receiver;
            if (obj == null || (msg = ((ForewarnMsgFactory)msgFactory).createMsg(units, receiver = obj.toString(), eoInfo)) == null) continue;
            if (this.mailMsgList.size() > this.forewarnItemInfo.getMaxMessageCount()) {
                this.logger.info((Object)("\u6d88\u606f\u6570" + this.messageCount + "\u5927\u4e8e\u6700\u5927\u6d88\u606f\u6570" + this.forewarnItemInfo.getMaxMessageCount()));
                return;
            }
            this.mailMsgList.add(msg);
        }
        if (msg != null) {
            String title = msg.getLocaleStringHeader("title", this.ctx.getLocale());
            String body = msg.getLocaleStringHeader("body", this.ctx.getLocale());
            for (Object obj : userInfo.setMobile) {
                if (obj == null) continue;
                String receiver = obj.toString();
                this.buildMobileMsg(receiver, body, title);
            }
            this.buildEMailMsg(userInfo.getEMailReceiverList(), userInfo.getCopyEMailReceiverList(), body, title);
            for (Object obj : userInfo.setWeiboReceivers) {
                if (obj == null) continue;
                String receiver = obj.toString();
                this.buildWeiboMsg(receiver, body);
            }
            this.buildCloudMsg(userInfo.getCloudUserSet(), body, title);
        }
    }

    @Override
    public void buildComboMessage(ArrayList units, ForewarnUserInfo userInfo, EntityObjectInfo eoInfo) throws Exception {
        ForewarnMailMsgFactory msgFactory = new ForewarnMailMsgFactory(this.ctx, this.forewarnItemInfo, this.forewarnVars, this.businessCollections, this.businessFacades);
        this.userTimeZoneMap = userInfo.userTimeZoneMap;
        this.readyUserTimeZoneMap = userInfo.readyUserTimeZoneMap;
        Message msg = ((ForewarnMsgFactory)msgFactory).createComboMsg(units, userInfo.getMailUserList(), eoInfo);
        if (msg != null) {
            if (this.mailMsgList.size() > this.forewarnItemInfo.getMaxMessageCount()) {
                this.logger.info((Object)("\u6d88\u606f\u6570" + this.messageCount + "\u5927\u4e8e\u6700\u5927\u6d88\u606f\u6570" + this.forewarnItemInfo.getMaxMessageCount()));
                return;
            }
            this.mailMsgList.add(msg);
            String title = msg.getLocaleStringHeader("title", this.ctx.getLocale());
            String body = msg.getLocaleStringHeader("body", this.ctx.getLocale());
            this.buildMobileMsg(userInfo.getMobileList(), body, title);
            this.buildEMailMsg(userInfo.getEMailReceiverList(), userInfo.getCopyEMailReceiverList(), body, title);
            this.buildWeiboMsg(userInfo.getWeiboReceivers(), body);
            this.buildCloudMsg(userInfo.getCloudUserSet(), body, title);
        }
    }

    private void buildMobileMsg(String domain, String body, String title) {
        if (this.isNeedSendMobileMsg()) {
            Message mobileMsg = MessageFactory.newMessage((String)"kingdee.forewarn");
            mobileMsg.setDomian(domain);
            mobileMsg.setStringHeader("receiver", domain);
            mobileMsg.setLocaleStringHeader("title", title, this.ctx.getLocale());
            mobileMsg.setLocaleStringHeader("body", body, this.ctx.getLocale());
            this.logger.info((Object)("mobile msg title:" + title));
            this.logger.info((Object)("mobile msg body:" + body));
            if (mobileMsg != null) {
                this.mobilMsgList.add(mobileMsg);
            }
        }
    }

    private void buildWeiboMsg(String receivers, String body) throws Exception {
        if (this.isNeedSendWeiboMsg()) {
            if (!ForewarnUserInfo.isAdmin(this.ctx) && ForewarnUserInfo.getPersonID(this.ctx, this.ctx.getCaller().toString()) == null) {
                return;
            }
            String[] receiverArray = receivers.split(";");
            for (int i = 0; i < receiverArray.length; ++i) {
                String personId = receiverArray[i];
                WeiboMsgInfo weiboMsgInfo = new WeiboMsgInfo();
                weiboMsgInfo.setReceiver(personId);
                weiboMsgInfo.setContent(body);
                this.weiboMsgList.add(weiboMsgInfo);
            }
        }
    }

    private void buildEMailMsg(String receivers, String copyReceivers, String content, String title) {
        if (this.isNeedSendEMailMsg() && !receivers.isEmpty()) {
            MailMsgInfo mmInfo = new MailMsgInfo();
            mmInfo.setReceiver(receivers);
            mmInfo.setCopyReceiver(copyReceivers);
            mmInfo.setContent(content);
            mmInfo.setMsgTitle(title);
            this.emailMsgList.add(mmInfo);
        }
    }

    private void buildCloudMsg(Set cloudUserSet, String body, String title) {
        if (this.isNeedSendCloudMsg()) {
            for (Object obj : cloudUserSet) {
                if (obj == null) continue;
                CloudMsgInfo cloudMsgInfo = new CloudMsgInfo();
                cloudMsgInfo.setUserInfo((UserInfo)obj);
                cloudMsgInfo.setTitle(title);
                cloudMsgInfo.setBody(body);
                this.cloudMsgList.add(cloudMsgInfo);
            }
        }
    }

    private boolean isNeedSendMobileMsg() {
        return this.forewarnItemInfo.getMessage().isNeedSendMobile();
    }

    private boolean isNeedSendEMailMsg() {
        return this.forewarnItemInfo.getMessage().isNeedSendEMail();
    }

    private boolean isNeedSendWeiboMsg() {
        return this.forewarnItemInfo.getMessage().isNeedSendWeibo();
    }

    private boolean isNeedSendCloudMsg() {
        return this.forewarnItemInfo.getMessage().isNeedSendCloud();
    }

    private Message createErrorMessage() {
        this.logger.info((Object)"\u521b\u5efa\u4e00\u6761\u65b0\u7684\u6d88\u606f....");
        String solution = this.ctx.getSolution();
        String databaseCenter = this.ctx.getAIS();
        Message message = MessageFactory.newMessage((String)"kingdee.forewarn");
        message.setStringHeader("databaseCenter", databaseCenter);
        message.setStringHeader("solution", solution);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        LanguageCollection languageCollection = this.solutionInfo.getLanguages();
        int languageSize = languageCollection.size();
        for (int j = 0; j < languageSize; ++j) {
            Locale locale = languageCollection.get(j).getLocale();
            StringBuffer sbTilte = new StringBuffer();
            sbTilte.append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)"title", (Locale)locale)).append(StringUtils.cnulls((String)this.forewarnItemInfo.getName(locale))).append("(").append(StringUtils.cnulls((String)this.forewarnItemInfo.getNumber())).append(")").append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)"title1", (Locale)locale));
            message.setLocaleStringHeader("title", sbTilte.toString(), locale);
            StringBuffer sbBody = new StringBuffer();
            sbBody.append(this.getCurrentTime()).append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)"body", (Locale)locale)).append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)"body1", (Locale)locale)).append("\n");
            message.setLocaleStringHeader("body", sbBody.toString(), locale);
            message.setLocaleStringHeader("sender", this.forewarnItemInfo.getCreator() == null ? "" : StringUtils.cnulls((String)this.forewarnItemInfo.getCreator().getNumber()), locale);
            message.setLocaleStringHeader("initiatorName", this.forewarnItemInfo.getCreator() == null ? "" : StringUtils.cnulls((String)this.forewarnItemInfo.getCreator().getNumber()), locale);
        }
        message.setStringHeader("sourceIDs", null);
        message.setStringHeader("receiver", StringUtils.cnulls((Object)this.forewarnItemInfo.getCreator().getId()));
        return message;
    }

    @Override
    public void sendMessage(Context ctx) {
        ForewarnMsgFactory msgFactory = null;
        ForewarnMessageInfo forewarMessageInfo = this.forewarnItemInfo.getMessage();
        boolean needMergeMessages = forewarMessageInfo.isNeedMergeMessages();
        if (!StringUtils.isEmpty((String)forewarMessageInfo.getAttrKeys()) && !StringUtils.isEmpty((String)forewarMessageInfo.getAttrScript()) && this.isNotEmpty(this.mailMsgList)) {
            try {
                this.dealAllVarsMsg(this.mailMsgList, needMergeMessages);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.isNotEmpty(this.mailMsgList)) {
            this.logger.info((Object)"\u53d1\u9001\u9884\u8b66\u6d88\u606f\u5f00\u59cb......");
            msgFactory = new ForewarnMailMsgFactory(this.ctx, this.forewarnItemInfo, this.forewarnVars, this.businessCollections, this.businessFacades);
            ArrayList msgList = this.mailMsgList;
            if (forewarMessageInfo != null && needMergeMessages) {
                msgList = this.dealAll2OneMsg(msgList);
            }
            msgFactory.sendMsg(msgList);
            this.alreaySendUserList.append(this.getAlreadyMsg(msgList, "receiver"));
            this.mailMsgList.clear();
        }
        if (this.isNotEmpty(this.mobilMsgList)) {
            this.logger.info((Object)"\u53d1\u9001\u6d88\u606f\u7ed9\u624b\u673a......");
            msgFactory = new ForewarnMobileMsgFactory(this.ctx, this.forewarnItemInfo, this.forewarnVars, this.businessCollections, this.businessFacades);
            if (needMergeMessages) {
                this.mobilMsgList = this.dealAll2OneMsg(this.mobilMsgList);
            }
            msgFactory.sendMsg(this.mobilMsgList);
            this.mobilMsgList.clear();
        }
        if (this.isNotEmpty(this.emailMsgList)) {
            this.logger.info((Object)"\u53d1\u9001\u90ae\u4ef6......");
            this.sendEMailMessage(needMergeMessages);
        }
        if (this.isNotEmpty(this.weiboMsgList)) {
            this.logger.info((Object)"\u53d1\u9001\u77ed\u90ae......");
            this.sendWeiboMsg(needMergeMessages);
        }
        if (this.isNeedSendCloudMsg() && this.isNotEmpty(this.cloudMsgList)) {
            this.logger.info((Object)"\u53d1\u9001\u4e91\u4e4b\u5bb6......");
            this.sendCloudMsg(ctx, needMergeMessages);
        }
    }

    private void sendCloudMsg(Context context, boolean needMergeMessages) {
        try {
            if (needMergeMessages) {
                this.cloudMsgList = this.dealAllOneCloudMsg(this.cloudMsgList);
            }
            Class<?> clz = Class.forName(this.forewarnItemInfo.getExtClassPath());
            Object o = clz.newInstance();
            Method method = clz.getMethod("sendCloudMsg", Context.class, List.class, ForewarnItemInfo.class);
            method.invoke(o, context, this.cloudMsgList, this.forewarnItemInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u53d1\u9001\u4e91\u4e4b\u5bb6\u5931\u8d25...", (Throwable)e);
        }
    }

    private void sendWeiboMsg(boolean needMergeMessages) {
        ArrayList newWeiboMsgList = this.weiboMsgList;
        if (needMergeMessages) {
            newWeiboMsgList = this.dealAll2OneWeiboMsg(this.weiboMsgList);
        }
        if (ForewarnUserInfo.isAdmin(this.ctx)) {
            for (int i = 0; i < newWeiboMsgList.size(); ++i) {
                WeiboMsgInfo weiboMsgInfo = (WeiboMsgInfo)newWeiboMsgList.get(i);
                weiboMsgInfo.adminSendWeiboMsg(this.ctx);
            }
        } else {
            String userId = this.ctx.getCaller().toString();
            String personId = null;
            try {
                personId = ForewarnUserInfo.getPersonID(this.ctx, userId);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            if (personId == null) {
                return;
            }
            for (int i = 0; i < newWeiboMsgList.size(); ++i) {
                WeiboMsgInfo weiboMsgInfo = (WeiboMsgInfo)newWeiboMsgList.get(i);
                weiboMsgInfo.sendWeiboMsg(this.ctx);
            }
        }
        this.weiboMsgList.clear();
    }

    private ArrayList dealAll2OneWeiboMsg(ArrayList allMsg) {
        if (allMsg == null || allMsg.size() == 0) {
            return null;
        }
        HashMap<String, WeiboMsgInfo> allMsgMap = new HashMap<String, WeiboMsgInfo>();
        for (int i = 0; i < allMsg.size(); ++i) {
            WeiboMsgInfo weiboMsgInfo = (WeiboMsgInfo)allMsg.get(i);
            WeiboMsgInfo tmpWeiboMsgInfo = (WeiboMsgInfo)allMsgMap.get(weiboMsgInfo.getReceiver());
            if (tmpWeiboMsgInfo != null) {
                tmpWeiboMsgInfo.setContent(weiboMsgInfo.getContent() + tmpWeiboMsgInfo.getContent());
                allMsgMap.put(tmpWeiboMsgInfo.getReceiver(), tmpWeiboMsgInfo);
                continue;
            }
            allMsgMap.put(weiboMsgInfo.getReceiver(), weiboMsgInfo);
        }
        ArrayList newAllMsg = new ArrayList();
        newAllMsg.addAll(allMsgMap.values());
        return newAllMsg;
    }

    private void sendEMailMessage(boolean needMergeMessages) {
        ArrayList list = this.emailMsgList;
        if (needMergeMessages) {
            list = this.dealAll2OneEMailMsg(this.emailMsgList);
        }
        for (int i = 0; i < list.size(); ++i) {
            MailMsgInfo mmInfo = (MailMsgInfo)list.get(i);
            try {
                String content = this.assembleHTMLMailContent(mmInfo.getContent());
                mmInfo.setContent(content);
                mmInfo.sendMail(this.ctx);
                continue;
            }
            catch (BOSException e) {
                this.logger.error((Object)"send email msg fail! ", (Throwable)e);
                continue;
            }
            catch (EASBizException e) {
                this.logger.error((Object)"send email msg fail!", (Throwable)e);
            }
        }
        this.emailMsgList.clear();
    }

    private boolean isNotEmpty(ArrayList list) {
        return list != null && !list.isEmpty();
    }

    private String getAlreadyMsg(List msgList, String contentStr) {
        if (msgList == null || msgList.isEmpty()) {
            return "";
        }
        StringBuffer retList = new StringBuffer("");
        for (int i = 0; i < msgList.size(); ++i) {
            Message msg = (Message)msgList.get(i);
            String oneStr = msg.getStringHeader(contentStr);
            if (StringUtils.isEmpty((String)oneStr) || retList.indexOf(oneStr) != -1) continue;
            retList.append(",").append(oneStr);
        }
        return retList.toString().substring(1);
    }

    private boolean isBodyTooLong(String combinMsgBody) {
        LanguageCollection languageCollection = this.solutionInfo.getLanguages();
        int languageSize = languageCollection.size();
        for (int j = 0; j < languageSize; ++j) {
            Locale locale = languageCollection.get(j).getLocale();
            if (combinMsgBody.getBytes().length <= 60000) continue;
            return true;
        }
        return false;
    }

    private ArrayList dealAll2OneMsg(ArrayList allMsg) {
        if (allMsg == null) {
            return null;
        }
        HashMap<String, Message> allMsgMap = new HashMap<String, Message>();
        ArrayList<Object> largeMsgList = new ArrayList<Object>();
        LanguageCollection languageCollection = this.solutionInfo.getLanguages();
        int languageSize = languageCollection.size();
        for (int i = 0; i < allMsg.size(); ++i) {
            Message tempMsg = (Message)allMsg.get(i);
            Message alreadyMsg = (Message)allMsgMap.get(tempMsg.getStringHeader("receiver"));
            if (alreadyMsg != null) {
                String alreadySourceIds;
                boolean isMsgBodyToLong = false;
                for (int j = 0; j < languageSize; ++j) {
                    Locale locale = languageCollection.get(j).getLocale();
                    String combinMsgBody = alreadyMsg.getLocaleStringHeader("body", locale) + "\n" + tempMsg.getLocaleStringHeader("body", locale);
                    if (combinMsgBody.getBytes().length > 60000) {
                        isMsgBodyToLong = true;
                        break;
                    }
                    alreadyMsg.setLocaleStringHeader("body", combinMsgBody, locale);
                }
                if (isMsgBodyToLong) {
                    largeMsgList.add(alreadyMsg);
                    allMsgMap.remove(tempMsg.getStringHeader("receiver"));
                    continue;
                }
                String sourceIds = alreadySourceIds = alreadyMsg.getStringHeader("sourceIDs");
                String tmpSourceIds = tempMsg.getStringHeader("sourceIDs");
                if (tmpSourceIds != null && tmpSourceIds.startsWith("(")) {
                    tmpSourceIds = tmpSourceIds.substring(1, tmpSourceIds.length());
                    if (StringUtils.isEmpty((String)alreadySourceIds)) {
                        alreadySourceIds = "(";
                    } else {
                        if (alreadySourceIds.endsWith(")")) {
                            alreadySourceIds = alreadySourceIds.substring(0, alreadySourceIds.length() - 1);
                        }
                        alreadySourceIds = alreadySourceIds + ",";
                    }
                    sourceIds = alreadySourceIds + tmpSourceIds;
                }
                alreadyMsg.setStringHeader("sourceIDs", sourceIds);
                allMsgMap.put(alreadyMsg.getStringHeader("receiver"), alreadyMsg);
                continue;
            }
            allMsgMap.put(tempMsg.getStringHeader("receiver"), tempMsg);
        }
        largeMsgList.addAll(allMsgMap.values());
        return new ArrayList(largeMsgList);
    }

    private void dealAllVarsMsg(ArrayList allMsg, boolean needMergeMessages) throws BOSException, EASBizException {
        block7: {
            if (allMsg == null) break block7;
            if (needMergeMessages) {
                HashMap<String, Message> allMsgMap = new HashMap<String, Message>();
                LanguageCollection languageCollection = this.solutionInfo.getLanguages();
                int languageSize = languageCollection.size();
                for (int i = 0; i < allMsg.size(); ++i) {
                    Message tempMsg = (Message)allMsg.get(i);
                    Message alreadyMsg = (Message)allMsgMap.get(tempMsg.getStringHeader("receiver"));
                    if (alreadyMsg != null) {
                        for (int j = 0; j < languageSize; ++j) {
                            Locale locale = languageCollection.get(j).getLocale();
                            String combinMsgBody = alreadyMsg.getLocaleStringHeader(Vars, locale) + "," + tempMsg.getLocaleStringHeader(Vars, locale);
                            alreadyMsg.setLocaleStringHeader(Vars, combinMsgBody, locale);
                        }
                        allMsgMap.put(alreadyMsg.getStringHeader("receiver"), alreadyMsg);
                        continue;
                    }
                    allMsgMap.put(tempMsg.getStringHeader("receiver"), tempMsg);
                }
                for (Map.Entry entry : allMsgMap.entrySet()) {
                    Message msg;
                    IObjectPK pk = this.insertVarsInfo(msg = (Message)entry.getValue());
                    msg.setStringHeader("forewarnDynVarsId", pk == null ? null : pk.toString());
                }
            } else {
                for (int i = 0; i < allMsg.size(); ++i) {
                    Message msg;
                    IObjectPK pk = this.insertVarsInfo(msg = (Message)allMsg.get(i));
                    msg.setStringHeader("forewarnDynVarsId", pk == null ? null : pk.toString());
                }
            }
        }
    }

    private IObjectPK insertVarsInfo(Message msg) {
        try {
            ForewarnDynVarsInfo fVars = new ForewarnDynVarsInfo();
            LanguageCollection languageCollection = this.solutionInfo.getLanguages();
            int languageSize = languageCollection.size();
            for (int i = 0; i < languageSize; ++i) {
                Locale locale = languageCollection.get(i).getLocale();
                fVars.setVal("[" + msg.getLocaleStringHeader(Vars, locale) + "]", locale);
                msg.setLocaleStringHeader(Vars, "", locale);
            }
            fVars.setCreateTime(new Timestamp(new Date().getTime()));
            fVars.setItemId(msg.getStringHeader("itemId"));
            return this.iDynVars.addnew(fVars);
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Message mergeMsg(LanguageCollection languageCollection, String mergeRule, HashSet<String> rule, Message alreadyMsg, Message tempMsg) {
        if (alreadyMsg == null) {
            alreadyMsg = tempMsg;
        } else if (!StringUtils.isEmpty((String)tempMsg.getStringHeader("extendParam"))) {
            // empty if block
        }
        for (String key : rule) {
            IMergeMessage merger = MergeConvertFactory.getInstance().getMerger(key);
            try {
                for (int j = 0; j < languageCollection.size(); ++j) {
                    tempMsg = merger.merge(alreadyMsg, tempMsg, key, languageCollection.get(j).getLocale());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int j = 0; j < languageCollection.size(); ++j) {
            String mergeRuleMessage = mergeRule;
            for (String key : rule) {
                mergeRuleMessage = mergeRuleMessage.replace("@@" + key + "@", tempMsg.getLocaleStringHeader(key, languageCollection.get(j).getLocale()));
            }
            tempMsg.setLocaleStringHeader("body", mergeRuleMessage, languageCollection.get(j).getLocale());
        }
        return tempMsg;
    }

    private HashSet<String> getRule(String mergeRule) {
        HashSet<String> rule = new HashSet<String>();
        if (StringUtils.isEmpty((String)mergeRule)) {
            return rule;
        }
        while (mergeRule.indexOf("@@") >= 0) {
            int index = mergeRule.indexOf("@@");
            mergeRule = mergeRule.substring(index + 2);
            index = mergeRule.indexOf("@");
            String ruleItem = mergeRule.substring(0, index);
            rule.add(ruleItem);
        }
        return rule;
    }

    private ArrayList dealAll2OneEMailMsg(ArrayList allMsg) {
        if (allMsg == null) {
            return null;
        }
        HashMap<String, MailMsgInfo> allMsgMap = new HashMap<String, MailMsgInfo>();
        for (int i = 0; i < allMsg.size(); ++i) {
            String[] receiverArray;
            MailMsgInfo tempMsg = (MailMsgInfo)allMsg.get(i);
            String receivers = tempMsg.getReceiver();
            for (String receiver : receiverArray = receivers.split(";")) {
                MailMsgInfo alreadyMsg = (MailMsgInfo)allMsgMap.get(receiver);
                if (alreadyMsg != null) {
                    alreadyMsg.setContent(alreadyMsg.getContent() + tempMsg.getContent());
                    continue;
                }
                MailMsgInfo mailMsgInfo = this.cloneMail(tempMsg);
                mailMsgInfo.setReceiver(receiver);
                allMsgMap.put(receiver, mailMsgInfo);
            }
        }
        return new ArrayList(allMsgMap.values());
    }

    private MailMsgInfo cloneMail(MailMsgInfo msgInfo) {
        MailMsgInfo mailMsgInfo = new MailMsgInfo();
        mailMsgInfo.setMsgTitle(msgInfo.getMsgTitle());
        mailMsgInfo.setReceiver(msgInfo.getReceiver());
        mailMsgInfo.setContent(msgInfo.getContent());
        mailMsgInfo.setCopyReceiver(msgInfo.getCopyReceiver());
        mailMsgInfo.setSecretReceiver(msgInfo.getSecretReceiver());
        mailMsgInfo.setSender(msgInfo.getSender());
        return mailMsgInfo;
    }

    private ArrayList dealAllOneCloudMsg(ArrayList allMsg) {
        if (allMsg == null) {
            return null;
        }
        HashMap<String, CloudMsgInfo> allMsgMap = new HashMap<String, CloudMsgInfo>();
        for (int i = 0; i < allMsg.size(); ++i) {
            CloudMsgInfo tempMsg = (CloudMsgInfo)allMsg.get(i);
            String userId = tempMsg.getUserInfo().getId().toString();
            CloudMsgInfo alreadyMsg = (CloudMsgInfo)allMsgMap.get(userId);
            if (alreadyMsg != null) {
                alreadyMsg.setBody(alreadyMsg.getBody() + tempMsg.getBody());
                alreadyMsg.setTitle(tempMsg.getTitle());
                allMsgMap.put(userId, alreadyMsg);
                continue;
            }
            allMsgMap.put(userId, tempMsg);
        }
        return new ArrayList(allMsgMap.values());
    }

    private boolean checkMessageCapacity() {
        LanguageCollection languageCollection = this.solutionInfo.getLanguages();
        int languageSize = languageCollection.size();
        for (int j = 0; j < languageSize; ++j) {
            Locale locale = languageCollection.get(j).getLocale();
            String body = this.errorMsg.getLocaleStringHeader("body", locale);
            if (body.getBytes().length <= 10000) continue;
            return false;
        }
        return true;
    }

    @Override
    public void buildErrorMessage(String errorTypeName, int number, boolean isNeedCount) {
        if (this.errorMsg == null) {
            this.errorMsg = this.createErrorMessage();
        }
        LanguageCollection languageCollection = this.solutionInfo.getLanguages();
        int languageSize = languageCollection.size();
        for (int j = 0; j < languageSize; ++j) {
            Locale locale = languageCollection.get(j).getLocale();
            StringBuffer bodyTitle = new StringBuffer(this.errorMsg.getLocaleStringHeader("body", locale));
            int maxForewarnCount = 100;
            if (this.forewarnItemInfo != null) {
                maxForewarnCount = this.forewarnItemInfo.getMaxForewarnCount();
            }
            StringBuffer sbBody = new StringBuffer();
            sbBody.append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)errorTypeName, (Locale)locale)).append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)(errorTypeName + 1), (Locale)locale)).append(String.valueOf(maxForewarnCount)).append("\n");
            if (isNeedCount) {
                sbBody.append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)(errorTypeName + 2), (Locale)locale)).append(String.valueOf(number));
            }
            bodyTitle.append(sbBody);
            this.errorMsg.setLocaleStringHeader("body", bodyTitle.toString(), locale);
        }
        this.errorMsgList.add(this.errorMsg);
    }

    @Override
    public void buildErrorMessage(Exception e, String errorTypeName) {
        if (this.errorMsg == null) {
            this.errorMsg = this.createErrorMessage();
        }
        if (this.checkMessageCapacity()) {
            LanguageCollection languageCollection = this.solutionInfo.getLanguages();
            int languageSize = languageCollection.size();
            for (int j = 0; j < languageSize; ++j) {
                Locale locale = languageCollection.get(j).getLocale();
                String body = this.errorMsg.getLocaleStringHeader("body", locale);
                StringBuffer sbBody = new StringBuffer(body);
                sbBody.append(ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.app.ForewarnApp", (String)errorTypeName, (Locale)locale)).append("\n").append(e.getMessage()).append("\n");
                this.errorMsg.setLocaleStringHeader("body", sbBody.toString(), locale);
            }
        }
        this.errorMsgList.add(this.errorMsg);
    }

    @Override
    public void sendErrorMessage() {
        this.logger.info((Object)"\u53d1\u9001\u9884\u8b66\u5931\u8d25\u6d88\u606f\u5f00\u59cb");
        LowTimer sendMessageTimer = new LowTimer();
        ForewarnMailMsgFactory mailFactory = new ForewarnMailMsgFactory();
        ((ForewarnMsgFactory)mailFactory).sendMsg(this.errorMsgList);
        String oneUserStr = this.getAlreadyMsg(this.errorMsgList, "receiver");
        if (this.alreaySendUserList != null && !StringUtils.isEmpty((String)oneUserStr) && this.alreaySendUserList.indexOf(oneUserStr) == -1) {
            this.alreaySendUserList.append(";").append(oneUserStr);
        }
        this.logger.info((Object)("...msg is:" + this.alreaySendUserList));
        this.errorMsgList.clear();
        this.logger.info((Object)("\u53d1\u9001\u9884\u8b66\u5931\u8d25\u6d88\u606f\u7ed3\u675f,\u5171\u8017\u65f6:\t" + sendMessageTimer.msValue()));
    }

    private String getCurrentTime() {
        return "(" + DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ")";
    }

    private String assembleHTMLMailContent(String mailTextContent) {
        if (HTMLElementUtil.isHTMLContent(mailTextContent)) {
            StringBuffer htmlElementBuf = new StringBuffer();
            String[] infos = mailTextContent.split("\n");
            htmlElementBuf.append("<table border='1' align='center' cellspacing='0' cellpadding='0' width='90%'>");
            for (int i = 0; i < infos.length; ++i) {
                if (i == 0) {
                    htmlElementBuf.append("<tr style=\"background-color:#CCCCCC\">").append(HTMLElementUtil.assembleHTMLTableTHElement(infos[i], "th")).append("</tr>");
                    htmlElementBuf.append("<tr>").append(HTMLElementUtil.assembleHTMLTableTHElement(infos[i], "td")).append("</tr>");
                    continue;
                }
                htmlElementBuf.append("<tr>").append(HTMLElementUtil.assembleHTMLTableTHElement(infos[i], "td")).append("</tr>");
            }
            htmlElementBuf.append("</table>");
            return htmlElementBuf.toString();
        }
        return mailTextContent;
    }
}

