/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.eas.base.forewarn.app.ForewarnHelper;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ForewarnObjInfo {
    private ForewarnItemInfo forewarnItemInfo = null;
    private Map businessEntities = null;
    private Context currentCtx = null;
    private EntityObjectInfo eoInfo = null;
    private static final String FOREWARN_OBJECT_TYPE = "ForewarnObjectType";
    public static final String FOREWARN_OBJECT_ALIAS = "ForwarnObjectAlias";

    public ForewarnObjInfo(ForewarnItemInfo forewarnItemInfo, Map businessEntities, Context currentCtx, EntityObjectInfo eoInfo) {
        this.forewarnItemInfo = forewarnItemInfo;
        this.businessEntities = businessEntities;
        this.currentCtx = currentCtx;
        this.eoInfo = eoInfo;
    }

    public Map getBusinessCollections(Connection connection) throws Exception {
        HashMap<String, IObjectCollection> collections = new HashMap<String, IObjectCollection>();
        int entitySize = this.forewarnItemInfo.getObjects().size();
        for (int i = 0; i < entitySize; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = this.forewarnItemInfo.getObjects().get(i);
            if (!forewarnObjectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT)) continue;
            String oql = null;
            if (forewarnObjectInfo.getEntityViewInfo() != null) {
                oql = CommonQueryUtil.getInnerFilterInfo((Context)this.currentCtx, (String)forewarnObjectInfo.getEntityViewInfo().toString());
            }
            collections.put(forewarnObjectInfo.getAlias(), this.getCollection(forewarnObjectInfo, oql, connection));
        }
        return collections;
    }

    public ArrayList getInstanceCombinations(ForewarnObjectCollection forewarnObjects, String mainObjID, Connection connection) throws Exception {
        ArrayList instanceCombinations = new ArrayList();
        ForewarnObjectCollection objColl = this.forewarnItemInfo.getObjects();
        ForewarnObjectInfo info = null;
        ForewarnObjectInfo foMainInfo = null;
        int objCollSize = objColl.size();
        for (int i = 0; i < objCollSize; ++i) {
            info = objColl.get(i);
            if (info == null || !info.getType().equals((Object)ForewarnObjectType.MAIN_OBJECT)) continue;
            foMainInfo = info;
            objColl.removeObject(i);
            break;
        }
        ArrayList bizInstances = this.getBizInstances(objColl, connection);
        IObjectValue mainValue = this.getRightnowMainObject(mainObjID, foMainInfo, connection);
        if (mainValue != null) {
            mainValue.setExtendedProperty(FOREWARN_OBJECT_ALIAS, foMainInfo == null ? null : foMainInfo.getAlias());
            mainValue.setExtendedProperty(FOREWARN_OBJECT_TYPE, foMainInfo == null ? null : foMainInfo.getType().getName());
            if (bizInstances == null) {
                bizInstances = new ArrayList();
            }
            ArrayList<IObjectValue> mainList = new ArrayList<IObjectValue>();
            mainList.add(mainValue);
            bizInstances.add(0, mainList);
        }
        ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
        instanceCombinations = helper.combinate(bizInstances);
        return instanceCombinations;
    }

    public ArrayList getInstanceCombinations(ForewarnObjectCollection forewarnObjects, Connection connection) throws Exception {
        ArrayList instanceCombinations = new ArrayList();
        ForewarnObjectCollection objColl = this.forewarnItemInfo.getObjects();
        ForewarnObjectInfo info = null;
        ForewarnObjectInfo foMainInfo = null;
        int objCollSize = objColl.size();
        for (int i = 0; i < objCollSize; ++i) {
            info = objColl.get(i);
            if (info == null || !info.getType().equals((Object)ForewarnObjectType.MAIN_OBJECT)) continue;
            foMainInfo = info;
            this.eoInfo = (EntityObjectInfo)this.businessEntities.get(foMainInfo.getName());
            break;
        }
        ArrayList bizInstances = this.getBizInstances(this.forewarnItemInfo.getObjects(), connection);
        ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
        instanceCombinations = helper.combinate(bizInstances);
        return instanceCombinations;
    }

    private ArrayList getBizInstances(ForewarnObjectCollection forewarnObjects, Connection connection) throws Exception {
        ArrayList bizInstances = new ArrayList();
        int size = forewarnObjects.size();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = forewarnObjects.get(i);
            if (forewarnObjectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) || !forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
            ArrayList<IObjectValue> arrayList = new ArrayList<IObjectValue>();
            String oql = "";
            if (forewarnObjectInfo.getEntityViewInfo() != null) {
                oql = new String(CommonQueryUtil.getInnerFilterInfo((Context)this.currentCtx, (String)forewarnObjectInfo.getEntityViewInfo()));
            }
            IObjectCollection collections = this.getCollection(forewarnObjectInfo, oql, connection);
            int length = collections.size();
            for (int j = 0; j < length; ++j) {
                arrayList.add(collections.getObject(j));
            }
            bizInstances.add(arrayList);
        }
        return bizInstances;
    }

    private IObjectCollection getCollection(ForewarnObjectInfo forewarnObject, String oql, Connection connection) throws Exception {
        IObjectCollection objectCollections = null;
        EntityObjectInfo objectInfo = (EntityObjectInfo)this.businessEntities.get(forewarnObject.getName());
        ORMappingDAO mappingDAO = new ORMappingDAO(objectInfo.getType(), this.currentCtx, connection);
        if (oql != null && !oql.trim().equalsIgnoreCase("")) {
            ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
            objectCollections = mappingDAO.getCollection(helper.processOql(oql));
        } else {
            objectCollections = mappingDAO.getCollection();
        }
        int size = objectCollections.size();
        for (int i = 0; i < size; ++i) {
            objectCollections.getObject(i).setExtendedProperty(FOREWARN_OBJECT_ALIAS, forewarnObject.getAlias());
            objectCollections.getObject(i).setExtendedProperty(FOREWARN_OBJECT_TYPE, forewarnObject.getType().getName());
        }
        return objectCollections;
    }

    private IObjectValue getRightnowMainObject(String mainObjID, ForewarnObjectInfo mainInfo, Connection connection) throws Exception {
        IObjectCollection objectCollections = null;
        this.eoInfo = (EntityObjectInfo)this.businessEntities.get(mainInfo.getName());
        ORMappingDAO mappingDAO = new ORMappingDAO(this.eoInfo.getType(), this.currentCtx, connection);
        String oql = CommonQueryUtil.getInnerFilterInfo((Context)this.currentCtx, (String)mainInfo.getEntityViewInfo());
        EntityViewInfo view = null;
        if (oql == null || oql.trim().length() == 0) {
            view = new EntityViewInfo();
        } else {
            ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
            view = new EntityViewInfo(helper.processOql(oql));
        }
        FilterItemInfo itemInfo = new FilterItemInfo("id", (Object)mainObjID, CompareType.EQUALS);
        if (view.getFilter() == null) {
            FilterInfo info = new FilterInfo();
            info.getFilterItems().add(itemInfo);
            view.setFilter(info);
        } else {
            view.getFilter().getFilterItems().add(itemInfo);
            StringBuffer sbFormula = new StringBuffer(view.getFilter().getMaskString());
            int size = view.getFilter().getFilterItems().size();
            if (size >= 2) {
                sbFormula.append(" and ");
            }
            sbFormula.append(" ( ").append("#").append(String.valueOf(size - 1)).append(" )");
            view.getFilter().setMaskString(sbFormula.toString());
        }
        objectCollections = mappingDAO.getCollection(view);
        return objectCollections.getObject(0);
    }

    public EntityObjectInfo getEoInfo() {
        return this.eoInfo;
    }

    public void setEoInfo(EntityObjectInfo eoInfo) {
        this.eoInfo = eoInfo;
    }
}

