/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.engine.RunFormulaException;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.forewarn.BaseForewarnAppException;
import com.kingdee.eas.base.forewarn.ForewarnItemCollection;
import com.kingdee.eas.base.forewarn.ForewarnItemFactory;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnMessageFactory;
import com.kingdee.eas.base.forewarn.ForewarnMessageInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnReceiverCollection;
import com.kingdee.eas.base.forewarn.ForewarnReceiverInfo;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversCollection;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.eas.base.forewarn.ReceiverType;
import com.kingdee.eas.base.forewarn.Type;
import com.kingdee.eas.base.forewarn.app.AbstractForewarnRunTimeControllerBean;
import com.kingdee.eas.base.forewarn.app.ForewarnForTest;
import com.kingdee.eas.base.forewarn.app.ForewarnFormulaAdapter;
import com.kingdee.eas.base.forewarn.app.ForewarnHelper;
import com.kingdee.eas.base.forewarn.app.ForewarnMsgCenter;
import com.kingdee.eas.base.forewarn.app.ForewarnObjInfo;
import com.kingdee.eas.base.forewarn.app.ForewarnRunContext;
import com.kingdee.eas.base.forewarn.app.ForewarnUserInfo;
import com.kingdee.eas.base.forewarn.app.rolereceiver.MainOrgValueUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ForewarnRunTimeControllerBean
extends AbstractForewarnRunTimeControllerBean {
    private ForewarnItemInfo forewarnItemInfo = null;
    private ForewarnMessageInfo forewarnTemplateMessageInfo = null;
    private Map businessEntities = null;
    private Map businessFacades = null;
    private Map businessCollections = null;
    private IVarInfo[] forewarnVars = null;
    private Context currentCtx = null;
    public static final String RES = "com.kingdee.eas.base.forewarn.app.ForewarnApp";
    private int instanceCount = 1;
    private int forewarnCount = 0;
    public static final String FOREWARN_OBJECT_ALIAS = "ForwarnObjectAlias";
    private long formulaEngineTime = 0L;
    private long getInstancesTime = 0L;
    private boolean hasError = false;
    private Set userFilter = null;
    private Map adminOrgUsers = null;
    private Map positionUsers = null;
    private EntityObjectInfo eoInfo = null;
    private static final int messageCombineCount = 50;
    ForewarnMsgCenter msgCenter = null;
    ForewarnMsgCenter msgCenterTimeZone = null;
    private static final Logger logger = Logger.getLogger(ForewarnRunTimeControllerBean.class);

    private void prepare(Context ctx, ForewarnItemInfo forewarnItemInfo) throws Exception {
        this.currentCtx = ctx;
        this.forewarnItemInfo = forewarnItemInfo;
        this.businessEntities = new HashMap();
        this.businessFacades = new HashMap();
        ForewarnObjectCollection objectCollection = forewarnItemInfo.getObjects();
        int objectCollectionSize = objectCollection.size();
        for (int i = 0; i < objectCollectionSize; ++i) {
            ForewarnObjectInfo objectInfo = objectCollection.get(i);
            String bizObjectName = objectInfo.getName();
            EntityObjectInfo businessObjectInfo = null;
            if (objectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) {
                businessObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.currentCtx).getEntity((IMetaDataPK)new MetaDataPK(bizObjectName));
                this.businessEntities.put(bizObjectName, businessObjectInfo);
                continue;
            }
            businessObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.currentCtx).getFacade((IMetaDataPK)new MetaDataPK(bizObjectName));
            this.businessFacades.put(bizObjectName, businessObjectInfo);
        }
        ForewarnObjInfo objInfo = new ForewarnObjInfo(this.forewarnItemInfo, this.businessEntities, this.currentCtx, this.eoInfo);
        logger.debug((Object)(".......... get obj connection is :" + this.currentCtx.getAIS()));
        Connection connection = null;
        try {
            connection = this.getConnection(this.currentCtx);
            this.businessCollections = objInfo.getBusinessCollections(connection);
        }
        catch (BOSException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)connection);
        this.instanceCount = 0;
        this.forewarnCount = 0;
        this.forewarnVars = ForewarnFormulaAdapter.getVarInfos(new String(this.forewarnItemInfo.getCondition().getContentScript()));
        this.userFilter = ForewarnItemFactory.getLocalInstance(ctx).getInvalidUsers();
        this.hasError = false;
        this.adminOrgUsers = new HashMap();
        this.positionUsers = new HashMap();
    }

    private void release() {
        this.forewarnItemInfo = null;
        this.businessEntities = null;
        this.businessFacades = null;
        this.businessCollections = null;
        this.instanceCount = 0;
        this.forewarnCount = 0;
        this.forewarnVars = null;
        this.userFilter = null;
        this.hasError = false;
        this.adminOrgUsers = null;
        this.positionUsers = null;
        if (this.currentCtx.get((Object)"appServerDate") != null) {
            this.msgCenterTimeZone = this.msgCenter;
        }
        this.msgCenter = null;
        this.currentCtx = null;
    }

    private ForewarnItemInfo getForewarnItem(Context ctx, String forewarnItemID) throws BaseForewarnAppException, EASBizException, BOSException {
        String oql = "select *, schedule.*,message.*,objects.*,condition.*,condition.thresholdCollection.*,receivers.*,templet.*, bizOrg.*,dynReceivers.*, creator.id, creator.name, planTimes.* where id = '" + forewarnItemID + "'";
        this.forewarnItemInfo = ForewarnItemFactory.getLocalInstance(ctx).getForewarnItemInfo(oql);
        if (this.forewarnItemInfo != null && this.forewarnItemInfo.getTemplet() != null && !StringUtils.isEmpty((String)this.forewarnItemInfo.getTemplet().getMessage().getId().toString())) {
            this.forewarnTemplateMessageInfo = ForewarnMessageFactory.getLocalInstance(ctx).getForewarnMessageInfo("select * where id = '" + this.forewarnItemInfo.getTemplet().getMessage().getId().toString() + "'");
        }
        ForewarnObjectCollection objs = this.forewarnItemInfo.getObjects();
        for (int i = 0; i < objs.size(); ++i) {
            ForewarnObjectInfo objectInfo = objs.get(i);
            if (!objectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
            String entityViewInfoSql = objectInfo.getEntityViewInfo();
            String resultSql = CommonQueryUtil.getInnerFilterInfo((Context)ctx, (String)entityViewInfoSql);
            objectInfo.setEntityViewInfo(resultSql);
            objs.setObject(i, (IObjectValue)objectInfo);
        }
        return this.forewarnItemInfo;
    }

    private String execRightnowForewarnItem(Context ctx, String forewarnItemID, String mainObjID) {
        return this.execFWItem(ctx, forewarnItemID, true, mainObjID);
    }

    @Override
    protected String _execForewarnItem(Context ctx, String forewarnItemID) {
        return this.execFWItem(ctx, forewarnItemID, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execFWItem(Context ctx, String forewarnItemID, boolean isRightnowFW, String mainObjID) {
        this.currentCtx = ctx;
        logger.info((Object)("\u9884\u8b66\u5f15\u64ce\u6267\u884c!" + ctx.getAIS() + "   forewarnItemID is: " + forewarnItemID + " mainObjID is:" + mainObjID));
        LowTimer forewarnTimer = new LowTimer();
        logger.debug((Object)"\u9884\u8b66\u5f15\u64ce\u73af\u5883\u521d\u59cb\u5316\u5f00\u59cb!");
        LowTimer timer = new LowTimer();
        try {
            ForewarnItemInfo forewarnItemInfo = this.getForewarnItem(ctx, forewarnItemID);
            if (forewarnItemInfo == null) {
                return "forewarnItemInfo is null";
            }
            if (!this.forewarnItemInfo.getType().equals((Object)Type.ITEM)) {
                logger.debug((Object)".....11 this item is not foreitem");
                this.release();
                return "id(" + forewarnItemInfo.getId().toString() + ") is not item";
            }
            this.prepare(ctx, forewarnItemInfo);
        }
        catch (ObjectNotFoundException oe) {
            logger.error((Object)("forewarnItemID is not found the obj , forewarnItemID is :" + forewarnItemID), (Throwable)oe);
            return "forewarnItemID is not found the obj , forewarnItemID is :" + forewarnItemID;
        }
        catch (Exception e) {
            this.writePreparationError(e);
            this.sendErrorMessage();
            logger.error((Object)"\u9884\u8b66\u5f15\u64ce\u73af\u5883\u521d\u59cb\u5316\u5931\u8d25!", (Throwable)e);
            this.release();
            return e.getMessage();
        }
        logger.info((Object)("\u9884\u8b66\u5f15\u64ce\u73af\u5883\u521d\u59cb\u5316\u5b8c\u6bd5,\u5171\u8017\u65f6:\t" + timer.msValue()));
        if (this.isSimpleForewarn()) {
            String res = this.simpleRun(ctx);
            this.getMsgCenter().sendMessage(ctx);
            this.release();
            return res;
        }
        if (!this.checkForewarnItem(isRightnowFW)) {
            this.sendErrorMessage();
            logger.error((Object)"\u9884\u8b66\u5b9e\u4f8b\u7ec4\u5408\u6570\u4e0d\u5408\u7406,\u4e0d\u8fdb\u884c\u9884\u8b66");
            if (this.instanceCount > this.forewarnItemInfo.getMaxInstanceCount()) {
                this.writeBadInstancesError();
                return ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"0_ForewarnRunTimeControllerBean", (Locale)ctx.getLocale());
            }
            this.release();
            return "forewarn obj component is not fit,not run forewarn";
        }
        logger.info((Object)"\u9884\u8b66\u5b9e\u4f8b\u7ec4\u5408\u6570\u5408\u7406,\u53ef\u4ee5\u9884\u8b66");
        ArrayList instanceCombinations = new ArrayList();
        Connection connection = null;
        try {
            connection = this.getConnection(this.currentCtx);
            ForewarnObjInfo objInfo = new ForewarnObjInfo(this.forewarnItemInfo, this.businessEntities, this.currentCtx, this.eoInfo);
            if (isRightnowFW) {
                logger.debug((Object)(".......... get obj connection is :" + this.currentCtx.getAIS()));
                instanceCombinations = objInfo.getInstanceCombinations(this.forewarnItemInfo.getObjects(), mainObjID, connection);
            } else {
                logger.debug((Object)(".......... get obj connection is :" + this.currentCtx.getAIS()));
                instanceCombinations = objInfo.getInstanceCombinations(this.forewarnItemInfo.getObjects(), connection);
            }
            this.eoInfo = objInfo.getEoInfo();
        }
        catch (Exception e) {
            String string;
            try {
                this.writeGetInstancesError(e);
                this.sendErrorMessage();
                logger.error((Object)"\u83b7\u5f97\u5168\u90e8\u9884\u8b66\u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
                this.release();
                string = e.getMessage();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(connection);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)connection);
            return string;
        }
        SQLUtils.cleanup((Connection)connection);
        this.getInstancesTime = timer.msValue();
        logger.info((Object)("\u83b7\u5f97\u9884\u8b66\u5b9e\u4f8b\u5b8c\u6bd5,\u5171\u8017\u65f6:\t" + timer.msValue()));
        logger.debug((Object)"\u68c0\u67e5\u6240\u6709\u5b9e\u4f8b\u5f00\u59cb");
        timer.reset();
        String batchStr = isRightnowFW ? this.executeRightNowForewarn(ctx, instanceCombinations) : this.batchHanderFW(ctx);
        if (batchStr != null) {
            return batchStr;
        }
        logger.info((Object)("\u68c0\u67e5\u6240\u6709\u5b9e\u4f8b\u5b8c\u6bd5,\u5171\u8017\u65f6:\t" + timer.msValue()));
        int msgCount = this.getMsgCenter().getMessageCount();
        this.getMsgCenter().sendMessage(ctx);
        try {
            long forewarnEngineTime = forewarnTimer.msValue();
            logger.debug((Object)("\u9884\u8b66\u5f15\u64ce\u6267\u884c\u5b8c\u6bd5,\u5171\u8017\u65f6:\t" + forewarnEngineTime));
            double per = Double.parseDouble(String.valueOf(this.formulaEngineTime)) / Double.parseDouble(String.valueOf(forewarnEngineTime));
            String str = String.valueOf(per);
            String strPer = "unknow";
            if (str.length() > 5) {
                strPer = str.substring(2, 4) + "%";
            }
            StringBuffer log = new StringBuffer();
            log.append("\n------------------------------------  \u9884\u8b66\u62a5\u544a  -----------------------------------------").append("\n-\t\t\u672c\u6b21\u5b9e\u4f8b\u7ec4\u5408\u4e2a\u6570\u4e3a:  " + this.instanceCount).append("\n-\t\t\u7b26\u5408\u9884\u8b66\u6761\u4ef6\u5b9e\u4f8b\u7ec4\u5408\u4e2a\u6570\u4e3a:  " + this.forewarnCount).append("\n-\t\t\u9884\u8b66\u5f15\u64ce\u53d1\u9001\u4e86 " + msgCount + " \u6761\u6d88\u606f!").append("\n-\t\t\u9884\u8b66\u5f15\u64ce\u603b\u8017\u65f6:  " + forewarnEngineTime).append("\n-\t\t\u5176\u4e2d\u9884\u8b66\u5f15\u64ce\u83b7\u53d6\u5b9e\u4f8b\u8017\u65f6:  " + this.getInstancesTime).append("\n-\t\t\u5176\u4e2d\u516c\u5f0f\u5f15\u64ce\u8017\u65f6:  " + this.formulaEngineTime + ",\u5360\u603b\u8017\u65f6\u7684" + strPer).append("\n-----------------------------------------------------------------------------------------");
            logger.info((Object)log.toString());
        }
        catch (Exception e1) {
            logger.error((Object)e1.getCause());
        }
        if (this.hasError) {
            this.sendErrorMessage();
        }
        String alreadSendUserList = this.getMsgCenter().getAlreaySendUserList();
        this.release();
        return alreadSendUserList;
    }

    private String batchHanderFW(Context ctx) {
        try {
            boolean isEmpty = true;
            int foresize = this.forewarnItemInfo.getObjects().size();
            for (int index = 0; index < foresize; ++index) {
                ForewarnObjectInfo forewarnObjectInfo = this.forewarnItemInfo.getObjects().get(index);
                if (forewarnObjectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) || !forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
                isEmpty = false;
                ArrayList arrayList = new ArrayList();
                String oql = "";
                if (forewarnObjectInfo.getEntityViewInfo() != null) {
                    oql = new String(CommonQueryUtil.getInnerFilterInfo((Context)this.currentCtx, (String)forewarnObjectInfo.getEntityViewInfo()));
                }
                EntityObjectInfo objectInfo = (EntityObjectInfo)this.businessEntities.get(forewarnObjectInfo.getName());
                if (this.forewarnTemplateMessageInfo != null && this.forewarnTemplateMessageInfo.isNeedSortMessages() && !StringUtils.isEmpty((String)this.forewarnTemplateMessageInfo.getSortField())) {
                    oql = this.forewarnTemplateMessageInfo.getSortRule().getValue() == 1 ? oql + " order by " + this.forewarnTemplateMessageInfo.getSortField() + " asc" : oql + " order by " + this.forewarnTemplateMessageInfo.getSortField() + " desc";
                }
                ICoreBase bizInterface = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)this.currentCtx, (IMetaDataPK)new MetaDataPK(objectInfo.getFullName()));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                if (oql != null && !oql.trim().equalsIgnoreCase("")) {
                    ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
                    entityViewInfo = new EntityViewInfo(helper.processOql(oql));
                }
                int totalCount = bizInterface.getCount(entityViewInfo);
                int pagerows = 100000 / (objectInfo.getProperties().size() + 1);
                int pages = totalCount / pagerows + 1;
                for (int k = 0; k < pages; ++k) {
                    List list = bizInterface.getPagingList(entityViewInfo, k * pagerows, pagerows);
                    for (int j = 0; j < list.size(); ++j) {
                        ((IObjectValue)list.get(j)).setExtendedProperty(FOREWARN_OBJECT_ALIAS, forewarnObjectInfo.getAlias());
                        ((IObjectValue)list.get(j)).setExtendedProperty("ForewarnObjectType", forewarnObjectInfo.getType().getName());
                    }
                    ArrayList instanceCombinations = (ArrayList)list;
                    int size = instanceCombinations.size();
                    ArrayList<ArrayList> needFWInstanceConbinations = new ArrayList<ArrayList>();
                    for (int i = 0; i < size; ++i) {
                        ArrayList instanceCombination = null;
                        if (instanceCombinations.get(i) instanceof ArrayList) {
                            instanceCombination = (ArrayList)instanceCombinations.get(i);
                        } else {
                            instanceCombination = new ArrayList();
                            instanceCombination.add(instanceCombinations.get(i));
                        }
                        logger.debug((Object)(".......... instance size is:" + instanceCombination.size()));
                        boolean result = false;
                        try {
                            result = this.execInstanceUnit(instanceCombination);
                        }
                        catch (Exception e) {
                            this.hasError = true;
                            this.writeExecConditionError(e);
                            logger.error((Object)"\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
                            result = false;
                        }
                        if (!result) continue;
                        ++this.forewarnCount;
                        if (this.forewarnCount > this.forewarnItemInfo.getMaxForewarnCount()) {
                            this.writeBadForewarnError();
                            this.sendErrorMessage();
                            logger.info((Object)"\u6ee1\u8db3\u9884\u8b66\u6761\u4ef6\u5b9e\u4f8b\u6570\u5927\u4e8e\u6700\u5927\u6570");
                            this.release();
                            needFWInstanceConbinations.clear();
                            needFWInstanceConbinations = null;
                            return "forewarn obj is over max count" + this.forewarnItemInfo.getMaxForewarnCount() + " now is:" + this.forewarnCount;
                        }
                        needFWInstanceConbinations.add(instanceCombination);
                    }
                    if (needFWInstanceConbinations == null || needFWInstanceConbinations.size() == 0) continue;
                    this.buildAllMessages(needFWInstanceConbinations);
                }
            }
            if (isEmpty) {
                String res = null;
                if (this.businessFacades != null && this.businessFacades.size() > 0) {
                    res = this.simpleRun(ctx);
                }
                logger.debug((Object)("run simpleRun over , res is:" + res));
            }
        }
        catch (Exception e) {
            this.writeGetInstancesError(e);
            this.sendErrorMessage();
            logger.error((Object)"\u83b7\u5f97\u5168\u90e8\u9884\u8b66\u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
            this.release();
            return e.getMessage();
        }
        return null;
    }

    private String executeRightNowForewarn(Context ctx, ArrayList instanceCombinations) {
        ArrayList<ArrayList> needFWInstanceConbinations = new ArrayList<ArrayList>();
        int size = instanceCombinations.size();
        try {
            if (size == 0) {
                String res = null;
                if (this.businessFacades != null && this.businessFacades.size() > 0) {
                    res = this.simpleRun(ctx);
                }
                logger.debug((Object)("run simpleRun over , res is:" + res));
            } else {
                for (int i = 0; i < size; ++i) {
                    ArrayList instanceCombination = null;
                    if (instanceCombinations.get(i) instanceof ArrayList) {
                        instanceCombination = (ArrayList)instanceCombinations.get(i);
                    } else {
                        instanceCombination = new ArrayList();
                        instanceCombination.add(instanceCombinations.get(i));
                    }
                    logger.debug((Object)(".......... instance size is:" + instanceCombination.size()));
                    boolean result = false;
                    try {
                        result = this.execInstanceUnit(instanceCombination);
                    }
                    catch (Exception e) {
                        this.hasError = true;
                        this.writeExecConditionError(e);
                        logger.error((Object)"\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
                        result = false;
                    }
                    if (!result) continue;
                    ++this.forewarnCount;
                    if (this.forewarnCount > this.forewarnItemInfo.getMaxForewarnCount()) {
                        this.writeBadForewarnError();
                        this.sendErrorMessage();
                        logger.info((Object)"\u6ee1\u8db3\u9884\u8b66\u6761\u4ef6\u5b9e\u4f8b\u6570\u5927\u4e8e\u6700\u5927\u6570");
                        this.release();
                        needFWInstanceConbinations.clear();
                        needFWInstanceConbinations = null;
                        return "forewarn obj is over max count" + this.forewarnItemInfo.getMaxForewarnCount() + " now is:" + this.forewarnCount;
                    }
                    needFWInstanceConbinations.add(instanceCombination);
                }
                if (needFWInstanceConbinations == null || needFWInstanceConbinations.size() == 0) {
                    return "not found need forewarn object ! object is null or size is 0";
                }
            }
            this.buildAllMessages(needFWInstanceConbinations);
        }
        catch (Exception e) {
            this.writeGetInstancesError(e);
            this.sendErrorMessage();
            logger.error((Object)"\u83b7\u5f97\u5168\u90e8\u9884\u8b66\u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
            this.release();
            return e.getMessage();
        }
        return null;
    }

    private boolean execInstanceUnit(ArrayList unit) throws BOSException, ParseException, RunFormulaException {
        logger.debug((Object)"\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5f00\u59cb");
        LowTimer unitTimer = new LowTimer();
        boolean flag = false;
        ForewarnRunContext runContext = new ForewarnRunContext(this.currentCtx, this.forewarnItemInfo, this.businessCollections, this.businessFacades);
        Map expressionContext = runContext.getFormulaContext(unit, new String(this.forewarnItemInfo.getCondition().getContentScript()), this.forewarnVars);
        logger.debug((Object)("\u516c\u5f0f\u8868\u8fbe\u5f0f:\t" + new String(this.forewarnItemInfo.getCondition().getContentScript())));
        logger.debug((Object)("\u516c\u5f0f\u8868\u8fbe\u5f0f\u53d8\u91cf:\t" + expressionContext.keySet()));
        String formula = new String(this.forewarnItemInfo.getCondition().getContentScript());
        ForewarnFormulaAdapter foumulaAdapter = new ForewarnFormulaAdapter(this.currentCtx);
        Object result = foumulaAdapter.execScript(formula, expressionContext, null);
        this.formulaEngineTime = foumulaAdapter.getFormulaEngineTime();
        if (result != null) {
            flag = new Boolean(result.toString());
        }
        logger.debug((Object)("\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5b8c\u6bd5,\u5171\u8017\u65f6:\t" + unitTimer.msValue()));
        logger.debug((Object)("\u9884\u8b66\u6761\u4ef6\u8fd4\u56de\u503c\u4e3a:\t" + result));
        logger.debug((Object)("\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5b8c\u6bd5,\u5171\u8017\u65f6:\t" + unitTimer.msValue()));
        return flag;
    }

    private void buildAllMessages(ArrayList needFWInstance) {
        int needFWinstanceSize = needFWInstance.size();
        for (int i = 0; i < needFWinstanceSize; ++i) {
            ArrayList instanceEveryTime = new ArrayList();
            instanceEveryTime.add(needFWInstance.get(i));
            try {
                this.buildMessage(instanceEveryTime);
                continue;
            }
            catch (Exception e) {
                this.hasError = true;
                this.writeParseMsgError(e);
                logger.error((Object)"\u6784\u5efa\u5355\u5143\u7ec4\u5b9e\u4f8b\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            }
        }
    }

    private void buildMessage(ArrayList instanceEveryTime) throws Exception {
        ForewarnUserInfo userInfo = new ForewarnUserInfo(this.currentCtx, this.adminOrgUsers, this.positionUsers, this.forewarnVars, this.businessEntities);
        Object isNotTestForewarn = this.currentCtx.get((Object)"isNotTestForewarn");
        if (this.isHasDynUser()) {
            ForewarnRunContext runContext = null;
            if (this.forewarnItemInfo.getDynReceivers() != null && this.forewarnItemInfo.getDynReceivers().size() > 0) {
                IVarInfo[] vars = ForewarnFormulaAdapter.getVarInfos(new String(this.forewarnItemInfo.getDynReceivers().get(0).getContentScript()));
                runContext = new ForewarnRunContext(this.currentCtx, this.forewarnItemInfo, this.businessCollections, this.businessFacades, vars);
            }
            if (instanceEveryTime == null) {
                userInfo.dealDynReceiver(null, this.forewarnItemInfo, this.userFilter, runContext, isNotTestForewarn);
                this.getMsgCenter().buildMessage(null, userInfo, this.eoInfo);
                return;
            }
            int size = instanceEveryTime.size();
            for (int i = 0; i < size; ++i) {
                ArrayList oneUnit = (ArrayList)instanceEveryTime.get(i);
                userInfo.dealDynReceiver(oneUnit, this.forewarnItemInfo, this.userFilter, runContext, isNotTestForewarn);
                this.getMsgCenter().buildMessage(oneUnit, userInfo, this.eoInfo);
            }
        } else {
            userInfo.dealReceiver(instanceEveryTime, this.forewarnItemInfo, this.userFilter, isNotTestForewarn);
            boolean needMultipleTimeZoom = this.forewarnItemInfo.isNeedMultipleTimeZoom();
            if (needMultipleTimeZoom) {
                int size = instanceEveryTime.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList oneUnit = (ArrayList)instanceEveryTime.get(i);
                    this.getMsgCenter().buildMessage(oneUnit, userInfo, this.eoInfo);
                }
            } else {
                this.getMsgCenter().buildComboMessage(instanceEveryTime, userInfo, this.eoInfo);
            }
        }
    }

    private boolean isHasDynUser() {
        ForewarnUserDefineReceiversCollection coll = this.forewarnItemInfo.getDynReceivers();
        if (coll != null && coll.size() > 0) {
            return true;
        }
        ForewarnReceiverCollection frColl = this.forewarnItemInfo.getReceivers();
        int size = frColl.size();
        for (int i = 0; i < size; ++i) {
            ForewarnReceiverInfo tmpInfo = frColl.get(i);
            if (!tmpInfo.getReceiverType().equals((Object)ReceiverType.DYNAMIC_ORG) && !tmpInfo.getReceiverType().equals((Object)ReceiverType.DYNAMIC_PEOPLE) && !tmpInfo.getReceiverType().equals((Object)ReceiverType.DYNAMIC_USER) && !tmpInfo.getReceiverType().equals((Object)ReceiverType.Role)) continue;
            return true;
        }
        return false;
    }

    private ForewarnMsgCenter getMsgCenter() {
        if (this.msgCenter == null) {
            this.msgCenter = ForewarnMsgCenter.getInstance(this.currentCtx, this.forewarnItemInfo, this.forewarnVars, this.eoInfo, this.businessCollections, this.businessFacades);
        }
        return this.msgCenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForewarnItem(boolean isRightnowFW) {
        Connection connection;
        boolean flag;
        LowTimer checkTimer;
        block9: {
            boolean bl;
            int objectCollectionSize;
            ForewarnObjectCollection objectCollection;
            block8: {
                checkTimer = new LowTimer();
                flag = true;
                connection = null;
                connection = this.getConnection(this.currentCtx);
                objectCollection = this.forewarnItemInfo.getObjects();
                objectCollectionSize = objectCollection.size();
                if (objectCollectionSize > 1 || !isRightnowFW) break block8;
                boolean bl2 = true;
                SQLUtils.cleanup((Connection)connection);
                return bl2;
            }
            try {
                for (int i = 0; i < objectCollectionSize; ++i) {
                    ForewarnObjectInfo objectInfo = objectCollection.get(i);
                    if (objectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) || !objectInfo.getMetadataType().equals((Object)MetadataType.ENTITY) || isRightnowFW && objectInfo.getType().equals((Object)ForewarnObjectType.MAIN_OBJECT)) continue;
                    String entityName = objectInfo.getName();
                    String oql = "";
                    if (objectInfo.getEntityViewInfo() != null) {
                        oql = new String(objectInfo.getEntityViewInfo());
                    }
                    ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
                    IObjectPK[] objectPKs = helper.getPKList(this.businessEntities, this.currentCtx, connection, entityName, oql);
                    int length = objectPKs.length;
                    if (i == 0) {
                        this.instanceCount = length;
                        continue;
                    }
                    this.instanceCount *= length;
                }
                if (this.instanceCount <= this.forewarnItemInfo.getMaxInstanceCount()) break block9;
                logger.debug((Object)("\u5b9e\u4f8b\u7ec4\u5408\u4e2a\u6570" + this.instanceCount + "\u5927\u4e8e\u6700\u5927\u5b9e\u4f8b\u6570" + this.forewarnItemInfo.getMaxInstanceCount()));
                bl = false;
            }
            catch (Exception e) {
                boolean bl3;
                try {
                    this.hasError = true;
                    this.writeCheckInstancesError(e);
                    logger.error((Object)"\u68c0\u67e5\u9884\u8b66\u6761\u76ee\u5b9e\u4f8b\u6570\u5931\u8d25!", (Throwable)e);
                    bl3 = false;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(connection);
                    throw throwable;
                }
                SQLUtils.cleanup((Connection)connection);
                return bl3;
            }
            SQLUtils.cleanup((Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((Connection)connection);
        logger.debug((Object)("\u9884\u8b66\u6761\u76ee\u5b9e\u4f8b\u6570:\t" + this.instanceCount));
        logger.debug((Object)("\u68c0\u67e5\u9884\u8b66\u6761\u76ee\u5b9e\u4f8b\u6570\u5b8c\u6bd5,\u5171\u8017\u65f6:\t" + checkTimer.msValue()));
        return flag;
    }

    private void writePreparationError(Exception e) {
        this.writeMsgError(e, "bodyPrepare");
    }

    private void writeCheckInstancesError(Exception e) {
        this.writeMsgError(e, "checkInstances");
    }

    private void writeGetInstancesError(Exception e) {
        this.writeMsgError(e, "getInstances");
    }

    private void writeExecConditionError(Exception e) {
        this.writeMsgError(e, "execCondition");
    }

    private void writeParseMsgError(Exception e) {
        this.writeMsgError(e, "parseMsg");
    }

    private void writeMsgError(Exception e, String errorTypeName) {
        this.getMsgCenter().buildErrorMessage(e, errorTypeName);
    }

    private void writeBadInstancesError() {
        this.writeMsgError("badInstances", this.instanceCount);
    }

    private void writeBadForewarnError() {
        this.writeMsgError("badForewarn", this.forewarnCount);
    }

    private void writeMsgError(String errorTypeName, int number) {
        this.writeMsgError(errorTypeName, number, true);
    }

    private void writeMsgError(String errorTypeName, int number, boolean isNeedCount) {
        this.getMsgCenter().buildErrorMessage(errorTypeName, number, isNeedCount);
    }

    private void writeBadMessageError() {
        this.writeMsgError("badMessage", 0, false);
    }

    private void sendErrorMessage() {
        this.getMsgCenter().sendErrorMessage();
    }

    @Override
    protected int _getInstanceCount(Context ctx, String entityName, String oql) throws BOSException, BaseForewarnAppException {
        String resultOql = CommonQueryUtil.getInnerFilterInfo((Context)ctx, (String)oql);
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            ORMappingDAO mappingDAO = new ORMappingDAO(objectInfo.getType(), ctx, connection);
            if (resultOql != null && !resultOql.trim().equalsIgnoreCase("")) {
                int n = mappingDAO.getCount(resultOql);
                return n;
            }
            int n = mappingDAO.getCount(new FilterInfo());
            return n;
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    @Override
    protected int _getCombinedInstanceCount(Context ctx, IObjectCollection objects) throws BOSException, BaseForewarnAppException {
        int count = 0;
        ForewarnObjectCollection forewarnObjects = (ForewarnObjectCollection)objects;
        int size = forewarnObjects.size();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo forewarnObject = forewarnObjects.get(i);
            if (forewarnObject.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) || !forewarnObject.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
            String entityName = forewarnObject.getName();
            String oql = null;
            if (forewarnObject.getEntityViewInfo() != null) {
                oql = new String(forewarnObject.getEntityViewInfo());
            }
            if (count == 0) {
                count = this._getInstanceCount(ctx, entityName, oql);
                continue;
            }
            count *= this._getInstanceCount(ctx, entityName, oql);
        }
        return count;
    }

    private String getCorrectInfo() {
        Locale locale = this.currentCtx.getLocale();
        String info = ResourceBase.getString((String)RES, (String)"scriptIsCorrect", (Locale)locale);
        return info;
    }

    private String getNoInstancesInfo() {
        Locale locale = this.currentCtx.getLocale();
        String info = ResourceBase.getString((String)RES, (String)"noInstances", (Locale)locale);
        return info;
    }

    public void prepareForTest(Context ctx, ForewarnItemInfo forewarnItemInfo) throws Exception {
        this.currentCtx = ctx;
        this.forewarnItemInfo = forewarnItemInfo;
        this.businessEntities = new HashMap();
        this.businessFacades = new HashMap();
        ForewarnObjectCollection objectCollection = forewarnItemInfo.getObjects();
        int objectCollectionSize = objectCollection.size();
        for (int i = 0; i < objectCollectionSize; ++i) {
            ForewarnObjectInfo objectInfo = objectCollection.get(i);
            String bizObjectName = objectInfo.getName();
            EntityObjectInfo businessObjectInfo = null;
            if (objectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) {
                businessObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.currentCtx).getEntity((IMetaDataPK)new MetaDataPK(bizObjectName));
                this.businessEntities.put(bizObjectName, businessObjectInfo);
                continue;
            }
            businessObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.currentCtx).getFacade((IMetaDataPK)new MetaDataPK(bizObjectName));
            this.businessFacades.put(bizObjectName, businessObjectInfo);
        }
        ForewarnObjInfo objInfo = new ForewarnObjInfo(this.forewarnItemInfo, this.businessEntities, this.currentCtx, this.eoInfo);
        logger.debug((Object)(".......... get obj connection is :" + this.currentCtx.getAIS()));
        Connection connection = null;
        try {
            connection = this.getConnection(this.currentCtx);
            this.businessCollections = objInfo.getBusinessCollections(connection);
        }
        catch (BOSException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)connection);
        this.instanceCount = 0;
        this.forewarnCount = 0;
        this.forewarnVars = ForewarnFormulaAdapter.getVarInfos(new String(this.forewarnItemInfo.getCondition().getContentScript()));
        this.userFilter = null;
        this.hasError = false;
        this.adminOrgUsers = new HashMap();
        this.positionUsers = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _testScript(Context ctx, String script, IObjectCollection forewarnObjects, IObjectCollection forewarnThresholds) throws BOSException, BaseForewarnAppException {
        if (script == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.SCRIPT_IS_NULL);
        }
        if (forewarnObjects == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.OBJECTS_IS_NULL);
        }
        ForewarnObjectCollection testObjects = (ForewarnObjectCollection)forewarnObjects;
        ForewarnThresholdCollection testThresholds = (ForewarnThresholdCollection)forewarnThresholds;
        ForewarnForTest test = new ForewarnForTest();
        ForewarnItemInfo testItem = test.createTestItem(script, testObjects, testThresholds);
        String info = null;
        try {
            this.prepareForTest(ctx, testItem);
            test.init(this.forewarnItemInfo, this.businessEntities, this.currentCtx);
            info = this.getCorrectInfo();
        }
        catch (Exception e) {
            info = this.getErrorInfo("execScriptError", e);
            this.release();
            return info;
        }
        if (this.isSimpleForewarn()) {
            return this.simpleRunForTest(info);
        }
        ArrayList randomPKCombinations = new ArrayList();
        Connection connection = null;
        try {
            connection = this.getConnection(this.currentCtx);
            ArrayList pkCombinations = test.getPKCombinations(this.forewarnItemInfo.getObjects(), connection);
            randomPKCombinations = test.getRandomPKCombinations(pkCombinations);
        }
        catch (Exception e) {
            String string;
            try {
                info = this.getErrorInfo("execScriptError", e);
                logger.debug((Object)"testForewarnCondition error!", (Throwable)e);
                this.release();
                string = info;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(connection);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)connection);
            return string;
        }
        SQLUtils.cleanup((Connection)connection);
        int size = randomPKCombinations.size();
        if (size == 0) {
            if (this.isSimpleForewarn()) {
                return this.simpleRunForTest(info);
            }
            info = this.getNoInstancesInfo();
            this.release();
            return info;
        }
        for (int i = 0; i < size; ++i) {
            ArrayList pkCombination = null;
            if (randomPKCombinations.get(i) instanceof ArrayList) {
                pkCombination = (ArrayList)randomPKCombinations.get(i);
            } else {
                pkCombination = new ArrayList();
                pkCombination.add(randomPKCombinations.get(i));
            }
            try {
                connection = this.getConnection(this.currentCtx);
                this.execInstanceUnit(test.getInstanceCombination(pkCombination, connection));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
                info = this.getErrorInfo("execScriptError", e);
                this.release();
                String string = info;
                return string;
            }
            finally {
                SQLUtils.cleanup((Connection)connection);
            }
        }
        this.release();
        return info;
    }

    private String simpleRunForTest(String info) {
        try {
            this.execInstanceUnit(null);
        }
        catch (Exception e) {
            logger.error((Object)"\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5931\u8d25!", e.getCause());
            info = this.getErrorInfo("execScriptError", e);
            this.release();
            return info;
        }
        this.release();
        return info;
    }

    private String getErrorInfo(String resName, Exception e) {
        StringBuffer errorInfo = new StringBuffer();
        Locale locale = this.currentCtx.getLocale();
        String info = ResourceBase.getString((String)RES, (String)resName, (Locale)locale);
        errorInfo.append(info).append("\n").append(e.getMessage());
        return errorInfo.toString();
    }

    private String simpleRun(Context ctx) {
        boolean result = false;
        try {
            result = this.execInstanceUnit(null);
        }
        catch (Exception e) {
            this.hasError = true;
            this.writeExecConditionError(e);
            logger.error((Object)"\u6267\u884c\u5355\u5143\u7ec4\u5b9e\u4f8b\u5931\u8d25!111", (Throwable)e);
            result = false;
            return e.getMessage();
        }
        if (result) {
            ++this.forewarnCount;
            if (this.forewarnCount > this.forewarnItemInfo.getMaxForewarnCount()) {
                this.hasError = true;
                this.writeBadForewarnError();
                this.sendErrorMessage();
                String msgStr = ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"10_ForewarnRunTimeControllerBean", (Locale)ctx.getLocale());
                logger.error((Object)msgStr);
                this.release();
                return msgStr;
            }
            Message message = MessageFactory.newMessage((String)"kingdee.forewarn");
            try {
                this.buildMessage(null);
            }
            catch (Exception e) {
                this.hasError = true;
                this.writeParseMsgError(e);
                logger.error((Object)"\u6784\u5efa\u5355\u5143\u7ec4\u5b9e\u4f8b\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            }
            if (message == null) {
                this.hasError = true;
                this.writeBadMessageError();
                this.sendErrorMessage();
                String msgStr = ResourceBase.getString((String)"com.kingdee.eas.base.forewarn.FOREWARNAutoGenerateResource", (String)"11_ForewarnRunTimeControllerBean", (Locale)ctx.getLocale());
                logger.debug((Object)msgStr);
                this.release();
                return msgStr;
            }
        }
        return "run simpleRun over";
    }

    private boolean isSimpleForewarn() {
        ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
        return helper.isSimpleForewarn(this.businessEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _execRightnowForewarn(Context ctx, String uiName, String actionName, String objID) throws BOSException, BaseForewarnAppException {
        StringBuffer querySql = new StringBuffer("select distinct item.FID as FID  from T_FW_RightnowAction action,T_FW_ForewarnItem item,T_FW_ForewarnObject object ").append(" where action.FForewarnTemplateID = item.FID  and object.FItemID = item.FID and item.FType = 0 and FState = 10 and FTouchType='1' and object.FType=0").append(" and FUiName =?").append(" and FActionName = ?");
        Object[] param = new Object[]{uiName, actionName};
        IRowSet rs = null;
        String fid = null;
        boolean result = false;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])param);
            while (rs.next()) {
                fid = rs.getString("FID");
                if (fid == null || fid.equals("")) continue;
                logger.debug((Object)("........begin1 exeRightNowforewarn, uiName is: " + StringUtils.cnulls((String)uiName) + " actionName is:" + StringUtils.cnulls((String)actionName) + " fid is:" + StringUtils.cnulls((String)fid) + " objID is:" + objID));
                this.execRightnowForewarnItem(ctx, fid, objID);
                result = true;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    @Override
    protected boolean _isHasMainOrgProp(Context ctx, String entityName) throws BOSException {
        return MainOrgValueUtil.isHasMainOrgProp(entityName, ctx);
    }

    @Override
    protected void _execTimeZoneForewarnItem(Context ctx) throws BOSException {
        try {
            ctx.put((Object)"appServerDate", (Object)SysUtil.getAppServerTime((Context)ctx));
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logger.error((Object)("==================\u5f53\u524d\u670d\u52a1\u5668\u7cfb\u7edf\u65f6\u95f4\uff1a" + df.format(new Date()) + "=======================\u591a\u65f6\u533a\u9884\u8b66\u540e\u53f0\u4e8b\u52a1\u5f00\u59cb\u6267\u884c..."));
        String oql = "select id,number where Type = 0 and State = 10 and TouchType='0' and needMultipleTimeZoom = 1 ";
        ForewarnItemCollection list = ForewarnItemFactory.getLocalInstance(ctx).getForewarnItemCollection(oql);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ForewarnItemInfo forewarnItemInfo = list.get(i);
                String id = forewarnItemInfo.getId().toString();
                logger.error((Object)("\u591a\u65f6\u533a\u9884\u8b66\u6761\u76eeid:" + id + ",number:" + forewarnItemInfo.getNumber() + ",\u9884\u8b66\u5f00\u59cb..."));
                Object isTestForewarn = ctx.get((Object)"isTestForewarn");
                if (isTestForewarn == null) {
                    ctx.put((Object)"isNotTestForewarn", (Object)true);
                }
                String alreadySendUser = this._execForewarnItem(ctx, id);
                String timeZoomsendMsgLog = null;
                try {
                    timeZoomsendMsgLog = this.getTimeZoomsendMsgLog(ctx, alreadySendUser);
                }
                catch (EASBizException e) {
                    logger.error((Object)("\u591a\u65f6\u533a\u9884\u8b66\u6761\u76eeid:" + id + ",\u9884\u8b66\u7ed3\u675f,\u5c01\u88c5\u8fd4\u56de\u63a5\u6536\u4eba\u4fe1\u606f\u5931\u8d25:" + e.getMessage()), (Throwable)e);
                }
                logger.error((Object)("\u591a\u65f6\u533a\u9884\u8b66\u6761\u76eeid:" + id + ",\u9884\u8b66\u7ed3\u675f,\u8fd4\u56de\u63a5\u6536\u4eba\u4fe1\u606f\u5982\u4e0b:" + timeZoomsendMsgLog));
            }
            this.msgCenterTimeZone = null;
        }
    }

    private String getTimeZoomsendMsgLog(Context ctx, String alreadySendUser) throws BOSException, EASBizException {
        String userInfoLog;
        alreadySendUser = StringUtils.cnulls((String)alreadySendUser);
        logger.info((Object)("userInfo is:" + alreadySendUser));
        String[] userAry = new String[]{};
        if (!alreadySendUser.startsWith("msg:")) {
            alreadySendUser = alreadySendUser.replaceAll(",", ";");
            userAry = StringUtils.split((String)alreadySendUser, (String)";");
        }
        Map<String, String> userTimeZoneMap = this.msgCenterTimeZone.getUserTimeZoneMap();
        Map<String, String> readyUserTimeZoneMap = this.msgCenterTimeZone.getReadyUserTimeZoneMap();
        String[] readyUserAry = new String[readyUserTimeZoneMap.size()];
        Iterator<Map.Entry<String, String>> iterator = readyUserTimeZoneMap.entrySet().iterator();
        int k = 0;
        while (iterator.hasNext()) {
            readyUserAry[k] = iterator.next().getKey();
            ++k;
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        StringBuffer viewStr = new StringBuffer("");
        if (userAry.length > 0) {
            userInfoLog = "";
            if (!"".equals(alreadySendUser)) {
                userInfoLog = this.getUserInfoLog(userAry, iUser, userTimeZoneMap);
            }
            viewStr.append("\u5df2\u6ee1\u8db3\u6ee1\u8db3\u89e6\u53d1\u6761\u4ef6\u7684\u4eba:").append(userInfoLog).append("\n");
        }
        if (readyUserAry.length > 0) {
            userInfoLog = this.getUserInfoLog(readyUserAry, iUser, readyUserTimeZoneMap);
            viewStr.append("\u672a\u6ee1\u8db3\u89e6\u53d1\u6761\u4ef6\u7684\u4eba:").append(userInfoLog);
        }
        return viewStr.toString();
    }

    private String getUserInfoLog(String[] userAry, IUser iUser, Map userTimeZoneMap) throws BOSException {
        if (userAry != null) {
            StringBuffer oql = new StringBuffer("select id,name,number where id in (");
            for (int i = 0; i < userAry.length; ++i) {
                if (i == userAry.length - 1) {
                    oql.append("'").append(userAry[i]).append("'");
                    continue;
                }
                oql.append("'").append(userAry[i]).append("'").append(",");
            }
            oql.append(")");
            StringBuffer viewStr = new StringBuffer("");
            UserCollection userCollection = iUser.getUserCollection(oql.toString());
            for (int i = 0; i < userCollection.size(); ++i) {
                UserInfo userInfo = userCollection.get(i);
                if (userInfo == null) continue;
                viewStr.append("(userid:").append(userInfo.getId()).append(",name:").append(userInfo.getName()).append(",number:").append(userInfo.getNumber()).append(",timezone:").append(userTimeZoneMap.get(userInfo.getId().toString())).append(")").append("\n");
            }
            return viewStr.toString();
        }
        return "";
    }
}

