/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app.rolereceiver;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserRoleManager {
    private static Logger logger = Logger.getLogger(UserRoleManager.class);

    public UserCollection getUserColl(Context ctx, String orgid, String roleid) throws BOSException, EASBizException {
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add(roleid);
        return this.getUserColl(ctx, orgid, roleList);
    }

    public UserCollection getUserColl(Context ctx, String orgid, List roleidList) throws BOSException, EASBizException {
        try {
            UserCollection collection = new UserCollection();
            StringBuffer sql = new StringBuffer(200);
            String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
            String roles = StringUtils.arrayToString((Object[])roleidList.toArray(new String[0]), (String)",");
            Object[] params = new Object[]{orgid, roles};
            sql.append("SELECT UserRoleOrg.FUserID, ").append(" U.FNumber , U.").append(nameField).append(" FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_User U ON U.FID = UserRoleOrg.FUserID ").append(" WHERE UserRoleOrg.FOrgID = ? ").append(" AND UserRoleOrg.FRoleID in (?) ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FUserID")));
                userInfo.setNumber(rowSet.getString("FNumber"));
                userInfo.setName(rowSet.getString(nameField));
                collection.add(userInfo);
            }
            return collection;
        }
        catch (SQLException e) {
            logger.error((Object)"get user coll error", (Throwable)e);
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, (Throwable)e);
        }
    }
}

