/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.event.adapter.EventServiceProviderManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.web.WfState;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;

public final class BusinessSeviceUtil {
    public static void applyDefaultVallue(Context context, BusinessInfo businessInfo, IObjectValue objectValue, OrgUnitInfo mainOrg) throws BOSException, JSONException, EASBizException {
        for (Entity entity : businessInfo.getEntrys()) {
            for (Field field : entity.getFields()) {
                Calendar calendar;
                JSONObject def;
                String mehtodname;
                String defValue = field.getDefValue();
                if (defValue == null || (mehtodname = (String)(def = new JSONObject(defValue)).get("methodname")) == null) continue;
                String[] params = (String[])def.get("params");
                if (mehtodname.equalsIgnoreCase("getTime")) {
                    if (params.length <= 0 || !"Current".equalsIgnoreCase(params[0])) continue;
                    calendar = Calendar.getInstance();
                    Timestamp t = new Timestamp(calendar.getTimeInMillis());
                    objectValue.setTimestamp(field.getPropertyName(), t);
                    continue;
                }
                if (mehtodname.equalsIgnoreCase("getDate")) {
                    if (params.length <= 0 || !"Current".equalsIgnoreCase(params[0])) continue;
                    calendar = Calendar.getInstance();
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    objectValue.setDate(field.getPropertyName(), calendar.getTime());
                    continue;
                }
                if (mainOrg != null && mehtodname.equalsIgnoreCase("getBillNumber")) {
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)context);
                    RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(objectValue, mainOrg.getId().toString());
                    if (!ruleStatus.isExist() || !ruleStatus.isAddView()) continue;
                    objectValue.setString("number", iCodingRuleManager.getNumber(objectValue, mainOrg.getId().toString()));
                    continue;
                }
                if (!mehtodname.equalsIgnoreCase("getUser") || params.length <= 0 || !"Current".equalsIgnoreCase(params[0])) continue;
                UserInfo currentUser = UserFactory.getLocalInstance((Context)context).getUserByID(context.getCaller());
                objectValue.put(field.getPropertyName(), (Object)currentUser);
            }
        }
    }

    public static void checkFunctionPermission(Context ctx, String mainOrgId, String permissionItem) throws EASBizException, BOSException {
        if (mainOrgId == null || StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(mainOrgId);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
    }

    public static FieldPermission getFieldPermission(Context ctx, OrgUnitInfo mainOrg, String bosType) throws EASBizException, BOSException {
        if (mainOrg == null) {
            mainOrg = (OrgUnitInfo)ctx.get((Object)"CurOU");
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(mainOrg.getId());
        return PermissionFactory.getLocalInstance((Context)ctx).getFieldPermission(BOSObjectType.create((String)bosType), userPK, (IObjectPK)orgPK);
    }

    public static boolean isExistsSameNumber(Context ctx, IObjectValue objValue) throws BOSException {
        return BusinessSeviceUtil.isExistsForData(ctx, objValue, "number", new String[]{"CU"});
    }

    public static boolean isExistsForData(Context ctx, IObjectValue objValue, String checkProp, String[] controlProps) throws BOSException {
        String number = objValue.getString(checkProp);
        if (number == null || number.trim().length() == 0) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(checkProp, (Object)number, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (objValue.get("id") != null) {
            filterItem = new FilterItemInfo("id", (Object)objValue.get("id").toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (controlProps != null) {
            for (int i = 0; i < controlProps.length; ++i) {
                String ctrlProp = controlProps[i];
                if (objValue.get(ctrlProp) != null) {
                    Object value = objValue.get(ctrlProp);
                    if (value instanceof IObjectValue) {
                        value = ((IObjectValue)value).get("id");
                    }
                    filterItem = new FilterItemInfo(ctrlProp, (Object)value.toString(), CompareType.EQUALS);
                    filter.getFilterItems().add(filterItem);
                    continue;
                }
                filterItem = new FilterItemInfo(ctrlProp, null, CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return DAOHelper.getDAO().exists(ctx, objValue.getBOSType(), filter);
    }

    public static boolean isExistsForData2(Context ctx, IObjectValue objValue, String checkProp, String[] controlProps) throws BOSException {
        String number = objValue.getString(checkProp);
        if (number == null || number.trim().length() == 0) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(checkProp, (Object)number, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (objValue.get("id") != null) {
            filterItem = new FilterItemInfo("id", (Object)objValue.get("id").toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (controlProps != null) {
            for (int i = 0; i < controlProps.length; ++i) {
                String ctrlProp = controlProps[i];
                if (objValue.get(ctrlProp) != null) {
                    Object value = objValue.get(ctrlProp);
                    if (value instanceof IObjectValue) {
                        value = ((IObjectValue)value).get("id");
                    }
                    filterItem = new FilterItemInfo(ctrlProp, (Object)value.toString(), CompareType.EQUALS);
                    filter.getFilterItems().add(filterItem);
                    continue;
                }
                filterItem = new FilterItemInfo(ctrlProp, null, CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return DAOHelper.getDAO().exists(ctx, objValue.getBOSType(), filter);
    }

    public static boolean isExistsForData4FlowType(Context ctx, IObjectValue objValue, String checkProp, String[] controlProps, String formId) throws BOSException {
        String number = objValue.getString(checkProp);
        if (number == null || number.trim().length() == 0) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(checkProp, (Object)number, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (objValue.get("id") != null) {
            filterItem = new FilterItemInfo("id", (Object)objValue.get("id").toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (controlProps != null) {
            for (int i = 0; i < controlProps.length; ++i) {
                String ctrlProp = controlProps[i];
                if (objValue.get(ctrlProp) != null) {
                    Object value = objValue.get(ctrlProp);
                    if (value instanceof IObjectValue) {
                        value = ((IObjectValue)value).get("id");
                    }
                    filterItem = new FilterItemInfo(ctrlProp, (Object)value.toString(), CompareType.EQUALS);
                    filter.getFilterItems().add(filterItem);
                    continue;
                }
                filterItem = new FilterItemInfo(ctrlProp, null, CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            }
        }
        if ("rkyC6Kl+TTWiY+RtjPP/IZp+rpI=".equals(formId)) {
            filter.getFilterItems().add(new FilterItemInfo("packageName", (Object)"com.kingdee.eas.cp.odm%", CompareType.NOTLIKE));
        } else if ("MyDTm4hpTXK8lqpe/3cS85p+rpI=".equals(formId)) {
            filter.getFilterItems().add(new FilterItemInfo("packageName", (Object)"com.kingdee.eas.cp.odm%", CompareType.LIKE));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return DAOHelper.getDAO().exists(ctx, objValue.getBOSType(), filter);
    }

    public static void triggerWfEvent(Context ctx, BOSObjectType bosType, String operation, String pk, String formId, String formName, String billNumber) throws BOSException {
        BusinessSeviceUtil.triggerWfEvent(bosType, new Object[]{ctx, operation, pk, formId, formName, billNumber});
    }

    public static void triggerWfEvent(BOSObjectType bosType, Object[] eventParams) throws BOSException {
        ServiceContext srvContext = BusinessSeviceUtil.createServiceContext(null, bosType, eventParams);
        EventServiceProviderManager.getDynamicBillEventServiceProvider().sendEvent((IServiceContext)srvContext);
    }

    public static void checkWfState(BillApplication application, String operation) throws BOSException {
        WfState wfState = application.getBillView().getWfState();
        String billid = application.getBillModel().getPKValue();
        int checkWfBefore = wfState.checkBeforeAction(application.getContext(), billid, operation);
        if (checkWfBefore == 1) {
            throw new MatchAssignmentException("BizObject aleady in process. ");
        }
        if (checkWfBefore == 4) {
            throw new MatchAssignmentException("BizObject aleady in process but operation not match.Current operation:" + operation);
        }
    }

    private static ServiceContext createServiceContext(MetaDataPK methodPK, BOSObjectType bosType, Object[] params) {
        return new ServiceContext(MetaDataTypeList.ENTITY, bosType, (IMetaDataPK)methodPK, params);
    }
}

