/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.plugin.AbstractFormBusiness;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class SendMessageAction
extends AbstractFormBusiness {
    private BillApplication application;

    public SendMessageAction(IFormApplication application) {
        super(application);
        this.application = (BillApplication)application;
    }

    public void doAction(ActionArgs e) throws BOSException, EASBizException {
        if (this.application instanceof BillApplication && !this.isPreCondition(e.getAction(), this.application.getBillModel().getBillValue())) {
            return;
        }
        String[] parameters = e.getParamenter();
        if (parameters.length < 3) {
            return;
        }
        int row = e.getRow();
        String msgTitle = parameters[0];
        msgTitle = ExpressionUtil.handleParamFillingValue((DynamicFormApplication)this.application, (String)msgTitle, (int)row, (boolean)false);
        String msgBody = parameters[1];
        msgBody = ExpressionUtil.handleParamFillingValue((DynamicFormApplication)this.application, (String)msgBody, (int)row, (boolean)false);
        String msgReceiver = this.fetchReceiver(parameters, -1);
        if (msgReceiver.length() == 0) {
            return;
        }
        String msgSender = null;
        UserInfo user = null;
        user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
        if (user != null) {
            msgSender = user.getName();
        }
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale locale = this.application.getContext().getLocale();
        Message message = MessageFactory.newMessage((String)"kingdee.forWarn");
        message.setLocaleStringHeader("title", msgTitle, locale);
        message.setLocaleStringHeader("sender", msgSender, locale);
        message.setLocaleStringHeader("body", msgBody, locale);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", this.application.getContext().getAIS());
        message.setStringHeader("solution", this.application.getContext().getSolution());
        message.setStringHeader("receiver", msgReceiver);
        senderAgent.sendMessage(message);
    }

    private String fetchReceiver(String[] parameters, int row) throws BOSException {
        StringBuffer sb = new StringBuffer();
        try {
            JSONArray jsa = new JSONArray(parameters[2]);
            String[] receivers = jsa.toArray();
            HashSet personIds = new HashSet();
            HashSet<String> userIds = new HashSet<String>();
            HashSet userNumbers = new HashSet();
            HashSet personNumbers = new HashSet();
            for (int i = 0; i < receivers.length; ++i) {
                String receiver = receivers[i];
                if (receiver.startsWith("[") && receiver.endsWith("]")) {
                    String var = receiver.substring(1, receiver.length() - 1);
                    Object value = this.application.searchValue(var, row);
                    this.parseReceiverFromValue(personIds, userIds, userNumbers, personNumbers, var, value);
                    continue;
                }
                userIds.add(receiver);
            }
            if (personIds.size() > 0) {
                IObjectCollection collection = this.fetchUsers(personIds, "person.id");
                this.addUserIds(userIds, collection);
            }
            if (personNumbers.size() > 0) {
                IObjectCollection collection = this.fetchUsers(personNumbers, "person.number");
                this.addUserIds(userIds, collection);
            }
            if (userNumbers.size() > 0) {
                IObjectCollection collection = this.fetchUsers(userNumbers, "number");
                this.addUserIds(userIds, collection);
            }
            Iterator iter = userIds.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                sb.append(";");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        catch (JSONException e1) {
            throw new BOSException((Throwable)e1);
        }
        return sb.toString();
    }

    private void parseReceiverFromValue(Set personIds, Set userIds, Set userNumbers, Set personNumbers, String var, Object value) throws JSONException {
        block5: {
            block8: {
                LookUpObject lookupObj;
                String[] recs;
                block9: {
                    block7: {
                        block6: {
                            block4: {
                                if (!(value instanceof PersonInfo)) break block4;
                                personIds.add(((PersonInfo)value).getId().toString());
                                break block5;
                            }
                            if (!(value instanceof UserInfo)) break block6;
                            userIds.add(((UserInfo)value).getId().toString());
                            break block5;
                        }
                        if (!(value instanceof String)) break block7;
                        userIds.add(value);
                        break block5;
                    }
                    if (!(value instanceof String[])) break block8;
                    recs = (String[])value;
                    Field field = this.application.getBillModel().getBusinessInfo().getField(var);
                    if (field.getElementType() != 24) break block5;
                    lookupObj = this.application.getBillModel().getBusinessInfo().getLookUpObject(field.getLookUpObjectID());
                    if (!"80EF7DED".equals(lookupObj.getBosType())) break block9;
                    for (int j = 0; j < recs.length; ++j) {
                        personNumbers.add(recs[j]);
                    }
                    break block5;
                }
                if (!"13B7DE7F".equals(lookupObj.getBosType())) break block5;
                for (int j = 0; j < recs.length; ++j) {
                    userNumbers.add(recs[j]);
                }
                break block5;
            }
            if (value instanceof Object[]) {
                Object[] recs = (Object[])value;
                for (int j = 0; j < recs.length; ++j) {
                    this.parseReceiverFromValue(personIds, userIds, userNumbers, personNumbers, var, recs[j]);
                }
            }
        }
    }

    private void addUserIds(Set userIds, IObjectCollection collection) {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            userIds.add(((UserInfo)collection.getObject(i)).getId().toString());
        }
    }

    private IObjectCollection fetchUsers(Set personIds, String key) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(key, (Object)personIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IUser iUser = UserFactory.getLocalInstance((Context)this.application.getContext());
        CoreBaseCollection collection = iUser.getCollection(view);
        return collection;
    }
}

