/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.IFormURL;
import com.kingdee.eas.base.form.util.SortUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultFormURLServer
extends AbstractBOSObject
implements IFormURL {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.app.DefaultFormURLServer");

    public DefaultFormURLServer(Context ctx) {
        super(ctx);
    }

    public DefaultFormURLServer() {
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public List getTopSystemList() throws BOSException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Context ctx = this.getContext();
        String sql = "select ftopclassid, ftopclassname_l1, ftopclassname_l2, ftopclassname_l3, fisdefault, findex  from t_bas_formtopclass where (fvisible <> -1 or fvisible is null)order by findex";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String[] strs = new String[]{rs.getString("ftopclassid"), rs.getString("ftopclassname_" + ctx.getLocale()) == null ? "" : rs.getString("ftopclassname_" + ctx.getLocale())};
                result.add(strs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getSubSystemList(String topId) throws BOSException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Context ctx = this.getContext();
        String sql = " select fsubsysid, ftopclassId, fname_l1, fname_l2, fname_l3, fisdefault, findex  from t_bas_formsubsystem where ftopclassid = ? order by findex ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{topId});
        try {
            while (rs.next()) {
                String[] strs = new String[]{rs.getString("fsubsysid"), rs.getString("fname_" + ctx.getLocale()) == null ? "" : rs.getString("fname_" + ctx.getLocale())};
                result.add(strs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getSubSystemList() throws BOSException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Context ctx = this.getContext();
        String sql = " select fsubsysid, ftopclassId, fname_l1, fname_l2, fname_l3, fisdefault, findex  from t_bas_formsubsystem order by ftopclassid, findex ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String[] strs = new String[]{rs.getString("fsubsysid"), rs.getString("fname_" + ctx.getLocale()) == null ? "" : rs.getString("fname_" + ctx.getLocale())};
                result.add(strs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getFormList(String subSystemId) throws BOSException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Context ctx = this.getContext();
        String sql = " select fid, fname_l1, fname_l2, fname_l3, FBosType  from t_bas_form where fsubsysid = ? order by fname_l2 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{subSystemId});
        try {
            while (rs.next()) {
                String[] strs = new String[]{rs.getString("fid"), rs.getString("fname_" + ctx.getLocale()), StringUtils.isEmpty((String)rs.getString("FBosType")) ? "" : rs.getString("FBosType").trim()};
                result.add(strs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return SortUtil.sortByPinYin(result, 1, true);
    }

    @Override
    public List getFormListBySubsys(String topSystemId, String subSystemId, int createType, boolean isTemplate) throws BOSException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Context ctx = this.getContext();
        String sql = " select a.fid id, a.fname_l1 fnamel1, a.fname_l2 fnamel2, a.fname_l3 fnamel3,  a.FBosType,  b.fname_l1 bnamel1, b.fname_l2 bnamel2, b.fname_l3 bnamel3, c.ftopclassname_l1 cnamel1, c.ftopclassname_l2 cnamel2, c.ftopclassname_l3 cnamel3,  a.fsubsysid subsysid, a.felementtypeid elementtypeid  from t_bas_form a, t_bas_formsubsystem b, t_bas_formtopclass c where a.fsubsysid = b.fsubsysid and b.ftopclassid = c.ftopclassid ";
        String mark = "";
        if (isTemplate) {
            sql = sql + " and a.felementtypeid < 0 ";
            mark = "-";
        } else {
            sql = sql + " and a.felementtypeid > 0 ";
            sql = sql + " and (FIsHide <> 1 or FIsHide is null) ";
        }
        if (createType == 1) {
            sql = sql + " and a.felementtypeid = " + mark + 100 + " ";
        } else if (createType == 0) {
            sql = sql + " and a.felementtypeid = " + mark + 200 + " ";
        } else if (createType == 2) {
            sql = sql + " and a.felementtypeid = " + mark + 210 + " ";
        }
        sql = !StringUtils.isEmpty((String)subSystemId) ? sql + " and a.fsubsysid = ? order by a.fname_l2 " : (!StringUtils.isEmpty((String)topSystemId) ? sql + " and c.ftopclassid = ? order by c.ftopclassid, b.fsubsysid, a.fname_l2 " : sql + " order by c.ftopclassid, b.fsubsysid, a.fname_l2 ");
        IRowSet rs = null;
        rs = !StringUtils.isEmpty((String)subSystemId) ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{subSystemId}) : (!StringUtils.isEmpty((String)topSystemId) ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{topSystemId}) : DbUtil.executeQuery((Context)ctx, (String)sql));
        try {
            while (rs.next()) {
                String[] strs = new String[]{rs.getString("id"), rs.getString("fname" + ctx.getLocale()), rs.getString("bname" + ctx.getLocale()), rs.getString("cname" + ctx.getLocale()), rs.getString("subsysid"), String.valueOf(rs.getInt("elementtypeid"))};
                result.add(strs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return SortUtil.sortByPinYin(result, 1, true);
    }

    @Override
    public String getBillType(String bosType) throws BOSException {
        Context ctx = this.getContext();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
        String billtype = entity.getFullName();
        return billtype;
    }
}

