/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityToTable;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.SuffixCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.CloneUtils;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.base.form.util.Util;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.ep.CustomizedUnitCollection;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.ep.updater.ImportBizUnitHelper4Update;
import com.kingdee.eas.ep.updater.UtilsForUpdate;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BOSEntityGenerator {
    private static final String IS_DYNAMIC = "1";
    public static final String WEB_DYNAMIC = "web_dynamic";
    private static final String BOSTYPE = "A286FAC9";
    private static final Logger logger = Logger.getLogger(BOSEntityGenerator.class);
    public static final int ID_LENTH = 44;
    public static final String ENUMTYPE = "enum_type";
    public static final int STR_ENUM = 0;
    public static final int INT_ENUM = 1;
    public static final int CHECKTYPE_ENTITY = 0;
    public static final int CHECKTYPE_TABLE = 1;
    public static final int CHECKTYPE_RELATION = 2;
    public static final String EASWEB_DEF_PROJECT_ID = "s39q05mDTtWvGKJ8yak72yyY1lE=";
    public static final String EASWEB_DEF_ROOT_CUSTOM_UNIT_ID = "EWjwb1j7Royt/GzsfZ+c9zN2tTA=";
    private IMetadataStore mds = null;
    private IMetaDataLoader loader = null;
    private SuffixCollection suffixs = null;

    public SuffixCollection getSuffixCollection() {
        if (this.suffixs == null) {
            SolutionInfo solution = this.getMetadataLoader(null).getSolution();
            this.suffixs = solution.getSuffixes();
        }
        return this.suffixs;
    }

    public static BOSEntityGenerator getInstance() {
        return new BOSEntityGenerator();
    }

    public IMetadataStore getMetadataStore(Context ctx) {
        if (this.mds == null) {
            this.mds = MetadataStoreFactory.getMetadataStore((Context)ctx);
        }
        return this.mds;
    }

    public IMetaDataLoader getMetadataLoader(Context ctx) {
        if (this.loader == null) {
            this.loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        }
        return this.loader;
    }

    public List updatePropeties(Context ctx, FormMetaData metaData) throws Exception {
        ArrayList<String> alertColumnSqlList = new ArrayList<String>();
        String sql = "alter table {0} alter column {1} NVARCHAR({2});";
        if (this.isContainDynField(metaData.getBusinessInfo())) {
            ArrayList<Object> metaList = new ArrayList<Object>();
            int j = metaData.getBusinessInfo().getEntrys().size();
            for (int i = 0; i < j; ++i) {
                Entity entity = (Entity)metaData.getBusinessInfo().getEntrys().get(i);
                if (StringUtils.isEmpty((String)entity.getBosType())) continue;
                EntityObjectInfo eo = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)entity.getBosType()));
                EntityObjectInfo cloneEntity = CloneUtils.clone((EntityObjectInfo)eo);
                DataTableInfo cloneTable = (DataTableInfo)eo.getTable().clone();
                metaList.add(cloneTable);
                metaList.add(cloneEntity);
                for (Field field : entity.getFields()) {
                    ColumnInfo column;
                    if (eo.getPropertyByName(field.getPropertyName()) == null || field.getElementType() != 1 && field.getElementType() != 10001 && field.getElementType() != 6 || (column = eo.getTable().getColumnByName(field.getFieldName())) == null || column.getLength() >= field.getEditlen()) continue;
                    ((OwnPropertyInfo)cloneEntity.getPropertyByName(field.getPropertyName())).setLength(field.getEditlen());
                    cloneTable.getColumnByName(field.getFieldName()).setLength(field.getEditlen());
                    String alertSql = MessageFormat.format(sql, cloneTable.getName(), field.getFieldName(), "" + field.getEditlen());
                    alertColumnSqlList.add(alertSql);
                }
            }
            AbstractMetaDataValue[] meta = new AbstractMetaDataValue[metaList.size()];
            metaList.toArray(meta);
            this.getMetadataStore(null).saveMetadata(meta, EASWEB_DEF_PROJECT_ID);
            CustomSchemeUtil.enableScheme((String)EASWEB_DEF_PROJECT_ID);
        }
        return alertColumnSqlList;
    }

    public void generatePropeties(Context ctx, FormMetaData metaData) throws Exception {
        Entity entity;
        if (!this.isContainDynField(metaData.getBusinessInfo())) {
            return;
        }
        ArrayList<Object> metaList = new ArrayList<Object>();
        BusinessInfo businessInfo = metaData.getBusinessInfo();
        List entrys = businessInfo.getEntrys();
        HashMap<String, EntityObjectInfo> entityMap = new HashMap<String, EntityObjectInfo>();
        HashMap<String, String> sameCaptionField = new HashMap<String, String>();
        for (int i = 0; i < entrys.size(); ++i) {
            entity = (Entity)entrys.get(i);
            if (StringUtils.isEmpty((String)entity.getBosType())) continue;
            EntityObjectInfo eo = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)entity.getBosType()));
            DataTableInfo table = eo.getTable();
            Iterator iter = entity.getFields().iterator();
            for (Field field : entity.getFields()) {
                FieldAppearance fa = metaData.getLayoutInfo().getFieldAppearance(field.getKey());
                String propertyName = field.getPropertyName();
                PropertyInfo property = eo.getPropertyByName(propertyName);
                if (property == null) continue;
                sameCaptionField.put(field.getKey(), property.getAlias());
            }
            while (iter.hasNext()) {
                FieldAppearance fa;
                PropertyInfo thisProp;
                String propertyName;
                Field field;
                field = (Field)iter.next();
                if (!field.isDynamic() || StringUtils.isEmpty((String)(propertyName = field.getPropertyName()))) continue;
                if (!BOSEntityGenerator.isValidName(propertyName)) {
                    throw new ActionCommonException(null, "\u5c5e\u6027\u540d\u79f0\u975e\u6cd5\uff0c\u5408\u6cd5\u540d\u79f0\u7531\u5b57\u6bcd\u548c\u6570\u5b57\u7ec4\u6210\u5e76\u4e14\u9996\u5b57\u6bcd\u4e3a\u5c0f\u5199\u5b57\u6bcd");
                }
                PropertyInfo property = eo.getPropertyByName(propertyName);
                int elementType = field.getElementType();
                if (property != null && elementType != 13 || elementType == 14 || elementType == 23 || elementType == 1020 || (thisProp = this.createPropertyInfo(ctx, eo, businessInfo, field, fa = metaData.getLayoutInfo().getFieldAppearance(field.getKey()), property)) == null) continue;
                if (thisProp instanceof LinkPropertyInfo) {
                    if (property != null) {
                        metaList.remove(property);
                    }
                    metaList.add(((LinkPropertyInfo)thisProp).getRelationship());
                }
                String fieldName = field.getFieldName();
                ColumnInfo column = eo.getTable().getColumnByName(fieldName);
                if (column == null) {
                    column = this.createAColumn(businessInfo, field, table, thisProp);
                }
                thisProp.setMappingField(column);
                if (property != null) {
                    eo.getProperties().remove(property);
                } else if (thisProp.getAlias().length() > 0) {
                    this.checkAlias(sameCaptionField, thisProp, field.getKey());
                    if (!sameCaptionField.containsKey(field.getKey())) {
                        sameCaptionField.put(field.getKey(), thisProp.getAlias());
                    }
                }
                eo.getProperties().add(thisProp);
                entityMap.put(eo.getPackage() + "." + eo.getName(), eo);
            }
        }
        if (entityMap.keySet().size() == 0) {
            return;
        }
        Iterator iter = entityMap.keySet().iterator();
        while (iter.hasNext()) {
            entity = (EntityObjectInfo)entityMap.get(iter.next());
            DataTableInfo table = entity.getTable();
            EntityObjectInfo cloneEntity = CloneUtils.clone((EntityObjectInfo)entity);
            DataTableInfo cloneTable = (DataTableInfo)table.clone();
            metaList.add(cloneTable);
            metaList.add(cloneEntity);
        }
        AbstractMetaDataValue[] meta = new AbstractMetaDataValue[metaList.size()];
        metaList.toArray(meta);
        this.getMetadataStore(null).saveMetadata(meta, EASWEB_DEF_PROJECT_ID);
        CustomSchemeUtil.enableScheme((String)EASWEB_DEF_PROJECT_ID);
    }

    private void checkAlias(Map sameCaptionField, PropertyInfo thisProp, String key) {
        boolean repeat = false;
        if (sameCaptionField.containsKey(key)) {
            sameCaptionField.remove(key);
        }
        if (sameCaptionField.containsValue(thisProp.getAlias())) {
            repeat = true;
        }
        String alias = thisProp.getAlias();
        if (repeat) {
            if (this.isNumeric(alias.substring(alias.length() - 1))) {
                int numDigit = 1;
                if (alias.length() > 1 && this.isNumeric(alias.substring(alias.length() - 2, alias.length() - 1))) {
                    numDigit = 2;
                    if (alias.length() > 2 && this.isNumeric(alias.substring(alias.length() - 3, alias.length() - 2))) {
                        numDigit = 3;
                    }
                }
                int numChar = Integer.parseInt(alias.substring(alias.length() - numDigit));
                thisProp.setAlias(alias.substring(0, alias.length() - numDigit) + (numChar + 1));
            } else {
                thisProp.setAlias(alias + 1);
            }
            this.checkAlias(sameCaptionField, thisProp, key);
        }
    }

    public boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public Map generateEntity(Context ctx, FormMetaData metaData) throws Exception {
        ArrayList<Object> metaDataList = new ArrayList<Object>();
        BusinessInfo businessInfo = metaData.getBusinessInfo();
        List entrys = businessInfo.getEntrys();
        HashMap<String, EntityObjectInfo> entityMap = new HashMap<String, EntityObjectInfo>();
        ArrayList<EntityObjectInfo> entityObjList = new ArrayList<EntityObjectInfo>();
        ArrayList<QueryInfo> queryObjList = new ArrayList<QueryInfo>();
        for (int i = 0; i < entrys.size(); ++i) {
            Entity entity = (Entity)entrys.get(i);
            EntityObjectInfo eo = null;
            if (StringUtils.isEmpty((String)entity.getBosType())) {
                eo = this.createAEntity(ctx, entity);
                entityObjList.add(eo);
                if (i == 0) {
                    QueryInfo query = BOSEntityGenerator.createAQuery(eo);
                    this.getMetadataStore(null).saveMetadata((AbstractMetaDataValue)query, EASWEB_DEF_PROJECT_ID);
                    queryObjList.add(query);
                }
            } else {
                eo = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)entity.getBosType()));
            }
            entityMap.put(entity.getKey(), eo);
        }
        EntityObjectInfo headEO = (EntityObjectInfo)entityMap.get(((Entity)entrys.get(0)).getKey());
        for (int i = 1; i < entrys.size(); ++i) {
            Entity entity = (Entity)entrys.get(i);
            if (!entity.isCustomEntity()) continue;
            EntityObjectInfo entryEO = (EntityObjectInfo)entityMap.get(entity.getKey());
            String headLinkPropName = this.createLinkPropName(headEO, "entries");
            String entryLinkPropName = this.createLinkPropName(headEO, "bill");
            LinkPropertyInfo linkProp = this.createALinkPropertyInfo(ctx, headEO, entryEO, headLinkPropName, false, true);
            linkProp.setName(headLinkPropName);
            linkProp.setAlias(entryEO.getAlias());
            linkProp.setDescription(entryEO.getAlias());
            linkProp.setConfigured(true);
            this.setExtendedPropertyForBotp((PropertyInfo)linkProp);
            logger.info((Object)("\u521b\u5efa\u5c5e\u6027" + linkProp.getName()));
            headEO.getProperties().add((PropertyInfo)linkProp);
            LinkPropertyInfo entryLinkProp = (LinkPropertyInfo)linkProp.clone();
            entryLinkProp.setName(entryLinkPropName);
            entryLinkProp.setAlias(headEO.getName());
            entryLinkProp.setDescription(headEO.getName());
            entryLinkProp.setConfigured(true);
            this.setExtendedPropertyForBotp((PropertyInfo)entryLinkProp);
            logger.info((Object)("\u521b\u5efa\u5c5e\u6027" + entryLinkProp.getName()));
            entryEO.getProperties().add((PropertyInfo)entryLinkProp);
            this.createAColumn(entryEO, (PropertyInfo)entryLinkProp);
            metaDataList.add(entryEO.getTable());
            metaDataList.add(entryEO);
            metaDataList.add(entryLinkProp.getRelationship());
        }
        if (metaDataList.size() > 0) {
            metaDataList.add(headEO);
            AbstractMetaDataValue[] meta = new AbstractMetaDataValue[metaDataList.size()];
            metaDataList.toArray(meta);
            this.getMetadataStore(null).saveMetadata(meta, EASWEB_DEF_PROJECT_ID);
            this.clearMetaDataCache(meta);
        }
        if (entityObjList.size() > 0) {
            EntityObjectInfo eo = (EntityObjectInfo)entityObjList.get(0);
            String name = eo.getName();
            String alias = eo.getAlias();
            String entityPK = eo.getPackage() + "." + eo.getName();
            BOSEntityGenerator.createACustomizedUnit(ctx, name, alias, entityPK, queryObjList);
        }
        return entityMap;
    }

    public static QueryInfo createAQuery(EntityObjectInfo eo) throws Exception {
        JoinQueryInfo query = new JoinQueryInfo();
        query.setName(eo.getRealName() + "Query");
        query.setAlias(eo.getAlias() + "\u7684\u67e5\u8be2");
        query.setDescription(eo.getAlias() + "\u7684\u67e5\u8be2");
        query.setUserDefined(false);
        query.setPackage(eo.getRealPackage());
        SubEntityInfo item = new SubEntityInfo((QueryInfo)query);
        item.setEntityRef(eo);
        item.setName(eo.getRealName());
        item.setAlias(eo.getAlias());
        query.getSubObjects().add((SubObjectInfo)item);
        PropertyCollection props = Util.getAllEntityProperties(eo);
        QueryFilterInfo filter = new QueryFilterInfo((QueryInfo)query);
        for (int j = 0; j < props.size(); ++j) {
            if (!(props.get(j) instanceof OwnPropertyInfo)) continue;
            PropertyInfo prop = props.get(j);
            QueryFieldInfo item1 = new QueryFieldInfo((QueryInfo)query);
            item1.setConfigured(true);
            item1.setName(prop.getName());
            item1.setDisplayName(prop.getAlias());
            item1.setIsFilter(true);
            item1.setIsSelector(true);
            item1.setReturnType(BOSEntityGenerator.trans(((OwnPropertyInfo)prop).getDataType()));
            PropertyRefInfo refInfo = new PropertyRefInfo((PropertyUnitInfo)item1, item, prop);
            item1.getPropertyRefs().add(refInfo);
            query.getUnits().add((PropertyUnitInfo)item1);
        }
        query.setDefaultFilter(filter);
        return query;
    }

    public static ConstDataType trans(DataType dataType) {
        if (dataType.getName().equals(DataType.SHORT.getName()) || dataType.getName().equals(DataType.INTEGER.getName()) || dataType.getName().equals(DataType.LONG.getName())) {
            return ConstDataType.INT;
        }
        if (dataType.getName().equals(DataType.DOUBLE.getName()) || dataType.getName().equals(DataType.DECIMAL.getName()) || dataType.getName().equals(DataType.FLOAT.getName())) {
            return ConstDataType.NUMBER;
        }
        if (dataType.getName().equals(DataType.STRING.getName()) || dataType.getName().equals(DataType.CHAR.getName()) || dataType.getName().equals(DataType.BOSUUID.getName())) {
            return ConstDataType.STRING;
        }
        if (dataType.getName().equals(DataType.DATE.getName())) {
            return ConstDataType.DATE;
        }
        if (dataType.getName().equals(DataType.TIME.getName())) {
            return ConstDataType.TIME;
        }
        if (dataType.getName().equals(DataType.TIMESTAMP.getName())) {
            return ConstDataType.TIMESTAMP;
        }
        if (dataType.getName().equals(DataType.ENUM.getName())) {
            return ConstDataType.ENUM;
        }
        if (dataType.getName().equals(DataType.BOOLEAN.getName())) {
            return ConstDataType.BOOLEAN;
        }
        return null;
    }

    private String createLinkPropName(EntityObjectInfo headEO, String prefix) {
        if (StringUtils.isEmpty((String)prefix)) {
            prefix = "prefix";
        }
        int i = 1;
        while (headEO.getPropertyByName(prefix + i) != null) {
            ++i;
        }
        return prefix + i;
    }

    public static void createACustomizedUnit(Context ctx, String name, String alias, String entityPK, List queryObjList) throws Exception {
        CustomizedUnitNodeInfo.MetaDataInfo md;
        String sListUIPK = null;
        String sEditUIPK = null;
        String entityFunctionPK = null;
        String editUIFunctionPK = null;
        String listUIFunctionPK = null;
        EntityObjectInfo mainEntityObject = null;
        if (StringUtils.isEmpty((String)entityPK)) {
            throw new BOSException("entityPK\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        mainEntityObject = UtilsForUpdate.loadEntity((IMetaDataPK)new MetaDataPK(entityPK), null);
        ICustomizedUnit bizInterface = null;
        bizInterface = ctx != null ? CustomizedUnitFactory.getLocalInstance((Context)ctx) : CustomizedUnitFactory.getRemoteInstance();
        CustomizedUnitNodeInfo cunInfo = new CustomizedUnitNodeInfo();
        cunInfo.setPackagePK(mainEntityObject.getPackage().substring(0, mainEntityObject.getPackage().length() - 4));
        cunInfo.setName(name);
        cunInfo.setAlias(alias);
        cunInfo.setCustomizedType("bizunit");
        if (!StringUtils.isEmpty((String)entityPK)) {
            EntityObjectInfo entityObject = UtilsForUpdate.loadEntity((IMetaDataPK)new MetaDataPK(entityPK), null);
            ArrayList entitys = new ArrayList();
            ImportBizUnitHelper4Update.getEntitys((EntityObjectInfo)entityObject, entitys);
            for (EntityObjectInfo eoi : entitys) {
                CustomizedUnitNodeInfo.MetaDataInfo md2 = new CustomizedUnitNodeInfo.MetaDataInfo(eoi.getPackage(), eoi.getName(), eoi.getAlias());
                cunInfo.getEntity().add(md2);
            }
        }
        for (int i = 0; i < queryObjList.size(); ++i) {
            QueryInfo query = (QueryInfo)queryObjList.get(i);
            if (query == null) continue;
            CustomizedUnitNodeInfo.MetaDataInfo md3 = new CustomizedUnitNodeInfo.MetaDataInfo(query.getPackage(), query.getName(), query.getAlias());
            cunInfo.getQuery().add(md3);
        }
        if (!StringUtils.isEmpty(sListUIPK)) {
            UIObjectInfo listui = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(sListUIPK), null);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
            cunInfo.getUi().getListui().add(md);
        }
        if (!StringUtils.isEmpty(sEditUIPK)) {
            UIObjectInfo editui = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(sEditUIPK), null);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
            cunInfo.getUi().getEditui().add(md);
        }
        if (!StringUtils.isEmpty(entityFunctionPK)) {
            FunctionObjectInfo function = UtilsForUpdate.loadFunction((IMetaDataPK)new MetaDataPK(entityFunctionPK), null);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        if (!StringUtils.isEmpty(editUIFunctionPK)) {
            FunctionObjectInfo function = UtilsForUpdate.loadFunction((IMetaDataPK)new MetaDataPK(editUIFunctionPK), null);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        if (!StringUtils.isEmpty(listUIFunctionPK)) {
            FunctionObjectInfo function = UtilsForUpdate.loadFunction((IMetaDataPK)new MetaDataPK(listUIFunctionPK), null);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        String xml = CustomizedUnitNodeInfoConverter.coverter2xml((CustomizedUnitNodeInfo)cunInfo);
        CustomizedUnitInfo parent = new CustomizedUnitInfo();
        parent.setCustomizedSchemeID(EASWEB_DEF_PROJECT_ID);
        parent.setId(BOSUuid.read((String)EASWEB_DEF_ROOT_CUSTOM_UNIT_ID));
        CustomizedUnitInfo dataObj = new CustomizedUnitInfo();
        dataObj.setId(BOSUuid.create((BOSObjectType)dataObj.getBOSType()));
        dataObj.setNumber(dataObj.getId().toString());
        dataObj.setName(cunInfo.getName());
        dataObj.setDisplayName(cunInfo.getAlias());
        dataObj.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
        dataObj.setCustomizedUnitObject(xml);
        dataObj.setIsLeaf(false);
        dataObj.setLevel(1);
        dataObj.setParent(parent);
        dataObj.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        dataObj.setCustomizedSchemeID(parent.getCustomizedSchemeID());
        bizInterface.addnew((CoreBaseInfo)dataObj);
    }

    public static void createACustomizedUnit(Context ctx, EntityObjectInfo parent_info, EntityObjectInfo entity_info) {
        try {
            ICustomizedUnit bizInterface = null;
            bizInterface = ctx != null ? CustomizedUnitFactory.getLocalInstance((Context)ctx) : CustomizedUnitFactory.getRemoteInstance();
            CustomizedUnitInfo parent = null;
            CustomizedUnitCollection items = bizInterface.getCustomizedUnitCollection();
            for (int i = 0; i < items.size(); ++i) {
                if (!parent_info.getName().equals(items.get(i).getName()) || !EASWEB_DEF_PROJECT_ID.equals(items.get(i).getCustomizedSchemeID())) continue;
                parent = items.get(i);
                break;
            }
            if (parent != null) {
                CustomizedUnitNodeInfo cunInfo = CustomizedUnitNodeInfoConverter.converter2Object((String)parent.getCustomizedUnitObject());
                CustomizedUnitNodeInfo.MetaDataInfo md = new CustomizedUnitNodeInfo.MetaDataInfo(entity_info.getPackage(), entity_info.getName(), entity_info.getAlias());
                cunInfo.getEntity().add(md);
                String xml = CustomizedUnitNodeInfoConverter.coverter2xml((CustomizedUnitNodeInfo)cunInfo);
                parent.setCustomizedUnitObject(xml);
                ObjectUuidPK pk = new ObjectUuidPK(parent.getId());
                bizInterface.update((IObjectPK)pk, (CoreBaseInfo)parent);
            } else {
                String name = parent_info.getName();
                String alias = parent_info.getAlias();
                String entityPK = parent_info.getPackage() + "." + parent_info.getName();
                BOSEntityGenerator.createACustomizedUnit(ctx, name, alias, entityPK, new ArrayList());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public EntityObjectInfo createAEntry(Context ctx, Entity entry, EntityObjectInfo parentEntity) {
        try {
            EntityObjectInfo enrtyInfo = this.createAEntity(ctx, entry);
            String headLinkPropName = this.createLinkPropName(parentEntity, "entries");
            String entryLinkPropName = this.createLinkPropName(parentEntity, "bill");
            ArrayList<Object> metaDataList = new ArrayList<Object>();
            LinkPropertyInfo linkProp = this.createALinkPropertyInfo(ctx, parentEntity, enrtyInfo, headLinkPropName, false, true);
            linkProp.setName(headLinkPropName);
            linkProp.setAlias(enrtyInfo.getAlias());
            linkProp.setDescription(enrtyInfo.getAlias());
            linkProp.setConfigured(true);
            this.setExtendedPropertyForBotp((PropertyInfo)linkProp);
            logger.info((Object)("\u521b\u5efa\u5c5e\u6027" + linkProp.getName()));
            parentEntity.getProperties().add((PropertyInfo)linkProp);
            LinkPropertyInfo entryLinkProp = (LinkPropertyInfo)linkProp.clone();
            entryLinkProp.setName(entryLinkPropName);
            entryLinkProp.setAlias(parentEntity.getAlias());
            entryLinkProp.setDescription(parentEntity.getAlias());
            entryLinkProp.setConfigured(true);
            this.setExtendedPropertyForBotp((PropertyInfo)entryLinkProp);
            logger.info((Object)("\u521b\u5efa\u5c5e\u6027" + entryLinkProp.getName()));
            enrtyInfo.getProperties().add((PropertyInfo)entryLinkProp);
            this.createAColumn(enrtyInfo, (PropertyInfo)entryLinkProp);
            metaDataList.add(enrtyInfo.getTable());
            metaDataList.add(enrtyInfo);
            metaDataList.add(entryLinkProp.getRelationship());
            if (metaDataList.size() > 0) {
                metaDataList.add(parentEntity);
                AbstractMetaDataValue[] meta = new AbstractMetaDataValue[metaDataList.size()];
                metaDataList.toArray(meta);
                this.getMetadataStore(null).saveMetadata(meta, EASWEB_DEF_PROJECT_ID);
                this.clearMetaDataCache(meta);
                CustomSchemeUtil.enableScheme((String)EASWEB_DEF_PROJECT_ID);
            }
            BOSEntityGenerator.createACustomizedUnit(ctx, parentEntity, enrtyInfo);
            CustomSchemeUtil.enableScheme((String)EASWEB_DEF_PROJECT_ID);
            return enrtyInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public void clearMetaDataCache(AbstractMetaDataValue[] metas) {
        for (int i = 0; i < metas.length; ++i) {
            AbstractMetaDataValue md = metas[i];
            if (md instanceof UIObjectInfo) continue;
            logger.info((Object)(" clear md cache --- > [" + md.getBOSType() + "]" + md.getFullName()));
            if (md == null) continue;
            this.getMetadataLoader(null).clear(md.getBOSType(), (IMetaDataPK)new MetaDataPK(md.getFullName()));
        }
    }

    private EntityObjectInfo createAEntity(Context ctx, Entity entity) throws Exception {
        int idx;
        ArrayList<Object> metaDataList = new ArrayList<Object>();
        EntityObjectInfo eo = new EntityObjectInfo();
        String name = entity.getEntityName().trim();
        String alias = entity.getName();
        boolean isRight = BOSEntityGenerator.isValidName(name, true, 30);
        if (!isRight) {
            throw new ActionCommonException(null, "\u540d\u79f0\u4e0d\u5408\u6cd5\uff0c\u5355\u636e\u540d\u79f0\u5fc5\u987b\u662f\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\u3001\u6570\u5b57\u7ec4\u6210\uff0c\u957f\u5ea6\u572830\u4e2a\u5b57\u7b26\u5185\uff0c\u4e14\u9996\u5b57\u6bcd\u5fc5\u987b\u662f\u5927\u5199\uff01");
        }
        eo.setPackage(entity.getPackageName());
        eo.setName(name);
        eo.setAlias(alias);
        eo.setIsGenerateCode(false);
        eo.setDescription(alias);
        eo.setExtendedProperty(WEB_DYNAMIC, IS_DYNAMIC);
        eo.setDynamic(true);
        this.setExtendedProperty(eo);
        String baseEntityFullName = entity.getBaseEntityFullName();
        EntityObjectInfo baseEntity = null;
        if (!StringUtils.isEmpty((String)baseEntityFullName) && baseEntityFullName.indexOf(46) > 0 && (baseEntity = BusinessProcessUtil.getEntityInfo((Context)ctx, (String)baseEntityFullName.substring(0, idx = baseEntityFullName.indexOf(46)), (String)baseEntityFullName.substring(idx + 1))) != null) {
            eo.setBaseEntity(baseEntity);
            eo.setLogicalKey(new LogicalKeyInfo());
            eo.getLogicalKey().getKeyPropertys().add(baseEntity.getPropertyByName("id"));
        }
        if (baseEntity == null) {
            throw new BOSException("\u7236\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DataTableInfo tableInfo = this.createATable(ctx, eo, entity);
        eo.setTable(tableInfo);
        PropertyCollection allEntityProperties = Util.getAllEntityProperties(eo);
        for (int i = 0; i < allEntityProperties.size(); ++i) {
            if (allEntityProperties.get(i).getMappingField() == null || tableInfo.getColumnByName(allEntityProperties.get(i).getMappingField().getName()) == null) {
                this.createAColumn(eo, allEntityProperties.get(i));
            }
            this.setExtendedPropertyForBotp(allEntityProperties.get(i));
        }
        String tableName = entity.getTableName();
        PrimaryKeyInfo pkInfo = new PrimaryKeyInfo();
        PKColumnInfo pkColumn = new PKColumnInfo();
        pkColumn.setColumn(tableInfo.getColumnByName("fid"));
        pkInfo.getPKColumns().add(pkColumn);
        String[] strs = tableName.split("_");
        if (strs != null && strs.length >= 2) {
            String secondName = strs[1].length() <= 3 ? strs[1] : strs[1].substring(0, 3);
            String thirdName = this.createThirdName();
            pkInfo.setName("CPK_" + secondName.toUpperCase() + "_" + thirdName);
        }
        tableInfo.setPrimaryKey(pkInfo);
        EntityToTable.autoCreateForeignKey((EntityObjectInfo)eo, (DataTableInfo)tableInfo, new ArrayList());
        metaDataList.add(tableInfo);
        metaDataList.add(eo);
        AbstractMetaDataValue[] meta = new AbstractMetaDataValue[metaDataList.size()];
        metaDataList.toArray(meta);
        this.getMetadataStore(null).saveMetadata(meta, EASWEB_DEF_PROJECT_ID);
        this.clearMetaDataCache(meta);
        CustomSchemeUtil.enableScheme((String)EASWEB_DEF_PROJECT_ID);
        eo = BusinessProcessUtil.getEntityInfo((Context)ctx, (String)entity.getPackageName(), (String)name);
        return eo;
    }

    private void setExtendedProperty(EntityObjectInfo eo) {
        if (eo == null) {
            return;
        }
        eo.setExtendedProperty("codingRuleEnabled", "true");
        eo.removeExtendedProperty("editUI");
        eo.removeExtendedProperty("listUI");
        eo.setExtendedProperty("webEditUI", "");
        eo.setExtendedProperty("webListUI", "");
        eo.setExtendedProperty("isSupportWeb", "true");
        eo.setExtendedProperty("webSupportOnly", "true");
        eo.setExtendedProperty("OrgType", "ControlUnit");
    }

    private void setExtendedPropertyForBotp(PropertyInfo prop) {
        if (prop != null) {
            prop.setExtendedProperty("isBOTPMustInput", "false");
            prop.setExtendedProperty("isForMapping", "true");
            prop.setExtendedProperty("isForMatching", "true");
            prop.setExtendedProperty("isForGrouping", "true");
            prop.setExtendedProperty("isForWrittenBack", "true");
        }
    }

    private DataTableInfo createATable(Context ctx, EntityObjectInfo eo, Entity entity) throws BOSException {
        DataTableInfo table = eo.getTable();
        if (table != null) {
            return table;
        }
        table = EntityToTable.CreateDataTable((EntityObjectInfo)eo, null);
        table.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String tableName = entity.getTableName();
        table.setName(tableName);
        table.setPackage(entity.getPackageName());
        table.setAlias(entity.getTableAlias());
        return table;
    }

    public static boolean checkAliasName(String alias, StringBuffer err_msg) {
        boolean result = true;
        if (StringUtil.isEmpty((String)alias)) {
            err_msg.append("\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            result = false;
        } else if (Pattern.matches("^[0-9].*", alias.trim())) {
            err_msg.append("\u522b\u540d\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u59cb!");
            result = false;
        } else if (alias.indexOf("-") != -1) {
            err_msg.append("\u522b\u540d\u4e0d\u80fd\u5305\u542b\u5b57\u7b26 '-'!");
            result = false;
        }
        return result;
    }

    public static boolean checkAliasName(String lang_name, String alias, StringBuffer err_msg) {
        boolean result = true;
        if (StringUtil.isEmpty((String)alias)) {
            err_msg.append(lang_name + "\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            result = false;
        } else if (Pattern.matches("^[0-9].*", alias.trim())) {
            err_msg.append(lang_name + "\u522b\u540d\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u59cb!");
            result = false;
        } else if (alias.indexOf("-") != -1) {
            err_msg.append(lang_name + "\u522b\u540d\u4e0d\u80fd\u5305\u542b\u5b57\u7b26 '-'!");
            result = false;
        }
        return result;
    }

    public static boolean checkAliasRepeatName(String sub_sys_id, Map names, StringBuffer err_msg) {
        boolean result = true;
        String[] lang_names = new String[]{"fname_l2", "fname_l3", "fname_l1"};
        String[] lang_caption = new String[]{"\u4e2d\u6587", "\u7e41\u4f53\u4e2d\u6587", "\u82f1\u6587"};
        for (int i = 0; i < lang_names.length; ++i) {
            if (!names.containsKey(lang_names[i]) || BOSEntityGenerator.checkAliasName(lang_caption[i], names.get(lang_names[i]).toString(), err_msg)) continue;
            return false;
        }
        try {
            Map map = MetaDataFactory.getFormNameBySysId(null, sub_sys_id, names);
            if (map.size() > 0) {
                result = false;
                err_msg.append("\u522b\u540d\u5728\u5f53\u524d\u5b50\u7cfb\u7edf\u4e0b\u5df2\u7ecf\u5b58\u5728!\n");
                if (map.containsKey("fname_l1")) {
                    err_msg.append("\u82f1\u6587\u540d\u79f0=" + map.get("fname_l1") + "\n");
                }
                if (map.containsKey("fname_l2")) {
                    err_msg.append("\u4e2d\u6587\u540d\u79f0=" + map.get("fname_l2") + "\n");
                }
                if (map.containsKey("fname_l3")) {
                    err_msg.append("\u4e2d\u6587\u7e41\u4f53\u540d\u79f0=" + map.get("fname_l3") + "\n");
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u67e5\u627e\u5355\u636e\u91cd\u540d\u65f6,\u53d1\u751f\u9519\u8bef: " + (Object)((Object)e)));
            result = false;
            err_msg.append("\u67e5\u627e\u5355\u636e\u91cd\u540d\u65f6,\u53d1\u751f\u9519\u8bef: " + (Object)((Object)e));
        }
        return result;
    }

    public static boolean isValidName(String name, boolean isFirstUpper, int maxLength) {
        if (StringUtils.isEmpty((String)name) && maxLength < 2) {
            return false;
        }
        String C = "[A-Z]";
        if (!isFirstUpper) {
            C = "[a-z]";
        }
        String SPECIAL_CHAR = "[A-Za-z0-9_]";
        String QUANTITY = "{1," + maxLength + "}";
        Pattern pattern = Pattern.compile(C + "[A-Za-z0-9_]" + QUANTITY);
        return pattern.matcher(name).matches();
    }

    public static boolean isValidName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        String C = "[A-Za-z_]";
        String SPECIAL_CHAR = "[A-Za-z0-9_]";
        String QUANTITY = "{1,30}";
        Pattern pattern = Pattern.compile("[A-Za-z_][A-Za-z0-9_]{1,30}");
        return pattern.matcher(name).matches();
    }

    private ColumnInfo createAColumn(BusinessInfo businessInfo, Field field, DataTableInfo table, PropertyInfo property) {
        ColumnCollection cols = table.getColumns();
        ColumnInfo col = new ColumnInfo();
        col.setName(field.getFieldName());
        SQLType type = SQLType.VARCHAR;
        int length = 0;
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo op = (OwnPropertyInfo)property;
            type = Util.getSQLType(op.getDataType(), (PropertyInfo)op);
            if (op.getDataType().equals((Object)DataType.STRING)) {
                length = op.getLength();
                String defValue = op.getDefaultValue();
                if (!StringUtils.isEmpty((String)defValue) && defValue.substring(0, 1).equals("\"") && defValue.substring(defValue.length() - 1, defValue.length()).equals("\"")) {
                    defValue = defValue.substring(1, defValue.length() - 1);
                }
                col.setDefaultValue(defValue);
            } else if (op.getDataType().equals((Object)DataType.INTEGER)) {
                String defValue = op.getDefaultValue();
                if (StringUtils.isEmpty((String)defValue)) {
                    defValue = "0";
                }
                col.setDefaultValue(defValue);
            } else if (op.getDataType().equals((Object)DataType.DECIMAL)) {
                if (field.getElementType() == 21 || field.getElementType() == 20) {
                    length = 17;
                    col.setPrecision(length);
                    col.setScale(4);
                } else {
                    length = 21;
                    col.setPrecision(length);
                    col.setScale(8);
                }
                String defValue = op.getDefaultValue();
                if (StringUtils.isEmpty((String)defValue)) {
                    defValue = "0";
                }
                col.setDefaultValue(defValue);
            } else if (op.getDataType().equals((Object)DataType.ENUM) && type.equals((Object)SQLType.VARCHAR)) {
                length = 50;
            }
        } else {
            length = 44;
        }
        if (length > 0) {
            col.setLength(length);
        }
        col.setConfigured(true);
        col.setTypeName(type);
        col.setMultilingual(field.isMulLanguage());
        col.setNullable(property instanceof OwnPropertyInfo ? ((OwnPropertyInfo)property).isNullable() : !field.isMustInput());
        cols.add(col);
        property.setMappingField(col);
        return col;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createAColumn(EntityObjectInfo eo, PropertyInfo property) {
        if (property == null) {
            return;
        }
        DataTableInfo table = eo.getTable();
        ColumnCollection cols = table.getColumns();
        ColumnInfo col = property.getMappingField();
        if (col == null) {
            col = new ColumnInfo();
        }
        if (property instanceof OwnPropertyInfo) {
            col.setName("F" + property.getName());
            SQLType type = SQLType.VARCHAR;
            int length = 0;
            OwnPropertyInfo op = (OwnPropertyInfo)property;
            type = Util.getSQLType(op.getDataType(), (PropertyInfo)op);
            if (op.getDataType().equals((Object)DataType.STRING)) {
                length = op.getLength();
                col.setMultilingual(op.isMultilingual());
                col.setLength(length);
                col.setDefaultValue(StringUtils.isEmpty((String)op.getDefaultValue()) ? " " : op.getDefaultValue());
                col.setNullable(op.isMultilingual() ? true : op.isNullable());
            } else if (op.getDataType().equals((Object)DataType.DECIMAL) || op.getDataType().equals((Object)DataType.FLOAT) || op.getDataType().equals((Object)DataType.DOUBLE)) {
                col.setLength(21);
                col.setPrecision(8);
                col.setDefaultValue("0");
                col.setNullable(op.isNullable());
            } else if (op.getDataType().equals((Object)DataType.INTEGER) || op.getDataType().equals((Object)DataType.BOOLEAN)) {
                col.setLength(4);
                col.setPrecision(4);
                col.setDefaultValue(StringUtils.isEmpty((String)op.getDefaultValue()) ? "0" : op.getDefaultValue());
                col.setNullable(op.isNullable());
            } else if (op.getDataType().equals((Object)DataType.BOSUUID) || op.getDataType().equals((Object)DataType.UUID)) {
                col.setLength(44);
                col.setNullable(op.isNullable());
            } else if (op.getDataType().equals((Object)DataType.TIME) || op.getDataType().equals((Object)DataType.DATE) || op.getDataType().equals((Object)DataType.TIMESTAMP)) {
                col.setNullable(true);
            }
            col.setTypeName(type);
        } else if (property instanceof LinkPropertyInfo) {
            RelationshipInfo ship = ((LinkPropertyInfo)property).getRelationship();
            if (ship.getType().equals((Object)RelationshipType.COMPOSITION)) {
                EntityObjectInfo supplyEO = ship.getSupplierObject();
                if (!Util.isSameOrAncestor(supplyEO, eo)) return;
                if (StringUtils.isEmpty((String)col.getName())) {
                    col.setName("F" + property.getName() + "ID");
                }
                col.setLength(44);
                col.setTypeName(SQLType.VARCHAR);
            } else {
                if (StringUtils.isEmpty((String)col.getName())) {
                    col.setName("F" + property.getName() + "ID");
                }
                col.setLength(44);
                col.setTypeName(SQLType.VARCHAR);
            }
        }
        if (!cols.containsObject((IObjectValue)col)) {
            cols.add(col);
        }
        property.setMappingField(col);
    }

    private PropertyInfo createPropertyInfo(Context ctx, EntityObjectInfo mainEO, BusinessInfo businessInfo, Field field, FieldAppearance fa, PropertyInfo oldProperty) throws BOSException {
        DataType dataType = DataMappingUtil.getDataTypeForElementType(field.getElementType());
        if (dataType == null) {
            return null;
        }
        LinkPropertyInfo thisProp = null;
        if (dataType.equals((Object)DataType.OBJECTVALUE)) {
            String supplierBosType = null;
            EntityObjectInfo supplierEntity = null;
            if (field.getElementType() == 30) {
                supplierBosType = "EE025FDF";
            } else {
                LookUpObject lookupObj = businessInfo.getLookUpObject(field.getLookUpObjectID());
                if (lookupObj == null) {
                    lookupObj = MetaDataFactory.getLoopUpObject(ctx, field.getLookUpObjectID());
                }
                if (lookupObj == null || StringUtils.isEmpty((String)lookupObj.getBosType())) {
                    logger.error((Object)("\u5173\u8054\u7c7b\u578b\u5b57\u6bb5" + field.getKey() + "\u7684LookUpObject\u4e0d\u5b58\u5728\u6216\u8005\u6ca1\u6709BOSType\uff01"));
                    return null;
                }
                supplierBosType = lookupObj.getBosType();
            }
            supplierEntity = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)supplierBosType));
            LinkPropertyInfo property = this.createALinkPropertyInfo(ctx, mainEO, supplierEntity, field.getPropertyName(), field.isMustInput(), false);
            if (oldProperty != null) {
                property.setAlias(oldProperty.getAlias());
                property.setDescription(oldProperty.getAlias());
            } else {
                property.setAlias(fa.getCaption());
                property.setDescription(fa.getCaption());
            }
            thisProp = property;
        } else {
            OwnPropertyInfo property = new OwnPropertyInfo();
            property.setDataType(dataType);
            property.setMultilingual(field.isMulLanguage());
            property.setNullable(!field.isMustInput());
            property.setAlias(fa.getCaption());
            property.setDescription(fa.getCaption());
            property.setDefaultValue(field.getDefValue());
            if (DataType.STRING.equals((Object)dataType)) {
                property.setLength(field.getEditlen());
                if (field.getElementType() == 29) {
                    property.setLength(300);
                } else if (field.getElementType() == 24) {
                    property.setLength(1000);
                }
            } else if (field.getEnumType() > 0) {
                EnumObject enumInfo = businessInfo.getEnumInfo().get(String.valueOf(field.getEnumType()));
                if (enumInfo == null) {
                    enumInfo = MetaDataFactory.getEnumObject(null, field.getEnumType());
                    businessInfo.getEnumInfo().add(enumInfo);
                }
                if (enumInfo != null && !StringUtils.isEmpty((String)enumInfo.getEnumClassName())) {
                    property.setMetadataRef(enumInfo.getEnumClassName());
                    List enumList = EnumUtils.getEnumList((String)enumInfo.getEnumClassName());
                    if (enumList != null && !enumList.isEmpty()) {
                        if (enumList.get(0) instanceof IntEnum) {
                            property.put(ENUMTYPE, (Object)new Integer(1));
                        } else {
                            property.put(ENUMTYPE, (Object)new Integer(0));
                        }
                    } else {
                        property.put(ENUMTYPE, (Object)new Integer(0));
                    }
                } else {
                    property.setDataType(DataType.INTEGER);
                }
            }
            if (property.getDataType().equals((Object)DataType.TIME) || property.getDataType().equals((Object)DataType.DATE) || property.getDataType().equals((Object)DataType.TIMESTAMP) || property.isMultilingual()) {
                property.setNullable(true);
            }
            thisProp = property;
        }
        this.setExtendedPropertyForBotp((PropertyInfo)thisProp);
        thisProp.setConfigured(true);
        thisProp.setName(field.getPropertyName());
        logger.info((Object)("\u521b\u5efa\u5c5e\u6027" + thisProp.getName()));
        return thisProp;
    }

    private LinkPropertyInfo createALinkPropertyInfo(Context ctx, EntityObjectInfo mainEO, EntityObjectInfo supplyEO, String propetyName, boolean isMustInput, boolean isComposition) {
        LinkPropertyInfo property = new LinkPropertyInfo();
        RelationshipInfo relation = new RelationshipInfo();
        relation.setType(isComposition ? RelationshipType.COMPOSITION : RelationshipType.ASSOCIATION);
        relation.setPackage(mainEO.getPackage());
        relation.setName("R_" + mainEO.getName() + "_" + supplyEO.getName() + "_" + propetyName);
        relation.setClientObject(mainEO);
        relation.setSupplierObject(supplyEO);
        relation.setClientCardinality(CardinalityType.ZERO_TO_ONE);
        if (!isComposition) {
            if (isMustInput) {
                relation.setSupplierCardinality(CardinalityType.ONE);
            } else {
                relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
            }
        } else if (isMustInput) {
            relation.setSupplierCardinality(CardinalityType.ONE_TO_UNBOUNDED);
        } else {
            relation.setSupplierCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
        }
        property.setRelationship(relation);
        return property;
    }

    public boolean checkExist(Context ctx, IMetaDataPK metadataPK, BOSObjectType bosObjectType) {
        boolean isExist = false;
        try {
            this.getMetadataLoader(ctx).get(bosObjectType, metadataPK);
            isExist = true;
        }
        catch (MetaDataNotFoundException metaDataNotFoundException) {
            // empty catch block
        }
        return isExist;
    }

    public boolean isContainDynField(BusinessInfo info) {
        List fieldList = info.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            Field field = (Field)fieldList.get(i);
            if (!field.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDynamic(EntityObjectInfo info) {
        return info != null && info.getExtendedProperty(WEB_DYNAMIC) != null && info.getExtendedProperty(WEB_DYNAMIC).equals(IS_DYNAMIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map copyEntity(String sourceEntityFullName, String targetPackage, String targetName, String targetAlias) {
        HashMap<Object, AbstractMetaDataValue> metaDataMap = new HashMap<Object, AbstractMetaDataValue>();
        ArrayList relate = new ArrayList();
        try {
            int i;
            MetaDataLoaderFactory.getRemoteMetaDataLoader().clear(MetaDataTypeList.UIOBJECT);
            XMLAccessEngine.getXMLLoader((Context)ConfigMDUtil.getContext()).clearCacheByType(MetaDataTypeList.UIOBJECT);
            BizUnitInfo bizUnitInfo = new BizUnitInfo();
            bizUnitInfo.setString("entityPK", sourceEntityFullName);
            BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
            bizUnitCtrl.loadAll(bizUnitInfo, true, false);
            if (bizUnitInfo.getEntity() != null) {
                EntityObjectInfo entity = bizUnitInfo.getEntity();
                entity.setTrueClone(true);
            }
            BizUnitInfo temp = bizUnitCtrl.clone(bizUnitInfo, this.getSuffixCollection(), targetPackage, targetName, 0);
            temp.setAlias(targetAlias);
            temp.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            BOSEntityGenerator.getRelateMetadata(temp, relate);
            HashMap<String, String> relationShip = new HashMap<String, String>();
            if (bizUnitInfo.getEntity() != null && temp.getEntity() != null) {
                relationShip.put(temp.getEntity().getFullName(), bizUnitInfo.getEntity().getFullName());
                if (bizUnitInfo.getEntity().getTable() != null && temp.getEntity().getTable() != null) {
                    relationShip.put(temp.getEntity().getTable().getFullName(), bizUnitInfo.getEntity().getTable().getFullName());
                }
            }
            this.setExtendedProperty(temp.getEntity());
            AbstractMetaDataValue[] meta = new AbstractMetaDataValue[relate.size()];
            meta = relate.toArray(meta);
            for (i = 0; i < meta.length; ++i) {
                if (meta[i] instanceof DataTableInfo) {
                    DataTableInfo table = (DataTableInfo)meta[i];
                    String tableName = table.getRealName();
                    if (StringUtils.isEmpty((String)tableName)) continue;
                    if (tableName.length() > 30) {
                        table.setName(tableName.substring(0, 30));
                    }
                    if (table.getPrimaryKey() == null) continue;
                    String[] strs = tableName.split("_");
                    if (strs != null && strs.length >= 3) {
                        String secondName = strs[1].length() <= 3 ? strs[1] : strs[1].substring(0, 3);
                        String thirdName = this.createThirdName();
                        table.getPrimaryKey().setName("CPK_" + secondName.toUpperCase() + "_" + thirdName);
                        continue;
                    }
                    String tempName = "CPK_" + tableName;
                    tempName = tempName.length() > 18 ? tempName.substring(0, 17) : tempName;
                    table.getPrimaryKey().setName(tempName);
                    continue;
                }
                if (!(meta[i] instanceof EntityObjectInfo)) continue;
                EntityObjectInfo entityObject = (EntityObjectInfo)meta[i];
                entityObject.setBusinessControllerName(null);
                entityObject.setBusinessImplName(null);
                entityObject.setBizUnitPK(null);
                entityObject.setDynamic(true);
                entityObject.setExtendedProperty(WEB_DYNAMIC, IS_DYNAMIC);
                PropertyCollection collection = entityObject.getEntityProperties();
                if (collection == null) continue;
                for (int j = 0; j < collection.size(); ++j) {
                    PropertyInfo prop = collection.get(j);
                    this.setExtendedPropertyForBotp(prop);
                }
            }
            this.getMetadataStore(null).saveMetadata(meta, EASWEB_DEF_PROJECT_ID);
            this.clearMetaDataCache(meta);
            CustomSchemeUtil.enableScheme((String)EASWEB_DEF_PROJECT_ID);
            for (i = 0; meta != null && i < meta.length; ++i) {
                if (relationShip.containsKey(meta[i].getFullName())) {
                    metaDataMap.put(relationShip.get(meta[i].getFullName()), meta[i]);
                    continue;
                }
                metaDataMap.put(meta[i].getFullName(), meta[i]);
            }
        }
        catch (Exception exc) {
            MsgBox.showError((Component)ComponentUtil.getOwnerWindow(null), (String)"\u521b\u5efa\u5b9e\u4f53\u5931\u8d25", (String)exc.getMessage());
            HashMap hashMap = new HashMap();
            return hashMap;
        }
        finally {
            for (AbstractMetaDataValue md : relate) {
                if (md instanceof UIObjectInfo) continue;
                logger.info((Object)(" clear md cache --- > [" + md.getBOSType() + "]" + md.getFullName()));
                if (md == null) continue;
                this.getMetadataLoader(null).clear(md.getBOSType(), (IMetaDataPK)new MetaDataPK(md.getFullName()));
            }
        }
        return metaDataMap;
    }

    private String createThirdName() {
        String thirdName = BOSUuid.create((String)BOSTYPE).toString();
        String tmp = "";
        for (int k = 0; k < thirdName.length(); ++k) {
            char achar = thirdName.charAt(k);
            if (!(achar >= '0' && achar <= '9' || achar >= 'a' && achar <= 'z') && (achar < 'A' || achar > 'Z')) continue;
            tmp = tmp + achar;
        }
        thirdName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        return thirdName;
    }

    public static void getRelateMetadata(BizUnitInfo info, List relate) throws Exception {
        FunctionObjectInfo fun;
        EntityObjectInfo entity = info.getEntity();
        if (entity != null) {
            if (entity.getTable() != null) {
                entity.setAlias(info.getAlias());
                entity.getTable().setBizUnitPK(info.getFullName());
                entity.setIsGenerateCode(false);
                relate.add(entity.getTable());
            }
            relate.add(entity);
            BizFieldCollection fields = info.getFields();
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                if (BizDataType.OBJECT.equals((Object)fields.get(i).getBizDataType()) && fields.get(i).getDataSource() != null) {
                    EntityObjectCollection extEntityCol;
                    String propName = fields.get(i).getPropertyName();
                    if (propName == null) continue;
                    LinkPropertyInfo lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false);
                    if (lnkProperty != null && lnkProperty.getRelationship() != null) {
                        RelationshipInfo relation = lnkProperty.getRelationship();
                        relate.add(relation);
                    }
                    if ((extEntityCol = info.getExtendEntities()) == null || extEntityCol.size() <= 0) continue;
                    int m = extEntityCol.size();
                    for (int j = 0; j < m; ++j) {
                        lnkProperty = (LinkPropertyInfo)extEntityCol.get(j).getPropertyByName(propName, false);
                        if (lnkProperty == null || lnkProperty.getRelationship() == null) continue;
                        RelationshipInfo relation = lnkProperty.getRelationship();
                        relate.add(relation);
                    }
                    continue;
                }
                if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)fields.get(i);
                BOSEntityGenerator.getRelateMetadata(info, entity, groupField, relate);
            }
        }
        if (info.getQuery() != null) {
            JoinQueryInfo query = info.getQuery();
            query.setAlias(info.getAlias());
            relate.add(query);
        }
        if (info.getEntityFunction() != null) {
            relate.add(info.getEntityFunction());
        }
        if (info.getEditUIFunction() != null) {
            fun = info.getEditUIFunction();
            fun.setAlias(info.getAlias());
            relate.add(fun);
        }
        if (info.getListUIFunction() != null) {
            fun = info.getListUIFunction();
            fun.setAlias(info.getAlias());
            relate.add(fun);
        }
    }

    public static void getRelateMetadata(BizUnitInfo info, EntityObjectInfo entity, BizGroupFieldInfo groupField, List list) throws Exception {
        JoinQueryInfo subQuery;
        EntityObjectInfo subEntity;
        DataTableInfo table = groupField.getTableObject();
        if (table != null) {
            list.add(table);
        }
        if ((subEntity = groupField.getEntityObject()) != null) {
            LinkPropertyInfo lnkProperty;
            list.add(subEntity);
            subEntity.setAlias(info.getAlias() + "\u5206\u5f55\u5b9e\u4f53");
            subEntity.setIsGenerateCode(false);
            String propName = groupField.getPropertyName();
            if (propName != null && (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false)) != null && lnkProperty.getRelationship() != null) {
                RelationshipInfo relation = lnkProperty.getRelationship();
                list.add(relation);
            }
            BizFieldCollection subFields = groupField.getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                LinkPropertyInfo lnkProperty2;
                String subPropName;
                if (subFields.get(j) instanceof BizGroupFieldInfo) {
                    BOSEntityGenerator.getRelateMetadata(info, subEntity, (BizGroupFieldInfo)subFields.get(j), list);
                    continue;
                }
                if (!BizDataType.OBJECT.equals((Object)subFields.get(j).getBizDataType()) || subFields.get(j).getDataSource() == null || (subPropName = subFields.get(j).getPropertyName()) == null || (lnkProperty2 = (LinkPropertyInfo)subEntity.getPropertyByName(subPropName, false)) == null || lnkProperty2.getRelationship() == null) continue;
                RelationshipInfo relation = lnkProperty2.getRelationship();
                list.add(relation);
            }
        }
        if ((subQuery = groupField.getQuery()) != null) {
            list.add(subQuery);
            subQuery.setAlias(info.getAlias() + "\u5b50\u67e5\u8be2");
        }
    }
}

