/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import java.util.HashMap;

public final class PrintHelper {
    private LayoutInfo layoutInfo;
    private BusinessInfo businessInfo;
    private String printTemplatePath;
    private String printTemplatePathAlias;

    public void writeToPrintMeta() throws KDRSException, BOSException {
        int size = this.businessInfo.getEntrys().size();
        if (size == 1) {
            Entity[] entitys = new Entity[]{(Entity)this.businessInfo.getEntrys().get(0)};
            this.writeAPrintMeta(entitys, this.layoutInfo.getCaption());
        } else if (size == 2) {
            Entity[] entitys = new Entity[]{(Entity)this.businessInfo.getEntrys().get(0), (Entity)this.businessInfo.getEntrys().get(1)};
            this.writeAPrintMeta(entitys, this.layoutInfo.getCaption());
        } else {
            BOSObjectType bosType = BOSObjectType.create((String)this.businessInfo.getForm().getBosType());
            for (int i = 0; i < size; ++i) {
                Entity ety = (Entity)this.businessInfo.getEntrys().get(i);
                if (ety.getEntityType() == 0) {
                    Entity[] entitys = new Entity[]{ety};
                    this.writeAPrintMeta(entitys, this.layoutInfo.getCaption());
                    continue;
                }
                PropertyInfo property = BusinessProcessUtil.getPropertyInfo(null, (BOSObjectType)bosType, (String)ety.getEntryName());
                if (property == null) continue;
                Entity[] entitys = new Entity[]{ety};
                this.writeAPrintMeta(entitys, ety.getName());
            }
        }
    }

    private void writeAPrintMeta(Entity[] entitys, String alias) throws KDRSException {
        MetaClass mc = new MetaClass();
        mc.setType("bos-query");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < entitys.length; ++i) {
            Entity eba = entitys[i];
            sb.append(eba.getKey()).append(".");
            this.writeEntityField(mc, eba);
        }
        sb.append("bos-query");
        String fullPath = PathUtil.makeChildPath((String)this.businessInfo.getForm().getTemplatePath(), (String)sb.toString());
        this.createTemplatePath(fullPath, alias);
        KDNoteHelper helper = new KDNoteHelper();
        helper.writeMetaClass(mc, fullPath);
    }

    private void writeEntityField(MetaClass mc, Entity eba) {
        for (Field fld : eba.getFields()) {
            FieldAppearance fieldApp = this.layoutInfo.getFieldAppearance(fld.getKey());
            if (fieldApp == null || !fieldApp.isPrintVisible()) continue;
            MetaField mf = new MetaField();
            mf.setName(fieldApp.getKey());
            mf.setAlias(fieldApp.getCaption());
            mf.setType(this.getRelevantDataType(fieldApp.getElementType()));
            mf.setProperty("formid", (Object)this.businessInfo.getForm().getId());
            mc.addField(mf);
        }
    }

    public void writeMultiApproveToPrintMeta() throws KDRSException {
        this.createTemplatePath();
        MetaClass mc = new MetaClass();
        mc.setType("bos-query");
        mc.addField(this.createAMetaField("FActDefName", "\u4efb\u52a1\u540d\u79f0", DataType.STRING));
        mc.addField(this.createAMetaField("FApproveResult", "\u5ba1\u6279\u7ed3\u679c", DataType.STRING));
        mc.addField(this.createAMetaField("FHandlerContent", "\u5ba1\u6279\u7b56\u7565", DataType.STRING));
        mc.addField(this.createAMetaField("FOpinion", "\u5ba1\u6279\u610f\u89c1", DataType.STRING));
        mc.addField(this.createAMetaField("FPersonEmpName", "\u5ba1\u6279\u4eba", DataType.STRING));
        mc.addField(this.createAMetaField("FPosition", "\u5ba1\u6279\u4eba\u804c\u4f4d", DataType.STRING));
        mc.addField(this.createAMetaField("FCompany", "\u5ba1\u6279\u4eba\u516c\u53f8", DataType.STRING));
        mc.addField(this.createAMetaField("FApproveTime", "\u5ba1\u6279\u65e5\u671f", DataType.DATETIME));
        KDNoteHelper helper = new KDNoteHelper();
        helper.writeMetaClass(mc, this.printTemplatePath);
    }

    public void writeSealApproveToPrintMeta(String key) throws KDRSException {
        this.createTemplatePath();
        MetaClass mc = new MetaClass();
        mc.setType("bos-query");
        Appearance ap = this.layoutInfo.getAppearance(key);
        mc.addField(this.createAMetaField(ap.getKey(), ap.getCaption(), DataType.BLOB));
        KDNoteHelper helper = new KDNoteHelper();
        helper.writeMetaClass(mc, this.printTemplatePath);
    }

    private MetaField createAMetaField(String key, String alias, DataType dataType) {
        MetaField mf = new MetaField();
        mf.setName(key);
        mf.setAlias(alias);
        mf.setType(dataType);
        return mf;
    }

    private void createTemplatePath() throws KDRSException {
        this.createTemplatePath(this.printTemplatePath, this.printTemplatePathAlias);
    }

    private void createTemplatePath(String printTemplatePath, String printTemplatePathAlias) throws KDRSException {
        String fullPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs/", (String)printTemplatePath);
        IBizContent content = KDNoteHelper.getBizContent();
        if (!content.isExist(fullPath)) {
            HashMap<String, Object> atts = new HashMap<String, Object>();
            atts.put("category", "bos-query");
            atts.put("name", PathUtil.getLastName((String)printTemplatePath));
            atts.put("alias", "#1");
            atts.put("alias.zh_CN", printTemplatePathAlias);
            atts.put("formid", this.businessInfo.getForm().getId());
            atts.put("create_policy", new Integer(2));
            content.create(fullPath, atts);
        }
    }

    public PrintHelper(BusinessInfo businessInfo, LayoutInfo layoutInfo, String printTemplatePath, String printTemplatePathAlias) {
        this.businessInfo = businessInfo;
        this.layoutInfo = layoutInfo;
        this.printTemplatePath = printTemplatePath;
        this.printTemplatePathAlias = printTemplatePathAlias;
    }

    private DataType getRelevantDataType(int et) {
        switch (et) {
            case 2: 
            case 20: 
            case 21: 
            case 22: {
                return DataType.DECIMAL;
            }
            case 4: 
            case 5: {
                return DataType.DATETIME;
            }
            case 3: {
                return DataType.INTEGER;
            }
        }
        return DataType.STRING;
    }

    public String getPrintTemplatePathAlias() {
        return this.printTemplatePathAlias;
    }

    public void setPrintTemplatePathAlias(String printTemplatePathAlias) {
        this.printTemplatePathAlias = printTemplatePathAlias;
    }
}

