/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.core.FormFactory;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.EnumBarItemStyle;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarTemplateManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BarUtils {
    public static final Integer MENU_BILL = new Integer(1);
    public static final Integer MENU_LIST = new Integer(2);
    public static final String BARITEM_TABLE = "T_BAS_BarItem";
    public static final String BARITEMLINK_TABLE = "T_BAS_BarItemLink";
    public static final String SQL_BARITEMLINK = "SELECT t1.FBarItemID, t1.FParentID FROM T_BAS_BarItemLink t1, T_Bas_FormMenu t2 \nWHERE t2.FFormID=? AND t2.FMenuID = t1.FMenuID AND t2.FType=? \nORDER BY t1.FParentID, t1.FIndex;";
    public static final String SQL_BARITEMLINKBYMENUID = "SELECT t1.FBarItemID, t1.FParentID FROM T_BAS_BarItemLink\tWHERE t1.FMenuID =? ORDER BY t1.FParentID, t1.FIndex;";
    public static final String BARTEMPLATE_FORMID = "99999999-9999-9999-9999-999999999999WWF7XXF4";

    public static ResultSet getBarItems(String formID, Integer menuType, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer(400);
        sql.append("SELECT t1.FID, t1.FCaption_l2, t1.FCaption_l1,t1.FCaption_l3, \n").append("       t1.FName, t1.FDescription_l2, t1.FDescription_l1, t1.FDescription_l3, \n").append("       t1.FStyle, t1.FToolTip_l2, t1.FToolTip_l1, t1.FToolTip_l3, \n").append("       t1.FImageKey, t1.FEnabled, t1.FChecked, t1.FVisible, t1.FShortcut, t1.FElementTypeID, t1.FSeq \n").append("FROM T_BAS_BarItem t1,T_Bas_FormMenu t2 \n").append("WHERE t2.FFormID=? AND t2.FMenuID = t1.FMenuID AND t2.FType=?;");
        IRowSet items = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{formID, menuType});
        return items;
    }

    public static ResultSet getSubCategoryBarItems_Template(Integer menuType, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer(400);
        sql.append("SELECT t1.FID, t1.FCaption_l2, t1.FCaption_l1,t1.FCaption_l3, \n").append("       t1.FName, t1.FDescription_l2, t1.FDescription_l1, t1.FDescription_l3, \n").append("       t1.FStyle, t1.FToolTip_l2, t1.FToolTip_l1, t1.FToolTip_l3, \n").append("       t1.FImageKey, t1.FEnabled, t1.FChecked, t1.FVisible, t1.FShortcut, t1.FElementTypeID, t1.FTemplateName, t1.FSeq \n").append("FROM T_BAS_BarItem t1,T_Bas_FormMenu t2 \n").append("WHERE t2.FFormID=? AND t2.FMenuID = t1.FMenuID AND t2.FType=? AND t1.FStyle=?;");
        IRowSet items = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{BARTEMPLATE_FORMID, menuType, String.valueOf(13)});
        return items;
    }

    public static ResultSet getBarItems_Template(Integer menuType, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer(400);
        sql.append("SELECT t1.FID, t1.FCaption_l2, t1.FCaption_l1,t1.FCaption_l3, \n").append("       t1.FName, t1.FDescription_l2, t1.FDescription_l1, t1.FDescription_l3, \n").append("       t1.FStyle, t1.FToolTip_l2, t1.FToolTip_l1, t1.FToolTip_l3, \n").append("       t1.FImageKey, t1.FEnabled, t1.FChecked, t1.FVisible, t1.FShortcut, t1.FElementTypeID, t1.FTemplateName, t1.FSeq \n").append("FROM T_BAS_BarItem t1,T_Bas_FormMenu t2 \n").append("WHERE t2.FFormID=? AND t2.FMenuID = t1.FMenuID AND t2.FType=? AND t1.FStyle not in (?);");
        IRowSet items = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{BARTEMPLATE_FORMID, menuType, String.valueOf(13)});
        return items;
    }

    public static Map getBarData(String formID, Integer menuType, Context ctx) throws BOSException {
        ResultSet items = BarUtils.getBarItems(formID, menuType, ctx);
        IRowSet links = DbUtil.executeQuery((Context)ctx, (String)SQL_BARITEMLINK, (Object[])new Object[]{formID, menuType});
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        result.put("items", items);
        result.put("links", (ResultSet)links);
        return result;
    }

    public static Map getBarData_Template(Integer menuType, Context ctx) throws BOSException {
        ResultSet SubCategories = BarUtils.getSubCategoryBarItems_Template(menuType, ctx);
        ResultSet items = BarUtils.getBarItems_Template(menuType, ctx);
        IRowSet links = DbUtil.executeQuery((Context)ctx, (String)SQL_BARITEMLINK, (Object[])new Object[]{BARTEMPLATE_FORMID, menuType});
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        result.put("SubCategories", SubCategories);
        result.put("items", items);
        result.put("links", (ResultSet)links);
        return result;
    }

    public static Map getBarData(String menuID, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer(400);
        sql.append("SELECT t1.FID, t1.FCaption_l2, t1.FCaption_l1, t1.FCaption_l3, \n").append("       t1.FName, t1.FDescription_l2, t1.FDescription_l1,t1.FDescription_l3, \n").append("       t1.FStyle, t1.FToolTip_l2, t1.FToolTip_l1,t1.FToolTip_l3, \n").append("       t1.FImageKey, t1.FEnabled, t1.FChecked, t1.FVisible, t1.FShortcut, t1.FElementTypeID \n").append("FROM T_BAS_BarItem t1").append("WHERE t1.FMenuID =?;");
        IRowSet items = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{menuID});
        sql = new StringBuffer(400);
        IRowSet links = DbUtil.executeQuery((Context)ctx, (String)SQL_BARITEMLINKBYMENUID, (Object[])new Object[]{menuID});
        HashMap<String, IRowSet> result = new HashMap<String, IRowSet>();
        result.put("items", items);
        result.put("links", links);
        return result;
    }

    public static String insertMenuScheme(String name1, String name2, String name3, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer(400);
        String schemeId = BOSUuid.create((String)"77887786").toString();
        sql.append(" INSERT INTO T_BAS_FormMenuScheme(FID,FName_l1,FName_l2,FName_l3) \n").append(" VALUES('").append(schemeId).append("','").append(name1).append("','").append(name2).append("','").append(name3).append("');");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return schemeId;
    }

    public static void insertFormMenu(String formId, String menuSchemeId, int isBillEdit, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer(400);
        String id = BOSUuid.create((String)"77887787").toString();
        sql.append(" INSERT INTO T_BAS_FormMenu(FID,FFormId,FType,FMenuId) \n").append(" VALUES('").append(id).append("','").append(formId).append("',").append(isBillEdit).append(",'").append(menuSchemeId).append("');");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void insertBarItem(Map param, Context ctx) {
        block11: {
            String formID = (String)param.get("formID");
            String menuName1 = (String)param.get("menuName1");
            String menuName2 = (String)param.get("menuName2");
            String menuName3 = (String)param.get("menuName3");
            Map items = (Map)param.get("items");
            Map links = (Map)param.get("links");
            HashMap<String, String> name2id = new HashMap<String, String>();
            Connection conn = null;
            PreparedStatement istmt = null;
            StringBuffer sql = new StringBuffer(400);
            sql.append(" INSERT INTO T_BAS_BarItem(FID,FMenuId,FName,FCaption_L2,FCaption_L1,FCaption_L3,FDescription_L2,FDescription_L1,FDescription_L3,FToolTip_L2,FToolTip_L1,FToolTip_L3, \n").append("        FStyle,FImageKey, FEnabled,FVisible,FChecked,FShortcut,FElementTypeID,FSeq,FTemplateName) \n").append(" VALUES(NEWBOSID('77887788'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) \n");
            try {
                String menuId = BarUtils.insertMenuScheme(menuName1, menuName2, menuName3, ctx);
                BarUtils.insertFormMenu(formID, menuId, 2, ctx);
                conn = EJBFactory.getConnection((Context)ctx);
                istmt = conn.prepareStatement(sql.toString());
                for (Map.Entry entry : items.entrySet()) {
                    Map item = (Map)entry.getValue();
                    istmt.setString(1, menuId);
                    istmt.setString(2, (String)item.get("name"));
                    istmt.setString(3, (String)item.get("caption_l2"));
                    istmt.setString(4, (String)item.get("caption_l1"));
                    istmt.setString(5, (String)item.get("caption_l3"));
                    istmt.setString(6, (String)item.get("desc_l2"));
                    istmt.setString(7, (String)item.get("desc_l1"));
                    istmt.setString(8, (String)item.get("desc_l3"));
                    istmt.setString(9, (String)item.get("tooltip_l2"));
                    istmt.setString(10, (String)item.get("tooltip_l1"));
                    istmt.setString(11, (String)item.get("tooltip_l3"));
                    istmt.setInt(12, (Integer)item.get("style"));
                    istmt.setString(13, (String)item.get("imagekey"));
                    istmt.setInt(14, (Integer)item.get("enabled"));
                    istmt.setInt(15, (Integer)item.get("visible"));
                    istmt.setInt(16, (Integer)item.get("checked"));
                    istmt.setString(17, (String)item.get("shortcut"));
                    istmt.setInt(18, (Integer)item.get("elementTypeID"));
                    istmt.setInt(19, (Integer)item.get("seq"));
                    istmt.setString(20, (String)item.get("temlpateID"));
                    istmt.addBatch();
                }
                istmt.executeBatch();
                ResultSet rs = BarUtils.getBarItems(formID, MENU_LIST, ctx);
                while (rs.next()) {
                    name2id.put(rs.getString("FName"), rs.getString("FID"));
                }
                sql = new StringBuffer(400);
                sql.append(" INSERT INTO T_BAS_BarItemLink(FID,FMenuId,FBarItemID,FParentID,FIndex) \n").append(" VALUES(NEWBOSID('77887789'),?,?,?,?) \n");
                istmt = conn.prepareStatement(sql.toString());
                for (Map.Entry entry : links.entrySet()) {
                    List link = (List)entry.getValue();
                    String parentName = (String)entry.getKey();
                    int index = 0;
                    Iterator it1 = link.iterator();
                    while (it1.hasNext()) {
                        istmt.setString(1, menuId);
                        String barItemName = (String)it1.next();
                        String barItemID = (String)name2id.get(barItemName);
                        String parentID = (String)name2id.get(parentName);
                        istmt.setString(2, barItemID);
                        istmt.setString(3, parentID);
                        istmt.setInt(4, index++);
                        istmt.addBatch();
                    }
                }
                istmt.executeBatch();
                DBUtils.cleanup((Statement)istmt, (Connection)conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e2) {
                e2.printStackTrace();
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBUtils.cleanup(istmt, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void insertBarTemplate(Map param, Context ctx) {
        block12: {
            String formID = BARTEMPLATE_FORMID;
            String menuName1 = "template";
            String menuName2 = "\u6a21\u677f";
            String menuName3 = "\u7bc4\u672c";
            Map subCategoryItems = (Map)param.get("subCategoryItems");
            Map items = (Map)param.get("items");
            Map links = (Map)param.get("links");
            Map templateLinks = (Map)param.get("templateLinks");
            HashMap<String, String> name2id = new HashMap<String, String>();
            Connection conn = null;
            PreparedStatement istmt = null;
            StringBuffer sqlSub = new StringBuffer(400);
            sqlSub.append(" INSERT INTO T_BAS_BarItem(FID,FMenuId,FName,FCaption_L2,FCaption_L1,FCaption_L3,FDescription_L2,FDescription_L1,FDescription_L3, \n").append("        FStyle,FElementTypeID,FSeq,FTemplateName) \n").append(" VALUES(NEWBOSID('77887788'),?,?,?,?,?,?,?,?,?,?,?,?) \n");
            StringBuffer sql = new StringBuffer(400);
            sql.append(" INSERT INTO T_BAS_BarItem(FID,FMenuId,FName,FCaption_L2,FCaption_L1,FCaption_L3,FDescription_L2,FDescription_L1,FDescription_L3,FToolTip_L2,FToolTip_L1,FToolTip_L3, \n").append("        FStyle,FImageKey, FEnabled,FVisible,FChecked,FShortcut,FElementTypeID,FSeq,FTemplateName) \n").append(" VALUES(NEWBOSID('77887788'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) \n");
            try {
                Map item;
                String menuId = BarUtils.insertMenuScheme(menuName1, menuName2, menuName3, ctx);
                BarUtils.insertFormMenu(formID, menuId, 2, ctx);
                conn = EJBFactory.getConnection((Context)ctx);
                istmt = conn.prepareStatement(sqlSub.toString());
                for (Map.Entry entry : subCategoryItems.entrySet()) {
                    item = (Map)entry.getValue();
                    istmt.setString(1, menuId);
                    istmt.setString(2, (String)item.get("name"));
                    istmt.setString(3, (String)item.get("caption_l2"));
                    istmt.setString(4, (String)item.get("caption_l1"));
                    istmt.setString(5, (String)item.get("caption_l3"));
                    istmt.setString(6, (String)item.get("desc_l2"));
                    istmt.setString(7, (String)item.get("desc_l1"));
                    istmt.setString(8, (String)item.get("desc_l3"));
                    istmt.setInt(9, (Integer)item.get("style"));
                    istmt.setInt(10, (Integer)item.get("elementTypeID"));
                    istmt.setInt(11, (Integer)item.get("seq"));
                    istmt.setString(12, (String)item.get("temlpateName"));
                    istmt.addBatch();
                }
                istmt.executeBatch();
                istmt = conn.prepareStatement(sql.toString());
                for (Map.Entry entry : items.entrySet()) {
                    item = (Map)entry.getValue();
                    istmt.setString(1, menuId);
                    istmt.setString(2, (String)item.get("name"));
                    istmt.setString(3, (String)item.get("caption_l2"));
                    istmt.setString(4, (String)item.get("caption_l1"));
                    istmt.setString(5, (String)item.get("caption_l3"));
                    istmt.setString(6, (String)item.get("desc_l2"));
                    istmt.setString(7, (String)item.get("desc_l1"));
                    istmt.setString(8, (String)item.get("desc_l3"));
                    istmt.setString(9, (String)item.get("tooltip_l2"));
                    istmt.setString(10, (String)item.get("tooltip_l1"));
                    istmt.setString(11, (String)item.get("tooltip_l3"));
                    istmt.setInt(12, (Integer)item.get("style"));
                    istmt.setString(13, (String)item.get("imagekey"));
                    istmt.setInt(14, (Integer)item.get("enabled"));
                    istmt.setInt(15, (Integer)item.get("visible"));
                    istmt.setInt(16, (Integer)item.get("checked"));
                    istmt.setString(17, (String)item.get("shortcut"));
                    istmt.setInt(18, (Integer)item.get("elementTypeID"));
                    istmt.setInt(19, (Integer)item.get("seq"));
                    istmt.setString(20, (String)item.get("temlpateName"));
                    istmt.addBatch();
                }
                istmt.executeBatch();
                ResultSet rs = BarUtils.getBarItems(formID, MENU_LIST, ctx);
                while (rs.next()) {
                    name2id.put(rs.getString("FName"), rs.getString("FID"));
                }
                sql = new StringBuffer(400);
                sql.append(" INSERT INTO T_BAS_BarItemLink(FID,FMenuId,FBarItemID,FParentID,FIndex) \n").append(" VALUES(NEWBOSID('77887789'),?,?,?,?) \n");
                istmt = conn.prepareStatement(sql.toString());
                for (Map.Entry entry : links.entrySet()) {
                    List link = (List)entry.getValue();
                    String parentName = (String)entry.getKey();
                    int index = 0;
                    Iterator it1 = link.iterator();
                    while (it1.hasNext()) {
                        istmt.setString(1, menuId);
                        String barItemName = (String)it1.next();
                        String barItemID = (String)name2id.get(barItemName);
                        String parentID = (String)name2id.get(parentName);
                        istmt.setString(2, barItemID);
                        istmt.setString(3, parentID);
                        istmt.setInt(4, index++);
                        istmt.addBatch();
                    }
                }
                istmt.executeBatch();
                DBUtils.cleanup((Statement)istmt, (Connection)conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e2) {
                e2.printStackTrace();
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBUtils.cleanup(istmt, conn);
            }
        }
    }

    public static void save2Db(Context ctx, String formID, String menuName1, String menuName2, String menuName3, BarDataManager barBuilder) {
        Map allItems = barBuilder.getAllBarItems();
        HashMap items = new HashMap();
        HashMap links = new HashMap();
        for (Map.Entry entry : allItems.entrySet()) {
            BarItem barItem = (BarItem)entry.getValue();
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("name", barItem.getName());
            item.put("caption_l2", barItem.getCaption_L2());
            item.put("caption_l1", barItem.getCaption_L1());
            item.put("caption_l3", barItem.getCaption_L3());
            item.put("style", new Integer(barItem.getStyle().getValue()));
            item.put("desc_l2", barItem.getDescription_L2());
            item.put("desc_l1", barItem.getDescription_L1());
            item.put("desc_l3", barItem.getDescription_L3());
            item.put("tooltip_l2", barItem.getToolTip_L1());
            item.put("tooltip_l1", barItem.getToolTip_L2());
            item.put("tooltip_l3", barItem.getToolTip_L3());
            item.put("imagekey", barItem.getImageKey());
            item.put("shortcut", barItem.getShortcut());
            item.put("enabled", new Integer(barItem.getEnabled()));
            item.put("visible", new Integer(barItem.getVisible()));
            item.put("checked", new Integer(barItem.getChecked()));
            item.put("elementTypeID", new Integer(barItem.getElementType()));
            item.put("seq", new Integer(barItem.getSeq()));
            item.put("temlpateName", barItem.getTemplateName());
            items.put(barItem.getName(), item);
            ArrayList<String> link = new ArrayList<String>();
            for (BarItem barItem1 : barItem.getChildren()) {
                link.add(barItem1.getName());
            }
            links.put(barItem.getName(), link);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("items", items);
        param.put("links", links);
        param.put("formID", formID);
        param.put("menuName1", menuName1);
        param.put("menuName2", menuName2);
        param.put("menuName3", menuName3);
        FormFactory.insertBarItem2Db(param, ctx);
    }

    public static void saveTemplate2Db(Context ctx, BarTemplateManager barTemplate) {
        Map subCategories = barTemplate.getSubCategoryItems();
        HashMap subCategoryItems = new HashMap();
        HashMap items = new HashMap();
        HashMap links = new HashMap();
        HashMap templateLinks = new HashMap();
        for (Map.Entry entry : subCategories.entrySet()) {
            BarItem categoryItem = (BarItem)entry.getValue();
            HashMap<String, Object> itemCI = new HashMap<String, Object>();
            itemCI.put("name", categoryItem.getName());
            itemCI.put("caption_l2", categoryItem.getCaption_L2());
            itemCI.put("caption_l1", categoryItem.getCaption_L1());
            itemCI.put("caption_l3", categoryItem.getCaption_L3());
            itemCI.put("style", new Integer(13));
            itemCI.put("desc_l2", categoryItem.getDescription_L2());
            itemCI.put("desc_l1", categoryItem.getDescription_L1());
            itemCI.put("desc_l3", categoryItem.getDescription_L3());
            itemCI.put("elementTypeID", new Integer(categoryItem.getElementType()));
            itemCI.put("seq", new Integer(categoryItem.getSeq()));
            itemCI.put("temlpateName", categoryItem.getTemplateName());
            subCategoryItems.put(categoryItem.getName(), itemCI);
            ArrayList<String> linkCI = new ArrayList<String>();
            for (BarItem barItem1 : categoryItem.getChildren()) {
                linkCI.add(barItem1.getName());
            }
            links.put(categoryItem.getName(), linkCI);
            BarDataManager barBuilder = categoryItem.getBarDataManagerOfSubCategory();
            if (barBuilder == null) continue;
            ArrayList<String> linkTemplate = new ArrayList<String>();
            Map topItems = barBuilder.getTopLevelBarItems();
            ArrayList<String> template_Items_link = new ArrayList<String>();
            for (Map.Entry entryTop : topItems.entrySet()) {
                BarItem topBarItem = (BarItem)entryTop.getValue();
                template_Items_link.add(topBarItem.getName());
            }
            links.put(categoryItem.getName(), template_Items_link);
            Map allItems = barBuilder.getAllBarItems();
            for (Map.Entry entryAll : allItems.entrySet()) {
                BarItem barItem = (BarItem)entryAll.getValue();
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("name", barItem.getName());
                item.put("caption_l2", barItem.getCaption_L2());
                item.put("caption_l1", barItem.getCaption_L1());
                item.put("caption_l3", barItem.getCaption_L3());
                item.put("style", new Integer(barItem.getStyle().getValue()));
                item.put("desc_l2", barItem.getDescription_L2());
                item.put("desc_l1", barItem.getDescription_L1());
                item.put("desc_l3", barItem.getDescription_L3());
                item.put("tooltip_l2", barItem.getToolTip_L1());
                item.put("tooltip_l1", barItem.getToolTip_L2());
                item.put("tooltip_l3", barItem.getToolTip_L3());
                item.put("imagekey", barItem.getImageKey());
                item.put("shortcut", barItem.getShortcut());
                item.put("enabled", new Integer(barItem.getEnabled()));
                item.put("visible", new Integer(barItem.getVisible()));
                item.put("checked", new Integer(barItem.getChecked()));
                item.put("elementTypeID", new Integer(barItem.getElementType()));
                item.put("seq", new Integer(barItem.getSeq()));
                item.put("temlpateName", barItem.getTemplateName());
                items.put(barItem.getName(), item);
                ArrayList<String> link = new ArrayList<String>();
                for (BarItem barItem1 : barItem.getChildren()) {
                    link.add(barItem1.getName());
                }
                links.put(barItem.getName(), link);
                linkTemplate.add(barItem.getName());
            }
            templateLinks.put(categoryItem.getName(), linkTemplate);
        }
        HashMap<String, HashMap<String, Cloneable>> param = new HashMap<String, HashMap<String, Cloneable>>();
        param.put("subCategoryItems", subCategoryItems);
        param.put("items", items);
        param.put("links", links);
        param.put("templateLinks", templateLinks);
        FormFactory.insertBarTemplate2Db(param, ctx);
    }

    public static BarTemplateManager createBarTemplateManager(Map barData, List barKeysCache) {
        BarTemplateManager template = new BarTemplateManager(barKeysCache);
        HashMap<String, String> id2name_SubCategory = new HashMap<String, String>();
        ResultSet SubCategories = (ResultSet)barData.get("SubCategories");
        ResultSet items = (ResultSet)barData.get("items");
        ResultSet links = (ResultSet)barData.get("links");
        try {
            while (SubCategories.next()) {
                String id = SubCategories.getString("FID");
                String name = SubCategories.getString("FName");
                template.addSubCategory(name, SubCategories.getString("FCaption_l2"), SubCategories.getString("FCaption_l1"), SubCategories.getString("FCaption_l3"), SubCategories.getString("FDescription_l2"), SubCategories.getString("FDescription_l1"), SubCategories.getString("FDescription_l3"), SubCategories.getInt("FElementTypeID"), SubCategories.getInt("FSeq"));
                id2name_SubCategory.put(id, name);
            }
            while (links.next()) {
                String parentID = links.getString("FParentID");
                String barItemID = links.getString("FBarItemID");
                String barItemName = (String)id2name_SubCategory.get(barItemID);
                String parentName = (String)id2name_SubCategory.get(parentID);
                template.addSubCategoryLink(parentName, barItemName);
            }
            Map mapping = template.getMapping_TemplateID_BarDataManager();
            for (Map.Entry entry : mapping.entrySet()) {
                String templateName = (String)entry.getKey();
                BarDataManager manager = (BarDataManager)entry.getValue();
                HashMap<String, String> id2name = new HashMap<String, String>();
                items.beforeFirst();
                while (items.next()) {
                    String id = items.getString("FID");
                    String name = items.getString("FName");
                    if (templateName == null || !templateName.equalsIgnoreCase(items.getString("FTemplateName"))) continue;
                    manager.addBarItem(name, items.getString("FCaption_l2"), items.getString("FCaption_l1"), items.getString("FCaption_l3"), items.getString("FDescription_l2"), items.getString("FDescription_l1"), items.getString("FDescription_l3"), items.getString("FTooltip_l2"), items.getString("FTooltip_l1"), items.getString("FTooltip_l3"), EnumBarItemStyle.getEnum(items.getInt("FStyle")), items.getString("FImagekey"), items.getString("FShortcut"), items.getBoolean("FEnabled"), items.getBoolean("FVisible"), items.getBoolean("FChecked"), false, items.getInt("FElementTypeID"), items.getInt("FSeq"));
                    id2name.put(id, name);
                }
                if (id2name.size() <= 0) continue;
                links.beforeFirst();
                while (links.next()) {
                    String parentID = links.getString("FParentID");
                    String barItemID = links.getString("FBarItemID");
                    String barItemName = (String)id2name.get(barItemID);
                    String parentName = (String)id2name.get(parentID);
                    manager.addBarItemLink(parentName, barItemName);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return template;
    }

    public static BarDataManager createBarDataManager(Map barData, List barKeysCache) {
        BarDataManager barDataMgr = new BarDataManager(barKeysCache);
        HashMap<String, String> id2name = new HashMap<String, String>();
        ResultSet items = (ResultSet)barData.get("items");
        ResultSet links = (ResultSet)barData.get("links");
        try {
            while (items.next()) {
                String id = items.getString("FID");
                String name = items.getString("FName");
                barDataMgr.addBarItem(name, items.getString("FCaption_l2"), items.getString("FCaption_l1"), items.getString("FCaption_l3"), items.getString("FDescription_l2"), items.getString("FDescription_l1"), items.getString("FDescription_l3"), items.getString("FTooltip_l2"), items.getString("FTooltip_l1"), items.getString("FTooltip_l3"), EnumBarItemStyle.getEnum(items.getInt("FStyle")), items.getString("FImagekey"), items.getString("FShortcut"), items.getBoolean("FEnabled"), items.getBoolean("FVisible"), items.getBoolean("FChecked"), false, items.getInt("FElementTypeID"), items.getInt("FSeq"));
                id2name.put(id, name);
            }
            while (links.next()) {
                String parentID = links.getString("FParentID");
                String barItemID = links.getString("FBarItemID");
                String barItemName = (String)id2name.get(barItemID);
                String parentName = (String)id2name.get(parentID);
                barDataMgr.addBarItemLink(parentName, barItemName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return barDataMgr;
    }
}

