/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.fme.dao.FMEDaoFactory;
import com.kingdee.eas.base.fme.dao.IFMEDao;
import com.kingdee.eas.base.form.core.IFormServer;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.core.app.AbstractFormObject;
import com.kingdee.eas.base.form.core.app.BarUtils;
import com.kingdee.eas.base.form.core.app.CpF7Util;
import com.kingdee.eas.base.form.core.app.FormDBUtils;
import com.kingdee.eas.base.form.core.app.TrdCtrlDBUtils;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.BaseTableInfo;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.Element;
import com.kingdee.eas.base.form.metadata.ElementProperty;
import com.kingdee.eas.base.form.metadata.ElementType;
import com.kingdee.eas.base.form.metadata.ElementTypes;
import com.kingdee.eas.base.form.metadata.EnumInfo;
import com.kingdee.eas.base.form.metadata.EnumItem;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.ExtProperty;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.TabControlAppearance;
import com.kingdee.eas.base.form.metadata.TabPageAppearance;
import com.kingdee.eas.base.form.metadata.TrdCtrlConstants;
import com.kingdee.eas.base.form.metadata.layout.AbstractLayout;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.Style;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarTemplateManager;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultFormServer
extends AbstractFormObject
implements IFormServer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.core.app.DefaultFormServer");

    public DefaultFormServer(Context ctx) {
        super(ctx);
    }

    public DefaultFormServer() {
    }

    @Override
    public ResultSet getElementType() throws BOSException {
        return FormDBUtils.getElementType(this.getContext());
    }

    @Override
    public ResultSet getCondition() throws BOSException {
        return FormDBUtils.getCondition(this.getContext());
    }

    @Override
    public ResultSet getFormList(int elementTypeID) throws BOSException {
        return FormDBUtils.getFormListByElementTypeID(elementTypeID, this.getContext());
    }

    @Override
    public IObjectValue getBillObjectValue(String bosId) throws BOSException {
        return Utils.getObjectValue((Context)this.getContext(), (BOSUuid)BOSUuid.read((String)bosId));
    }

    @Override
    public void updateBillObjectValue(String bosId, IObjectValue obj) throws BOSException {
        Utils.updateObjectValue((Context)this.getContext(), (BOSUuid)BOSUuid.read((String)bosId), (IObjectValue)obj);
    }

    @Override
    public FormMetaData getFormMetaData(String formId, IRowSet formRs) throws BOSException {
        Context ctx = this.getContext();
        IRowSet rs = formRs != null ? formRs : FormDBUtils.getFormType(formId, ctx);
        int elementTypeID = 0;
        ElementTypes types = null;
        try {
            rs.beforeFirst();
            if (rs.next()) {
                elementTypeID = rs.getInt("felementtypeid");
                elementTypeID = elementTypeID < 0 ? -elementTypeID : elementTypeID;
            }
            rs.beforeFirst();
            types = MetaDataFactory.getElementTypesByElement(ctx, elementTypeID);
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return this.getFormMetaData((ResultSet)rs, types);
    }

    @Override
    public FormMetaData getFormMetaData(BOSObjectType bosType) throws BOSException {
        Context ctx = this.getContext();
        ResultSet rs = FormDBUtils.getFormType(bosType, ctx);
        int elementTypeID = 0;
        String sql = " select felementtypeid from T_BAS_Form WHERE fbostype = ? ";
        ElementTypes types = null;
        try {
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bosType.toString()});
            if (rs1.next()) {
                elementTypeID = rs1.getInt("felementtypeid");
                elementTypeID = elementTypeID < 0 ? -elementTypeID : elementTypeID;
            }
            types = MetaDataFactory.getElementTypesByElement(ctx, elementTypeID);
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return this.getFormMetaData(rs, types);
    }

    @Override
    public FormMetaData getFormMetaData(String formID) throws BOSException {
        Context ctx = this.getContext();
        ResultSet rs = FormDBUtils.getFormType(formID, ctx);
        int elementTypeID = 0;
        String sql = " select felementtypeid from T_BAS_Form WHERE fid = ? ";
        ElementTypes types = null;
        try {
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{formID});
            if (rs1.next()) {
                elementTypeID = rs1.getInt("felementtypeid");
                elementTypeID = elementTypeID < 0 ? -elementTypeID : elementTypeID;
            }
            types = MetaDataFactory.getElementTypesByElement(ctx, elementTypeID);
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return this.getFormMetaData(rs, types);
    }

    @Override
    public FormMetaData getFormMetaData(ElementTypes types, String formID) throws BOSException {
        ResultSet rs = FormDBUtils.getFormType(formID, this.getContext());
        return this.getFormMetaData(rs, types);
    }

    private FormMetaData getFormMetaData(ResultSet rs, ElementTypes types) throws BOSException {
        FormMetaData billMetaData = new FormMetaData();
        BusinessInfo businessInfo = billMetaData.getBusinessInfo();
        String formID = "";
        try {
            ElementType elementType;
            EnumObject enumObj;
            if (rs.next()) {
                formID = rs.getString("FID");
                ElementType elementType2 = types.getElementType(rs.getInt("FElementTypeID"));
                Element bill = elementType2.createElement("_Bill");
                this.setBusinessValue(bill, elementType2, rs);
                businessInfo.add(bill);
            }
            if (formID == null) {
                return null;
            }
            String lang = ResourceUtil.getLanguage(this.getContext());
            String formName = lang.equals("L2") ? businessInfo.getForm().getName_L2() : (lang.equals("L3") ? businessInfo.getForm().getName_L3() : businessInfo.getForm().getName_L1());
            businessInfo.getForm().setName(formName);
            billMetaData.setFormId(formID);
            businessInfo.setLookUpObjects(FormDBUtils.getLookUpObjects(formID, this.getContext()));
            EnumInfo enumInfo = businessInfo.getEnumInfo();
            rs = FormDBUtils.getFormEnum(formID, this.getContext());
            while (rs.next()) {
                enumObj = new EnumObject(rs.getString("FID"));
                enumObj.setEnumClassName(rs.getString("FEnumClassName"));
                enumInfo.add(enumObj);
            }
            rs = FormDBUtils.getFormEnumItem(formID, this.getContext());
            while (rs.next()) {
                enumObj = enumInfo.get(rs.getString("FEnumID"));
                EnumItem item = new EnumItem();
                item.setValue(rs.getInt("FValue"));
                item.setDisplayValueValue(rs.getString("FDisplay_L2"));
                enumObj.addItem(item);
            }
            HashMap sqlComboLists = businessInfo.getSqlComboLists();
            rs = FormDBUtils.getFormSqlComboList(formID, this.getContext());
            while (rs.next()) {
                String key = rs.getString("FID");
                String sqlString = rs.getString("FSqlString");
                List list = this.getComboListBySql(sqlString);
                sqlComboLists.put(key, list);
            }
            rs = FormDBUtils.getFormEntity(formID, this.getContext());
            while (rs.next()) {
                elementType = types.getElementType(rs.getInt("FElementTypeID"));
                Element billEntry = elementType.createElement(rs.getString("FKey"));
                this.setBusinessValue(billEntry, elementType, rs);
                businessInfo.add(billEntry);
            }
            rs = FormDBUtils.getFormEntityFields(formID, this.getContext());
            while (rs.next()) {
                elementType = types.getElementType(rs.getInt("FElementTypeID"));
                Element field = elementType.createElement(rs.getString("FKey"));
                this.setBusinessValue(field, elementType, rs);
                if (elementType.getId() == 31 || elementType.getId() == 30) {
                    businessInfo.addAssistDataType(((Field)field).getLink());
                }
                businessInfo.add(field);
            }
            List barKeysCache = billMetaData.getBarKeysCache();
            Map barData = this.getBarData(formID, BarUtils.MENU_LIST);
            billMetaData.setBarDataManager(BarUtils.createBarDataManager(barData, barKeysCache));
            Map barData_template = this.getBarData_Template(BarUtils.MENU_LIST);
            billMetaData.setBarTemplateManager(BarUtils.createBarTemplateManager(barData_template, barKeysCache));
            this.createActionList_ForBarTemplate(billMetaData.getBarTemplateManager());
            this.createLayouts(types, billMetaData, formID);
            this.createContainerLayout(billMetaData, formID);
            this.createOperation(businessInfo.getForm());
            this.createActionList(billMetaData, businessInfo, formID);
            this.createPlugins(businessInfo.getForm());
            this.createExtPropertys(billMetaData, formID);
            this.createEventParams(businessInfo.getForm());
            this.createCondition(businessInfo.getForm());
            this.createBaseTableInfo(businessInfo.getForm());
            businessInfo.setConditionSelectors();
            this.setDatabaseSelector(billMetaData);
            this.setF7FieldStore(billMetaData);
            Map baseReferTables = FormDBUtils.getBaseReferTables(this.getContext(), formID);
            billMetaData.getBusinessInfo().setBaseReferTables((HashMap)baseReferTables);
            this.setTrdCtrlParams(businessInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException("\u521b\u5efa\u5355\u636e\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return billMetaData;
    }

    private void createBaseTableInfo(Form form) throws BOSException {
        Context ctx = this.getContext();
        String formId = form.getId();
        IRowSet rs = FormDBUtils.getBaseTableInfo(formId, ctx);
        try {
            ArrayList<BaseTableInfo> list = new ArrayList<BaseTableInfo>();
            while (rs.next()) {
                String id = rs.getString("FID");
                int lookupId = rs.getInt("FLookUpClassId");
                String tableName = rs.getString("FTableName");
                String fieldName = rs.getString("FFieldName");
                String srcTableName = rs.getString("FSrcTableName");
                String srcFieldName = rs.getString("FSrcFieldName");
                String dspTableName = rs.getString("FTableNameAs");
                String dspFieldName = rs.getString("FDspFieldName");
                String fieldKey = rs.getString("FFieldKey");
                BaseTableInfo info = new BaseTableInfo();
                info.setId(id);
                info.setFormId(formId);
                info.setLookUpId(lookupId);
                info.setFieldKey(fieldKey);
                info.setTableName(tableName);
                info.setFieldName(fieldName);
                info.setSrcTableName(srcTableName);
                info.setSrcFieldName(srcFieldName);
                info.setDspTableName(dspTableName);
                info.setDspFieldName(dspFieldName);
                list.add(info);
            }
            form.setBaseTableList(list);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void setF7FieldStore(FormMetaData billMetaData) {
        Context ctx = this.getContext();
        LayoutInfo layoutInfo = billMetaData.getLayoutInfo();
        List fieldApps = layoutInfo.getFieldAppearances();
        for (FieldAppearance fieldApp : fieldApps) {
            Field field = billMetaData.getBusinessInfo().getField(fieldApp.getKey());
            if (field == null || field.getElementType() != 13 && field.getElementType() != 10012 && field.getElementType() != 24) continue;
            String f7Store = CpF7Util.setF7Store(ctx, billMetaData.getBusinessInfo(), fieldApp);
            field.setF7Store(f7Store);
        }
    }

    private void setTrdCtrlParams(BusinessInfo businessInfo) {
        businessInfo.getTrdCtrlParams().put(TrdCtrlConstants._OFFICE_TYPE_KEY, TrdCtrlDBUtils.getOfficeType(this.getContext()));
    }

    private void setDatabaseSelector(FormMetaData billMetaData) {
        LayoutInfo layoutInfo = billMetaData.getLayoutInfo();
        List fieldApps = layoutInfo.getFieldAppearances();
        for (FieldAppearance fieldApp : fieldApps) {
            this.addFormatSelector(billMetaData.getBusinessInfo(), fieldApp.getKey(), fieldApp.getDisplayPropertyName());
            this.addFormatSelector(billMetaData.getBusinessInfo(), fieldApp.getKey(), fieldApp.getEditPropertyName());
        }
    }

    private void addFormatSelector(BusinessInfo businessInfo, String key, String format) {
        if (StringUtils.isEmpty((String)format) || format.equals("name") || format.equals("number")) {
            return;
        }
        Field field = businessInfo.getField(key);
        if (field == null) {
            return;
        }
        businessInfo.addSelector(field, format);
    }

    private void createPlugins(Form form) throws BOSException, SQLException {
        List[] plugins = FormDBUtils.getFormPlugins(form.getId(), this.getContext());
        form.setPlugins(plugins);
    }

    private void createEventParams(Form form) throws BOSException, SQLException {
        form.setEventParams(FormDBUtils.getFormEventParams(form.getId(), this.getContext()));
    }

    private void createOperation(Form form) throws BOSException, SQLException {
        String language = ResourceUtil.getLanguage(this.getContext());
        String name = "FName_" + language;
        IRowSet rs = FormDBUtils.getFormOperation(form.getId(), this.getContext(), name);
        ArrayList<FormOperation> opertionList = new ArrayList<FormOperation>();
        while (rs.next()) {
            FormOperation operation = new FormOperation(rs.getInt("FOperationID"), rs.getString(name), rs.getString("FOperation"), rs.getString("FPermissionItem"), rs.getString("FStateField"), rs.getString("FPreStateValue"), rs.getString("FSuccessSateValue"), rs.getString("FFailedSateValue"), rs.getBoolean("FIsConfirm"), rs.getString("FResource"), rs.getString("FEnabledState"));
            operation.setOperEleIds(rs.getString("FOperEleIds"));
            operation.setCheckWfState(rs.getInt("FCheckWfState"));
            operation.setTopSysID(rs.getString("FTopSysID"));
            operation.setSubSysID(rs.getString("FSubSysID"));
            operation.setRunClassName(rs.getString("FRunClassName"));
            operation.setType(rs.getInt("FType"));
            form.addOperation(operation);
            opertionList.add(operation);
        }
        form.setFormOperations(opertionList);
    }

    private void createCondition(Form form) throws BOSException, SQLException {
        form.setConditions(FormDBUtils.getFormConditions(form.getId(), this.getContext()));
    }

    private void createLayouts(ElementTypes types, FormMetaData billMetaData, String formID) throws BOSException, SQLException {
        ElementType elementType;
        LayoutInfo layout;
        String layoutID;
        ResultSet rs = FormDBUtils.getFormLayout(formID, this.getContext());
        ResultSet rsEntity = FormDBUtils.getFormEntityLayout(formID, this.getContext());
        ResultSet rsField = FormDBUtils.getFormEntityFieldsLayout(formID, this.getContext());
        ResultSet rsControl = FormDBUtils.getFormEntityControlsLayout(formID, this.getContext());
        ResultSet rsTabPage = FormDBUtils.getFormLayoutTabPage(formID, this.getContext());
        while (rs.next()) {
            LayoutInfo layout2 = new LayoutInfo(rs.getString("FLayoutKey"), rs.getString("FID").trim());
            ElementType elementType2 = types.getElementType(rs.getInt("FElementTypeID"));
            Appearance billFrame = elementType2.createAppearance("_Bill");
            this.setAppearenceValue(billFrame, elementType2, rs);
            layout2.setFormId(formID);
            layout2.setCaption(billFrame.getCaption());
            layout2.setListCaption(rs.getString("FListCaption_" + this.getContext().getLocale()));
            layout2.add(billFrame);
            billMetaData.addLayoutInfo(layout2);
        }
        while (rsEntity.next()) {
            layoutID = rsEntity.getString("FLayoutID").trim();
            layout = billMetaData.getLayoutInfobyID(layoutID);
            if (layout == null) continue;
            ElementType elementType3 = types.getElementType(rsEntity.getInt("FElementTypeID"));
            Appearance billEntityCtl = elementType3.createAppearance(rsEntity.getString("FKey"));
            this.setAppearenceValue(billEntityCtl, elementType3, rsEntity);
            layout.add(billEntityCtl);
        }
        while (rsControl.next()) {
            layoutID = rsControl.getString("FLayoutID").trim();
            layout = billMetaData.getLayoutInfobyID(layoutID);
            if (layout == null) continue;
            int elementTypeID = rsControl.getInt("FElementTypeID");
            elementTypeID = elementTypeID < 0 ? -elementTypeID : elementTypeID;
            elementType = types.getElementType(elementTypeID);
            Appearance ctl = elementType.createAppearance(rsControl.getString("FKey"), layout);
            this.setAppearenceValue(ctl, elementType, rsControl);
            layout.add(ctl);
        }
        while (rsTabPage.next()) {
            TabControlAppearance tabAp;
            layoutID = rsTabPage.getString("FLayoutID").trim();
            layout = billMetaData.getLayoutInfobyID(layoutID);
            if (layout == null || (tabAp = (TabControlAppearance)layout.getAppearance(rsTabPage.getString("FContainer"))) == null) continue;
            elementType = types.getElementType(rsTabPage.getInt("FElementTypeID"));
            TabPageAppearance tabPage = (TabPageAppearance)elementType.createAppearance(rsTabPage.getString("FKey"));
            this.setAppearenceValue(tabPage, elementType, rsTabPage);
            tabAp.add(tabPage);
            layout.add(tabPage);
        }
        while (rsField.next()) {
            layoutID = rsField.getString("FLayoutID").trim();
            layout = billMetaData.getLayoutInfobyID(layoutID);
            if (layout == null) continue;
            ElementType elementType4 = types.getElementType(rsField.getInt("FElementTypeID"));
            String entityKey = rsField.getString("FEntityKey");
            Appearance fldCtl = elementType4.createAppearance(rsField.getString("FKey"));
            this.setAppearenceValue(fldCtl, elementType4, rsField);
            layout.add(fldCtl);
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void createContainerLayout(FormMetaData billMetaData, String formID) throws BOSException, SQLException {
        ResultSet rs = FormDBUtils.getFormConatinerLayout(formID, this.getContext());
        AbstractLayout lay = null;
        while (rs.next()) {
            String containerKey = rs.getString("FContainerKey");
            String layoutID = rs.getString("FLayoutID");
            int layoutType = rs.getInt("FLayoutType");
            ControlAppearance el = billMetaData.getLayoutInfobyID(layoutID).getControlAppearance(containerKey);
            if (el == null || layoutType != 1) continue;
            lay = new TableLayout();
            lay.setLayoutType(layoutType);
            PropertyUtil.setPropertyValue(lay, "Cols", rs.getObject("FCols"));
            PropertyUtil.setPropertyValue(lay, "Rows", rs.getObject("FRows"));
            el.setLayout(lay);
        }
        rs = FormDBUtils.getFormTableLayoutStyle(formID, this.getContext());
        String oldContainerKey = "";
        String oldStyleType = "";
        String oldLayoutID = "";
        lay = null;
        ArrayList<Style> styles = new ArrayList<Style>();
        while (rs.next()) {
            String containerKey = rs.getString("FContainerKey");
            String layoutID = rs.getString("FLayoutID");
            String styleType = rs.getString("FType");
            if (!(oldContainerKey.equalsIgnoreCase(containerKey) && oldStyleType.equalsIgnoreCase(styleType) && oldLayoutID.equalsIgnoreCase(layoutID))) {
                if (lay != null) {
                    PropertyUtil.setPropertyValue(lay, oldStyleType, styles);
                }
                if (!oldContainerKey.equalsIgnoreCase(containerKey)) {
                    ControlAppearance el = billMetaData.getLayoutInfobyID(layoutID).getControlAppearance(containerKey);
                    lay = el.getLayout();
                }
                styles = new ArrayList();
            }
            styles.add(new Style(rs.getInt("FOut")));
            oldContainerKey = containerKey;
            oldStyleType = styleType;
            oldLayoutID = layoutID;
        }
        if (lay != null) {
            PropertyUtil.setPropertyValue(lay, oldStyleType, styles);
        }
    }

    private void createExtPropertys(FormMetaData billMetaData, String formID) throws BOSException, SQLException {
        ResultSet rs = FormDBUtils.getFormControlExtPropertys(formID, this.getContext());
        int oldObjectType = 0;
        String oldObjectKey = "";
        String oldLayoutID = "";
        Serializable el = null;
        ArrayList<ExtProperty> extPropList = new ArrayList<ExtProperty>();
        while (rs.next()) {
            int objectType = rs.getInt("FObjectType");
            String objectKey = rs.getString("FObjectKey");
            String layoutID = rs.getString("FLayoutID");
            String propName = rs.getString("FPropertyName");
            String value = rs.getString("FValue") == null ? "" : rs.getString("FValue");
            int valueType = rs.getInt("FValueType");
            if (layoutID == null) {
                layoutID = "";
            }
            if (oldObjectType != objectType || !oldObjectKey.equalsIgnoreCase(objectKey) || !oldLayoutID.equalsIgnoreCase(layoutID)) {
                if (el != null) {
                    PropertyUtil.setPropertyValue(el, "ExtPropertys", extPropList);
                }
                extPropList = new ArrayList();
                if (oldObjectType != objectType || !oldObjectKey.equalsIgnoreCase(objectKey) || !oldLayoutID.equalsIgnoreCase(layoutID)) {
                    switch (objectType) {
                        case 1: 
                        case 2: 
                        case 4: {
                            el = billMetaData.getBusinessInfo().getElement(objectKey);
                            break;
                        }
                        case 3: {
                            el = billMetaData.getLayoutInfobyID(layoutID).getAppearance(objectKey);
                            break;
                        }
                        case 5: {
                            el = billMetaData.getBarDataManager().getBarItem(objectKey);
                            break;
                        }
                        case 6: {
                            el = billMetaData.getBusinessInfo().getForm().getOperation(objectKey);
                        }
                    }
                }
            }
            ExtProperty prop = new ExtProperty(propName, value, valueType);
            extPropList.add(prop);
            oldObjectType = objectType;
            oldObjectKey = objectKey;
            oldLayoutID = layoutID;
        }
        if (el != null) {
            PropertyUtil.setPropertyValue(el, "ExtPropertys", extPropList);
        }
    }

    private void createActionList(FormMetaData billMetaData, BusinessInfo businessInfo, String formID) throws BOSException, SQLException {
        FormOperation operation;
        ArrayList list;
        String opertionkey;
        ResultSet rs = FormDBUtils.getFormActionList(formID, this.getContext());
        ResultSet rs1 = FormDBUtils.getFormActionListEntry(formID, this.getContext());
        HashMap<String, String> cacheMap1 = new HashMap<String, String>();
        HashMap<String, String> cacheMap2 = new HashMap<String, String>();
        while (rs1.next()) {
            String parentId = rs1.getString("FParentID");
            String condition = rs1.getString("FCondition");
            String setting = rs1.getString("FSetting");
            if (cacheMap1.containsKey(parentId)) {
                if (!StringUtils.isEmpty((String)condition)) {
                    cacheMap1.put(parentId, cacheMap1.get(parentId) + condition);
                }
                if (StringUtils.isEmpty((String)setting)) continue;
                cacheMap2.put(parentId, cacheMap2.get(parentId) + setting);
                continue;
            }
            cacheMap1.put(parentId, condition);
            cacheMap2.put(parentId, setting);
        }
        AbstractElement el = null;
        ArrayList<Object[]> allList = new ArrayList<Object[]>();
        HashMap<String, List<Action>> beforeActionMap = new HashMap<String, List<Action>>();
        HashMap<String, List<Action>> afterActionMap = new HashMap<String, List<Action>>();
        while (rs.next()) {
            Object[] objs;
            int objectType = rs.getInt("FObjectType");
            String objectKey = rs.getString("FObjectKey");
            String actionType = rs.getString("FActionType");
            String layoutID = rs.getString("FLayoutID");
            String name = rs.getString("FName");
            String desc = rs.getString("FDesc");
            String setComponent = rs.getString("fsetcomponent");
            String reverseActionClass = rs.getString("FReverseActionClass");
            int seq = rs.getInt("FSeq");
            String param = rs.getString("FParaments");
            String paramExtendData = null;
            if (param != null && param.indexOf("@#@") > 0) {
                String[] pr = param.split("@#@", 2);
                param = pr[0];
                paramExtendData = pr[1];
            }
            int type = rs.getInt("FType");
            if (layoutID == null) {
                layoutID = "";
            }
            switch (objectType) {
                case 2: 
                case 4: {
                    LayoutInfo layout = billMetaData.getLayoutInfobyID(layoutID);
                    if (layout == null) {
                        el = businessInfo.getElement(objectKey);
                        break;
                    }
                    el = layout.getAppearance(objectKey);
                    break;
                }
                case 1: {
                    el = businessInfo.getForm();
                    break;
                }
                case 3: {
                    LayoutInfo layout = billMetaData.getLayoutInfobyID(layoutID);
                    if (layout == null) {
                        el = null;
                        break;
                    }
                    el = layout.getAppearance(objectKey);
                    break;
                }
                case 5: {
                    el = billMetaData.getBarDataManager().getBarItem(objectKey);
                    break;
                }
                case 6: {
                    el = billMetaData.getBusinessInfo().getForm();
                }
            }
            if (el == null) continue;
            Action action = new Action(rs.getInt("FActionID"), rs.getString("FRunComponent"), param, rs.getString("FExpression"), rs.getString("FSetting"));
            action.setName(name);
            action.setDesc(desc);
            action.setSetComponent(setComponent);
            action.setReverseActionClass(reverseActionClass);
            action.setType(type);
            action.setParamExtendData(paramExtendData);
            action.setObjectKey(objectKey);
            action.setSeq(seq);
            action.setActionType(actionType);
            action.setObjectType(objectType);
            String id = rs.getString("id1");
            if (!StringUtils.isEmpty((String)id) && cacheMap1.containsKey(id)) {
                action.setExpression(cacheMap1.get(id).toString());
                action.setSetting(cacheMap2.get(id).toString());
            }
            if (objectType == 6 && actionType != null) {
                List list2 = null;
                if (actionType.equalsIgnoreCase("AfterActions")) {
                    list2 = afterActionMap.containsKey(objectKey) ? (List)afterActionMap.get(objectKey) : new ArrayList();
                    list2.add(action);
                    afterActionMap.put(objectKey, list2);
                } else if (actionType.equalsIgnoreCase("BeforeActions")) {
                    list2 = beforeActionMap.containsKey(objectKey) ? (List)beforeActionMap.get(objectKey) : new ArrayList();
                    list2.add(action);
                    beforeActionMap.put(objectKey, list2);
                }
            }
            if (allList.isEmpty()) {
                ArrayList<Action> actionList = new ArrayList<Action>();
                actionList.add(action);
                Object[] objs2 = new Object[]{el, actionType, actionList};
                allList.add(objs2);
                continue;
            }
            boolean isFind = false;
            for (int i = 0; i < allList.size(); ++i) {
                objs = (Object[])allList.get(i);
                if (!((AbstractElement)objs[0]).getKey().equalsIgnoreCase(el.getKey()) || !objs[1].equals(actionType)) continue;
                ((ArrayList)objs[2]).add(action);
                isFind = true;
            }
            if (isFind) continue;
            ArrayList<Action> actionList = new ArrayList<Action>();
            actionList.add(action);
            objs = new Object[]{el, actionType, actionList};
            allList.add(objs);
        }
        for (int i = 0; i < allList.size(); ++i) {
            Object[] objs = (Object[])allList.get(i);
            List actionList = (List)objs[2];
            Collections.sort(actionList, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Action a0 = (Action)arg0;
                    Action a1 = (Action)arg1;
                    if (a0.getSeq() > a1.getSeq()) {
                        return 1;
                    }
                    if (a0.getSeq() < a1.getSeq()) {
                        return -1;
                    }
                    return 0;
                }
            });
            PropertyUtil.setPropertyValue(objs[0], (String)objs[1], actionList);
        }
        Iterator it = beforeActionMap.keySet().iterator();
        while (it.hasNext()) {
            opertionkey = it.next().toString();
            list = (ArrayList)beforeActionMap.get(opertionkey);
            operation = businessInfo.getForm().getOperation(opertionkey);
            operation.setBeforeActions(list);
        }
        it = afterActionMap.keySet().iterator();
        while (it.hasNext()) {
            opertionkey = it.next().toString();
            list = (ArrayList)afterActionMap.get(opertionkey);
            operation = businessInfo.getForm().getOperation(opertionkey);
            operation.setAfterActions(list);
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((ResultSet)rs1);
    }

    private void createActionList_ForBarTemplate(BarTemplateManager barTemplateManager) throws BOSException, SQLException {
        HashMap<String, BarItem> key2Bar = new HashMap<String, BarItem>();
        Map mapping = barTemplateManager.getMapping_TemplateID_BarDataManager();
        for (Map.Entry entry : mapping.entrySet()) {
            BarDataManager manager = (BarDataManager)entry.getValue();
            Map barItems = manager.getAllBarItems();
            for (Map.Entry entry2 : barItems.entrySet()) {
                BarItem barItem = (BarItem)entry2.getValue();
                key2Bar.put(barItem.getName(), barItem);
            }
        }
        ResultSet rs = FormDBUtils.getFormActionList("99999999-9999-9999-9999-999999999999WWF7XXF4", this.getContext());
        BarItem item = null;
        ArrayList<Object[]> allList = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] objs;
            int objectType = rs.getInt("FObjectType");
            String objectKey = rs.getString("FObjectKey");
            String actionType = rs.getString("FActionType");
            String layoutID = rs.getString("FLayoutID");
            String name = rs.getString("FName");
            String desc = rs.getString("FDesc");
            String setComponent = rs.getString("fsetcomponent");
            String reverseActionClass = rs.getString("FReverseActionClass");
            int seq = rs.getInt("FSeq");
            String param = rs.getString("FParaments");
            String paramExtendData = null;
            if (param != null && param.indexOf("@#@") > 0) {
                String[] pr = param.split("@#@", 2);
                param = pr[0];
                paramExtendData = pr[1];
            }
            int type = rs.getInt("FType");
            if (layoutID == null) {
                layoutID = "";
            }
            if (objectType != 5 || (item = (BarItem)key2Bar.get(objectKey)) == null) continue;
            Action action = new Action(rs.getInt("FActionID"), rs.getString("FRunComponent"), param, rs.getString("FExpression"), rs.getString("FSetting"));
            action.setName(name);
            action.setDesc(desc);
            action.setSetComponent(setComponent);
            action.setReverseActionClass(reverseActionClass);
            action.setType(type);
            action.setParamExtendData(paramExtendData);
            action.setObjectKey(objectKey);
            action.setSeq(seq);
            action.setActionType(actionType);
            action.setObjectType(objectType);
            if (allList.isEmpty()) {
                ArrayList<Action> actionList = new ArrayList<Action>();
                actionList.add(action);
                Object[] objs2 = new Object[]{item, actionType, actionList};
                allList.add(objs2);
                continue;
            }
            boolean isFind = false;
            for (int i = 0; i < allList.size(); ++i) {
                objs = (Object[])allList.get(i);
                if (!((AbstractElement)objs[0]).getKey().equalsIgnoreCase(item.getKey()) || !objs[1].equals(actionType)) continue;
                ((ArrayList)objs[2]).add(action);
                isFind = true;
            }
            if (isFind) continue;
            ArrayList<Action> actionList = new ArrayList<Action>();
            actionList.add(action);
            objs = new Object[]{item, actionType, actionList};
            allList.add(objs);
        }
        for (int i = 0; i < allList.size(); ++i) {
            Object[] objs = (Object[])allList.get(i);
            List actionList = (List)objs[2];
            Collections.sort(actionList, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Action a0 = (Action)arg0;
                    Action a1 = (Action)arg1;
                    if (a0.getSeq() > a1.getSeq()) {
                        return 1;
                    }
                    if (a0.getSeq() < a1.getSeq()) {
                        return -1;
                    }
                    return 0;
                }
            });
            PropertyUtil.setPropertyValue(objs[0], (String)objs[1], actionList);
        }
    }

    private void setBusinessValue(Element ba, ElementType elementType, ResultSet rs) throws SQLException, BOSException {
        ba.setId(rs.getString("fid"));
        ba.setElementType(elementType.getId());
        List elementProps = elementType.getBusinessPropertys();
        this.setElementPropertyValue(ba, elementProps, rs);
        ba.setName(ba.getName(this.getContext().getLocale()));
    }

    private void setAppearenceValue(Appearance ba, ElementType elementType, ResultSet rs) throws SQLException, BOSException {
        List elementProps = elementType.getAppearancePropertys();
        ba.setId(rs.getString("fid"));
        ba.setControlType(rs.getInt("FControlTypeID"));
        ba.setCaption(rs.getString("FCaption_" + this.getContext().getLocale()));
        ba.setElementType(elementType.getId());
        this.setElementPropertyValue(ba, elementProps, rs);
    }

    private void setElementPropertyValue(Object elementObj, List elementProps, ResultSet rs) throws SQLException, BOSException {
        for (ElementProperty elementProp : elementProps) {
            Object value;
            String sField = elementProp.getFieldName();
            if (!this.hasField(rs.getMetaData(), sField) || (value = rs.getObject(sField)) == null) continue;
            PropertyUtil.setPropertyValue(elementObj, elementProp.getPropertyName(), value);
        }
    }

    private boolean hasField(ResultSetMetaData meta, String name) throws SQLException {
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            if (!meta.getColumnName(i).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map getBarData(String formID, Integer menuType) throws BOSException {
        return BarUtils.getBarData(formID, menuType, this.getContext());
    }

    public Map getBarData_Template(Integer menuType) throws BOSException {
        return BarUtils.getBarData_Template(menuType, this.getContext());
    }

    @Override
    public void insertBarItem(Map param) throws BOSException {
        BarUtils.insertBarItem(param, this.getContext());
    }

    @Override
    public void insertBarTemplate(Map param) throws BOSException {
        BarUtils.insertBarTemplate(param, this.getContext());
    }

    @Override
    public ResultSet getAssistantData(String dataType) throws BOSException {
        return FormDBUtils.getAssistantData(dataType, this.getContext());
    }

    @Override
    public ResultSet getAssistantData(String dataType, String cu, String longNumber) throws BOSException {
        return FormDBUtils.getAssistantData(dataType, cu, longNumber, this.getContext());
    }

    @Override
    public String getAssistantDataVersion(String dataType, String cu) throws BOSException {
        return FormDBUtils.getAssistantDataVersion(dataType, cu, this.getContext());
    }

    @Override
    public String getAssistantDataDesc(String id) throws BOSException {
        return FormDBUtils.getAssistantDataDesc(id, this.getContext());
    }

    @Override
    public Map getDataForDeploySetting(Map param) throws BOSException {
        HashMap result = new HashMap();
        Assert.that((boolean)param.containsKey("DeployRange"));
        int DeployRange = Integer.valueOf((String)param.get("DeployRange"));
        StringBuffer sb = new StringBuffer();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        ArrayList<Form> FormList = new ArrayList<Form>();
        sb.append(" select fid , fname_").append(locale).append(" from T_BAS_Form ");
        switch (DeployRange) {
            case 1: {
                sb.append(" where FCustom = 1 ");
                break;
            }
            case 2: {
                sb.append(" where FCustom = 0 ");
                break;
            }
        }
        sb.append(" order by fname_").append(locale);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String id = rs.getString(1);
                String name = rs.getString(2);
                Form form = new Form(id);
                form.setName(name);
                FormList.add(form);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        result.put("FormList", FormList);
        return result;
    }

    @Override
    public Map getDataForDeployPackage(Map param) throws BOSException {
        HashMap result = new HashMap();
        Assert.that((boolean)param.containsKey("CheckedObjects"));
        Assert.that((boolean)param.containsKey("IsDeployMeta"));
        Assert.that((boolean)param.containsKey("MetaFileName"));
        Assert.that((boolean)param.containsKey("IsDeployFile"));
        boolean isDeployMeta = Boolean.valueOf((String)param.get("IsDeployMeta"));
        if (isDeployMeta) {
            HashMap metaDatas = new HashMap();
            Map checkedObjects = (Map)param.get("CheckedObjects");
            Assert.that((boolean)checkedObjects.containsKey("FormList"));
            HashMap<Form, FormMetaData> formMetaDatas = new HashMap<Form, FormMetaData>();
            List formList = (List)checkedObjects.get("FormList");
            for (int i = 0; i < formList.size(); ++i) {
                Form form = (Form)formList.get(i);
                FormMetaData formMeta = this.getFormMetaData(form.getKey().toString());
                formMetaDatas.put(form, formMeta);
            }
            metaDatas.put("FormMetaDataList", formMetaDatas);
            result.put("MetaDatas", metaDatas);
        }
        return result;
    }

    @Override
    public EnumObject getEnumObject(int enumId) throws BOSException {
        EnumObject enumObj = null;
        String sql = " SELECT * FROM T_BAS_FormEnum where FID = ? ";
        String sql1 = " SELECT * FROM T_BAS_FormEnumItem where FEnumID = ? ";
        Context ctx = this.getContext();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(enumId)});
        try {
            if (rs.next()) {
                enumObj = new EnumObject(rs.getString("FID"));
                enumObj.setEnumClassName(rs.getString("FEnumClassName"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{new Integer(enumId)});
        try {
            while (rs.next()) {
                EnumItem item = new EnumItem();
                item.setValue(rs.getInt("FValue"));
                item.setDisplayValueValue(rs.getString("FDisplay_" + ctx.getLocale()));
                enumObj.addItem(item);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return enumObj;
    }

    @Override
    public List getFtpServerList() throws BOSException {
        List ftpServerList = null;
        try {
            Context ctx = this.getContext();
            IFMEDao fmeDao = FMEDaoFactory.getFMEDaoInstance((Context)ctx);
            ftpServerList = fmeDao.querySavePath();
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6FTP\u670d\u52a1\u5668\u5217\u8868\u5f02\u5e38", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ftpServerList;
    }

    public List getComboListBySql(String sql) throws BOSException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (StringUtil.isEmpty((String)sql)) {
            return list;
        }
        try {
            Context ctx = this.getContext();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String[] item = new String[]{rs.getString(1), rs.getString(2)};
                list.add(item);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6SQL\u4e0b\u62c9\u5217\u8868\u5f02\u5e38", (Throwable)e);
            list.add("SQL\u9519\u8bef");
            throw new BOSException((Throwable)e);
        }
        return list;
    }
}

