/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.core.BasImgHelper;
import com.kingdee.eas.base.form.core.FormCoreException;
import com.kingdee.eas.base.form.core.IMetaData;
import com.kingdee.eas.base.form.core.MetaDataHelper;
import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.core.app.BarUtils;
import com.kingdee.eas.base.form.core.app.FormObjectTransFactory;
import com.kingdee.eas.base.form.core.app.SqlParameter;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.BaseTableInfo;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.CtrlType;
import com.kingdee.eas.base.form.metadata.Element;
import com.kingdee.eas.base.form.metadata.ElementGroup;
import com.kingdee.eas.base.form.metadata.ElementProperty;
import com.kingdee.eas.base.form.metadata.ElementType;
import com.kingdee.eas.base.form.metadata.ElementTypes;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.EnumItem;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.ExtProperty;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FlowDirInfo;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.FormCondition;
import com.kingdee.eas.base.form.metadata.FormConditionEntry;
import com.kingdee.eas.base.form.metadata.FormFunction;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.metadata.TabControlAppearance;
import com.kingdee.eas.base.form.metadata.TabPageAppearance;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.Style;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarTemplateManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DefaultMetaDataServer
extends AbstractBOSObject
implements IMetaData {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.core.app.DefaultMetaDataServer");

    public DefaultMetaDataServer(Context ctx) {
        super(ctx);
    }

    public DefaultMetaDataServer() {
    }

    @Override
    public List getElementGroup() throws BOSException {
        ArrayList<ElementGroup> result = new ArrayList<ElementGroup>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid , fname_" + locale + " from T_BAS_ElementGroup";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                int id = rs.getInt(1);
                String name = rs.getString(2);
                result.add(new ElementGroup(id, name));
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public ElementGroup getElementGroup(int id) throws BOSException {
        ElementGroup group = null;
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid , fname_" + locale + " from T_BAS_ElementGroup where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(id)});
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(id)});
        try {
            if (rs.next()) {
                id = rs.getInt("fid");
                String name = rs.getString("fname_" + locale);
                group = new ElementGroup(id, name);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return group;
    }

    @Override
    public List getElementGroup(List idList) throws BOSException {
        int queryCountPerTime = 10;
        ArrayList<ElementGroup> result = new ArrayList<ElementGroup>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid , fname_" + locale + " from T_BAS_ElementGroup where fid in " + MetaDataHelper.getMarks(10);
        List paramList = MetaDataHelper.createParamArray(idList, 10);
        for (int i = 0; paramList != null && i < paramList.size(); ++i) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])((Object[])paramList.get(i)));
            try {
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String name = rs.getString(2);
                    result.add(new ElementGroup(id, name));
                }
                continue;
            }
            catch (SQLException e) {
                Log.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public List getElementTypeList(int groupId) throws BOSException {
        ArrayList<ElementType> result = new ArrayList<ElementType>();
        Context ctx = this.getContext();
        ArrayList<Integer> elementTypeIdList = new ArrayList<Integer>();
        Locale locale = ctx.getLocale();
        String sql = " select fid , fname_" + locale + ", fseq, fcontrolTypeid, fisPhysicsField, fimgKey, ftypeid, FIsVisible,FElementClass,FAppearanceClass  from T_BAS_ElementType where FElementGroupId = ? order by fseq";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(groupId)});
        try {
            while (rs.next()) {
                int id = rs.getInt("fid");
                String name = rs.getString("fname_" + locale);
                int seq = rs.getInt("fseq");
                int controlTypeId = rs.getInt("fcontrolTypeid");
                ElementGroup group = new ElementGroup();
                group.setId(groupId);
                CtrlType ctrl = new CtrlType();
                ctrl.setId(controlTypeId);
                boolean isPhysicsField = rs.getBoolean("fisPhysicsField");
                String imgKey = rs.getString("fimgKey");
                int type = rs.getInt("ftypeid");
                boolean isVisible = rs.getBoolean("FIsVisible");
                ElementType elementType = new ElementType(id, name, seq, group, ctrl, isPhysicsField, imgKey, type);
                elementType.setVisible(isVisible);
                elementType.setElementClass(rs.getString("FElementClass"));
                elementType.setAppearanceClass(rs.getString("FAppearanceClass"));
                result.add(elementType);
                elementTypeIdList.add(new Integer(id));
            }
            Map propertymap = this.getElementPropertys(elementTypeIdList);
            for (int i = 0; i < result.size(); ++i) {
                ElementType elementType = (ElementType)result.get(i);
                elementType.setElementPropertyArray((List)propertymap.get(new Integer(elementType.getId())));
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getForms(int elementTypeId) throws BOSException {
        ArrayList<FormAppearance> result = new ArrayList<FormAppearance>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid , fname_" + locale + " from T_BAS_Form where FElementTypeId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(elementTypeId)});
        try {
            while (rs.next()) {
                String id = rs.getString(1);
                String name = rs.getString(2);
                FormAppearance form = new FormAppearance(id);
                form.setId(id);
                form.setCaption(name);
                result.add(form);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getElementPropertys(int elementTypeId) throws BOSException {
        elementTypeId = elementTypeId < 0 ? -elementTypeId : elementTypeId;
        ArrayList<ElementProperty> result = new ArrayList<ElementProperty>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select FID, FElementTypeID, FName_" + locale + ", FDescription_" + locale + ", \tFSeq, FFieldName, FPropertyName, FDefaultValue,  FValueType, FCtlType, FVisible, FLock , fbindingflags, faction, fpropclass, fafterclass  from T_BAS_ElementProperty where FElementTypeId = ? order by fbindingflags, FSeq";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(elementTypeId)});
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                ElementType type = new ElementType();
                type.setId(elementTypeId);
                String name = rs.getString("fname_" + locale);
                String description = rs.getString("fdescription_" + locale);
                int seq = rs.getInt("fseq");
                String fieldName = rs.getString("ffieldName");
                String propertyName = rs.getString("fpropertyName");
                String defaultValue = rs.getString("fdefaultValue");
                int valueType = rs.getInt("fvalueType");
                int ctrlType = rs.getInt("fctlType");
                int visible = rs.getInt("fvisible");
                int lock = rs.getInt("flock");
                int bindingFlags = rs.getInt("fbindingFlags");
                String action = rs.getString("faction");
                String propClass = rs.getString("fpropclass");
                String afterClass = rs.getString("fafterclass");
                ElementProperty property = new ElementProperty(id, type, name, description, seq, fieldName, propertyName, defaultValue, valueType, ctrlType, visible, lock);
                property.setBindingFlags(bindingFlags);
                property.setAction(action);
                property.setPropClass(propClass);
                property.setAfterClass(afterClass);
                result.add(property);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Map getElementPropertys(List elementTypeIdList) throws BOSException {
        int i;
        HashMap result = new HashMap();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        ArrayList<ElementProperty> tmpPropertyList = new ArrayList<ElementProperty>();
        int queryCountPerTime = 10;
        String sql = " select FID, FElementTypeID, FName_" + locale + ", FDescription_" + locale + ", \tFSeq, FFieldName, FPropertyName, FDefaultValue,  FValueType, FCtlType, FVisible, FLock , fbindingflags, faction , fpropClass, fafterclass  from T_BAS_ElementProperty  where FElementTypeId in " + MetaDataHelper.getMarks(queryCountPerTime) + " order by FElementTypeID, fbindingflags, FSeq";
        List paramList = MetaDataHelper.createParamArray(elementTypeIdList, queryCountPerTime);
        for (i = 0; paramList != null && i < paramList.size(); ++i) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])((Object[])paramList.get(i)));
            try {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    int elementTypeId = rs.getInt("FElementTypeID");
                    ElementType type = new ElementType();
                    type.setId(elementTypeId);
                    String name = rs.getString("fname_" + locale);
                    String description = rs.getString("fdescription_" + locale);
                    int seq = rs.getInt("fseq");
                    String fieldName = rs.getString("ffieldName");
                    String propertyName = rs.getString("fpropertyName");
                    String defaultValue = rs.getString("fdefaultValue");
                    int valueType = rs.getInt("fvalueType");
                    int ctrlType = rs.getInt("fctlType");
                    int visible = rs.getInt("fvisible");
                    int lock = rs.getInt("flock");
                    int bindingFlags = rs.getInt("fbindingFlags");
                    String action = rs.getString("faction");
                    String propClass = rs.getString("fpropClass");
                    String afterClass = rs.getString("fafterclass");
                    ElementProperty property = new ElementProperty(id, type, name, description, seq, fieldName, propertyName, defaultValue, valueType, ctrlType, visible, lock);
                    property.setBindingFlags(bindingFlags);
                    property.setAction(action);
                    property.setPropClass(propClass);
                    property.setAfterClass(afterClass);
                    tmpPropertyList.add(property);
                }
                continue;
            }
            catch (SQLException e) {
                Log.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        for (i = 0; i < tmpPropertyList.size(); ++i) {
            List tmp;
            int elementTypeId = ((ElementProperty)tmpPropertyList.get(i)).getType().getId();
            if (result.containsKey(new Integer(elementTypeId))) {
                tmp = (List)result.get(new Integer(elementTypeId));
                tmp.add(tmpPropertyList.get(i));
                result.put(new Integer(elementTypeId), tmp);
                continue;
            }
            tmp = new ArrayList();
            tmp.add(tmpPropertyList.get(i));
            result.put(new Integer(elementTypeId), tmp);
        }
        return result;
    }

    @Override
    public ElementTypes getElementTypes(int solutionID) throws BOSException {
        ArrayList<Integer> groupIdList = new ArrayList<Integer>();
        switch (solutionID) {
            case 3: {
                groupIdList.add(new Integer(0));
                groupIdList.add(new Integer(1));
                groupIdList.add(new Integer(2));
                groupIdList.add(new Integer(3));
                groupIdList.add(new Integer(4));
                groupIdList.add(new Integer(10));
                break;
            }
            case 4: {
                groupIdList.add(new Integer(0));
                groupIdList.add(new Integer(2));
                groupIdList.add(new Integer(6));
                groupIdList.add(new Integer(8));
                groupIdList.add(new Integer(10));
                break;
            }
            case 5: {
                groupIdList.add(new Integer(0));
                groupIdList.add(new Integer(2));
                groupIdList.add(new Integer(6));
                groupIdList.add(new Integer(7));
                groupIdList.add(new Integer(10));
            }
        }
        ElementTypes types = this.getElementTypes(groupIdList);
        return types;
    }

    @Override
    public ElementTypes getElementTypesByElement(int elementTypeID) throws BOSException {
        Context ctx = this.getContext();
        ArrayList<Integer> groupIdList = new ArrayList<Integer>();
        ArrayList<Integer> elementTypeIdList = new ArrayList<Integer>();
        ArrayList<ElementType> elementTypeList = new ArrayList<ElementType>();
        ElementTypes types = new ElementTypes();
        Locale locale = ctx.getLocale();
        try {
            String sql = " select frefGroupIdS from T_BAS_ElementType where fid = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(elementTypeID)});
            String refGroupIdS = null;
            if (rs.next()) {
                refGroupIdS = rs.getString(1);
            }
            sql = " select fid , fname_" + locale + ", fseq, fcontrolTypeid, fisPhysicsField, fimgKey, ftypeid, felementgroupid, FIsVisible,FElementClass,FAppearanceClass  from T_BAS_ElementType where FElementGroupId in (" + refGroupIdS + ")  order by FElementGroupId, fseq ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                int id = rs.getInt("fid");
                String name = rs.getString("fname_" + locale);
                int seq = rs.getInt("fseq");
                int controlTypeId = rs.getInt("fcontrolTypeid");
                int groupId = rs.getInt("felementgroupid");
                ElementGroup group = new ElementGroup();
                group.setId(groupId);
                if (!groupIdList.contains(new Integer(groupId))) {
                    groupIdList.add(new Integer(groupId));
                }
                CtrlType ctrl = new CtrlType();
                ctrl.setId(controlTypeId);
                boolean isPhysicsField = rs.getBoolean("fisPhysicsField");
                String imgKey = rs.getString("fimgKey");
                int type = rs.getInt("ftypeid");
                boolean isVisible = rs.getBoolean("FIsVisible");
                ElementType elementType = new ElementType(id, name, seq, group, ctrl, isPhysicsField, imgKey, type);
                elementType.setVisible(isVisible);
                elementTypeList.add(elementType);
                elementType.setElementClass(rs.getString("FElementClass"));
                elementType.setAppearanceClass(rs.getString("FAppearanceClass"));
                elementTypeIdList.add(new Integer(id < 0 ? -id : id));
            }
            Map propertymap = this.getElementPropertys(elementTypeIdList);
            for (int i = 0; i < elementTypeList.size(); ++i) {
                ElementType elementType = (ElementType)elementTypeList.get(i);
                elementType.setElementPropertyArray((List)propertymap.get(new Integer(elementType.getId())));
            }
            HashMap elementTypeMap = new HashMap();
            for (int i = 0; i < elementTypeList.size(); ++i) {
                int elementTypeId = ((ElementType)elementTypeList.get(i)).getId();
                elementTypeMap.put(new Integer(elementTypeId), elementTypeList.get(i));
            }
            types.setElementTypeList(elementTypeList);
            types.setElementTypeMap(elementTypeMap);
            types.setGroupIdList(groupIdList);
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return types;
    }

    @Override
    public ElementTypes getElementTypes(List groupIdList) throws BOSException {
        ElementTypes types = new ElementTypes();
        ArrayList elementTypeList = new ArrayList();
        for (int i = 0; i < groupIdList.size(); ++i) {
            int groupId = (Integer)groupIdList.get(i);
            elementTypeList.addAll(this.getElementTypeList(groupId));
        }
        HashMap elementTypeMap = new HashMap();
        for (int i = 0; i < elementTypeList.size(); ++i) {
            int elementTypeId = ((ElementType)elementTypeList.get(i)).getId();
            elementTypeMap.put(new Integer(elementTypeId), elementTypeList.get(i));
        }
        types.setElementTypeList(elementTypeList);
        types.setElementTypeMap(elementTypeMap);
        types.setGroupIdList(groupIdList);
        return types;
    }

    private void checkF7Fields(FormMetaData billMetaData) throws Exception {
        Context ctx = this.getContext();
        LayoutInfo layoutInfo = billMetaData.getLayoutInfo();
        List fieldApps = layoutInfo.getFieldAppearances();
        Iterator iter = fieldApps.iterator();
        LookUpObject lookup = null;
        BusinessInfo businessInfo = billMetaData.getBusinessInfo();
        while (iter.hasNext()) {
            FieldAppearance fieldApp = (FieldAppearance)iter.next();
            Field field = businessInfo.getField(fieldApp.getKey());
            if (field == null || field.getElementType() != 13 && field.getElementType() != 10012 && field.getElementType() != 24) continue;
            String queryInfo = "";
            String filterInfo = "";
            if (field != null) {
                lookup = businessInfo.getLookUpObject(field.getLookUpObjectID());
                if (field.getFilter() != null && !"".equals(field.getFilter().trim())) {
                    filterInfo = field.getFilter();
                }
            }
            if (lookup == null || StringUtils.isEmpty((String)lookup.getQueryInfo())) continue;
            queryInfo = lookup.getQueryInfo();
            try {
                DefaultMetaDataServer.checkF7Filed(ctx, queryInfo, filterInfo);
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (e instanceof InvocationTargetException && errMsg == null) {
                    errMsg = ((InvocationTargetException)e).getTargetException().getMessage();
                }
                errMsg = "\u5bf9\u5e94\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\uff1a" + field.getName() + "--" + field.getKey() + "\n" + errMsg;
                throw new Exception(errMsg);
            }
        }
    }

    private static void checkF7Filed(Context ctx, String queryName, String filterInfo) throws Exception {
        MetaDataPK pk = MetaDataPK.create((String)queryName);
        QueryInfo query = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)pk);
        if (query == null) {
            throw new Exception("\u57fa\u7840\u8d44\u6599\u7ed1\u5b9a\u7684query\uff1a" + queryName + " \u5728\u5143\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        EntityViewInfo entityView = null;
        if (!StringUtils.isEmpty((String)filterInfo)) {
            String filter = filterInfo.trim().toUpperCase().startsWith("WHERE") ? filterInfo : " WHERE " + filterInfo;
            try {
                entityView = new EntityViewInfo(filter);
            }
            catch (Exception ex) {
                entityView = new EntityViewInfo();
            }
        } else {
            entityView = new EntityViewInfo();
        }
        String className = "com.kingdee.eas.cp.base.cache.CacheManager";
        Class<?> c = Class.forName(className);
        Method m = c.getMethod("getCacheManager", Context.class);
        Object cacheManager = m.invoke(c, ctx);
        m = cacheManager.getClass().getMethod("checkFileds", Context.class, QueryInfo.class, EntityViewInfo.class);
        m.invoke(cacheManager, ctx, query, entityView);
    }

    @Override
    public String updateFormMetadata(FormMetaData billMetaData, ElementTypes types, List vctDel) throws Exception {
        String formid = null;
        this.checkF7Fields(billMetaData);
        Object[] params = new Object[]{billMetaData, types, vctDel};
        Method method = null;
        try {
            method = DefaultMetaDataServer.class.getMethod("updateFormMetadata1", FormMetaData.class, ElementTypes.class, List.class);
            formid = (String)FormObjectTransFactory.invokeRequired(this, method, params);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        return formid;
    }

    public String updateFormMetadata1(FormMetaData billMetaData, ElementTypes types, List vctDel) throws Exception {
        Context ctx = this.getContext();
        BusinessInfo businessInfo = billMetaData.getBusinessInfo();
        Form form = businessInfo.getForm();
        String formID = form.getId();
        if (formID == null || formID.length() == 0) {
            formID = this.createNewID();
        }
        try {
            Iterator iter = vctDel.iterator();
            while (iter.hasNext()) {
                this.deleteEelement(iter.next(), formID);
            }
            this.updateBusiness(form, types, formID);
            int i = 1;
            for (Entity eba : businessInfo.getEntrys()) {
                eba.setSeq(i);
                this.updateBusiness(eba, types, formID);
                for (Field fld : eba.getFields()) {
                    this.updateBusiness(fld, types, formID);
                }
                ++i;
            }
            String sql1 = " DELETE T_BAS_FormMenuScheme  WHERE  fid in  ( select fmenuid from t_bas_formmenu where fformid = ? )";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{"99999999-9999-9999-9999-999999999999WWF7XXF4"});
            sql1 = " DELETE T_BAS_BarItem WHERE   FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid = ? )";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{"99999999-9999-9999-9999-999999999999WWF7XXF4"});
            sql1 = " DELETE T_BAS_BarItemLink WHERE   FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid = ? )";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{"99999999-9999-9999-9999-999999999999WWF7XXF4"});
            sql1 = " DELETE T_BAS_FormMenu WHERE  FFormID = ?";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{"99999999-9999-9999-9999-999999999999WWF7XXF4"});
            BarUtils.saveTemplate2Db(ctx, billMetaData.getBarTemplateManager());
            String menuName = "";
            if (businessInfo != null && businessInfo.getForm() != null) {
                menuName = businessInfo.getForm().getName_L2();
            }
            String sql2 = " DELETE T_BAS_FormMenuScheme  WHERE  fid in  ( select fmenuid from t_bas_formmenu where fformid = ? )";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{formID});
            sql2 = " DELETE T_BAS_BarItem WHERE   FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid = ? )";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{formID});
            sql2 = " DELETE T_BAS_BarItemLink WHERE   FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid = ? )";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{formID});
            sql2 = " DELETE T_BAS_FormMenu WHERE  FFormID = ?";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{formID});
            BarUtils.save2Db(ctx, formID, menuName, menuName, menuName, billMetaData.getBarDataManager());
            for (LayoutInfo layoutInfo : billMetaData.getLayoutInfos()) {
                FormAppearance bap = layoutInfo.getFormAppearance();
                String layoutID = layoutInfo.getId();
                if (layoutID.length() == 0) {
                    layoutID = this.createNewID();
                }
                this.updateAppearance(bap, types, formID, layoutID);
                this.updateLayout(layoutInfo, types, formID, layoutID);
                this.updateActionList_FromBar(formID, layoutID, billMetaData.getBarDataManager());
                this.updateActionList_FromTemplateBar(billMetaData.getBarTemplateManager());
            }
            billMetaData.getBusinessInfo().getForm().setId(formID);
            MetaDataHelper.updateEventDef(this.getContext(), billMetaData);
            for (int j = 0; form.getBaseTableList() != null && j < form.getBaseTableList().size(); ++j) {
                BaseTableInfo baseTableInfo = (BaseTableInfo)form.getBaseTableList().get(j);
                baseTableInfo.setFormId(formID);
            }
            this.updateBaseTableInfoList(formID, form.getBaseTableList());
            String bosType = form.getBosType();
            if (!StringUtils.isEmpty((String)bosType)) {
                String sql = " select count(fid) cnt from t_bas_form where fbostype = ? and fid!=?";
                int cnt = 0;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bosType, formID});
                if (rs.next()) {
                    cnt = rs.getInt("cnt");
                }
                if (cnt > 0) {
                    sql = " update t_bas_form set FIsMain = 0 where fid = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{formID});
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        return formID;
    }

    private String createNewID() {
        return BOSUuid.create((String)"9A7EAE92").toString();
    }

    private Object getPropertyValue(Object elementObj, String propertyName) {
        if (elementObj != null) {
            Method mi = null;
            try {
                mi = elementObj.getClass().getMethod("get" + propertyName, null);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (mi != null) {
                try {
                    return mi.invoke(elementObj, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)e);
                }
            }
        }
        return null;
    }

    private void updateLayout(LayoutInfo layoutInfo, ElementTypes types, String billTypeID, String layoutID) throws BOSException, EASBizException {
        for (ControlAppearance ctl : layoutInfo.getControls()) {
            this.updateAppearance(ctl, types, billTypeID, layoutID);
            if (ctl instanceof EntityAppearance) {
                this.updateLayout(((EntityAppearance)ctl).getLayoutinfo(), types, billTypeID, layoutID);
            } else if (ctl instanceof TabControlAppearance) {
                int i = 0;
                for (TabPageAppearance tabPageAp : ((TabControlAppearance)ctl).getTabPages()) {
                    tabPageAp.setPageIndex(i);
                    this.updateAppearance(tabPageAp, types, billTypeID, layoutID);
                    ++i;
                }
            }
            this.clearTableLayout(ctl, layoutID);
            if (ctl.getLayout() instanceof TableLayout) {
                this.updateTableLayout(ctl, billTypeID, layoutID);
            }
            if (ctl.getControlType() != 1027) continue;
            logger.info((Object)("billTypeID===" + billTypeID + "======ctl.getControlType====" + ctl.getControlType() + "formid====" + layoutInfo.getFormId() + "ctl.getKey()====" + ctl.getKey()));
            this.updateBasImg(billTypeID, ctl.getKey(), ctl.getImgFile());
            ctl.setImgFile(null);
        }
    }

    private void updateBasImg(String formID, String fieldKey, String imgFile) throws BOSException {
        if (StringUtil.isEmpty((String)imgFile)) {
            return;
        }
        logger.info((Object)("imgFile====" + imgFile.length()));
        BasImgHelper biHelper = new BasImgHelper();
        biHelper.setImgFile(imgFile);
        biHelper.setFormID(formID);
        biHelper.setFieldKey(fieldKey);
        biHelper.setCreater(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
        biHelper.setCreateTime(new Timestamp(new Date().getTime()));
        biHelper.setCtrlUint(ContextUtil.getCurrentCtrlUnit((Context)this.getContext()));
        biHelper.setDesc("");
        biHelper.setLastUpdateTime(new Timestamp(new Date().getTime()));
        biHelper.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
        logger.info((Object)"exist data");
        if (this.existImgData(biHelper)) {
            logger.info((Object)"update data");
            this.updateImgData(biHelper);
        } else {
            logger.info((Object)"new data");
            this.addNewImgData(biHelper);
        }
        BasImgHelper.deleteImagFile(formID, fieldKey, "del_some");
    }

    private void updateActionList(String formID, String layoutID, AbstractElement el) throws BOSException {
        int[] objectType;
        String sourceKey = el.getOriginKey();
        String[][] actionTypes = null;
        if (el instanceof Field) {
            actionTypes = new String[][]{{"LoadActions", "UpdateActions", "ClickActions"}};
            objectType = new int[]{4};
        } else if (el instanceof ButtonAppearance) {
            actionTypes = new String[][]{{"ClickActions"}};
            objectType = new int[]{3};
        } else if (el instanceof EntityAppearance) {
            actionTypes = new String[][]{{"DblClickActions"}};
            objectType = new int[]{2};
        } else if (el instanceof Form) {
            actionTypes = new String[2][];
            objectType = new int[2];
            actionTypes[0] = new String[]{"LoadActions", "ListLoadActions"};
            objectType[0] = 1;
            actionTypes[1] = new String[]{"BeforeActions", "AfterActions"};
            objectType[1] = 6;
        } else {
            return;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            st = conn.createStatement();
            String sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and UCASE(fobjectkey) = '" + sourceKey.toUpperCase() + "'";
            if (layoutID == null || layoutID.trim().length() == 0) {
                sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + sourceKey.toUpperCase() + "'";
            }
            st.addBatch(sql1);
            if (el instanceof Form) {
                sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and fobjecttype = 6 ";
                if (layoutID == null || layoutID.trim().length() == 0) {
                    sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and fobjecttype = 6 ";
                }
                st.addBatch(sql1);
            }
            sql1 = " delete from t_bas_fcEntry where fparentid in  ( select fid from t_bas_formActionList where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and UCASE(fobjectkey) = '" + sourceKey.toUpperCase() + "')";
            if (layoutID == null || layoutID.trim().length() == 0) {
                sql1 = " delete from t_bas_fcEntry where fparentid in  ( select fid from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + sourceKey.toUpperCase() + "')";
            }
            st.addBatch(sql1);
            if (el instanceof Form) {
                sql1 = " delete from t_bas_fcEntry where fparentid in  ( select fid from t_bas_formActionList where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and fobjecttype = 6 )";
                if (StringUtils.isEmpty((String)layoutID)) {
                    sql1 = " delete from t_bas_fcEntry where fparentid in  ( select fid from t_bas_formActionList where fformid = '" + formID + "'  and fobjecttype = 6 )";
                }
                st.addBatch(sql1);
            }
            for (int m = 0; m < actionTypes.length; ++m) {
                for (int i = 0; i < actionTypes[m].length; ++i) {
                    List actionList = (List)this.getPropertyValue(el, actionTypes[m][i]);
                    for (int j = 0; actionList != null && j < actionList.size(); ++j) {
                        Action act = (Action)actionList.get(j);
                        String id = this.createNewID();
                        int actionId = act.getActionId();
                        String param = act.getJsonParameters() == null ? "" : act.getJsonParameters().toString();
                        String key = act.getObjectKey();
                        String paramExtendData = act.getParamExtendData();
                        String expression = act.getExpression();
                        String setting = act.getSetting();
                        if (act.isExcept()) {
                            param = "!" + param;
                        }
                        if (paramExtendData != null && paramExtendData.length() > 0) {
                            param = param + "@#@" + paramExtendData;
                        }
                        String sql2 = " insert into t_bas_formActionList(FID, FFormID, FLayoutID, FObjectKey,  FObjectType, FActionID, FDefineType, FActionType,  FParaments, FExpression, FSetting, FSeq) VALUES('" + id + "','" + formID + "','" + layoutID + "','" + key + "'," + objectType[m] + "," + actionId + "," + 0 + ",'" + actionTypes[m][i] + "','" + (param == null ? "" : param.replaceAll("'", "''")) + "','" + "" + "','" + "" + "'," + j + ") ";
                        st.addBatch(sql2);
                        List entryList = FormConditionEntry.getEntryList(id, expression == null ? "" : expression, setting == null ? "" : setting);
                        if (entryList == null || entryList.size() <= 0) continue;
                        for (int k = 0; k < entryList.size(); ++k) {
                            FormConditionEntry entry = (FormConditionEntry)entryList.get(k);
                            String id1 = this.createNewID();
                            String parenid = entry.getParentId();
                            String condition1 = entry.getConditon();
                            String setting1 = entry.getSetting();
                            int seq = entry.getSeq();
                            sql2 = " INSERT INTO T_BAS_FCEntry( FID, FParentId, FCondition, FSetting, FSeq ) VALUES('" + id1 + "','" + parenid + "','" + condition1.replaceAll("'", "''") + "','" + setting1.replaceAll("'", "''") + "'," + seq + ") ";
                            st.addBatch(sql2);
                        }
                    }
                }
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateActionList_FromBar(String formID, String layoutID, BarDataManager barBuilder) throws BOSException {
        int objectType = 5;
        String[] actionTypes = new String[]{"ClickActions"};
        Connection conn = null;
        Statement st = null;
        try {
            BarItem barItem;
            conn = EJBFactory.getConnection((Context)this.getContext());
            st = conn.createStatement();
            Map allItems = barBuilder.getAllBarItems();
            for (Map.Entry entry : barBuilder.getRemoveBarItems().entrySet()) {
                barItem = (BarItem)entry.getValue();
                String OriginObjectKey = barItem.getOriginKey();
                String sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and UCASE(fobjectkey) = '" + OriginObjectKey.toUpperCase() + "' and fobjecttype = " + objectType;
                if (layoutID == null || layoutID.trim().length() == 0) {
                    sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + OriginObjectKey.toUpperCase() + "' and fobjecttype = " + objectType;
                }
                st.addBatch(sql1);
            }
            for (Map.Entry entry : allItems.entrySet()) {
                barItem = (BarItem)entry.getValue();
                String Objectkey = barItem.getName();
                String OriginObjectKey = barItem.getOriginKey();
                String sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and UCASE(fobjectkey) = '" + OriginObjectKey.toUpperCase() + "' and fobjecttype = " + objectType;
                if (layoutID == null || layoutID.trim().length() == 0) {
                    sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + OriginObjectKey.toUpperCase() + "' and fobjecttype = " + objectType;
                }
                st.addBatch(sql1);
                for (int i = 0; i < actionTypes.length; ++i) {
                    List actionList = (List)this.getPropertyValue(barItem, actionTypes[i]);
                    for (int j = 0; actionList != null && j < actionList.size(); ++j) {
                        String paramExtendData;
                        Action act = (Action)actionList.get(j);
                        String id = this.createNewID();
                        int actionId = act.getActionId();
                        String param = act.getJsonParameters() == null ? "" : act.getJsonParameters().toString();
                        String expression = act.getExpression();
                        if (act.isExcept()) {
                            param = "!" + param;
                        }
                        if ((paramExtendData = act.getParamExtendData()) != null && paramExtendData.length() > 0) {
                            param = param + "@#@" + paramExtendData;
                        }
                        String sql2 = " insert into t_bas_formActionList(FID, FFormID, FLayoutID, FObjectKey,  FObjectType, FActionID, FDefineType, FActionType, FParaments, FExpression, FSeq) VALUES('" + id + "','" + formID + "','" + layoutID + "','" + Objectkey + "'," + objectType + "," + actionId + "," + 0 + ",'" + actionTypes[i] + "','" + (param == null ? "" : param.replaceAll("'", "''")) + "','" + (expression == null ? "" : expression.replaceAll("'", "''")) + "'," + j + ") ";
                        st.addBatch(sql2);
                    }
                }
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateActionList_FromTemplateBar(BarTemplateManager templateManager) throws BOSException {
        String formID = "99999999-9999-9999-9999-999999999999WWF7XXF4";
        int objectType = 5;
        String[] actionTypes = new String[]{"ClickActions"};
        Connection conn = null;
        Statement st = null;
        try {
            BarDataManager barManager;
            conn = EJBFactory.getConnection((Context)this.getContext());
            st = conn.createStatement();
            Iterator it = templateManager.getRemovedMapping_TemplateID_BarDataManager().entrySet().iterator();
            while (it.hasNext()) {
                String sql1;
                String OriginObjectKey;
                BarItem barItem;
                Map.Entry entry = it.next();
                barManager = (BarDataManager)entry.getValue();
                Iterator itAll = barManager.getAllBarItems().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entryAll = itAll.next();
                    barItem = (BarItem)entryAll.getValue();
                    OriginObjectKey = barItem.getOriginKey();
                    sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + OriginObjectKey.toUpperCase() + "' and fobjecttype = " + objectType;
                    st.addBatch(sql1);
                }
                Iterator itRm = barManager.getRemoveBarItems().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entryRm = itRm.next();
                    barItem = (BarItem)entryRm.getValue();
                    OriginObjectKey = barItem.getOriginKey();
                    sql1 = "delete from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + OriginObjectKey.toUpperCase() + "' and fobjecttype = " + objectType;
                    st.addBatch(sql1);
                }
            }
            for (Map.Entry entry : templateManager.getMapping_TemplateID_BarDataManager().entrySet()) {
                barManager = (BarDataManager)entry.getValue();
                Map allItems = barManager.getAllBarItems();
                for (Map.Entry entry2 : allItems.entrySet()) {
                    BarItem barItem = (BarItem)entry2.getValue();
                    String Objectkey = barItem.getName();
                    String OriginObjectKey = barItem.getOriginKey();
                    String sql1 = "delete from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + OriginObjectKey.toUpperCase() + "' and fobjecttype = " + objectType;
                    st.addBatch(sql1);
                    for (int i = 0; i < actionTypes.length; ++i) {
                        List actionList = (List)this.getPropertyValue(barItem, actionTypes[i]);
                        for (int j = 0; actionList != null && j < actionList.size(); ++j) {
                            String paramExtendData;
                            Action act = (Action)actionList.get(j);
                            String id = this.createNewID();
                            int actionId = act.getActionId();
                            String param = act.getJsonParameters() == null ? "" : act.getJsonParameters().toString();
                            String expression = act.getExpression();
                            if (act.isExcept()) {
                                param = "!" + param;
                            }
                            if ((paramExtendData = act.getParamExtendData()) != null && paramExtendData.length() > 0) {
                                param = param + "@#@" + paramExtendData;
                            }
                            String sql2 = " insert into t_bas_formActionList(FID, FFormID, FLayoutID, FObjectKey,  FObjectType, FActionID, FDefineType, FActionType, FParaments, FExpression, FSeq) VALUES('" + id + "','" + formID + "',' ','" + Objectkey + "'," + objectType + "," + actionId + "," + 0 + ",'" + actionTypes[i] + "','" + (param == null ? "" : param.replaceAll("'", "''")) + "','" + (expression == null ? "" : expression.replaceAll("'", "''")) + "'," + j + ") ";
                            st.addBatch(sql2);
                        }
                    }
                }
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateCustomProperty(String formID, String layoutID, List elementProps, AbstractElement el, AbstractElement elSystem) throws BOSException {
        String key = el.getKey();
        String sourceKey = el.getOriginKey();
        int objectType = 0;
        if (el instanceof Field) {
            objectType = 4;
        } else if (el instanceof ControlAppearance) {
            objectType = 3;
        } else if (el instanceof Form) {
            objectType = 1;
        } else if (el instanceof Entity) {
            objectType = 2;
        } else {
            return;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            st = conn.createStatement();
            String sql1 = " delete from T_BAS_FormCustomProperty where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and fobjectkey = '" + sourceKey + "' AND FObjectType=" + objectType;
            if (layoutID == null || layoutID.trim().length() == 0) {
                sql1 = " delete from T_BAS_FormCustomProperty where fformid = '" + formID + "'  and fobjectkey = '" + sourceKey + "' AND FObjectType=" + objectType;
            }
            st.addBatch(sql1);
            for (ElementProperty prop : elementProps) {
                Object value = null;
                Object sysValue = null;
                try {
                    value = this.getPropertyValue(el, prop.getPropertyName());
                    sysValue = this.getPropertyValue(elSystem, prop.getPropertyName());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (value == sysValue) continue;
                String id = this.createNewID();
                String sql2 = " insert into T_BAS_FormCustomProperty(FID, FFormID, FLayoutID, FObjectKey,  FObjectType, FPropertyName, FValue, FValueType) VALUES('" + id + "','" + formID + "','" + layoutID + "','" + key + "'," + objectType + ",'" + prop.getPropertyName() + "','" + value + "'," + value.getClass().getName() + ")";
                st.addBatch(sql2);
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void deleteExtProperty(String formID, AbstractElement el) throws BOSException {
        String key = el.getKey();
        String sourceKey = el.getOriginKey();
        int objectType = 0;
        if (el instanceof Field) {
            objectType = 4;
        } else if (el instanceof Appearance) {
            objectType = 3;
        } else if (el instanceof Form) {
            objectType = 1;
        } else if (el instanceof Entity) {
            objectType = 2;
        } else {
            return;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            st = conn.createStatement();
            String sql1 = " delete from T_BAS_FormExtProperty where fformid = '" + formID + "'  and fobjectkey = '" + sourceKey + "' AND FObjectType=" + objectType;
            st.addBatch(sql1);
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateExtProperty(String formID, String layoutID, AbstractElement el) throws BOSException {
        String key = el.getKey();
        String sourceKey = el.getOriginKey();
        int objectType = 0;
        if (el instanceof Field) {
            objectType = 4;
        } else if (el instanceof Appearance) {
            objectType = 3;
        } else if (el instanceof Form) {
            objectType = 1;
        } else if (el instanceof Entity) {
            objectType = 2;
        } else {
            return;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            st = conn.createStatement();
            String sql1 = " delete from T_BAS_FormExtProperty where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and fobjectkey = '" + sourceKey + "' AND FObjectType=" + objectType;
            if (layoutID == null || layoutID.trim().length() == 0) {
                sql1 = " delete from T_BAS_FormExtProperty where fformid = '" + formID + "'  and fobjectkey = '" + sourceKey + "' AND FObjectType=" + objectType;
            }
            st.addBatch(sql1);
            ArrayList extProps = el.getExtPropertys();
            for (int j = 0; extProps != null && j < extProps.size(); ++j) {
                ExtProperty prop = (ExtProperty)extProps.get(j);
                String id = this.createNewID();
                int valueType = 0;
                if (PropertyUtil.getPropertyValue(el, prop.getPropertyName()) instanceof Integer) {
                    valueType = 1;
                }
                String sql2 = " insert into T_BAS_FormExtProperty(FID, FFormID, FLayoutID, FObjectKey,  FObjectType, FPropertyName, FValue, FValueType) VALUES('" + id + "','" + formID + "','" + layoutID + "','" + key + "'," + objectType + ",'" + prop.getPropertyName() + "','" + (prop.getValue() == null || prop.getValue().equalsIgnoreCase("") ? " " : prop.getValue()) + "'," + valueType + ")";
                st.addBatch(sql2);
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void deleteActionList(String formID, String layoutID, AbstractElement el) throws BOSException {
        String sourceKey = el.getOriginKey();
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            st = conn.createStatement();
            String sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and flayoutid = '" + layoutID + "' and UCASE(fobjectkey) = '" + sourceKey.toUpperCase() + "'";
            if (layoutID == null || layoutID.trim().length() == 0) {
                sql1 = " delete from t_bas_formActionList where fformid = '" + formID + "'  and UCASE(fobjectkey) = '" + sourceKey.toUpperCase() + "'";
            }
            st.execute(sql1);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateTableLayout(ControlAppearance ctl, String billTypeID, String layoutID) throws BOSException {
        String key = ctl.getKey();
        if (layoutID == null || layoutID.trim().length() == 0) {
            layoutID = this.createNewID();
        }
        String containerLayoutId = this.createNewID();
        TableLayout layout = (TableLayout)ctl.getLayout();
        int layoutType = layout.getLayoutType();
        int rows = layout.getRows();
        int cols = layout.getCols();
        Context ctx = this.getContext();
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            String sql2 = " insert into t_bas_FormContainerLayout(FID, FFormID, FLayoutID, FContainerKey, FLayoutType, FCols, FRows) VALUES('" + containerLayoutId + "','" + billTypeID + "','" + layoutID + "','" + key + "'," + layoutType + "," + cols + "," + rows + ") ";
            st.addBatch(sql2);
            this.updateTableLayoutStyle(billTypeID, layoutID, key, layout, layout.getColStyles(), "ColStyles", st);
            this.updateTableLayoutStyle(billTypeID, layoutID, key, layout, layout.getRowStyles(), "RowStyles", st);
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void clearTableLayout(ControlAppearance ctl, String layoutID) throws BOSException {
        String key = ctl.getKey();
        if (layoutID == null || layoutID.trim().length() == 0) {
            layoutID = this.createNewID();
        }
        Context ctx = this.getContext();
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            String sql1 = " delete from t_bas_FormContainerLayout where flayoutid = '" + layoutID + "' and fcontainerkey = '" + key + "'";
            st.addBatch(sql1);
            String sql3 = " delete from t_BAS_FormTableLayoutStyle where flayoutid = '" + layoutID + "' and fcontainerkey = '" + key + "'";
            st.addBatch(sql3);
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateTableLayoutStyle(String billTypeID, String layoutID, String key, TableLayout layout, List styleList, String styleType, Statement st) throws SQLException {
        for (int i = 0; i < styleList.size(); ++i) {
            String id = this.createNewID();
            int out = ((Style)styleList.get(i)).getOut();
            String sql4 = "\tINSERT INTO t_BAS_FormTableLayoutStyle(FID, FFormID, FLayoutID, FContainerKey, FType, FIndex, FOut)  VALUES('" + id + "','" + billTypeID + "','" + layoutID + "','" + key + "','" + styleType + "'," + i + "," + out + ") ";
            st.addBatch(sql4);
        }
    }

    private void updateAppearance(Appearance ap, ElementTypes types, String billTypeID, String layoutID) throws BOSException, EASBizException {
        String tableName = this.getAppearanceTableName(ap);
        ElementType type = types.getElementType(ap.getElementType());
        List propertyList = type.getAppearancePropertys();
        if (ap.getId() == null || ap.getId().length() == 0) {
            ArrayList<SqlParameter> PK = new ArrayList<SqlParameter>();
            if (tableName.equalsIgnoreCase("T_BAS_FormLayout")) {
                PK.add(new SqlParameter("FFormID", billTypeID));
                PK.add(new SqlParameter("FID", layoutID));
            } else {
                PK.add(new SqlParameter("FLayoutID", layoutID));
                PK.add(new SqlParameter("FID", this.createNewID()));
            }
            this.insertRow(ap, propertyList, tableName, PK);
        } else {
            this.updateRow(ap, propertyList, tableName);
        }
        this.updateExtProperty(billTypeID, layoutID, ap);
        this.updateActionList(billTypeID, layoutID, ap);
    }

    private String getAppearanceTableName(Appearance ap) {
        String tableName = "";
        tableName = ap instanceof FormAppearance ? "T_BAS_FormLayout" : (ap instanceof EntityAppearance ? "T_BAS_FormLayoutEntity" : (ap instanceof FieldAppearance ? "T_BAS_FormLayoutField" : (ap instanceof TabPageAppearance ? "T_BAS_FormLayoutTabPage" : "T_BAS_FormLayoutCtrl")));
        return tableName;
    }

    private void insertRow(Object elementObj, List elementProps, String tableName, List pk) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String strSQL = " INSERT INTO " + tableName + "(";
        String strField = "";
        String strValue = "";
        ArrayList<Object> params = new ArrayList<Object>();
        for (SqlParameter parammeter : pk) {
            String sField = parammeter.getFieldName();
            strField = strField + sField + ",";
            strValue = strValue + " ? ,";
            Object value = parammeter.getFieldValue();
            params.add(value);
        }
        for (ElementProperty property : elementProps) {
            if (property.getFieldName() == null || property.getFieldName().trim().length() == 0) continue;
            Object value = null;
            try {
                value = this.getPropertyValue(elementObj, property.getPropertyName());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (value == null) continue;
            strField = strField + property.getFieldName() + ",";
            strValue = strValue + " ? ,";
            params.add(value);
        }
        if (strField.length() > 0) {
            strField = strField.substring(0, strField.length() - 1);
            strValue = strValue.substring(0, strValue.length() - 1);
            strSQL = strSQL + strField + ") values(" + strValue + ")";
            DbUtil.execute((Context)ctx, (String)strSQL, (Object[])params.toArray());
        }
    }

    private void updateRow(Object elementObj, List elementProps, String tableName) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String strSQL = " UPDATE " + tableName + " SET ";
        ArrayList<Object> params = new ArrayList<Object>();
        for (ElementProperty prop : elementProps) {
            String sField = prop.getFieldName();
            if (sField == null || sField.trim().length() == 0) continue;
            Object value = null;
            try {
                value = this.getPropertyValue(elementObj, prop.getPropertyName());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (value == null) continue;
            params.add(value);
            strSQL = strSQL + sField + " = ? ,";
        }
        if (strSQL.length() > 0 && params.size() > 0) {
            strSQL = strSQL.substring(0, strSQL.length() - 1);
            strSQL = strSQL + " WHERE FID = ?";
            Object value = this.getPropertyValue(elementObj, "Id");
            params.add(value);
            DbUtil.execute((Context)ctx, (String)strSQL, (Object[])params.toArray());
        }
    }

    private void updateBusiness(Element ba, ElementTypes types, String billTypeID) throws BOSException, EASBizException {
        String tableName = this.getBusinessTableName(ba);
        ElementType type = types.getElementType(ba.getElementType());
        List propertyList = type.getBusinessPropertys();
        String id = ba.getId();
        if (id == null || id.length() == 0) {
            ArrayList<SqlParameter> PK = new ArrayList<SqlParameter>();
            if (tableName.equalsIgnoreCase("T_BAS_Form")) {
                PK.add(new SqlParameter("FID", billTypeID));
            } else {
                PK.add(new SqlParameter("FID", this.createNewID()));
                PK.add(new SqlParameter("FFormID", billTypeID));
            }
            this.insertRow(ba, propertyList, tableName, PK);
        } else {
            this.updateRow(ba, propertyList, tableName);
        }
        if (ba instanceof Form) {
            this.updateFormOperation(billTypeID, (Form)ba);
            this.updateFormPlugIn(billTypeID, (Form)ba);
            this.updateFormConditions(billTypeID, (Form)ba);
        }
        this.updateExtProperty(billTypeID, "", ba);
        this.updateActionList(billTypeID, "", ba);
    }

    private void updateFormPlugIn(String formId, Form form) throws BOSException {
        Context ctx = this.getContext();
        Connection conn = null;
        PreparedStatement st = null;
        try {
            String deleteSql = " delete from t_bas_formplugin where fformid = ? ";
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{formId});
            String insertSql = " insert into t_bas_formplugin (FID, FFormID, FDesc, FClassName, FSeq, FType) values  (?,?,?,?,?,?) ";
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.prepareStatement(insertSql);
            List[] plugins = form.getPlugins();
            int index = 0;
            for (int j = 0; plugins != null && j < plugins.length; ++j) {
                for (int k = 0; plugins[j] != null && k < plugins[j].size(); ++k) {
                    String id = this.createNewID();
                    String className = plugins[j].get(k).toString();
                    st.setString(1, id);
                    st.setString(2, formId);
                    st.setString(3, null);
                    st.setString(4, className);
                    st.setInt(5, k);
                    st.setInt(6, j + 1);
                    st.addBatch();
                    ++index;
                }
            }
            if (index > 0) {
                st.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateFormOperation(String formId, Form form) throws BOSException {
        Context ctx = this.getContext();
        Connection conn = null;
        PreparedStatement st = null;
        try {
            String deleteSql = " delete from t_bas_formOperation where fformid = ? ";
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{formId});
            String insertSql = " INSERT INTO T_BAS_FormOperation( FID, FFormID, FPermissionItem,  FStateField, FPreStateValue, FSuccessSateValue, FFailedSateValue, FOperationID, FCheckWfState) VALUES(?,?,?,?,?,?,?,?,?) ";
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.prepareStatement(insertSql);
            List formOperationList = form.getFormOperations();
            for (int j = 0; formOperationList != null && j < formOperationList.size(); ++j) {
                FormOperation operation = (FormOperation)formOperationList.get(j);
                String id = this.createNewID();
                String permissionItem = operation.getPermissionItem();
                String stateField = operation.getStateField();
                String preStateValue = operation.getPreStateValue();
                String successSateValue = operation.getSuccessSateValue();
                String failedSateValue = operation.getFailedSateValue();
                int operationId = operation.getId();
                int checkWfState = operation.getCheckWfState();
                st.setString(1, id);
                st.setString(2, formId);
                st.setString(3, permissionItem);
                st.setString(4, stateField);
                st.setString(5, preStateValue);
                st.setString(6, successSateValue);
                st.setString(7, failedSateValue);
                st.setInt(8, operationId);
                st.setInt(9, checkWfState);
                st.addBatch();
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private void updateFormConditions(String formId, Form form) throws BOSException {
        Context ctx = this.getContext();
        Connection conn = null;
        PreparedStatement st = null;
        try {
            String deleteSql = " delete from t_bas_fcentry where fparentid in ( select fid from t_bas_formCondition where fformid = ? )";
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{formId});
            deleteSql = " delete from t_bas_formCondition where fformid = ? ";
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{formId});
            String insertSql = " INSERT INTO T_BAS_FormCondition(  FID, FFormID, FName_L1, FName_L2, FName_L3, FCondition, FSetting, FSeq ) VALUES(?,?,?,?,?,?,?,?) ";
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.prepareStatement(insertSql);
            ArrayList conditions = form.getConditions();
            HashMap<String, List> entryMap = new HashMap<String, List>();
            for (int j = 0; conditions != null && j < conditions.size(); ++j) {
                String setting;
                FormCondition condition = (FormCondition)conditions.get(j);
                String id = StringUtils.isEmpty((String)condition.getId()) ? this.createNewID() : condition.getId();
                String name_l1 = condition.getName_l1();
                String name_l2 = condition.getName_l2();
                String name_l3 = condition.getName_l3();
                int feq = condition.getSeq();
                String conditionStr = condition.getConditon();
                List entryList = FormConditionEntry.getEntryList(id, conditionStr, setting = condition.getSetting());
                if (entryList != null && entryList.size() > 0) {
                    conditionStr = "";
                    setting = "";
                }
                entryMap.put(id, entryList);
                st.setString(1, id);
                st.setString(2, formId);
                st.setString(3, name_l1);
                st.setString(4, name_l2);
                st.setString(5, name_l3);
                st.setString(6, conditionStr);
                st.setString(7, setting);
                st.setInt(8, feq);
                st.addBatch();
            }
            if (conditions != null && conditions.size() > 0) {
                st.executeBatch();
            }
            insertSql = " INSERT INTO T_BAS_FCEntry( FID, FParentId, FCondition, FSetting, FSeq ) VALUES(?,?,?,?,?) ";
            st = conn.prepareStatement(insertSql);
            int count = 0;
            for (Object key : entryMap.keySet()) {
                List entryList = (List)entryMap.get(key);
                for (int i = 0; i < entryList.size(); ++i) {
                    FormConditionEntry entry = (FormConditionEntry)entryList.get(i);
                    String id = this.createNewID();
                    String parenid = entry.getParentId();
                    String condition = entry.getConditon();
                    String setting = entry.getSetting();
                    int seq = entry.getSeq();
                    st.setString(1, id);
                    st.setString(2, parenid);
                    st.setString(3, condition);
                    st.setString(4, setting);
                    st.setInt(5, seq);
                    st.addBatch();
                    ++count;
                }
            }
            if (count > 0) {
                st.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private String getBusinessTableName(Element ba) {
        String tableName = "";
        tableName = ba instanceof Form ? "T_BAS_Form" : (ba instanceof Entity ? "T_BAS_FormEntity" : "T_BAS_FormField");
        return tableName;
    }

    private void deleteEelement(Object el, String formId) throws BOSException {
        if (el instanceof Appearance) {
            ControlAppearance ctl;
            this.deleteAppearance((Appearance)el);
            this.deleteAppearanceExtend(formId, (Appearance)el);
            this.deleteActionList(formId, null, (Appearance)el);
            this.deleteExtProperty(formId, (Appearance)el);
            if (el instanceof ControlAppearance && (ctl = (ControlAppearance)el).getElementType() == 1027) {
                this.deleteImgPanelData(ctl, formId);
            }
            if (el instanceof EntityAppearance) {
                EntityAppearance entityCtl = (EntityAppearance)el;
                for (ControlAppearance ctl2 : entityCtl.getLayoutinfo().getControls()) {
                    this.deleteAppearance(ctl2);
                    this.deleteAppearanceExtend(formId, ctl2);
                    this.deleteActionList(formId, null, (Appearance)el);
                }
            }
        }
        if (el instanceof Element) {
            this.deleteBusiness((Element)el);
            this.deleteExtProperty(formId, (Element)el);
            this.deleteActionList(formId, null, (Element)el);
            if (el instanceof Entity) {
                Entity entity = (Entity)el;
                for (Field fld : entity.getFields()) {
                    this.deleteBusiness(fld);
                    this.deleteExtProperty(formId, fld);
                    this.deleteActionList(formId, null, (Element)el);
                }
            }
        }
    }

    private void deleteImgPanelData(ControlAppearance ctl, String formId) {
        BasImgHelper biHelper = new BasImgHelper();
        biHelper.setFormID(formId);
        biHelper.setFieldKey(ctl.getKey());
        this.deleteImgData(biHelper);
    }

    private void deleteBusiness(Element ba) throws BOSException {
        String tableName = this.getBusinessTableName(ba);
        String strSQL = " DELETE FROM  " + tableName + " WHERE FID = ?";
        DbUtil.execute((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{ba.getId()});
    }

    private void deleteAppearance(Appearance ap) throws BOSException {
        String tableName = this.getAppearanceTableName(ap);
        String strSQL = " DELETE FROM  " + tableName + " WHERE FID = ?";
        DbUtil.execute((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{ap.getId()});
    }

    private void deleteAppearanceExtend(String formId, Appearance ap) throws BOSException {
        if (ap.getElementType() == 1012) {
            String strSQL = "delete from T_BAS_FormTableLayoutStyle where fformid = ? and FcontainerKey = ?";
            String key = ap.getKey();
            DbUtil.execute((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{formId, key});
        }
    }

    @Override
    public List getForms(List elementTypeList) throws BOSException {
        if (elementTypeList == null || elementTypeList.isEmpty()) {
            return null;
        }
        ArrayList<FormAppearance> result = new ArrayList<FormAppearance>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid, FElementTypeId, fname_" + locale + " from T_BAS_Form where ";
        for (int i = 0; i < elementTypeList.size(); ++i) {
            sql = i == 0 ? sql + " FElementTypeId = ? " : sql + " or FElementTypeId = ? ";
        }
        sql = sql + " order by FElementTypeId ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])elementTypeList.toArray());
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                String name = rs.getString("fname_" + locale);
                FormAppearance form = new FormAppearance(id);
                form.setId(id);
                form.setCaption(name);
                form.setElementType(rs.getInt("FElementTypeId"));
                result.add(form);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getAllBillLayout(List formIdList) throws BOSException {
        if (formIdList == null || formIdList.isEmpty()) {
            return null;
        }
        ArrayList<LayoutInfo> result = new ArrayList<LayoutInfo>();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid, fformid, flayoutkey, fcaption_" + locale + " from t_bas_formlayout where ";
        for (int i = 0; i < formIdList.size(); ++i) {
            sql = i == 0 ? sql + " fformid = ? " : sql + " or fformid = ? ";
        }
        sql = sql + " order by fformid ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])formIdList.toArray());
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                String formId = rs.getString("fformId");
                String key = rs.getString("flayoutkey");
                String caption = rs.getString("fcaption_" + locale);
                LayoutInfo layout = new LayoutInfo(key, id);
                if (key.equalsIgnoreCase("_default")) {
                    layout.setCaption(caption);
                } else {
                    layout.setCaption("\u5e03\u5c40_" + key);
                }
                layout.setFormId(formId);
                result.add(layout);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getFormTemplateList(int solutionID) throws BOSException {
        Context ctx = this.getContext();
        ArrayList<Form> result = new ArrayList<Form>();
        String sql = " select * from t_bas_form where felementtypeid < 0 and felementtypeid != -220 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                Form template = new Form("_Bill");
                template.setId(rs.getString("fid"));
                template.setElementType(rs.getInt("felementtypeid"));
                template.setName_L1(rs.getString("fname_L1"));
                template.setName_L2(rs.getString("fname_L2"));
                template.setName_L3(rs.getString("fname_L3"));
                template.setName(rs.getString("fname_" + ctx.getLocale()));
                result.add(template);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public void deleteForm(String formId) throws BOSException, EASBizException {
        block7: {
            String sql = " select * from  T_BAS_Template  where fformid = '" + formId + "'";
            Context ctx = this.getContext();
            Connection conn = null;
            Statement st = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                st = conn.createStatement();
                if (rs != null && !rs.next()) {
                    String[] del_sqls = this.getDeleteSql(formId);
                    for (int i = 0; i < del_sqls.length; ++i) {
                        st.addBatch(del_sqls[i]);
                    }
                    st.executeBatch();
                    break block7;
                }
                throw new FormCoreException(FormCoreException.NOTDELBYTEMPREF);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(null, (Statement)st, (Connection)conn);
            }
        }
    }

    private String[] getDeleteSql(String form_id) {
        String sql;
        ArrayList<String> del_list = new ArrayList<String>();
        String[] flayoutid_names = new String[]{"T_BAS_FormContainerLayout", "T_BAS_FormLayoutTabPage", "T_BAS_FormLayoutCtrl", "T_BAS_FormLayoutField", "T_BAS_FormLayoutEntity"};
        for (int i = 0; i < flayoutid_names.length; ++i) {
            String sql2 = "delete " + flayoutid_names[i] + "  WHERE FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID='" + form_id + "')";
            del_list.add(sql2);
        }
        String[] menuid_names = new String[]{"T_BAS_BarItemLink", "T_BAS_BarItem", "T_BAS_FormMenuScheme"};
        for (int i = 0; i < menuid_names.length; ++i) {
            String id = "fmenuid";
            if ("T_BAS_FormMenuScheme".equals(menuid_names[i])) {
                id = "fid";
            }
            sql = "delete " + menuid_names[i] + " where " + id + "  in (select FMenuId from T_BAS_FormMenu where fformid='" + form_id + "')";
            del_list.add(sql);
        }
        del_list.add("delete T_BAS_FCEntry WHERE FParentId in ( select fid from T_BAS_FormCondition where FFormID='" + form_id + "')");
        del_list.add("delete T_BAS_FCEntry WHERE FParentId in ( select fid from T_BAS_FormActionList where FFormID='" + form_id + "')");
        String[] formid_names = new String[]{"T_BAS_FormField", "T_BAS_FormEntity", "T_BAS_FormActionList", "T_BAS_FormLayout", "T_BAS_FormTableLayoutStyle", "T_BAS_FormOperation", "T_BAS_FormMenu", "T_BAS_FormPlugin", "T_BAS_FormExtProperty", "T_BAS_FormEventPm", "T_BAS_FormCondition", "T_BAS_BaseTableInfo", "T_BAS_ComPageSet"};
        for (int i = 0; i < formid_names.length; ++i) {
            sql = "delete " + formid_names[i] + " where fformid='" + form_id + "'";
            del_list.add(sql);
        }
        String[] fid_names = new String[]{"T_BAS_Form", "t_bas_form_permission", "t_bas_form_notes"};
        for (int i = 0; i < fid_names.length; ++i) {
            String sql3 = "delete " + fid_names[i] + " where fid='" + form_id + "'";
            del_list.add(sql3);
        }
        String[] out = new String[del_list.size()];
        del_list.toArray(out);
        return out;
    }

    @Override
    public void deleteFormLayout(String formId, String layoutId) throws BOSException, EASBizException {
        Statement st;
        Connection conn;
        IRowSet rs;
        Context ctx;
        String sql12;
        String sql11;
        String sql10;
        String sql9;
        String sql8;
        String sql7;
        String sql6;
        String sql5;
        block6: {
            String sql = " select count(fid) from T_BAS_FormLayout where fformid  = ? ";
            sql5 = " delete from T_BAS_FormLayout where fid = '" + layoutId + "'";
            sql6 = " delete from T_BAS_FormLayoutEntity where flayoutid = '" + layoutId + "'";
            sql7 = " delete from T_BAS_FormLayoutField where flayoutid = '" + layoutId + "'";
            sql8 = " delete from T_BAS_FormLayoutCtrl where flayoutid  = '" + layoutId + "'";
            sql9 = " delete from T_BAS_FormLayoutTabPage where flayoutid = '" + layoutId + "'";
            sql10 = " delete from T_BAS_FormContainerLayout where flayoutid = '" + layoutId + "'";
            sql11 = " delete from T_BAS_FormActionList where flayoutid = '" + layoutId + "'";
            sql12 = " delete from T_BAS_FormExtProperty where flayoutid = '" + layoutId + "'";
            ctx = this.getContext();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{formId});
            conn = null;
            st = null;
            int layoutCount = 0;
            if (rs.next()) {
                layoutCount = rs.getInt(1);
            }
            if (layoutCount > true) break block6;
            this.deleteForm(formId);
            SQLUtils.cleanup((ResultSet)rs, st, (Connection)conn);
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            st.addBatch(sql9);
            st.addBatch(sql8);
            st.addBatch(sql7);
            st.addBatch(sql6);
            st.addBatch(sql5);
            st.addBatch(sql10);
            st.addBatch(sql11);
            st.addBatch(sql12);
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, st, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)st, (Connection)conn);
    }

    @Override
    public Map getOrgTypeLoopUpMap() throws BOSException {
        Context ctx = this.getContext();
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        String sql = "select forgtype, fid from t_bas_lookupclass where flookuptype = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                result.put(new Integer(rs.getInt("forgtype")), new Integer(rs.getInt("fid")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getLookUPClassList(int type, String name, String bostype) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        ArrayList<LookUpObject> result = new ArrayList<LookUpObject>();
        String sql = "select fid, fname_" + l + ", fname_l1, fname_l2, fname_l3 , fqueryinfo, fnamefieldname, fnumberfieldname, f7provider, fcontrolFieldFilter,FBosType,FTableName  from t_bas_lookupclass where flookuptype = ?  and fname_" + l + " like ?   and FBosType = ? ";
        Object[] param = new Object[]{new Integer(type), StringUtils.isEmpty((String)name) ? "%%" : "%" + name.trim() + "%", bostype == null ? "" : bostype};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (rs.next()) {
                LookUpObject lookup = new LookUpObject();
                lookup.setID(rs.getInt("fid"));
                lookup.setName(rs.getString("fname_" + l));
                lookup.setName_l1(rs.getString("fname_l1"));
                lookup.setName_l2(rs.getString("fname_l2"));
                lookup.setName_l3(rs.getString("fname_l3"));
                lookup.setQueryInfo(rs.getString("fqueryinfo"));
                lookup.setNameFieldName(rs.getString("fnamefieldname"));
                lookup.setNumberFieldName(rs.getString("fnumberfieldname"));
                lookup.setF7Provider(rs.getString("f7provider"));
                lookup.setCtlFieldFiler(rs.getString("fcontrolFieldFilter"));
                lookup.setBosType(rs.getString("fBosType"));
                lookup.setTableName(rs.getString("FTableName"));
                result.add(lookup);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getLookUPClassList(String filterStr) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        ArrayList<LookUpObject> result = new ArrayList<LookUpObject>();
        String sql = "select fid, fname_" + l + ", fname_l1, fname_l2, fname_l3, fqueryinfo, fnamefieldname, fnumberfieldname, f7provider, fcontrolFieldFilter  from t_bas_lookupclass where " + filterStr + " and ( fbostype is not null) order by fid ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                LookUpObject lookup = new LookUpObject();
                lookup.setID(rs.getInt("fid"));
                lookup.setName(rs.getString("fname_" + l));
                lookup.setName_l1(rs.getString("fname_l1"));
                lookup.setName_l2(rs.getString("fname_l2"));
                lookup.setName_l3(rs.getString("fname_l3"));
                lookup.setQueryInfo(rs.getString("fqueryinfo"));
                lookup.setNameFieldName(rs.getString("fnamefieldname"));
                lookup.setNumberFieldName(rs.getString("fnumberfieldname"));
                lookup.setF7Provider(rs.getString("f7provider"));
                lookup.setCtlFieldFiler(rs.getString("fcontrolFieldFilter"));
                result.add(lookup);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public LookUpObject getLookUpObject(int id) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        LookUpObject lookup = null;
        String sql = "select fid, fname_" + l + ", fname_l1, fname_l2, fname_l3, fqueryinfo, fnamefieldname, fnumberfieldname, fbostype, f7provider, fcontrolFieldFilter  from t_bas_lookupclass where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(id)});
        try {
            if (rs.next()) {
                lookup = new LookUpObject();
                lookup.setID(rs.getInt("fid"));
                lookup.setName(rs.getString("fname_" + l));
                lookup.setName_l1(rs.getString("fname_l1"));
                lookup.setName_l2(rs.getString("fname_l2"));
                lookup.setName_l3(rs.getString("fname_l3"));
                lookup.setQueryInfo(rs.getString("fqueryinfo"));
                lookup.setNameFieldName(rs.getString("fnamefieldname"));
                lookup.setNumberFieldName(rs.getString("fnumberfieldname"));
                lookup.setBosType(rs.getString("fbostype"));
                lookup.setF7Provider(rs.getString("f7provider"));
                lookup.setCtlFieldFiler(rs.getString("fcontrolFieldFilter"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return lookup;
    }

    @Override
    public EnumObject getEnumObject(int id) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        EnumObject enumObject = null;
        String sql = "select fid, fkeyname, fenumclassname, fname_" + l + "  from t_bas_formenum where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(id)});
        try {
            if (rs.next()) {
                enumObject = new EnumObject();
                enumObject.setId(rs.getInt("fid"));
                enumObject.setKey(rs.getString("fkeyname"));
                enumObject.setEnumClassName(rs.getString("fenumclassname"));
                enumObject.setName(rs.getString("fname_" + l));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return enumObject;
    }

    public int getEnumObjectId(String key) throws BOSException, SQLException {
        int id = 0;
        StringBuffer sql = new StringBuffer(400);
        sql.append("SELECT fid FROM t_bas_formenum").append("\n").append("WHERE fkeyname = ?;");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])new Object[]{key});
        if (!rs.next()) {
            throw new BOSException("failed to find specified enum: enumKey=" + key);
        }
        id = rs.getInt("fid");
        return id;
    }

    public String getEnumItemId(int enumId, int itemValue) throws BOSException, SQLException {
        String id = null;
        StringBuffer sql = new StringBuffer(400);
        sql.append("SELECT fid FROM t_bas_formEnumItem").append("\n").append("WHERE fEnumId = ? and fValue = ?;");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])new Object[]{new Integer(enumId), new Integer(itemValue)});
        if (!rs.next()) {
            throw new BOSException("failed to find specified enum item(enumid, itemValue):" + enumId + "," + itemValue);
        }
        id = rs.getString("fid");
        return id;
    }

    @Override
    public void deleteEnumObject(int enumId) throws BOSException {
        DbUtil.execute((Context)this.getContext(), (String)"DELETE FROM t_bas_formEnum WHERE FID=?", (Object[])new Object[]{new Integer(enumId)});
        DbUtil.execute((Context)this.getContext(), (String)"DELETE FROM t_bas_formEnumItem WHERE FEnumID=?", (Object[])new Object[]{new Integer(enumId)});
    }

    public void deleteEnumItems(int enumId, Set itemValues) throws BOSException {
        StringBuffer sb = new StringBuffer();
        Iterator it = itemValues.iterator();
        while (it.hasNext()) {
            sb.append("or FValue=").append((Integer)it.next());
        }
        DbUtil.execute((Context)this.getContext(), (String)("DELETE FROM t_bas_formEnumItem WHERE FEnumId=" + enumId + "and (" + sb.substring(3) + ");"));
    }

    @Override
    public Map saveEnumObject(EnumObject enumObj, boolean saveItemsOnly, Set deletedItemValues) throws BOSException {
        HashMap<Integer, Object> ids = new HashMap<Integer, Object>();
        Context ctx = this.getContext();
        try {
            if (!saveItemsOnly) {
                StringBuffer sb = new StringBuffer(400);
                String enumClsName = enumObj.getEnumClassName() == null ? null : enumObj.getEnumClassName().trim();
                String string = enumClsName = enumClsName == null || enumClsName.length() == 0 ? "null" : "'" + enumClsName + "'";
                if (enumObj.getId() > 0) {
                    sb.append("UPDATE t_bas_formenum \n").append("SET fkeyname='").append(enumObj.getKey()).append("',fname_l1='").append(enumObj.getName_L1()).append("',fname_l2='").append(enumObj.getName_L2()).append("',fname_l3='").append(enumObj.getName_L3()).append("',fenumclassname=").append(enumClsName).append("\n").append("WHERE FID=" + enumObj.getId() + ";");
                } else {
                    sb.append("INSERT INTO t_bas_formenum(fid, fkeyname, fname_l1, fname_l2, fname_l3, fenumclassname) \n").append("SELECT isnull(max(fid),1000000)+1,'").append(enumObj.getKey() + "','" + enumObj.getName_L1() + "','" + enumObj.getName_L2() + "','" + enumObj.getName_L3() + "',").append(enumClsName).append("\n  from t_bas_formenum where fid >=1000000 and fid<2000000;");
                }
                DbUtil.execute((Context)ctx, (String)sb.toString());
                if (enumObj.getId() == 0) {
                    int enumId = this.getEnumObjectId(enumObj.getKey());
                    enumObj.setId(enumId);
                    ids.put(new Integer(0), new Integer(enumId));
                }
            }
            if (enumObj.getId() > 0) {
                for (EnumItem item : enumObj.getEnumItems()) {
                    String id = this.saveEnumItem(item, enumObj.getId());
                    ids.put(new Integer(item.getValue()), id);
                }
            }
            if (deletedItemValues != null && deletedItemValues.size() > 0) {
                this.deleteEnumItems(enumObj.getId(), deletedItemValues);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    public String saveEnumItem(EnumItem item, int enumId) throws BOSException, SQLException {
        String id = item.getId();
        Context ctx = this.getContext();
        StringBuffer sb = new StringBuffer(400);
        if (id != null) {
            sb.append("UPDATE t_bas_formEnumItem \n").append("SET fDisplay_l1='").append(item.getDisplayValue_L1()).append("',fDisplay_l2='").append(item.getDisplayValue_L2()).append("',fDisplay_l3='").append(item.getDisplayValue_L3()).append("'\n").append("WHERE FID='" + id + "' AND FEnumId=" + enumId);
        } else {
            sb.append("INSERT INTO t_bas_formEnumItem(fid, fValue, fEnumId, fDisplay_l1, fDisplay_l2, fDisplay_l3) \n").append("SELECT NEWBOSID('77888881'),").append(item.getValue() + ",").append(enumId + ",'").append(item.getDisplayValue_L1() + "','" + item.getDisplayValue_L2() + "','" + item.getDisplayValue_L3() + "';");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString());
        if (id == null) {
            id = this.getEnumItemId(enumId, item.getValue());
        }
        return id;
    }

    @Override
    public EnumObject getEnumObjectWithItems(int id) throws BOSException {
        Context ctx = this.getContext();
        EnumObject enumObj = null;
        String sql = "select fid, fkeyname, fname_l1, fname_l2, fname_l3, fenumclassname from t_bas_formenum where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(id)});
        try {
            if (rs.next()) {
                enumObj = new EnumObject();
                enumObj.setId(rs.getInt("fid"));
                enumObj.setKey(rs.getString("fkeyname"));
                enumObj.setEnumClassName(rs.getString("fenumclassname"));
                enumObj.setName_L1(rs.getString("fname_l1"));
                enumObj.setName_L2(rs.getString("fname_l2"));
                enumObj.setName_L3(rs.getString("fname_l3"));
                if (enumObj.isCustomizedEnum()) {
                    this.getEnumItems(enumObj, id);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return enumObj;
    }

    public void getEnumItems(EnumObject enumObj, int enumId) throws BOSException {
        Context ctx = this.getContext();
        String sql = "select fid, fValue, fDisplay_l1, fDisplay_l2, fDisplay_l3 from t_bas_formEnumItem where fEnumId = ? order by fValue;";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(enumId)});
        try {
            while (rs.next()) {
                EnumItem enumItem = new EnumItem();
                enumItem.setId(rs.getString("fid"));
                enumItem.setValue(rs.getInt("fValue"));
                enumItem.setDisplayValue_L1(rs.getString("fDisplay_l1"));
                enumItem.setDisplayValue_L2(rs.getString("fDisplay_l2"));
                enumItem.setDisplayValue_L3(rs.getString("fDisplay_l3"));
                enumObj.addItem(enumItem);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public List getEnumObjectList(String name) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        ArrayList<EnumObject> result = new ArrayList<EnumObject>();
        String sql = "select fid, fkeyname, fname_" + l + "  from t_bas_formenum where fname_" + l + " like ? ";
        if (name == null) {
            name = "";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"%" + name.trim() + "%"});
        try {
            while (rs.next()) {
                EnumObject enumObject = new EnumObject();
                enumObject.setId(rs.getInt("fid"));
                enumObject.setKey(rs.getString("fkeyname"));
                enumObject.setName(rs.getString("fname_" + l));
                result.add(enumObject);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getBOSEnumObjectList(String name) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        ArrayList<EnumObject> result = new ArrayList<EnumObject>();
        String sql = "select fid, fkeyname, fname_" + l + "  from t_bas_formenum where fid<10000 and fname_" + l + " like ? ";
        if (name == null) {
            name = "";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"%" + name.trim() + "%"});
        try {
            while (rs.next()) {
                EnumObject enumObject = new EnumObject();
                enumObject.setId(rs.getInt("fid"));
                enumObject.setKey(rs.getString("fkeyname"));
                enumObject.setName(rs.getString("fname_" + l));
                result.add(enumObject);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getActionList(String name, String desc) throws BOSException {
        Context ctx = this.getContext();
        ArrayList<Action> result = new ArrayList<Action>();
        String sql = "select fid, fname, fdesc, fsyntax , fsetcomponent, FReverseActionClass  from t_bas_formaction where FDesignerVisible=1 and fname like ?  and fdesc like ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{"%" + name + "%", "%" + desc + "%"});
        try {
            while (rs.next()) {
                Action action = new Action();
                action.setActionId(rs.getInt("fid"));
                action.setName(rs.getString("fname"));
                action.setDesc(rs.getString("fdesc"));
                action.setSyntax(rs.getString("fsyntax"));
                action.setSetComponent(rs.getString("fsetcomponent"));
                action.setReverseActionClass(rs.getString("FReverseActionClass"));
                action.setExpression("");
                result.add(action);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public Action getAction(int id) throws BOSException {
        Context ctx = this.getContext();
        Action action = null;
        String sql = "select fid, fname, fdesc, fsyntax, fsetcomponent, FReverseActionClass from t_bas_formaction where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(id)});
        try {
            if (rs.next()) {
                action = new Action();
                action.setActionId(rs.getInt("fid"));
                action.setName(rs.getString("fname"));
                action.setDesc(rs.getString("fdesc"));
                action.setSyntax(rs.getString("fsyntax"));
                action.setSetComponent(rs.getString("fsetcomponent"));
                action.setReverseActionClass(rs.getString("FReverseActionClass"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return action;
    }

    @Override
    public List getFormOperationList() throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        ArrayList<FormOperation> result = new ArrayList<FormOperation>();
        String sql = "select fid, foperation, fname_" + l + ", FOperEleIds, FType  from t_bas_formOperationType order by fid";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                FormOperation operation = new FormOperation();
                operation.setId(rs.getInt("fid"));
                operation.setName(rs.getString("fname_" + l));
                operation.setOperation(rs.getString("foperation"));
                operation.setOperEleIds(rs.getString("FOperEleIds"));
                operation.setType(rs.getInt("FType"));
                result.add(operation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getFormOperationList(String topSysId, String subSysId) throws BOSException {
        return this.getFormOperationList(topSysId, subSysId, false);
    }

    @Override
    public List getFormOperationList(String topSysId, String subSysId, boolean isIncludePub) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        ArrayList<FormOperation> result = new ArrayList<FormOperation>();
        String sql = "select fid, foperation, fname_" + l + ", FOperEleIds, FType  from t_bas_formOperationType  where (FTopSysID = ? and FSubSysID = ?) or (FTopSysID = ? and FSubSysID = ?)  order by fid";
        Object[] params = new String[]{topSysId, subSysId, "public", "public"};
        if (StringUtils.isEmpty((String)topSysId)) {
            sql = "select fid, foperation, fname_" + l + ", FOperEleIds, FType  from t_bas_formOperationType  where (FSubSysID = ?) or (FSubSysID = ?)  order by fid";
            params = new String[]{subSysId, "public"};
        }
        if (!isIncludePub) {
            if (params.length == 4) {
                params[2] = "xxx";
                params[3] = "xxx";
            } else {
                params[1] = "xxx";
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            while (rs.next()) {
                FormOperation operation = new FormOperation();
                operation.setId(rs.getInt("fid"));
                operation.setName(rs.getString("fname_" + l));
                operation.setOperation(rs.getString("foperation"));
                operation.setOperEleIds(rs.getString("FOperEleIds"));
                operation.setType(rs.getInt("FType"));
                result.add(operation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public Map getForms(List subsysIds, List elementTypeList) throws BOSException {
        int i;
        if (elementTypeList == null || elementTypeList.isEmpty()) {
            return null;
        }
        HashMap total = new HashMap();
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid, fsubsysid, FElementTypeId, fname_" + locale + " from T_BAS_Form where ";
        ArrayList params = new ArrayList();
        for (i = 0; i < elementTypeList.size(); ++i) {
            sql = i == 0 ? sql + " ( FElementTypeId = ? " : sql + " or FElementTypeId = ? ";
            params.add(elementTypeList.get(i));
        }
        if (elementTypeList.size() > 0) {
            sql = sql + " ) ";
        }
        for (i = 0; i < subsysIds.size(); ++i) {
            sql = i == 0 ? (elementTypeList.size() > 0 ? sql + " and ( fsubsysid = ? " : sql + " ( fsubsysid = ? ") : sql + " or fsubsysid = ? ";
            params.add(subsysIds.get(i));
        }
        if (subsysIds.size() > 0) {
            sql = sql + " ) ";
        }
        if (elementTypeList.size() > 0 || subsysIds.size() > 0) {
            sql = sql + " and ";
        }
        sql = sql + " (FIsHide <> 1 or FIsHide is null) order by fsubsysid, FElementTypeId , fname_" + locale;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                String name = rs.getString("fname_" + locale);
                String subsysId = rs.getString("fsubsysid");
                FormAppearance form = new FormAppearance(id);
                form.setId(id);
                form.setCaption(name);
                form.setElementType(rs.getInt("FElementTypeId"));
                form.setSubsysId(subsysId);
                List result = null;
                result = total.containsKey(subsysId) ? (List)total.get(subsysId) : new ArrayList();
                result.add(form);
                total.put(subsysId, result);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return total;
    }

    @Override
    public FormAppearance getForm(String formId) throws BOSException {
        if (StringUtils.isEmpty((String)formId)) {
            return null;
        }
        FormAppearance result = null;
        Context ctx = this.getContext();
        Locale locale = ctx.getLocale();
        String sql = " select fid, fsubsysid, FElementTypeId, fname_" + locale + " from T_BAS_Form where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{formId});
        try {
            if (rs.next()) {
                String id = rs.getString("fid");
                String name = rs.getString("fname_" + locale);
                String subsysId = rs.getString("fsubsysid");
                result = new FormAppearance(id);
                result.setId(id);
                result.setCaption(name);
                result.setElementType(rs.getInt("FElementTypeId"));
                result.setSubsysId(subsysId);
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public List getFormFunctionList() throws BOSException {
        Context ctx = this.getContext();
        ArrayList<FormFunction> result = new ArrayList<FormFunction>();
        String sql = "select fid, fname, fdesc, fdataType, fsample, fsetcomponent from t_bas_formfunction order by fid";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                FormFunction function = new FormFunction();
                function.setId(rs.getInt("fid"));
                function.setName(rs.getString("fname"));
                function.setDesc(rs.getString("fdesc"));
                function.setDateType(rs.getString("fdataType"));
                function.setSample(rs.getString("fsample"));
                function.setSetComponent(rs.getString("fsetcomponent"));
                result.add(function);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public void checkConditionCanDelete(String conditionId) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        int count = 0;
        String sql = " select count(FStartConditionID) cnt from T_BAS_TemplateWorkFlow where FStartConditionID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{conditionId});
        try {
            if (rs.next() && (count = rs.getInt("cnt")) > 0) {
                throw new FormCoreException(FormCoreException.CONDITIONUSED);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void updateBaseTableInfo(BaseTableInfo info) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String formId = info.getFormId();
        int lookUpId = info.getLookUpId();
        String sql = " delete from T_BAS_BaseTableInfo where FFormId = ? and FLookUpClassId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{formId, new Integer(lookUpId)});
        sql = " insert into T_BAS_BaseTableInfo( FID, FFormId, FLookupClassId,  FTableName, FFieldName, FSrcTableName,  FSrcFieldName, FDspFieldName, FTableNameAs )  values(?,?,?,?,?,?,?,?,?) ";
        String id = this.createNewID();
        String tableName = info.getTableName();
        String fieldName = info.getFieldName();
        String srcTableName = info.getSrcTableName();
        String srcFieldName = info.getSrcFieldName();
        String dspTableName = info.getDspTableName();
        String dspFieldName = info.getDspFieldName();
        Object[] param = new Object[]{id, formId, new Integer(lookUpId), tableName, fieldName, srcTableName, srcFieldName, dspTableName, dspFieldName};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    private void updateBaseTableInfoList(String formId, List infoList) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        Connection conn = null;
        PreparedStatement ps = null;
        String sql = " delete from T_BAS_BaseTableInfo where FFormId = ? ";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, formId);
            ps.executeUpdate();
            sql = " insert into T_BAS_BaseTableInfo( FID, FFormId, FLookupClassId,  FTableName, FFieldName, FSrcTableName,  FSrcFieldName, FTableNameAs, FDspFieldName, FFieldKey )  values(?,?,?,?,?,?,?,?,?,?) ";
            ps = conn.prepareStatement(sql);
            for (int i = 0; infoList != null && i < infoList.size(); ++i) {
                BaseTableInfo info = (BaseTableInfo)infoList.get(i);
                String id = this.createNewID();
                int lookupId = info.getLookUpId();
                String tableName = info.getTableName();
                String fieldName = info.getFieldName();
                String srcTableName = info.getSrcTableName();
                String srcFieldName = info.getSrcFieldName();
                String dspTableName = info.getDspTableName();
                String dspFieldName = info.getDspFieldName();
                String fieldKey = info.getFieldKey();
                ps.setString(1, id);
                ps.setString(2, formId);
                ps.setInt(3, lookupId);
                ps.setString(4, tableName);
                ps.setString(5, fieldName);
                ps.setString(6, srcTableName);
                ps.setString(7, srcFieldName);
                ps.setString(8, dspTableName);
                ps.setString(9, dspFieldName);
                ps.setString(10, fieldKey);
                ps.addBatch();
            }
            if (infoList != null && infoList.size() > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void createTable(Entity entity) throws BOSException {
        Context ctx = this.getContext();
        String sql = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME =?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{entity.getTableName()});
        try {
            if (!rs.next()) {
                sql = this.genCreateTableSql(entity);
            } else {
                sql = "SELECT TOP 1 * FROM " + entity.getTableName();
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                sql = this.genAlterTableSql(rs.getMetaData(), entity);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (sql.length() > 0) {
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private String genAlterTableSql(ResultSetMetaData meta, Entity entity) {
        StringBuffer sb = new StringBuffer();
        Vector fields = entity.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            boolean isMulLanguage = field.isMulLanguage();
            if (StringUtil.isEmpty((String)field.getFieldName())) continue;
            if (isMulLanguage) {
                String fieldName = field.getFieldName() + "_L1";
                this.genAlterSql(meta, entity.getTableName(), sb, fieldName);
                fieldName = field.getFieldName() + "_L2";
                this.genAlterSql(meta, entity.getTableName(), sb, fieldName);
                fieldName = field.getFieldName() + "_L3";
                this.genAlterSql(meta, entity.getTableName(), sb, fieldName);
                continue;
            }
            this.genAlterSql(meta, entity.getTableName(), sb, field.getFieldName());
        }
        return sb.toString();
    }

    private void genAlterSql(ResultSetMetaData meta, String tableName, StringBuffer sb, String fieldName) {
        if (!this.hasField(meta, fieldName)) {
            sb.append("alter table ").append(tableName);
            sb.append(" add ").append(fieldName);
            sb.append(" varchar(50) ;");
            sb.append("\r\n");
        }
    }

    private String genCreateTableSql(Entity entity) {
        if (StringUtil.isEmpty((String)entity.getTableName())) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '");
        sb.append(entity.getTableName()).append("'");
        sb.append("\r\n");
        sb.append("CREATE TABLE ").append(entity.getTableName()).append("(");
        sb.append("\r\n");
        sb.append(entity.getPkFieldName()).append(" ");
        sb.append(" varchar(44)");
        sb.append(",");
        if (entity.getEntryPkFieldName() != null && entity.getEntryPkFieldName().trim().length() > 0) {
            sb.append("\r\n");
            sb.append(entity.getEntryPkFieldName()).append(" ");
            sb.append(" varchar(44)");
            sb.append(",");
        }
        Vector fields = entity.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            if (StringUtil.isEmpty((String)field.getPropertyName()) || StringUtil.isEmpty((String)field.getFieldName())) continue;
            sb.append("\r\n");
            sb.append(field.getFieldName()).append(" ");
            sb.append(" varchar(44)");
            sb.append(",");
        }
        sb.append("\r\n");
        sb.append("CONSTRAINT ");
        String pkName = "PrimaryKey_" + entity.getPkFieldName();
        sb.append(pkName);
        sb.append(" PRIMARY KEY(");
        String colName = entity.getPkFieldName();
        sb.append(colName).append(")");
        return sb.toString();
    }

    private boolean hasField(ResultSetMetaData meta, String name) {
        try {
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                if (!meta.getColumnName(i).equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public List getFlowDirList(String filterStr) throws BOSException {
        Context ctx = this.getContext();
        Locale l = ctx.getLocale();
        ArrayList<FlowDirInfo> result = new ArrayList<FlowDirInfo>();
        String sql = "select fid, fname_l1, fname_l2, fname_l3, fseq, FDir, fisdefault  from T_BAS_FormFlowDir where " + filterStr + " order by fseq ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                FlowDirInfo flowDir = new FlowDirInfo();
                flowDir.setId(rs.getString("fid"));
                flowDir.setName_l1(rs.getString("fname_l1"));
                flowDir.setName_l2(rs.getString("fname_l2"));
                flowDir.setName_l3(rs.getString("fname_l3"));
                flowDir.setName(rs.getString("fname_" + l));
                flowDir.setDefault(rs.getBoolean("fisdefault"));
                flowDir.setSeq(rs.getInt("fseq"));
                flowDir.setDir(rs.getString("FDir"));
                result.add(flowDir);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public void deleteFlowDir(String id) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String sql = "select count(fflowdirid) cnt from T_BAS_Template where fflowdirid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{id});
        int count = 0;
        try {
            if (rs.next()) {
                count = rs.getInt("cnt");
            }
            if (count > 0) {
                throw new FormCoreException(FormCoreException.REFBYTEMPLATE);
            }
            sql = "delete from T_BAS_FormFlowDir where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{id});
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void saveFlowDir(FlowDirInfo info) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String name1 = info.getName_l1();
        String name2 = info.getName_l2();
        String name3 = info.getName_l3();
        if (StringUtils.isEmpty((String)info.getId())) {
            int seq = 0;
            String sql = "select max(fseq) seq from T_BAS_FormFlowDir";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    seq = rs.getInt("seq") + 1;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            sql = "insert into T_BAS_FormFlowDir(FID,FName_l1,FName_l2,FName_l3,FDir,FSeq,FIsDefault) values(?,?,?,?,?,?,0)";
            String id = this.createNewID();
            String dir = info.getDir();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id, name1, name2, name3, dir, new Integer(seq)});
        } else {
            String sql = "update T_BAS_FormFlowDir set FName_l1 = ? ,FName_l2 = ?,FName_l3 = ?,FDir = ? where fid = ?";
            String id = info.getId();
            String dir = info.getDir();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{name1, name2, name3, dir, id});
        }
    }

    private String getEmptyStringWithNull(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public void saveLookUpClass(LookUpObject info) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String name1 = this.getEmptyStringWithNull(info.getName_l1());
        String name2 = this.getEmptyStringWithNull(info.getName_l2());
        String name3 = this.getEmptyStringWithNull(info.getName_l3());
        int LookUptype = 2;
        String QueryInfo2 = this.getEmptyStringWithNull(info.getQueryInfo());
        String F7Provider = this.getEmptyStringWithNull(info.getF7Provider());
        String CtlFieldFiler = this.getEmptyStringWithNull(info.getCtlFieldFiler());
        String businessImplName = this.getEmptyStringWithNull(info.getBusinessImplName());
        String bosType = info.getBosType();
        String tableName = info.getTableName();
        String nameFieldName = this.getEmptyStringWithNull(info.getNameFieldName());
        String pkFieldName = this.getEmptyStringWithNull(info.getPkFieldName());
        if (pkFieldName == null || pkFieldName.equals("")) {
            pkFieldName = "FID";
        }
        String numberFieldName = this.getEmptyStringWithNull(info.getNumberFieldName());
        String url = this.getEmptyStringWithNull(info.getUrl());
        if (StringUtils.isEmpty((String)Integer.toString(info.getID())) || info.getID() == 0) {
            int seq = 1;
            String sql = "select max(fid) seq from t_bas_lookupclass";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    seq = rs.getInt("seq") + 1;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            sql = "insert into t_bas_lookupclass(flookuptype,fbusinessimplname, fname_l1 , fname_l2, fname_l3,fqueryinfo,f7provider , fcontrolfieldfilter, fproject, fvision,  fbostype ,ftablename, fpkfieldname, fnamefieldname, fnumberfieldname, fid) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(LookUptype), businessImplName, name1, name2, name3, QueryInfo2, F7Provider, CtlFieldFiler, "", "", bosType, tableName, pkFieldName, nameFieldName, numberFieldName, new Integer(seq)});
        } else {
            String sql = "update t_bas_lookupclass set FName_l1 = ? ,FName_l2 = ?,FName_l3 = ?,fqueryinfo=?,f7provider=? ,fcontrolfieldfilter=?  where fid = ?";
            int id = info.getID();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{name1, name2, name3, QueryInfo2, F7Provider, CtlFieldFiler, new Integer(id)});
        }
    }

    @Override
    public void deleteLookUpClass(String id) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        String sql = "";
        sql = "delete from t_bas_lookupclass where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{id});
    }

    @Override
    public Map getFormNameBySysId(String sub_sys_id, Map params) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] names = new String[]{"fname_l1", "fname_l2", "fname_l3"};
        String where_sql = "";
        String sql = "select top 1 fname_l1,fname_l2,fname_l3 from t_bas_form where felementtypeid>0 and  fsubsysid=? ";
        if (params != null && params.size() > 0) {
            for (int i = 0; i < names.length; ++i) {
                if (!params.containsKey(names[i])) continue;
                where_sql = where_sql + names[i].toString() + "='" + params.get(names[i]).toString() + "' or ";
            }
            if (where_sql.length() > 0) {
                where_sql = where_sql.substring(0, where_sql.length() - 3);
            }
            sql = sql + " and (" + where_sql + ")";
        }
        IRowSet result = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new String[]{sub_sys_id});
        try {
            while (result.next()) {
                for (int i = 0; i < names.length; ++i) {
                    map.put(names[i], result.getString(names[i]));
                }
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    public int getFormEditOrHide(String formId) throws BOSException {
        Context ctx = this.getContext();
        String sql = "";
        sql = "select FIsHide from t_bas_form where fid = ?";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{formId});
            if (result.next()) {
                return result.getInt("FIsHide");
            }
        }
        catch (SQLException e) {
            Log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    @Override
    public String getFormPermissionCreator(String form_id) throws BOSException {
        String user_id = "";
        if (!StringUtil.isEmpty((String)form_id)) {
            Context ctx = this.getContext();
            String sql = "select fuserid from t_bas_form_permission where fid=? and fiscreate=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{form_id, new Integer(1)});
            try {
                if (rs.next()) {
                    user_id = rs.getString("fuserid");
                }
            }
            catch (SQLException e) {
                Log.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return user_id;
    }

    @Override
    public Map getUserPermission(String form_id) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (!StringUtil.isEmpty((String)form_id)) {
            Context ctx = this.getContext();
            String sql = "select fuserid,fpermissiontype from t_bas_form_permission where fid=? and fiscreate=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{form_id, new Integer(0)});
            try {
                while (rs.next()) {
                    int permissiontype = rs.getInt("fpermissiontype");
                    String user_id = rs.getString("fuserid");
                    result.put(user_id, new Integer(permissiontype));
                }
            }
            catch (SQLException e) {
                Log.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public boolean updateFormPermission(String form_id, Map permission_info) throws BOSException {
        if (!StringUtils.isEmpty((String)form_id)) {
            PreparedStatement st;
            Connection conn;
            block6: {
                Context ctx = this.getContext();
                String sql = "";
                sql = "delete from t_bas_form_permission where fiscreate=0 and fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{form_id});
                String insert_sql = "insert into t_bas_form_permission (fid,fuserid,fiscreate,fpermissiontype) values (?,?,?,?) ";
                conn = null;
                st = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    st = conn.prepareStatement(insert_sql);
                    for (Map.Entry entry : permission_info.entrySet()) {
                        Object key = entry.getKey();
                        Object val = entry.getValue();
                        st.setString(1, form_id);
                        st.setString(2, key.toString());
                        st.setInt(3, 0);
                        st.setInt(4, Integer.parseInt(val.toString()));
                        st.addBatch();
                    }
                    if (permission_info.size() <= 0) break block6;
                    st.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(st, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
        return true;
    }

    @Override
    public boolean updateFormPermission(String form_id, String user_id, int permission_type, boolean is_create) throws BOSException {
        if (!StringUtils.isEmpty((String)form_id) && !StringUtils.isEmpty((String)user_id)) {
            Context ctx = this.getContext();
            String sql = "delete from t_bas_form_permission where fid = ? and fuserid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{form_id, user_id});
            StringBuffer insert_sql = new StringBuffer("insert into t_bas_form_permission (fid,fuserid,fiscreate,fpermissiontype) values ");
            insert_sql.append("('").append(form_id).append("','").append(user_id).append("',").append(is_create ? 1 : 0).append(",").append(permission_type).append(")");
            DbUtil.execute((Context)ctx, (String)insert_sql.toString());
            return true;
        }
        return false;
    }

    @Override
    public String getUserPermissionNotes(String form_id) throws BOSException {
        String notes = "";
        if (!StringUtil.isEmpty((String)form_id)) {
            Context ctx = this.getContext();
            String sql = "select fnotes from t_bas_form_notes where fid=? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{form_id});
            try {
                if (rs.next()) {
                    notes = rs.getString("fnotes");
                }
            }
            catch (SQLException e) {
                Log.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return notes;
    }

    @Override
    public boolean updateUserPermissionNotes(String form_id, String notes) throws BOSException {
        if (!StringUtils.isEmpty((String)form_id)) {
            Context ctx = this.getContext();
            String sql = "delete from t_bas_form_notes where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{form_id});
            StringBuffer insert_sql = new StringBuffer("insert into t_bas_form_notes (fid,fnotes) values ");
            insert_sql.append("('").append(form_id).append("','").append(notes).append("'").append(")");
            DbUtil.execute((Context)ctx, (String)insert_sql.toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean alertEntityTable(List sqlList) throws BOSException {
        boolean flag = true;
        Context ctx = this.getContext();
        if (sqlList != null && sqlList.size() > 0) {
            int j = sqlList.size();
            for (int i = 0; i < j; ++i) {
                try {
                    DbUtil.execute((Context)ctx, (String)((String)sqlList.get(i)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteImgData(BasImgHelper param) {
        Object imgData = null;
        if (StringUtils.isEmpty((String)param.getFormID()) || StringUtils.isEmpty((String)param.getFieldKey())) {
            return false;
        }
        Context ctx = this.getContext();
        String sql = "delete from t_bas_formImg where fformid = ? and ffieldkey = ? ";
        Connection conn = null;
        PreparedStatement ps = null;
        logger.info((Object)("delete Img  sql  ====" + sql));
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, param.getFormID());
            ps.setString(2, param.getFieldKey());
            ps.execute();
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getImgDataStream(BasImgHelper param) {
        Blob imgData = null;
        if (StringUtils.isEmpty((String)param.getBosType()) || StringUtils.isEmpty((String)param.getFieldKey())) {
            return null;
        }
        Context ctx = this.getContext();
        String sql = "select fimg from t_bas_formImg where fbostype = ? and ffieldkey = ? order by fcreatetime desc";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        logger.info((Object)("getImg  sql  ====" + sql));
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, param.getBosType());
            ps.setString(2, param.getFieldKey());
            rs = ps.executeQuery();
            if (rs.next()) {
                imgData = rs.getBlob("fimg");
            }
            if (imgData == null) {
                String string = null;
                return string;
            }
            param.setTmpImg(imgData.getBinaryStream());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                rs = null;
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        return param.getImgString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existImgData(BasImgHelper param) {
        Blob imgData = null;
        if (StringUtils.isEmpty((String)param.getFormID()) || StringUtils.isEmpty((String)param.getFieldKey())) {
            return false;
        }
        Context ctx = this.getContext();
        String sql = "select fimg from t_bas_formImg img inner join t_bas_form form on form.fbostype = img.fbostype where form.fid = ? and img.ffieldkey = ? order by img.fcreatetime desc";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        logger.info((Object)("exist  sql  ====" + sql));
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, param.getFormID());
            ps.setString(2, param.getFieldKey());
            rs = ps.executeQuery();
            if (rs.next()) {
                imgData = rs.getBlob("fimg");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                rs = null;
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        if (imgData == null) {
            return false;
        }
        imgData = null;
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addNewImgData(BasImgHelper param) throws BOSException {
        InputStream imgData = null;
        logger.info((Object)("param.getFormID()======" + param.getFormID() + "========param.getFieldKey()==========" + param.getFieldKey()));
        if (StringUtils.isEmpty((String)param.getFormID())) return;
        if (StringUtils.isEmpty((String)param.getFieldKey())) {
            return;
        }
        Context ctx = this.getContext();
        String id = this.createNewID();
        String userID = param.getCreater() == null ? null : param.getCreater().getId().toString();
        String ctrlUnitID = param.getCtrlUint() == null ? null : param.getCtrlUint().getId().toString();
        String sql = "insert into t_bas_formImg(FID, FCreatorID, FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FCtrlUnitID,FBizDate,fbostype,FFieldkey,FImg, fformid) values (?,?,?,?,?,?,?,?,?,?,?,?)";
        logger.info((Object)("sql==============context=" + ctx + "==================" + sql + "     " + param.getBosType()));
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            imgData = param.getImgStreamFromString();
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, id);
            ps.setString(2, userID);
            ps.setTimestamp(3, param.getCreateTime());
            ps.setString(4, userID);
            ps.setTimestamp(5, param.getLastUpdateTime());
            ps.setString(6, ctrlUnitID);
            ps.setString(7, ctrlUnitID);
            ps.setTimestamp(8, param.getCreateTime());
            ps.setString(9, this.getFormBosTypeByID(param.getFormID()));
            ps.setString(10, param.getFieldKey());
            ps.setBinaryStream(11, imgData, imgData == null ? 0 : imgData.available());
            ps.setString(12, param.getFormID());
            ps.execute();
            if (imgData != null) {
                imgData.close();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateImgData(BasImgHelper param) throws BOSException {
        InputStream imgData = null;
        if (StringUtils.isEmpty((String)param.getFormID())) return;
        if (StringUtils.isEmpty((String)param.getFieldKey())) {
            return;
        }
        Context ctx = this.getContext();
        String userID = param.getCreater() == null ? null : param.getCreater().getId().toString();
        String sql = "update t_bas_formImg set FImg=?, FLastUpdateUserID=?, FLastUpdateTime=?, fformid=? where fbostype = ? and ffieldkey = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            imgData = param.getImgStreamFromString();
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(2, userID);
            ps.setTimestamp(3, param.getLastUpdateTime());
            ps.setString(4, param.getFormID());
            ps.setString(5, this.getFormBosTypeByID(param.getFormID()));
            ps.setString(6, param.getFieldKey());
            ps.setBinaryStream(1, imgData, imgData == null ? 0 : imgData.available());
            ps.execute();
            if (imgData != null) {
                imgData.close();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyImgCtlData(String srcBosType, String bosType) {
        PreparedStatement ps;
        Connection conn;
        block6: {
            if (StringUtils.isEmpty((String)srcBosType) || StringUtils.isEmpty((String)bosType)) {
                return;
            }
            String selSql = "select fimg, FFieldkey from t_bas_formImg where fbostype = ?";
            String inSql = "insert into t_bas_formImg(FID, FCreatorID, FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FCtrlUnitID,FBizDate,fbostype,FFieldkey,FImg) values (?,?,?,?,?,?,?,?,?,?,?)";
            Context ctx = this.getContext();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String userID = user == null ? "" : user.getId().toString();
            String ctrlUnitID = cu == null ? "" : cu.getId().toString();
            conn = null;
            ps = null;
            PreparedStatement ps1 = null;
            boolean needAdd = false;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(selSql);
                ps1 = conn.prepareStatement(inSql);
                ps.setString(1, srcBosType);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    needAdd = true;
                    ps1.setString(1, this.createNewID());
                    ps1.setString(2, userID);
                    ps1.setTimestamp(3, new Timestamp(new Date().getTime()));
                    ps1.setString(4, userID);
                    ps1.setTimestamp(5, new Timestamp(new Date().getTime()));
                    ps1.setString(6, ctrlUnitID);
                    ps1.setString(7, ctrlUnitID);
                    ps1.setTimestamp(8, new Timestamp(new Date().getTime()));
                    ps1.setString(9, bosType);
                    ps1.setString(10, rs.getString("FFieldkey"));
                    Blob imgData = rs.getBlob("fimg");
                    logger.info((Object)("imgData.length()======" + imgData.length()));
                    ps1.setBlob(11, imgData);
                    ps1.addBatch();
                }
                if (!needAdd) break block6;
                ps1.executeBatch();
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public String getFormBosTypeByID(String formID) {
        String sql = " select fbostype from t_bas_form where fid = ?";
        String bosType = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new String[]{formID});
            if (rs.next()) {
                bosType = rs.getString("fbostype");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return bosType;
    }
}

